package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-07-21
 */
@Data
@ApiModel("用户员工绑定信息")
public class OrgUserEmpBuDTO implements Serializable {

    /**
     * 用户账号ID
     */
    @ApiModelProperty("用户账号ID")
    private Long userId;

    /**
     * 绑定的员工ID
     */
    @ApiModelProperty("绑定的员工ID")
    private Long empId;

    /**
     * 绑定的员工的编号路径
     */
    @ApiModelProperty("绑定的员工的编号路径")
    private String empCodePath;

    /**
     * 自己和所有子员工ID列表
     */
    @ApiModelProperty("自己和所有子员工ID列表")
    private List<Long> childEmpIds;

    /**
     * 员工绑定的，指定用来做数据权限过滤的组织树ID
     */
    @ApiModelProperty("员工绑定的，指定用来做数据权限过滤的组织树ID")
    private Long empBuTreeId;

    /**
     * 员工绑定的组织ID
     */
    @ApiModelProperty("员工绑定的组织ID")
    private List<Long> empBuIds;

    /**
     * 员工绑定的组织编号路径
     */
    @ApiModelProperty("员工绑定的组织的路径")
    private List<String> empBuCodePath;

    /**
     * 绑定的组织ID和所有子组织ID列表
     */
    @ApiModelProperty("员工绑定的组织ID和所有子组织ID列表")
    private List<Long> childEmpBuIds;

    /**
     * 员工所属总公司编码
     */
    @ApiModelProperty("员工所属总公司编码")
    private String headOuCode;


    /**
     * 员工所属总公司名称
     */
    @ApiModelProperty("员工所属总公司名称")
    private String headOuName;

}
