package com.elitesland.support.component.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitesland.support.component.service.DataTurboService;
import com.elitesland.support.component.service.DataTurboTransferService;
import com.elitesland.support.component.service.param.DataTurboProcessParam;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DataTurboServiceImpl  implements DataTurboService {

    @Override
    public Object transfer(DataTurboProcessParam param) {
        checkProcessParam(param);
        DataTurboTransferService dataTurboTransferService = DataTurboProcessFactory.DATA_TURBO_SERVICE_MAP.get(param.getProcessName());
        if(dataTurboTransferService == null){
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "找不到该工作流的回调方法:{}" + param.getProcessName());
        }
        return dataTurboTransferService.transfer(param);
    }

    private void checkProcessParam(DataTurboProcessParam param) {
        if(!StringUtils.hasText(param.getProcessName())){
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "工作流名称不能为空");
        }
        if(CollectionUtils.isEmpty(param.getStartParams())){
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "业务参数不能为空");
        }
    }
}
