/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.industry.general.item.proportion.provider;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.supp.dto.SrmPurSuppDTO;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.out.service.ItmService;
import com.elitesland.yst.srmdomain.out.service.SrmService;
import com.elitesland.yst.srmdomain.proportion.convert.YstItemProportionConvert;
import com.elitesland.yst.srmdomain.proportion.entity.QYstItemProportionDO;
import com.elitesland.yst.srmdomain.proportion.entity.YstItemProportionDO;
import com.elitesland.yst.srmdomain.proportion.provider.YstItemProportionProvider;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepo;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepoProc;
import com.elitesland.yst.srmdomain.proportion.vo.excel.YstItemProportionExcelVO;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstItemProportionPageParamVO;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstItemProportionParamVO;
import com.elitesland.yst.srmdomain.proportion.vo.resp.YstItemProportionPageRespVO;
import com.elitesland.yst.srmdomain.proportion.vo.resp.YstItemProportionRespVO;
import com.elitesland.yst.srmdomain.proportion.vo.save.YstItemProportionPageSaveVO;
import com.elitesland.yst.srmdomain.suppitem.entity.QYstSuppItemDO;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepoProc;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemRespVO;
import com.elitesland.yst.srmdomain.util.excel.importExcel.listener.ExcelEntityDataListener;
import com.elitesland.yst.supportdomain.provider.item.param.SrmItmItemNParamVO;
import com.elitesland.yst.supportdomain.provider.item.vo.SrmItmItemNRespVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"ystItemProportion"})
@Service
@UnicomTag(value="GENERAL")
public class GeneralYstItemProportionProvider
implements YstItemProportionProvider {
    private final YstItemProportionRepo ystItemProportionRepo;
    private final YstItemProportionRepoProc ystItemProportionRepoProc;
    private final YstSuppItemRepoProc ystSuppItemRepoProc;
    private final SrmService srmService;
    private final ItmService itmService;

    @Override
    @SysCodeProc
    public PagingVO<YstItemProportionPageRespVO> search(YstItemProportionPageParamVO ystItemProportionPageParamVO) {
        YstItemProportionParamVO param = YstItemProportionConvert.INSTANCE.pageParamToParam(ystItemProportionPageParamVO);
        if (!ObjectUtils.isEmpty((Object)ystItemProportionPageParamVO.getCurrent())) {
            param.setCurrent(ystItemProportionPageParamVO.getCurrent() + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSuppCodeName())) {
            List<SrmPurSuppDTO> SrmPurSuppDTOList = this.srmService.findBylikeSuppCodeOrName(param.getSuppCodeName());
            if (!CollectionUtils.isEmpty(SrmPurSuppDTOList)) {
                List<String> suppCodes = SrmPurSuppDTOList.stream().map(SrmPurSuppDTO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                param.setSuppCodes(suppCodes);
            } else {
                return new PagingVO();
            }
        }
        Long total = this.ystItemProportionRepoProc.countContractTmplGroupBy(param);
        List<YstItemProportionRespVO> search = this.ystItemProportionRepoProc.searchGroup(param);
        if (!CollectionUtils.isEmpty(search)) {
            this.fill(search);
        }
        List<YstItemProportionPageRespVO> pageList = YstItemProportionConvert.INSTANCE.respVOToPageResp(search);
        return total > 0L ? PagingVO.builder().total(total).records(pageList).build() : new PagingVO();
    }

    @Override
    public Object searchpo(YstItemProportionPageParamVO param) {
        return null;
    }

    @Override
    public PagingVO<YstItemProportionPageRespVO> searchGroup(YstItemProportionPageParamVO ystItemProportionPageParamVO) {
        YstItemProportionParamVO param = YstItemProportionConvert.INSTANCE.pageParamToParam(ystItemProportionPageParamVO);
        if (StringUtils.isNotBlank((CharSequence)param.getSuppCodeName())) {
            List<SrmPurSuppDTO> SrmPurSuppDTOList = this.srmService.findBylikeSuppCodeOrName(param.getSuppCodeName());
            if (!CollectionUtils.isEmpty(SrmPurSuppDTOList)) {
                List<String> suppCodes = SrmPurSuppDTOList.stream().map(SrmPurSuppDTO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                param.setSuppCodes(suppCodes);
            } else {
                return new PagingVO();
            }
        }
        Long total = this.ystItemProportionRepoProc.countContractTmpl(param);
        List<YstItemProportionRespVO> search = this.ystItemProportionRepoProc.search(param);
        if (!CollectionUtils.isEmpty(search)) {
            this.fill(search);
        }
        List<YstItemProportionPageRespVO> pageList = YstItemProportionConvert.INSTANCE.respVOToPageResp(search);
        return total > 0L ? PagingVO.builder().total(total).records(pageList).build() : new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<YstItemProportionExcelVO> importVeFile(MultipartFile file) {
        ExcelEntityDataListener ydExcelEntityDataListener = new ExcelEntityDataListener();
        try {
            EasyExcel.read((InputStream)file.getInputStream(), YstItemProportionExcelVO.class, ydExcelEntityDataListener).doReadAll();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u5bfc\u5165\u6570\u636e\u5982\u65f6\u95f4\uff0c\u6570\u5b57\u683c\u5f0f\u5f02\u5e38,\u8bf7\u68c0\u67e5");
        }
        List<YstItemProportionExcelVO> ystItemProportionExcelVOList = ydExcelEntityDataListener.getDatas();
        ystItemProportionExcelVOList = ystItemProportionExcelVOList.stream().filter(Objects::nonNull).filter(o -> !StringUtils.isEmpty((CharSequence)o.getItemCode()) && !StringUtils.isEmpty((CharSequence)o.getSuppCode())).collect(Collectors.toList());
        ArrayList ystItemProportionDoS = new ArrayList();
        ArrayList ystItemProportionExcelVoS = new ArrayList();
        if (!CollectionUtils.isEmpty(ystItemProportionExcelVOList)) {
            ystItemProportionExcelVOList.forEach(v -> {
                QYstItemProportionDO ystItemProportionQDo = QYstItemProportionDO.ystItemProportionDO;
                List fetch = ((JPAQuery)this.ystItemProportionRepoProc.select().where((Predicate)ystItemProportionQDo.itemCode.eq((Object)v.getItemCode()).and((Predicate)ystItemProportionQDo.suppCode.eq((Object)v.getSuppCode())))).fetch();
                if (CollectionUtils.isEmpty((Collection)fetch)) {
                    ystItemProportionExcelVoS.add(v);
                }
            });
        }
        ystItemProportionExcelVOList.removeAll(ystItemProportionExcelVoS);
        List<YstItemProportionDO> ystItemProporDoS = YstItemProportionConvert.INSTANCE.excelVoToDo(ystItemProportionExcelVOList);
        this.ystItemProportionRepo.saveAll(ystItemProporDoS);
        if (!CollectionUtils.isEmpty(ystItemProportionExcelVOList)) {
            return ystItemProportionExcelVOList;
        }
        return null;
    }

    @Override
    public List<YstItemProportionPageRespVO> findbySuppCode(String suppCode) {
        QYstItemProportionDO ystItemProportionQDo = QYstItemProportionDO.ystItemProportionDO;
        List search = ((JPAQuery)this.ystItemProportionRepoProc.select().where((Predicate)ystItemProportionQDo.suppCode.eq((Object)suppCode))).fetch();
        if (!CollectionUtils.isEmpty((Collection)search)) {
            this.fill(search);
        }
        List<YstItemProportionPageRespVO> pageList = YstItemProportionConvert.INSTANCE.respVOToPageResp(search);
        return pageList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<YstItemProportionPageSaveVO> updateAll(List<YstItemProportionPageSaveVO> param) {
        List<String> itemCodes = param.stream().map(YstItemProportionPageSaveVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
        ystItemProportionParamVO.setItemCodeList(itemCodes);
        List<YstItemProportionRespVO> search = this.ystItemProportionRepoProc.searchM(ystItemProportionParamVO);
        List<YstItemProportionRespVO> pageList = YstItemProportionConvert.INSTANCE.pageSaveVOTorespVO(param);
        search.addAll(pageList);
        this.big100(search, param);
        List<YstItemProportionDO> doList = YstItemProportionConvert.INSTANCE.pageSaveVOToDo(param);
        if (!CollectionUtils.isEmpty(param)) {
            doList.forEach(v -> {
                if (this.ystItemProportionRepo.existsBySuppCodeAndItemCode(v.getSuppCode(), v.getItemCode())) {
                    QYstItemProportionDO ystItemProportionQDo = QYstItemProportionDO.ystItemProportionDO;
                    List fetch = ((JPAQuery)this.ystItemProportionRepoProc.select().where((Predicate)ystItemProportionQDo.itemCode.eq((Object)v.getItemCode()).and((Predicate)ystItemProportionQDo.suppCode.eq((Object)v.getSuppCode())))).fetch();
                    Optional<YstItemProportionRespVO> first = fetch.stream().filter(Objects::nonNull).distinct().findFirst();
                    if (!first.isPresent()) {
                        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
                    }
                    YstItemProportionDO ystItemProportionDO = YstItemProportionConvert.INSTANCE.voToDo(first.get());
                    YstItemProportionConvert.INSTANCE.copyRpDoToDo((YstItemProportionDO)v, ystItemProportionDO);
                    this.ystItemProportionRepo.save(ystItemProportionDO);
                } else {
                    this.ystItemProportionRepo.save(v);
                }
            });
        }
        return param;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<YstItemProportionPageSaveVO> updateC13All(List<YstItemProportionPageSaveVO> param) {
        List<String> itemCodes = param.stream().map(YstItemProportionPageSaveVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
        ystItemProportionParamVO.setItemCodeList(itemCodes);
        List<YstItemProportionRespVO> search = this.ystItemProportionRepoProc.searchM(ystItemProportionParamVO);
        this.big100(search, param);
        List<YstItemProportionDO> doList = YstItemProportionConvert.INSTANCE.pageSaveVOToDo(param);
        doList.forEach(v -> {
            if (this.ystItemProportionRepo.existsBySuppCodeAndItemCode(v.getSuppCode(), v.getItemCode())) {
                QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
                List fetch1 = ((JPAQuery)this.ystSuppItemRepoProc.select().where((Predicate)ystSuppItemDo.itemCode.eq((Object)v.getItemCode()).and((Predicate)ystSuppItemDo.suppCode.eq((Object)v.getSuppCode())))).fetch();
                Optional<YstSuppItemRespVO> first1 = fetch1.stream().filter(Objects::nonNull).distinct().findFirst();
                if (!first1.isPresent()) {
                    QYstItemProportionDO ystItemProportionQDo = QYstItemProportionDO.ystItemProportionDO;
                    List fetch = ((JPAQuery)this.ystItemProportionRepoProc.select().where((Predicate)ystItemProportionQDo.itemCode.eq((Object)v.getItemCode()).and((Predicate)ystItemProportionQDo.suppCode.eq((Object)v.getSuppCode())))).fetch();
                    Optional<YstItemProportionRespVO> first = fetch.stream().filter(Objects::nonNull).distinct().findFirst();
                    if (!first.isPresent()) {
                        this.ystItemProportionRepo.save(v);
                    }
                    YstItemProportionDO ystItemProportionDO = YstItemProportionConvert.INSTANCE.voToDo(first.get());
                    YstItemProportionConvert.INSTANCE.copyRpDoToDo((YstItemProportionDO)v, ystItemProportionDO);
                    this.ystItemProportionRepo.save(ystItemProportionDO);
                }
            } else {
                this.ystItemProportionRepo.save(v);
            }
        });
        return param;
    }

    @Transactional(rollbackFor={Exception.class})
    void big100(List<YstItemProportionRespVO> param, List<YstItemProportionPageSaveVO> ystItemProportionPageSaveVOS) {
        if (CollectionUtils.isNotEmpty(param) && CollectionUtils.isNotEmpty(ystItemProportionPageSaveVOS)) {
            ystItemProportionPageSaveVOS.forEach(v -> {
                BigDecimal sum;
                List ystItemProportionRespVOList;
                if (!ObjectUtils.isEmpty((Object)v.getItemCode()) && !ObjectUtils.isEmpty((Object)v.getItemProportion()) && CollectionUtils.isNotEmpty(ystItemProportionRespVOList = param.stream().filter(Objects::nonNull).distinct().filter(t -> v.getItemCode().equals(v.getItemCode()) && !v.getSuppCode().equals(v.getSuppCode())).collect(Collectors.toList())) && !ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum = ystItemProportionRespVOList.stream().map(q -> {
                    try {
                        return q.getItemProportion();
                    }
                    catch (Exception x) {
                        return BigDecimal.ZERO;
                    }
                }).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(new BigDecimal("100")) == 1) {
                    throw new BusinessException(ApiCode.FAIL, v.getItemName() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%");
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteId(Long id) {
        this.ystItemProportionRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
        ystItemProportionParamVO.setIds(ids);
        this.ystItemProportionRepoProc.updateDeleteFlagBatch(ystItemProportionParamVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
        ystItemProportionParamVO.setId(id);
        Long count = this.ystItemProportionRepoProc.updateDeleteFlagBatch(ystItemProportionParamVO);
    }

    private void fill(List<YstItemProportionRespVO> list) {
        List<String> suppCodes = list.stream().map(YstItemProportionRespVO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemCodes = list.stream().map(YstItemProportionRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<SrmPurSuppDTO> purSuppBaseRespVOList = new ArrayList<SrmPurSuppDTO>();
        ArrayList<SrmItmItemNRespVO> itmItemRpcList = new ArrayList<SrmItmItemNRespVO>();
        ArrayList itmItemCateDetailsList = new ArrayList();
        if (!CollectionUtils.isEmpty(suppCodes)) {
            try {
                purSuppBaseRespVOList.addAll(this.srmService.findBySuppCodes(suppCodes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(itemCodes)) {
            try {
                SrmItmItemNParamVO itmItemRpcDtoParam = new SrmItmItemNParamVO();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                itmItemRpcList.addAll(this.itmService.findItemRpcDtoByParam(itmItemRpcDtoParam));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list.forEach(v -> {
            Optional<SrmPurSuppDTO> first;
            if (!ObjectUtils.isEmpty((Object)v.getLessNumber())) {
                if ("A".equals(v.getLessNumber())) {
                    v.setLessNumber("\u53ef\u8d85\u91cf");
                } else if ("B".equals(v.getLessNumber())) {
                    v.setLessNumber("\u53ef\u6b20\u91cf");
                } else if ("A,B".equals(v.getLessNumber())) {
                    v.setLessNumber("\u53ef\u8d85\u91cf,\u53ef\u6b20\u91cf");
                } else if ("B,A".equals(v.getLessNumber())) {
                    v.setLessNumber("\u53ef\u8d85\u91cf,\u53ef\u6b20\u91cf");
                }
            }
            v.setLessNumberList(!ObjectUtils.isEmpty((Object)v.getLessNumber()) ? Arrays.asList(v.getLessNumber().split(",")) : new ArrayList<String>());
            if (!ObjectUtils.isEmpty((Object)v.getSuppCode()) && (first = purSuppBaseRespVOList.stream().filter(t -> v.getSuppCode().equals(t.getSuppCode())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                v.setSuppCode(first.get().getSuppCode());
                v.setSuppName(first.get().getSuppName());
                v.setSuppType(first.get().getSuppType());
                v.setSuppTypeName(first.get().getSuppTypeName());
                v.setSuppAbbr(first.get().getSuppAbbr());
            }
            if (!StringUtils.isEmpty((CharSequence)v.getItemCode()) && (first = itmItemRpcList.stream().filter(v1 -> v1.getItemCode().equals(v.getItemCode())).findFirst()).isPresent()) {
                v.setItemCode(((SrmItmItemNRespVO)first.get()).getItemCode());
                v.setItemCode2(((SrmItmItemNRespVO)first.get()).getItemCode2());
                v.setItemCode3(((SrmItmItemNRespVO)first.get()).getItemCode3());
                v.setItemName(((SrmItmItemNRespVO)first.get()).getItemName());
                v.setUom(((SrmItmItemNRespVO)first.get()).getUom());
                v.setUomName(((SrmItmItemNRespVO)first.get()).getUomName());
                v.setItemCateCode(((SrmItmItemNRespVO)first.get()).getItemCateCode());
                List itemCatePathName = ((SrmItmItemNRespVO)first.get()).getItemCatePathName();
                if (!CollectionUtils.isEmpty((Collection)itemCatePathName)) {
                    String itemCateCodes = String.join((CharSequence)">", itemCatePathName);
                    v.setItemCateCodeName(itemCateCodes);
                }
            }
        });
    }

    public GeneralYstItemProportionProvider(YstItemProportionRepo ystItemProportionRepo, YstItemProportionRepoProc ystItemProportionRepoProc, YstSuppItemRepoProc ystSuppItemRepoProc, SrmService srmService, ItmService itmService) {
        this.ystItemProportionRepo = ystItemProportionRepo;
        this.ystItemProportionRepoProc = ystItemProportionRepoProc;
        this.ystSuppItemRepoProc = ystSuppItemRepoProc;
        this.srmService = srmService;
        this.itmService = itmService;
    }
}

