/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.industry.general.item.suppitem.provider;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.supp.dto.PurPurcPriceParamDTO;
import com.elitesland.supp.dto.SrmPurSuppDTO;
import com.elitesland.supp.outprovider.PurPurcPriceOutProvider;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.out.service.ItmService;
import com.elitesland.yst.srmdomain.out.service.SrmService;
import com.elitesland.yst.srmdomain.proportion.provider.YstItemProportionProvider;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepoProc;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstItemProportionParamVO;
import com.elitesland.yst.srmdomain.proportion.vo.resp.YstItemProportionRespVO;
import com.elitesland.yst.srmdomain.proportion.vo.save.YstItemProportionPageSaveVO;
import com.elitesland.yst.srmdomain.suppitem.convert.YstSuppItemConvert;
import com.elitesland.yst.srmdomain.suppitem.entity.QYstSuppItemDO;
import com.elitesland.yst.srmdomain.suppitem.entity.YstSuppItemDO;
import com.elitesland.yst.srmdomain.suppitem.provider.YstSuppItemProvider;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepo;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepoProc;
import com.elitesland.yst.srmdomain.suppitem.vo.excel.YstSuppItemExcelVO;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemPageParamVO;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemParamVO;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemScorePayload;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemPageRespVO;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemRespVO;
import com.elitesland.yst.srmdomain.suppitem.vo.save.SuppItemCompRespVO;
import com.elitesland.yst.srmdomain.suppitem.vo.save.YstSuppItemPageSaveVO;
import com.elitesland.yst.srmdomain.suppitem.vo.save.YstSuppItemSaveVO;
import com.elitesland.yst.srmdomain.util.enumproduct.SrmUdcEnum;
import com.elitesland.yst.srmdomain.util.listener.YstSuppItemListener;
import com.elitesland.yst.srmdomain.ystsuppc13.entity.QYstSuppC13DO;
import com.elitesland.yst.srmdomain.ystsuppc13.provider.YstSuppC13Provider;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13Repo;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13RepoProc;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.param.YstSuppC13ParamVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.resp.YstSuppC13RespVO;
import com.elitesland.yst.supportdomain.provider.item.param.SrmItmItemNParamVO;
import com.elitesland.yst.supportdomain.provider.item.vo.SrmItmItemNRespVO;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@UnicomTag(value="GENERAL")
public class GeneralYstSuppItemProvider
implements YstSuppItemProvider {
    private static final Logger log = LoggerFactory.getLogger(GeneralYstSuppItemProvider.class);
    private final YstSuppC13Provider ystSuppC13Service;
    private final YstSuppItemRepo ystSuppItemRepo;
    private final YstSuppItemRepoProc ystSuppItemRepoProc;
    private final YstSuppC13RepoProc ystSuppC13RepoProc;
    private final SrmService srmService;
    private final YstSuppC13Repo ystSuppC13Repo;
    private final ItmService itmService;
    private final YstItemProportionRepoProc ystItemProportionRepoProc;
    private final YstItemProportionProvider ystItemProportionProvider;
    @DubboReference
    private PurPurcPriceOutProvider purPurcPriceOutProvider;

    @Override
    public PagingVO<YstSuppItemPageRespVO> search(YstSuppItemPageParamVO param) {
        if (StringUtils.isNotBlank((CharSequence)param.getSuppCodeName())) {
            List<SrmPurSuppDTO> SrmPurSuppDTOList = this.srmService.findBylikeSuppCodeOrName(param.getSuppCodeName());
            if (!CollectionUtils.isEmpty(SrmPurSuppDTOList)) {
                List<String> suppCodes = SrmPurSuppDTOList.stream().map(SrmPurSuppDTO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                param.setSuppCodes(suppCodes);
            } else {
                return new PagingVO();
            }
        }
        YstSuppItemParamVO ystSuppItemParamVO = YstSuppItemConvert.INSTANCE.pageParamToParamVO(param);
        if (!ObjectUtils.isEmpty((Object)param.getCurrent())) {
            ystSuppItemParamVO.setCurrent(param.getCurrent() + 1);
        }
        Long total = this.ystSuppItemRepoProc.countContractTmpl(ystSuppItemParamVO);
        List<YstSuppItemRespVO> search = this.ystSuppItemRepoProc.search(ystSuppItemParamVO);
        if (!CollectionUtils.isEmpty(search)) {
            this.fill(search, null);
        }
        List<YstSuppItemPageRespVO> pageList = YstSuppItemConvert.INSTANCE.respVOToPageResp(search);
        return total > 0L ? PagingVO.builder().total(total).records(pageList).build() : new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        YstSuppItemParamVO ystSuppItemParamVO = new YstSuppItemParamVO();
        ystSuppItemParamVO.setIds(ids);
        this.ystSuppItemRepoProc.updateDeleteFlagBatch(ystSuppItemParamVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ids.forEach(this::deleteOne);
    }

    @Override
    public List<YstSuppItemPageRespVO> findBySuppId(String suppCode) {
        QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
        List fetch = ((JPAQuery)this.ystSuppItemRepoProc.select().where((Predicate)ystSuppItemDo.suppCode.eq((Object)suppCode))).fetch();
        this.fill(fetch, suppCode);
        List<YstSuppItemPageRespVO> pageList = YstSuppItemConvert.INSTANCE.respVOToPageResp(fetch);
        return pageList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAll(List<YstSuppItemPageSaveVO> lists) {
        List<YstSuppItemSaveVO> param = YstSuppItemConvert.INSTANCE.pageSaveToSaveList(lists);
        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
        ystItemProportionParamVO.setSuppCode(lists.get(0).getSuppCode());
        List<YstItemProportionRespVO> ystItemProportionRespVOS = this.ystItemProportionRepoProc.searchM(ystItemProportionParamVO);
        List<String> itemCodes = ystItemProportionRespVOS.stream().map(YstItemProportionRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> itemids = ystItemProportionRespVOS.stream().map(YstItemProportionRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemCode2 = lists.stream().map(YstSuppItemPageSaveVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemids2 = lists.stream().map(YstSuppItemPageSaveVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(param) && this.ystSuppItemRepo.existsBySuppCode(param.get(0).getSuppCode())) {
            this.ystSuppItemRepo.deleteBySuppCode(param.get(0).getSuppCode());
        }
        itemCodes.removeAll(itemCode2);
        itemids.removeAll(itemids2);
        if (!CollectionUtils.isEmpty(itemCodes)) {
            List<String> itemCateCodes = ystItemProportionRespVOS.stream().filter(v -> itemCodes.contains(v.getItemCode())).map(YstItemProportionRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<YstItemProportionRespVO> fileYstItemProportionList = ystItemProportionRespVOS.stream().filter(v -> itemCodes.contains(v.getItemCode())).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            this.delesuppItem(itemCateCodes, param.get(0).getSuppId(), param.get(0).getSuppCode(), itemCodes, fileYstItemProportionList, itemids);
        }
        this.big100(lists);
        this.ystSuppItemRepo.saveAll(YstSuppItemConvert.INSTANCE.pageSaveListToDo(lists));
        List<YstItemProportionPageSaveVO> ystItemProportionPageSaveVOlist = lists.stream().map(i -> {
            YstItemProportionPageSaveVO DO = new YstItemProportionPageSaveVO();
            DO.setItemCode(i.getItemCode());
            DO.setItemCode2(i.getItemCode2());
            DO.setItemId(i.getItemId());
            DO.setItemCateCode(i.getItemCateCode());
            DO.setSuppCode(i.getSuppCode());
            DO.setSuppId(i.getSuppId());
            DO.setSuppId(i.getSuppId());
            DO.setItemProportion(i.getItemProportion());
            DO.setLessProportion(i.getLessProportion());
            DO.setLessNumber(i.getLessNumber());
            DO.setMoreProportion(i.getMoreProportion());
            return DO;
        }).collect(Collectors.toList());
        this.ystItemProportionProvider.updateAll(ystItemProportionPageSaveVOlist);
    }

    @Transactional(rollbackFor={Exception.class})
    void delesuppItem(List<String> itemCateCodes, Long suppId, String suppCode, List<String> itemCodes, List<YstItemProportionRespVO> fileYstItemProportionList, List<Long> itemids) {
        YstSuppC13ParamVO ystSuppC13ParamVO = new YstSuppC13ParamVO();
        ystSuppC13ParamVO.setSuppCode(suppCode);
        ystSuppC13ParamVO.setItemCateCodeList(itemCateCodes);
        List<YstSuppC13RespVO> ystSuppC13RespVOList = this.ystSuppC13RepoProc.searchM(ystSuppC13ParamVO);
        if (!CollectionUtils.isEmpty(ystSuppC13RespVOList)) {
            List itemCateCodes2 = ystSuppC13RespVOList.stream().map(YstSuppC13RespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            itemCateCodes.removeAll(itemCateCodes2);
            YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
            ystItemProportionParamVO.setSuppCode(suppCode);
            ystItemProportionParamVO.setItemCodeList(itemCodes);
            ystItemProportionParamVO.setItemCateCodeList(itemCateCodes);
            this.ystItemProportionRepoProc.updateDeleteFlagBatch(ystItemProportionParamVO);
            PurPurcPriceParamDTO purPurcPriceParamDTO = new PurPurcPriceParamDTO();
            purPurcPriceParamDTO.setSuppId(suppId);
            purPurcPriceParamDTO.setItemIds(itemids);
            purPurcPriceParamDTO.setBindStatus(SrmUdcEnum.CBPL_ITMBINDPRICE_B.getCode());
            this.purPurcPriceOutProvider.updateBindStatus(purPurcPriceParamDTO);
            ystSuppC13RespVOList.forEach(v -> {
                YstItemProportionParamVO ystItemProportionParamV = new YstItemProportionParamVO();
                ystItemProportionParamV.setSuppCode(suppCode);
                ystItemProportionParamV.setItemCateCode(v.getItemCateCode());
                ystItemProportionParamV.setItemCodeList(itemCodes);
                ystItemProportionParamV.setItemProportion(v.getItemProportion());
                ystItemProportionParamV.setLessProportion(v.getLessProportion());
                ystItemProportionParamV.setLessNumber(v.getLessNumber());
                ystItemProportionParamV.setMoreProportion(v.getMoreProportion());
                this.ystItemProportionRepoProc.updateItemProportionBatch(ystItemProportionParamV);
            });
        } else {
            YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
            ystItemProportionParamVO.setSuppCode(suppCode);
            ystItemProportionParamVO.setItemCodeList(itemCodes);
            ystItemProportionParamVO.setItemCateCodeList(itemCateCodes);
            this.ystItemProportionRepoProc.updateDeleteFlagBatch(ystItemProportionParamVO);
            PurPurcPriceParamDTO purPurcPriceParamDTO = new PurPurcPriceParamDTO();
            purPurcPriceParamDTO.setSuppId(suppId);
            purPurcPriceParamDTO.setItemIds(itemids);
            purPurcPriceParamDTO.setBindStatus(SrmUdcEnum.CBPL_ITMBINDPRICE_B.getCode());
            this.purPurcPriceOutProvider.updateBindStatus(purPurcPriceParamDTO);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAllimport(List<YstSuppItemPageSaveVO> lists) {
        List<YstSuppItemSaveVO> param = YstSuppItemConvert.INSTANCE.pageSaveToSaveList(lists);
        if (!CollectionUtils.isEmpty(param) && this.ystSuppItemRepo.existsBySuppCode(param.get(0).getSuppCode())) {
            YstSuppItemParamVO ystSuppItemParamVO = new YstSuppItemParamVO();
            List<String> itemCodes = lists.stream().map(YstSuppItemPageSaveVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            ystSuppItemParamVO.setSuppCode(param.get(0).getSuppCode());
            ystSuppItemParamVO.setItemCodeList(itemCodes);
            this.ystSuppItemRepoProc.updateDeleteFlagBatch(ystSuppItemParamVO);
        }
        this.big100(lists);
        this.ystSuppItemRepo.saveAll(YstSuppItemConvert.INSTANCE.pageSaveListToDo(lists));
        List<YstItemProportionPageSaveVO> ystItemProportionPageSaveVOlist = lists.stream().map(i -> {
            YstItemProportionPageSaveVO DO = new YstItemProportionPageSaveVO();
            DO.setItemCode(i.getItemCode());
            DO.setItemCode2(i.getItemCode2());
            DO.setItemId(i.getItemId());
            DO.setItemCateCode(i.getItemCateCode());
            DO.setSuppCode(i.getSuppCode());
            DO.setSuppId(i.getSuppId());
            DO.setSuppId(i.getSuppId());
            DO.setItemProportion(i.getItemProportion());
            DO.setLessProportion(i.getLessProportion());
            DO.setLessNumber(i.getLessNumber());
            DO.setMoreProportion(i.getMoreProportion());
            return DO;
        }).collect(Collectors.toList());
        this.ystItemProportionProvider.updateAll(ystItemProportionPageSaveVOlist);
    }

    @Override
    public PagingVO<SuppItemCompRespVO> queryItemPicker(YstSuppItemPageParamVO paramVO) {
        return null;
    }

    private void big100(List<YstSuppItemPageSaveVO> param) {
        List<String> itemCodes = param.stream().map(YstSuppItemPageSaveVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> itemCateCodeS = param.stream().map(YstSuppItemPageSaveVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<YstSuppC13RespVO> ystSuppC13RespVOS = new ArrayList<YstSuppC13RespVO>();
        ArrayList<YstSuppItemRespVO> ystSuppItemRespVOS = new ArrayList<YstSuppItemRespVO>();
        if (this.ystSuppC13Repo.existsByItemCateCodeIn(itemCateCodeS)) {
            ystSuppC13RespVOS.addAll(this.selectProProtion(itemCateCodeS));
        }
        if (this.ystSuppItemRepo.existsByItemCodeIn(itemCodes)) {
            ystSuppItemRespVOS.addAll(this.selectItemProProtion(itemCodes));
        }
        if (!(CollectionUtils.isEmpty(param) || CollectionUtils.isEmpty(ystSuppC13RespVOS) && CollectionUtils.isEmpty(ystSuppItemRespVOS))) {
            param.forEach(v -> {
                if (!ObjectUtils.isEmpty((Object)v.getItemCateCode()) && !ObjectUtils.isEmpty((Object)v.getItemProportion())) {
                    BigDecimal sum;
                    Optional<YstSuppC13RespVO> first = ystSuppC13RespVOS.stream().filter(t -> v.getItemCateCode().equals(t.getItemCateCode())).filter(Objects::nonNull).distinct().findFirst();
                    Optional<YstSuppItemRespVO> first1 = ystSuppItemRespVOS.stream().filter(t -> v.getItemCode().equals(t.getItemCode())).filter(Objects::nonNull).distinct().findFirst();
                    if (first.isPresent() && first1.isPresent()) {
                        BigDecimal sum2;
                        if (!ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum2 = first.get().getProportion().add(v.getItemProportion()).add(first1.get().getProportion())).compareTo(new BigDecimal("100")) == 1) {
                            throw new BusinessException(ApiCode.FAIL, v.getItemCateCode() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%" + sum2 + "%");
                        }
                    } else if (first.isPresent()) {
                        BigDecimal sum3;
                        if (!ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum3 = first.get().getProportion().add(v.getItemProportion())).compareTo(new BigDecimal("100")) == 1) {
                            throw new BusinessException(ApiCode.FAIL, v.getItemCateCode() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%,\u6bd4\u4f8b\u4e3a" + sum3 + "%");
                        }
                    } else if (first1.isPresent() && !ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum = first1.get().getProportion().add(v.getItemProportion())).compareTo(new BigDecimal("100")) == 1) {
                        throw new BusinessException(ApiCode.FAIL, v.getItemCateCode() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%,\u6bd4\u4f8b\u4e3a" + sum + "%");
                    }
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void imports(MultipartFile file) {
        YstSuppItemListener listener = new YstSuppItemListener();
        try {
            EasyExcel.read((InputStream)file.getInputStream(), YstSuppItemExcelVO.class, (ReadListener)listener).sheet().doRead();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List<YstSuppItemExcelVO> datas = listener.getDatas();
        if (CollectionUtils.isEmpty(datas)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<YstSuppItemPageSaveVO> ystSuppItemSaveVoS = YstSuppItemConvert.INSTANCE.excelVoTOsavePageList(datas);
        ystSuppItemSaveVoS = ystSuppItemSaveVoS.stream().filter(Objects::nonNull).filter(o -> !StringUtils.isEmpty((CharSequence)o.getSuppCode()) && !StringUtils.isEmpty((CharSequence)o.getItemCateCode())).collect(Collectors.toList());
        List itemCodes = ystSuppItemSaveVoS.stream().map(YstSuppItemPageSaveVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> suppCodes = ystSuppItemSaveVoS.stream().map(YstSuppItemPageSaveVO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<SrmPurSuppDTO> purSuppBaseRespVOList = new ArrayList<SrmPurSuppDTO>();
        ArrayList<SrmItmItemNRespVO> itmItemRpcList = new ArrayList<SrmItmItemNRespVO>();
        if (!CollectionUtils.isEmpty(suppCodes)) {
            try {
                purSuppBaseRespVOList.addAll(this.srmService.findBySuppCodes(suppCodes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(itemCodes)) {
            try {
                SrmItmItemNParamVO itmItemRpcDtoParam = new SrmItmItemNParamVO();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                itmItemRpcList.addAll(this.itmService.findItemRpcDtoByParam(itmItemRpcDtoParam));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ystSuppItemSaveVoS.forEach(v -> {
            Optional<SrmPurSuppDTO> first;
            if (!ObjectUtils.isEmpty((Object)v.getSuppCode()) && (first = purSuppBaseRespVOList.stream().filter(t -> v.getSuppCode().equals(t.getSuppCode())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                v.setSuppId(first.get().getId());
                v.setSuppCode(first.get().getSuppCode());
            }
            if (!StringUtils.isEmpty((CharSequence)v.getItemCode()) && (first = itmItemRpcList.stream().filter(v1 -> v1.getItemCode().equals(v.getItemCode())).findFirst()).isPresent()) {
                v.setItemId(((SrmItmItemNRespVO)first.get()).getId());
                v.setItemCode(((SrmItmItemNRespVO)first.get()).getItemCode());
                v.setItemCode2(((SrmItmItemNRespVO)first.get()).getItemCode2());
                v.setItemCode3(((SrmItmItemNRespVO)first.get()).getItemCode3());
                v.setItemName(((SrmItmItemNRespVO)first.get()).getItemName());
                v.setItemCateCode(((SrmItmItemNRespVO)first.get()).getItemCateCode());
            }
        });
        Map<String, List<YstSuppItemPageSaveVO>> collect = ystSuppItemSaveVoS.stream().collect(Collectors.groupingBy(i -> i.getSuppCode()));
        collect.keySet().stream().forEach(key -> this.updateAllimport((List)collect.get(key)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        Optional byId = this.ystSuppItemRepo.findById(id);
        if (byId.isPresent()) {
            YstSuppItemParamVO ystSuppItemParamVO = new YstSuppItemParamVO();
            ystSuppItemParamVO.setId(id);
            this.ystSuppItemRepoProc.updateDeleteFlagBatch(ystSuppItemParamVO);
            YstSuppC13ParamVO ystSuppC13ParamVO = new YstSuppC13ParamVO();
            ystSuppC13ParamVO.setSuppCode(((YstSuppItemDO)byId.get()).getSuppCode());
            ystSuppC13ParamVO.setItemCateCode(((YstSuppItemDO)byId.get()).getItemCateCode());
            List<YstSuppC13RespVO> search = this.ystSuppC13RepoProc.searchM(ystSuppC13ParamVO);
            if (!CollectionUtils.isEmpty(search)) {
                YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
                ystItemProportionParamVO.setSuppCode(((YstSuppItemDO)byId.get()).getSuppCode());
                ystItemProportionParamVO.setItemCode(((YstSuppItemDO)byId.get()).getItemCode());
                ystItemProportionParamVO.setItemProportion(search.get(0).getItemProportion());
                ystItemProportionParamVO.setLessProportion(search.get(0).getLessProportion());
                ystItemProportionParamVO.setLessNumber(search.get(0).getLessNumber());
                ystItemProportionParamVO.setMoreProportion(search.get(0).getMoreProportion());
                this.ystItemProportionRepoProc.updateItemProportionBatch(ystItemProportionParamVO);
            } else {
                YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
                ystItemProportionParamVO.setSuppCode(((YstSuppItemDO)byId.get()).getSuppCode());
                ystItemProportionParamVO.setItemCode(((YstSuppItemDO)byId.get()).getItemCode());
                this.ystItemProportionRepoProc.updateDeleteFlagBatch(ystItemProportionParamVO);
                PurPurcPriceParamDTO purPurcPriceParamDTO = new PurPurcPriceParamDTO();
                purPurcPriceParamDTO.setSuppId(((YstSuppItemDO)byId.get()).getSuppId());
                ArrayList<Long> itemidlist = new ArrayList<Long>();
                itemidlist.add(((YstSuppItemDO)byId.get()).getItemId());
                purPurcPriceParamDTO.setItemIds(itemidlist);
                purPurcPriceParamDTO.setBindStatus(SrmUdcEnum.CBPL_ITMBINDPRICE_B.getCode());
                this.purPurcPriceOutProvider.updateBindStatus(purPurcPriceParamDTO);
            }
        }
    }

    @Override
    @Transactional
    public void changeSuppItemScore(YstSuppItemScorePayload payload) {
        this.ystSuppItemRepoProc.updateDeleteFlagBatch(payload);
    }

    @Override
    public PagingVO<YstSuppItemPageRespVO> searchProportion(YstSuppItemPageParamVO param) {
        return null;
    }

    @Override
    public void updateAllProportion(List<YstSuppItemPageSaveVO> param) {
    }

    @Override
    public void importsProportion(MultipartFile file) {
    }

    @Override
    public List<YstSuppItemPageRespVO> findByItemCode(String itemCode) {
        return null;
    }

    @Override
    public PagingVO<YstSuppItemPageRespVO> searchItem(YstSuppItemPageParamVO param) {
        return null;
    }

    private void fill(List<YstSuppItemRespVO> list, String suppCode) {
        List<String> suppCodes = list.stream().map(YstSuppItemRespVO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemCodes = list.stream().map(YstSuppItemRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<YstSuppC13RespVO> ystSuppC13RespVOList = new ArrayList<YstSuppC13RespVO>();
        ArrayList<SrmPurSuppDTO> purSuppBaseRespVOList = new ArrayList<SrmPurSuppDTO>();
        ArrayList<SrmItmItemNRespVO> itmItemRpcList = new ArrayList<SrmItmItemNRespVO>();
        ArrayList itmItemCateDetailsList = new ArrayList();
        if (!CollectionUtils.isEmpty(suppCodes)) {
            try {
                purSuppBaseRespVOList.addAll(this.srmService.findBySuppCodes(suppCodes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(itemCodes)) {
            try {
                SrmItmItemNParamVO itmItemRpcDtoParam = new SrmItmItemNParamVO();
                itmItemRpcDtoParam.setItemCodes(itemCodes);
                itmItemRpcList.addAll(this.itmService.findItemRpcDtoByParam(itmItemRpcDtoParam));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list.forEach(v -> {
            Optional<SrmPurSuppDTO> first;
            if (!ObjectUtils.isEmpty((Object)v.getSuppCode()) && (first = purSuppBaseRespVOList.stream().filter(t -> v.getSuppCode().equals(t.getSuppCode())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                v.setSuppCode(first.get().getSuppCode());
                v.setSuppName(first.get().getSuppName());
                v.setSuppType(first.get().getSuppType());
                v.setSuppTypeName(first.get().getSuppTypeName());
                v.setSuppAbbr(first.get().getSuppAbbr());
            }
            if (!StringUtils.isEmpty((CharSequence)v.getItemCode()) && (first = itmItemRpcList.stream().filter(v1 -> v1.getItemCode().equals(v.getItemCode())).findFirst()).isPresent()) {
                v.setItemCode(((SrmItmItemNRespVO)first.get()).getItemCode());
                v.setItemCode2(((SrmItmItemNRespVO)first.get()).getItemCode2());
                v.setItemCode3(((SrmItmItemNRespVO)first.get()).getItemCode3());
                v.setItemName(((SrmItmItemNRespVO)first.get()).getItemName());
                v.setSpec(((SrmItmItemNRespVO)first.get()).getSpec());
                v.setTooth(((SrmItmItemNRespVO)first.get()).getTooth());
                v.setTooth(((SrmItmItemNRespVO)first.get()).getTooth());
                v.setMaterial(((SrmItmItemNRespVO)first.get()).getMaterial());
                v.setDiameter(((SrmItmItemNRespVO)first.get()).getDiameter());
                v.setDiameterDesc(((SrmItmItemNRespVO)first.get()).getDiameterDesc());
                v.setLengths(((SrmItmItemNRespVO)first.get()).getLengths());
                v.setStamp(((SrmItmItemNRespVO)first.get()).getStamp());
                v.setStandard(((SrmItmItemNRespVO)first.get()).getStandard());
                List itemCatePathName = ((SrmItmItemNRespVO)first.get()).getItemCatePathName();
                String itemCateCodes = String.join((CharSequence)">", itemCatePathName);
                v.setItemCateCodeName(itemCateCodes);
            }
        });
        if (StringUtils.isNotBlank((CharSequence)suppCode)) {
            List<String> itemCateCodeS = list.stream().map(YstSuppItemRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(itemCateCodeS)) {
                try {
                    ystSuppC13RespVOList.addAll(this.ystSuppC13Service.findSuppCodeAndItemCateCode(suppCode, itemCateCodeS));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            list.forEach(v -> {
                Optional<YstSuppC13RespVO> first;
                v.setSuppBool(false);
                if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && !CollectionUtils.isEmpty((Collection)ystSuppC13RespVOList) && (first = ystSuppC13RespVOList.stream().filter(vo -> vo.getItemCateCode().equals(v.getItemCateCode())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                    YstSuppC13RespVO ystSuppC13RespVO = first.get();
                    v.setSuppBool(true);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void createAll(List<YstSuppItemPageSaveVO> param) {
        List<YstSuppItemDO> ystSuppItemDoS = YstSuppItemConvert.INSTANCE.pageSaveListToDo(param);
        this.ystSuppItemRepo.saveAll(ystSuppItemDoS);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.ystSuppItemRepo.deleteById(id);
    }

    public List<YstSuppC13RespVO> selectProProtion(List<String> list) {
        QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
        return ((JPAQuery)this.ystSuppC13RepoProc.selectProProtion().where((Predicate)ystSuppC13Do.itemCateCode.in(list))).fetch();
    }

    List<YstSuppItemRespVO> selectItemProProtion(List<String> list) {
        QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
        List fetch = ((JPAQuery)this.ystSuppItemRepoProc.selectProProtion().where((Predicate)ystSuppItemDo.itemCode.in(list))).fetch();
        return fetch;
    }

    public GeneralYstSuppItemProvider(YstSuppC13Provider ystSuppC13Service, YstSuppItemRepo ystSuppItemRepo, YstSuppItemRepoProc ystSuppItemRepoProc, YstSuppC13RepoProc ystSuppC13RepoProc, SrmService srmService, YstSuppC13Repo ystSuppC13Repo, ItmService itmService, YstItemProportionRepoProc ystItemProportionRepoProc, YstItemProportionProvider ystItemProportionProvider) {
        this.ystSuppC13Service = ystSuppC13Service;
        this.ystSuppItemRepo = ystSuppItemRepo;
        this.ystSuppItemRepoProc = ystSuppItemRepoProc;
        this.ystSuppC13RepoProc = ystSuppC13RepoProc;
        this.srmService = srmService;
        this.ystSuppC13Repo = ystSuppC13Repo;
        this.itmService = itmService;
        this.ystItemProportionRepoProc = ystItemProportionRepoProc;
        this.ystItemProportionProvider = ystItemProportionProvider;
    }
}

