/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.industry.medicinal.tm.item;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.supp.dto.SrmPurSuppDTO;
import com.elitesland.supp.outprovider.PurPurcPriceOutProvider;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.comm.vo.resp.ComTaxRateVO;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.srmdomain.itmitem.convert.SrmItmItemConvert;
import com.elitesland.yst.srmdomain.itmitem.provider.SrmItmItemProvider;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.srmdomain.itmitem.vo.excel.SrmItmItemExcelVO;
import com.elitesland.yst.srmdomain.itmitem.vo.excel.TmItmItemExcelVO;
import com.elitesland.yst.srmdomain.itmitem.vo.param.SrmItmItemPageParamVO;
import com.elitesland.yst.srmdomain.itmitem.vo.param.SrmItmItemParamVO;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.SrmItmItemDetailRespVO;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.SrmItmItemPageRespVO;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.SrmItmItemPriceRespVO;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.tm.EdpUdcVal;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.tm.TmSrmItmItemDetailRespVO;
import com.elitesland.yst.srmdomain.itmitem.vo.save.SrmItmItemPageSaveVO;
import com.elitesland.yst.srmdomain.out.service.ComOutService;
import com.elitesland.yst.srmdomain.out.service.SrmService;
import com.elitesland.yst.srmdomain.out.service.SuppService;
import com.elitesland.yst.srmdomain.proportion.entity.YstItemProportionDO;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepo;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepoProc;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstItemProportionParamVO;
import com.elitesland.yst.srmdomain.suppitem.provider.YstSuppItemProvider;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepoProc;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemParamVO;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemPageRespVO;
import com.elitesland.yst.srmdomain.util.enumproduct.FlowRoleCodeEnum;
import com.elitesland.yst.srmdomain.util.enumproduct.ItemDefKey;
import com.elitesland.yst.srmdomain.util.enumproduct.SrmUdcEnum;
import com.elitesland.yst.srmdomain.util.excel.exportExcel.ExcelWriteUtil;
import com.elitesland.yst.srmdomain.util.excel.importExcel.listener.ExcelEntityDataListener;
import com.elitesland.yst.srmdomain.ystsuppc13.entity.QYstSuppC13DO;
import com.elitesland.yst.srmdomain.ystsuppc13.provider.YstSuppC13Provider;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13RepoProc;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.resp.YstSuppC13PageRespVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.resp.YstSuppC13RespVO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemUomConvService;
import com.elitesland.yst.supportdomain.item.vo.TmItmItemUomConvVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.yst.supportdomain.provider.item.param.SrmItmItemNParamVO;
import com.elitesland.yst.supportdomain.provider.item.vo.SrmItmItemNRespVO;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.yst.system.service.SysUdcService;
import com.elitesland.yst.system.service.SysUserFlowRoleRpcService;
import com.elitesland.yst.system.vo.SysUdcVO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping
@Service
@UnicomTag(value="TONGMING")
public class TmSrmItmItemProvider
implements SrmItmItemProvider {
    private static final Logger log = LoggerFactory.getLogger(TmSrmItmItemProvider.class);
    private final ItmItemRepo ystItmItemRepo;
    private final SrmService srmService;
    private final SrmItmItemRepoProc ystItmItemRepoProc;
    @DubboReference
    private WorkflowService workflowService;
    public static final String COM = "COM";
    public static final String UOM = "UOM";
    private final YstSuppC13Provider ystSuppC13Service;
    private final YstSuppC13RepoProc ystSuppC13RepoProc;
    private final YstSuppItemRepoProc ystSuppItemRepoProc;
    private final YstSuppItemProvider ystitemService;
    private final YstItemProportionRepoProc ystItemProportionRepoproc;
    private final SuppService suppService;
    private final ComOutService comOutService;
    @DubboReference
    private SysUdcService sysUdcService;
    private final ItmItemCateService itmItemCateService;
    private final ItmItemUomConvService itmItemUomConvService;
    private final YstItemProportionRepoProc ystItemProportionRepoProc;
    private final OrgBuService orgBuService;
    @DubboReference
    private SysUserFlowRoleRpcService flowRoleRpcService;
    @Autowired
    private YstItemProportionRepo ystItemProportionRepo;
    @DubboReference
    private PurPurcPriceOutProvider purPurcPriceOutProvider;

    protected GeneralUserDetails currentUser() {
        return SecurityUtil.getUser();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateOne(SrmItmItemPageSaveVO param) {
        boolean tag = false;
        if (null == param.getId()) {
            tag = true;
        }
        SrmItmItemPageSaveVO srmItmItemPageSaveVO = this.updateOneS(param);
        if (tag && StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            this.crateItempros(Arrays.asList(srmItmItemPageSaveVO));
        }
        return srmItmItemPageSaveVO.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    void crateItempros(List<SrmItmItemPageSaveVO> srmItmItemPageSaveVOS) {
        List itemCateCodeS = srmItmItemPageSaveVOS.stream().map(SrmItmItemPageSaveVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList ystItemProportionPageSaveVOlist = new ArrayList();
        if (!CollectionUtils.isEmpty(itemCateCodeS)) {
            QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
            List fetch = ((JPAQuery)this.ystSuppC13RepoProc.select().where((Predicate)ystSuppC13Do.itemCateCode.in(itemCateCodeS))).fetch();
            if (!CollectionUtils.isEmpty((Collection)fetch)) {
                fetch.forEach(v -> {
                    List<SrmItmItemPageSaveVO> itmItemPageSaveVOS = srmItmItemPageSaveVOS.stream().filter(Objects::nonNull).filter(t -> v.getItemCateCode().equals(t.getItemCateCode())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(itmItemPageSaveVOS)) {
                        itmItemPageSaveVOS.forEach(s -> {
                            YstItemProportionDO ystItemProportionDO = new YstItemProportionDO();
                            ystItemProportionDO.setItemCateCode(v.getItemCateCode());
                            ystItemProportionDO.setSuppCode(v.getSuppCode());
                            ystItemProportionDO.setSuppId(v.getSuppId());
                            ystItemProportionDO.setItemCode(s.getItemCode());
                            ystItemProportionDO.setItemId(s.getId());
                            ystItemProportionPageSaveVOlist.add(ystItemProportionDO);
                        });
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty(ystItemProportionPageSaveVOlist)) {
            this.ystItemProportionRepo.saveAll(ystItemProportionPageSaveVOlist);
        }
    }

    @Override
    @SysCodeProc
    public PagingVO<SrmItmItemPageRespVO> search(SrmItmItemPageParamVO srmItmItemPageParamVO) {
        SrmItmItemParamVO param = SrmItmItemConvert.INSTANCE.pageParamToParamVO(srmItmItemPageParamVO);
        if (!ObjectUtils.isEmpty((Object)srmItmItemPageParamVO.getCurrent())) {
            param.setCurrent(srmItmItemPageParamVO.getCurrent() + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSuppCode())) {
            List<YstSuppItemPageRespVO> ystSuppItemList = this.ystitemService.findBySuppId(param.getSuppCode());
            List<YstSuppC13PageRespVO> ystSuppC13PageList = this.ystSuppC13Service.findAllbyid(param.getSuppCode());
            if (!CollectionUtils.isEmpty(ystSuppItemList)) {
                List<String> itemCodes = ystSuppItemList.stream().map(YstSuppItemPageRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                param.setItemCodeList(itemCodes);
            }
            if (!CollectionUtils.isEmpty(ystSuppC13PageList)) {
                List<String> suppCodes = ystSuppC13PageList.stream().map(YstSuppC13PageRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                param.setItemCateCodeList(suppCodes);
            }
            if (CollectionUtils.isEmpty(param.getItemCodeList()) && CollectionUtils.isEmpty(param.getItemCateCodeList())) {
                return new PagingVO();
            }
        }
        Long total = this.ystItmItemRepoProc.countContractTmplTm(param);
        List<SrmItmItemPageRespVO> search = this.ystItmItemRepoProc.searchSrmTTm(param);
        if (!CollectionUtils.isEmpty(search)) {
            this.fill(search, srmItmItemPageParamVO);
        }
        return total > 0L ? PagingVO.builder().total(total).records(search).build() : new PagingVO();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SrmItmItemExcelVO> importVeFile(MultipartFile file) {
        ExcelEntityDataListener ydExcelEntityDataListener = new ExcelEntityDataListener();
        try {
            EasyExcel.read((InputStream)file.getInputStream(), TmItmItemExcelVO.class, ydExcelEntityDataListener).doReadAll();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u5bfc\u5165\u6570\u636e\u5982\u65f6\u95f4\uff0c\u6570\u5b57\u683c\u5f0f\u5f02\u5e38,\u8bf7\u68c0\u67e5");
        }
        List<TmItmItemExcelVO> ystItmItemExcelVOList = ydExcelEntityDataListener.getDatas();
        ystItmItemExcelVOList = ystItmItemExcelVOList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        ystItmItemExcelVOList.forEach(v -> {
            ArrayList<String> runtimeValues = new ArrayList<String>();
            String itemCode = this.comOutService.generateCode("SPU_NO", runtimeValues);
            v.setSpuId(0L);
            v.setItemCode(itemCode);
            if (StringUtils.isNotBlank((CharSequence)v.getUomName())) {
                SysUdcVO oneSysUdc = this.sysUdcService.findOneSysUdc(COM, UOM, v.getUomName());
                if (Objects.isNull(oneSysUdc)) {
                    throw new BusinessException("\u5355\u4f4d " + v.getUomName() + " \u4e0d\u5b58\u5728");
                }
                v.setUom(v.getUomName());
            }
        });
        List<ItmItemDO> ItmItemDOS = SrmItmItemConvert.INSTANCE.excelVoToDo(ystItmItemExcelVOList);
        List itmItemDOS = this.ystItmItemRepo.saveAll(ItmItemDOS);
        List<SrmItmItemPageSaveVO> srmItmItemPageSaveVOS = SrmItmItemConvert.INSTANCE.excelVoToPage(itmItemDOS);
        this.crateItempros(srmItmItemPageSaveVOS);
        return null;
    }

    @Override
    @SysCodeProc
    public Optional<TmSrmItmItemDetailRespVO> findIdOne(Long id) {
        QItmItemDO itmItem = QItmItemDO.itmItemDO;
        JPAQuery where = (JPAQuery)this.ystItmItemRepoProc.selectTmDetail().where((Predicate)itmItem.id.eq((Object)id));
        Optional first = where.fetch().stream().findFirst();
        if (first.isPresent()) {
            TmSrmItmItemDetailRespVO SrmItmItemPageRespVO1 = (TmSrmItmItemDetailRespVO)first.get();
            this.fillDetail(Arrays.asList(SrmItmItemPageRespVO1));
            return Optional.of(SrmItmItemPageRespVO1);
        }
        return Optional.empty();
    }

    @Override
    @SysCodeProc
    public Object findParam(SrmItmItemPageParamVO SrmItmItemPageParamVO2) {
        SrmItmItemParamVO param = SrmItmItemConvert.INSTANCE.pageParamToParamVO(SrmItmItemPageParamVO2);
        List search = ((JPAQuery)this.ystItmItemRepoProc.selectTmDetail().where(this.ystItmItemRepoProc.whereTm(param))).fetch();
        this.filltm(search);
        return search;
    }

    private void filltm(List<TmSrmItmItemDetailRespVO> list) {
        List itemCateCodeS = list.stream().map(SrmItmItemDetailRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> ouIds = list.stream().map(SrmItmItemDetailRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> buIds = list.stream().map(SrmItmItemDetailRespVO::getBuId).distinct().collect(Collectors.toList());
        List<String> taxNoList = list.stream().map(SrmItmItemDetailRespVO::getTaxRateNo).distinct().collect(Collectors.toList());
        List<String> uomlist = list.stream().map(TmSrmItmItemDetailRespVO::getUom).distinct().collect(Collectors.toList());
        List uom2list = list.stream().map(TmSrmItmItemDetailRespVO::getUom2).distinct().collect(Collectors.toList());
        List purcList = list.stream().map(TmSrmItmItemDetailRespVO::getPurcUom).distinct().collect(Collectors.toList());
        List<Long> idlist = list.stream().map(SrmItmItemDetailRespVO::getId).distinct().collect(Collectors.toList());
        uomlist.addAll(uom2list);
        uomlist.addAll(purcList);
        ArrayList<OrgOuRpcDTO> orgOuList = new ArrayList<OrgOuRpcDTO>();
        ArrayList<OrgBuDTO> orgBuList = new ArrayList<OrgBuDTO>();
        ArrayList<ComTaxRateVO> comTaxRateVoS = new ArrayList<ComTaxRateVO>();
        ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
        codeParam.setItemCateCodes(itemCateCodeS);
        Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.suppService.findCateCodeReItemCateCode(codeParam);
        if (!CollectionUtils.isEmpty(ouIds)) {
            try {
                orgOuList.addAll(this.suppService.findOuByIds(ouIds));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(buIds)) {
            try {
                OrgBuDtoParam buParam = OrgBuDtoParam.builder().buIds(buIds).build();
                orgBuList.addAll(this.orgBuService.findBuDtoByParam(buParam));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(taxNoList)) {
            try {
                comTaxRateVoS.addAll(this.comOutService.findTaxRateBytaxRateNoList(taxNoList));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<TmItmItemUomConvVO> itmItemUomConvByItemIdsanduom = new ArrayList<TmItmItemUomConvVO>();
        if (!CollectionUtils.isEmpty(idlist) && !CollectionUtils.isEmpty(uomlist)) {
            try {
                itmItemUomConvByItemIdsanduom.addAll(this.itmItemUomConvService.getItmItemUomConvByItemIdsanduom(idlist, uomlist));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list.forEach(v -> {
            List itmItemUomConvVOList;
            Optional<ComTaxRateVO> comTaxRateOptional;
            Optional<OrgBuDTO> first;
            Optional<OrgOuRpcDTO> orgOuVO;
            if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                List cateNameList = codeAndNameRpcDTO.getCateNameList();
                if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                    v.setItemCateName(String.join((CharSequence)">", cateNameList));
                    int size = cateNameList.size();
                    v.setItemCateName3((String)cateNameList.get(size - 1));
                }
            }
            if (!ObjectUtils.isEmpty((Object)v.getOuId()) && (orgOuVO = orgOuList.stream().filter(vo -> vo.getId().equals(v.getOuId())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                OrgOuRpcDTO ouVO = orgOuVO.get();
                v.setOuName(ouVO.getOuName());
                v.setOuCode(ouVO.getOuCode());
            }
            if (!ObjectUtils.isEmpty((Object)v.getBuId()) && (first = orgBuList.stream().filter(Objects::nonNull).filter(vo -> vo.getId().equals(v.getBuId())).findFirst()).isPresent()) {
                OrgBuDTO orgBuVO = first.get();
                v.setBuName(orgBuVO.getBuName());
                v.setBuCode(orgBuVO.getBuCode());
            }
            if (!ObjectUtils.isEmpty((Object)v.getTaxRateNo()) && (comTaxRateOptional = comTaxRateVoS.stream().filter(taxRateVo -> Objects.equals(taxRateVo.getTaxRateNo(), v.getTaxRateNo())).findFirst()).isPresent()) {
                v.setTaxRateDesc(comTaxRateOptional.get().getTaxRateDesc());
                v.setTaxRate(!ObjectUtils.isEmpty((Object)comTaxRateOptional.get().getTaxRateValue()) ? BigDecimal.valueOf(comTaxRateOptional.get().getTaxRateValue()) : null);
            }
            if (!CollectionUtils.isEmpty((Collection)itmItemUomConvByItemIdsanduom) && !CollectionUtils.isEmpty(itmItemUomConvVOList = itmItemUomConvByItemIdsanduom.stream().filter(conv -> Objects.equals(conv.getItemId(), v.getId())).distinct().collect(Collectors.toList()))) {
                List edpUdcValList = itmItemUomConvVOList.stream().map(i -> {
                    EdpUdcVal edpUdcVal = new EdpUdcVal();
                    edpUdcVal.setUdcVal(i.getFromUom());
                    edpUdcVal.setUdcTxt(i.getFromUomName());
                    return edpUdcVal;
                }).collect(Collectors.toList());
                List edpUdcVals = itmItemUomConvVOList.stream().map(i -> {
                    EdpUdcVal edpUdcVal = new EdpUdcVal();
                    edpUdcVal.setUdcVal(i.getToUom());
                    edpUdcVal.setUdcTxt(i.getToUomName());
                    return edpUdcVal;
                }).collect(Collectors.toList());
                edpUdcValList.removeAll(edpUdcVals);
                edpUdcValList.addAll(edpUdcVals);
                List<EdpUdcVal> edpUdcVals1 = edpUdcValList.stream().distinct().collect(Collectors.toList());
                v.setEdpUdcValList(edpUdcVals1);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createOne(SrmItmItemPageSaveVO param) {
        ItmItemDO ItmItemDO2 = SrmItmItemConvert.INSTANCE.saveToDo(param);
        ArrayList<String> runtimeValues = new ArrayList<String>();
        String itemCode = this.comOutService.generateCode("SPU_NO", runtimeValues);
        ItmItemDO2.setItemCode(itemCode);
        return ((ItmItemDO)this.ystItmItemRepo.save(ItmItemDO2)).getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createAll(List<SrmItmItemPageSaveVO> param) {
        List<ItmItemDO> ItmItemDOS = SrmItmItemConvert.INSTANCE.saveListToDo(param);
        this.ystItmItemRepo.saveAll(ItmItemDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public SrmItmItemPageSaveVO updateOneS(SrmItmItemPageSaveVO param) {
        if (param.getId() != null) {
            Optional first = this.ystItmItemRepo.findById(param.getId());
            if (!first.isPresent()) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
            }
            if (!ObjectUtils.isEmpty((Object)param.getItemCateCode())) {
                String[] splitItemCateCode = param.getItemCateCode().split("-");
                if (splitItemCateCode.length > 0) {
                    param.setC1Code(splitItemCateCode[0]);
                }
                if (splitItemCateCode.length > 1) {
                    param.setC2Code(splitItemCateCode[1]);
                }
                if (splitItemCateCode.length > 2) {
                    param.setC3Code(splitItemCateCode[2]);
                }
            }
            SrmItmItemConvert.INSTANCE.copyRpSaveToDo(param, (ItmItemDO)first.get());
            if (param.isSubmitted()) {
                ((ItmItemDO)first.get()).setProcInstStatus(ProcInstStatus.APPROVING);
                ((ItmItemDO)first.get()).setItemStatus(SrmUdcEnum.CBPL_ITMITEMSTATUS_B.getValueCode());
            }
            this.ystItmItemRepo.save((ItmItemDO)first.get());
        } else {
            ArrayList<String> runtimeValues = new ArrayList<String>();
            String itemCode = this.comOutService.generateCode("SPU_NO", runtimeValues);
            param.setItemCode(itemCode);
            ItmItemDO itmItemDO = SrmItmItemConvert.INSTANCE.saveToDo(param);
            if (param.isSubmitted()) {
                itmItemDO.setProcInstStatus(ProcInstStatus.APPROVING);
                itmItemDO.setItemStatus(SrmUdcEnum.CBPL_ITMITEMSTATUS_B.getValueCode());
            }
            itmItemDO.setSpuId(0L);
            if (!ObjectUtils.isEmpty((Object)itmItemDO.getItemCateCode())) {
                String[] splitItemCateCode = param.getItemCateCode().split("-");
                if (splitItemCateCode.length > 0) {
                    itmItemDO.setC1Code(splitItemCateCode[0]);
                }
                if (splitItemCateCode.length > 1) {
                    itmItemDO.setC2Code(splitItemCateCode[1]);
                }
                if (splitItemCateCode.length > 2) {
                    itmItemDO.setC3Code(splitItemCateCode[2]);
                }
            }
            Long id = ((ItmItemDO)this.ystItmItemRepo.save(itmItemDO)).getId();
            param.setId(id);
        }
        return param;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<SrmItmItemPageSaveVO> updateAll(List<SrmItmItemPageSaveVO> param) {
        if (!CollectionUtils.isEmpty(param)) {
            List ids = param.stream().map(SrmItmItemPageSaveVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
            List ystItmItemBatch = new ArrayList();
            if (!CollectionUtils.isEmpty(ids)) {
                try {
                    ystItmItemBatch = this.ystItmItemRepo.findAllById(ids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (SrmItmItemPageSaveVO detailDTO : param) {
                if (detailDTO.getId() != null) {
                    Optional<ItmItemDO> first = ystItmItemBatch.stream().filter(t -> detailDTO.getId().equals(t.getId())).findFirst();
                    if (!first.isPresent()) {
                        throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
                    }
                    SrmItmItemConvert.INSTANCE.copyRpSaveToDo(detailDTO, first.get());
                    this.ystItmItemRepo.save(first.get());
                    continue;
                }
                Long id = ((ItmItemDO)this.ystItmItemRepo.save(SrmItmItemConvert.INSTANCE.saveToDo(detailDTO))).getId();
                detailDTO.setId(id);
            }
        }
        return param;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.ystItmItemRepo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ids.forEach(this::deleteOne);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        SrmItmItemParamVO srmItmItemParamVO = new SrmItmItemParamVO();
        srmItmItemParamVO.setIds(ids);
        List<SrmItmItemPageRespVO> srmItmItemPageRespVOList = this.ystItmItemRepoProc.searchSrmM(srmItmItemParamVO);
        List<String> itemCodes = srmItmItemPageRespVOList.stream().map(SrmItmItemPageRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemId = srmItmItemPageRespVOList.stream().map(SrmItmItemPageRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.ystItmItemRepoProc.updateDeleteFlagBatch(srmItmItemParamVO);
        YstSuppItemParamVO ystSuppItemParamVO = new YstSuppItemParamVO();
        ystSuppItemParamVO.setItemCodeList(itemCodes);
        this.ystSuppItemRepoProc.updateDeleteFlagBatchTm(ystSuppItemParamVO);
        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
        ystItemProportionParamVO.setItemCodeList(itemCodes);
        this.ystItemProportionRepoproc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        SrmItmItemParamVO SrmItmItemParamVO2 = new SrmItmItemParamVO();
        SrmItmItemParamVO2.setId(id);
        Long count = this.ystItmItemRepoProc.updateDeleteFlagBatch(SrmItmItemParamVO2);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String submitInquiry(SrmItmItemPageSaveVO saveParam) {
        SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
        ArrayList<Long> ouList = new ArrayList<Long>();
        ouList.add(saveParam.getOuId());
        param.setOuIds(ouList);
        param.setFlowRoleCodes((List)Lists.newArrayList((Object[])new String[]{FlowRoleCodeEnum.PUR_MANAGER.name()}));
        List yybzFlowRoles = this.flowRoleRpcService.findUserIdsByFlowRoles(param);
        List yybzUserIds = yybzFlowRoles.stream().map(e -> String.valueOf(e)).collect(Collectors.toList());
        HashMap map = new HashMap(1);
        System.out.println("\u6253\u5370\u89d2\u8272" + yybzUserIds);
        map.put("Activity_0oufj22", yybzUserIds);
        ProcessInfo processInfo = this.workflowService.startProcess(ItemDefKey.ITM_ITEM_CREATE.getCode(), ItemDefKey.ITM_ITEM_CREATE.getDesc(), "" + saveParam.getId(), map);
        this.ystItmItemRepo.updateWorkflowInItmitem(saveParam.getId(), processInfo.getProcInstId(), SrmUdcEnum.CBPL_ITMITEMSTATUS_B.getValueCode());
        return processInfo.getProcInstId();
    }

    private void fill(List<SrmItmItemPageRespVO> list, SrmItmItemPageParamVO SrmItmItemPageParamVO2) {
        List<String> itemCateCodeS = list.stream().map(SrmItmItemPageRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> ouIds = list.stream().map(SrmItmItemPageRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> buIds = list.stream().map(SrmItmItemPageRespVO::getBuId).distinct().collect(Collectors.toList());
        List<String> taxNoList = list.stream().map(SrmItmItemPageRespVO::getTaxRateNo).distinct().collect(Collectors.toList());
        ArrayList<OrgOuRpcDTO> orgOuList = new ArrayList<OrgOuRpcDTO>();
        ArrayList<YstSuppC13RespVO> ystSuppC13RespVOList = new ArrayList<YstSuppC13RespVO>();
        ArrayList<OrgBuDTO> orgBuList = new ArrayList<OrgBuDTO>();
        ArrayList<ComTaxRateVO> comTaxRateVoS = new ArrayList<ComTaxRateVO>();
        ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
        codeParam.setItemCateCodes(itemCateCodeS);
        Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.suppService.findCateCodeReItemCateCode(codeParam);
        if (!CollectionUtils.isEmpty(ouIds)) {
            try {
                orgOuList.addAll(this.suppService.findOuByIds(ouIds));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!ObjectUtils.isEmpty((Object)SrmItmItemPageParamVO2.getSuppCode2()) && !CollectionUtils.isEmpty(itemCateCodeS)) {
            try {
                ystSuppC13RespVOList.addAll(this.ystSuppC13Service.findSuppCodeAndItemCateCode(SrmItmItemPageParamVO2.getSuppCode2(), itemCateCodeS));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(buIds)) {
            try {
                OrgBuDtoParam buParam = OrgBuDtoParam.builder().buIds(buIds).build();
                orgBuList.addAll(this.orgBuService.findBuDtoByParam(buParam));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(taxNoList)) {
            try {
                comTaxRateVoS.addAll(this.comOutService.findTaxRateBytaxRateNoList(taxNoList));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list.forEach(v -> {
            Optional<ComTaxRateVO> comTaxRateOptional;
            Optional<OrgOuRpcDTO> orgOuVO;
            Optional<Serializable> first;
            v.setSuppBool(false);
            if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode())) {
                if (null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                    ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                    List cateNameList = codeAndNameRpcDTO.getCateNameList();
                    if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                        v.setItemCateName(String.join((CharSequence)">", cateNameList));
                        int size = cateNameList.size();
                        if (size > 2) {
                            v.setC2Name((String)cateNameList.get(size - 2));
                        }
                        if (size > 1) {
                            v.setItemCateName3((String)cateNameList.get(size - 1));
                        }
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)ystSuppC13RespVOList) && (first = ystSuppC13RespVOList.stream().filter(vo -> vo.getItemCateCode().equals(v.getItemCateCode())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                    YstSuppC13RespVO ystSuppC13RespVO = (YstSuppC13RespVO)first.get();
                    v.setSuppBool(true);
                }
            }
            if (!ObjectUtils.isEmpty((Object)v.getOuId()) && (orgOuVO = orgOuList.stream().filter(vo -> vo.getId().equals(v.getOuId())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                OrgOuRpcDTO ouVO = orgOuVO.get();
                v.setOuName(ouVO.getOuName());
                v.setOuCode(ouVO.getOuCode());
            }
            if (!ObjectUtils.isEmpty((Object)v.getBuId()) && (first = orgBuList.stream().filter(Objects::nonNull).filter(vo -> vo.getId().equals(v.getBuId())).findFirst()).isPresent()) {
                OrgBuDTO orgBuVO = (OrgBuDTO)first.get();
                v.setBuName(orgBuVO.getBuName());
                v.setBuCode(orgBuVO.getBuCode());
            }
            if (!ObjectUtils.isEmpty((Object)v.getTaxRateNo()) && (comTaxRateOptional = comTaxRateVoS.stream().filter(taxRateVo -> Objects.equals(taxRateVo.getTaxRateNo(), v.getTaxRateNo())).findFirst()).isPresent()) {
                v.setTaxRateDesc(comTaxRateOptional.get().getTaxRateDesc());
                v.setTaxRate(!ObjectUtils.isEmpty((Object)comTaxRateOptional.get().getTaxRateValue()) ? BigDecimal.valueOf(comTaxRateOptional.get().getTaxRateValue()) : null);
            }
        });
    }

    private void fillDetail(List<TmSrmItmItemDetailRespVO> list) {
        List itemCateCodeS = list.stream().map(SrmItmItemDetailRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> ouIds = list.stream().map(SrmItmItemDetailRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> buIds = list.stream().map(SrmItmItemDetailRespVO::getBuId).distinct().collect(Collectors.toList());
        List<String> taxNoList = list.stream().map(SrmItmItemDetailRespVO::getTaxRateNo).distinct().collect(Collectors.toList());
        ArrayList<OrgOuRpcDTO> orgOuList = new ArrayList<OrgOuRpcDTO>();
        ArrayList ystSuppC13RespVOList = new ArrayList();
        ArrayList<OrgBuDTO> orgBuList = new ArrayList<OrgBuDTO>();
        ArrayList<ComTaxRateVO> comTaxRateVoS = new ArrayList<ComTaxRateVO>();
        ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
        codeParam.setItemCateCodes(itemCateCodeS);
        Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.suppService.findCateCodeReItemCateCode(codeParam);
        if (!CollectionUtils.isEmpty(ouIds)) {
            try {
                orgOuList.addAll(this.suppService.findOuByIds(ouIds));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(buIds)) {
            try {
                OrgBuDtoParam buParam = OrgBuDtoParam.builder().buIds(buIds).build();
                orgBuList.addAll(this.orgBuService.findBuDtoByParam(buParam));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!CollectionUtils.isEmpty(taxNoList)) {
            try {
                comTaxRateVoS.addAll(this.comOutService.findTaxRateBytaxRateNoList(taxNoList));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list.forEach(v -> {
            Optional<ComTaxRateVO> comTaxRateOptional;
            Optional<OrgBuDTO> first;
            Optional<OrgOuRpcDTO> orgOuVO;
            if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                List cateNameList = codeAndNameRpcDTO.getCateNameList();
                if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                    v.setItemCateName(String.join((CharSequence)">", cateNameList));
                    int size = cateNameList.size();
                    v.setItemCateName3((String)cateNameList.get(size - 1));
                }
            }
            if (!ObjectUtils.isEmpty((Object)v.getOuId()) && (orgOuVO = orgOuList.stream().filter(vo -> vo.getId().equals(v.getOuId())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                OrgOuRpcDTO ouVO = orgOuVO.get();
                v.setOuName(ouVO.getOuName());
                v.setOuCode(ouVO.getOuCode());
            }
            if (!ObjectUtils.isEmpty((Object)v.getBuId()) && (first = orgBuList.stream().filter(Objects::nonNull).filter(vo -> vo.getId().equals(v.getBuId())).findFirst()).isPresent()) {
                OrgBuDTO orgBuVO = first.get();
                v.setBuName(orgBuVO.getBuName());
                v.setBuCode(orgBuVO.getBuCode());
            }
            if (!ObjectUtils.isEmpty((Object)v.getTaxRateNo()) && (comTaxRateOptional = comTaxRateVoS.stream().filter(taxRateVo -> Objects.equals(taxRateVo.getTaxRateNo(), v.getTaxRateNo())).findFirst()).isPresent()) {
                v.setTaxRateDesc(comTaxRateOptional.get().getTaxRateDesc());
                v.setTaxRate(!ObjectUtils.isEmpty((Object)comTaxRateOptional.get().getTaxRateValue()) ? BigDecimal.valueOf(comTaxRateOptional.get().getTaxRateValue()) : null);
            }
        });
    }

    @Override
    public void updateInquiryStatus(long businessKey, String docStatus, ProcInstStatus procInstStatus) {
        if (StringUtils.isNotBlank((CharSequence)docStatus) && SrmUdcEnum.CBPL_ITMITEMSTATUS_C.getValueCode().equals(docStatus)) {
            this.ystItmItemRepoProc.updateInquiryStatus(Collections.singletonList(businessKey), docStatus, LocalDateTime.now(), procInstStatus);
        } else {
            this.ystItmItemRepoProc.updateInquiryStatus(Collections.singletonList(businessKey), docStatus, procInstStatus);
        }
    }

    private void fillPrice(List<SrmItmItemPriceRespVO> list) {
        List itemCateCodeS = list.stream().map(SrmItmItemPriceRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> suppIds = list.stream().map(SrmItmItemPriceRespVO::getSuppId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
        codeParam.setItemCateCodes(itemCateCodeS);
        ArrayList<SrmPurSuppDTO> srmPurSuppList = new ArrayList<SrmPurSuppDTO>();
        Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.suppService.findCateCodeReItemCateCode(codeParam);
        if (!CollectionUtils.isEmpty(suppIds)) {
            try {
                srmPurSuppList.addAll(this.srmService.findPurSuppbyId(suppIds));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        list.forEach(v -> {
            v.setItemId(v.getId());
            if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                List cateNameList = codeAndNameRpcDTO.getCateNameList();
                if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                    v.setItemCateName(String.join((CharSequence)">", cateNameList));
                }
            }
            srmPurSuppList.stream().filter(orgSuppVO -> orgSuppVO.getId().equals(v.getSuppId())).findFirst().ifPresent(orgSuppVO -> {
                v.setSuppName(orgSuppVO.getSuppName());
                v.setSuppCode(orgSuppVO.getSuppCode());
            });
        });
    }

    @Override
    public List<SrmItmItemNRespVO> findItemRpcDtoByParam(SrmItmItemNParamVO param) {
        try {
            List srmList = this.ystItmItemRepoProc.selectNTm(param).fetch();
            if (!CollectionUtils.isEmpty((Collection)srmList)) {
                this.fill(srmList);
                return srmList;
            }
        }
        catch (Exception e) {
            log.error("findItemUomConvDtoByParam error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public void stkAcctExport(HttpServletResponse response, SrmItmItemPageParamVO param) throws IOException {
        param.setSize(20000);
        List ystItmItemRespVOList = this.search(param).getRecords();
        List<TmItmItemExcelVO> ystItmItemExcelVOS = SrmItmItemConvert.INSTANCE.voListToTmExcelVo(ystItmItemRespVOList);
        ExcelWriteUtil.excelWrite(response, ystItmItemExcelVOS, TmItmItemExcelVO.class, "YstItmItem\u5bfc\u51fa", "YstItmItem\u5bfc\u51fa");
    }

    private void fill(List<SrmItmItemNRespVO> list) {
        List itemCateCodeS = list.stream().map(SrmItmItemNRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        try {
            ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
            codeParam.setItemCateCodes(itemCateCodeS);
            Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.findCateCodeReItemCateCode(codeParam);
            list.forEach(v -> {
                if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                    ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                    List cateNameList = codeAndNameRpcDTO.getCateNameList();
                    v.setItemCatePathName(cateNameList);
                    if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                        v.setItemCateName(String.join((CharSequence)">", cateNameList));
                    }
                }
                if (!ObjectUtils.isEmpty((Object)v.getItemCateCode())) {
                    String[] splitItemCateCode = v.getItemCateCode().split("-");
                    if (splitItemCateCode.length > 0) {
                        v.setC1Code(splitItemCateCode[0]);
                    }
                    if (splitItemCateCode.length > 1) {
                        v.setC2Code(splitItemCateCode[1]);
                    }
                    if (splitItemCateCode.length > 2) {
                        v.setC3Code(splitItemCateCode[2]);
                    }
                }
                if (!ObjectUtils.isEmpty((Object)v.getItemCateName())) {
                    String[] splitItemCateName = v.getItemCateName().split(">");
                    if (splitItemCateName.length > 0) {
                        v.setC1Name(splitItemCateName[0]);
                    }
                    if (splitItemCateName.length > 1) {
                        v.setC2Name(splitItemCateName[1]);
                    }
                    if (splitItemCateName.length > 2) {
                        v.setC3Name(splitItemCateName[2]);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
        }
    }

    public Map<String, ItmCateCodeAndNameRpcDTO> findCateCodeReItemCateCode(ItmItemCateCodeParam param) {
        log.info("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3findCateCodeReItemCateCode\u65b9\u6cd5\u5f00\u59cb,\u65f6\u95f4:{},\u53c2\u6570:{}", (Object)param);
        try {
            if (CollectionUtils.isEmpty((Collection)param.getItemCateCodes())) {
                return null;
            }
            ItmItemCateCodeRpcDTO itemCateCode = this.findCateCodeReItemCateCodes(param);
            Map itemCateCodeCateMap = itemCateCode.getCateMap();
            return itemCateCodeCateMap;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    public ItmItemCateCodeRpcDTO findCateCodeReItemCateCodes(ItmItemCateCodeParam param) {
        List itemCateCodes = param.getItemCateCodes();
        HashMap resultMap = new HashMap();
        itemCateCodes.forEach(itemCateCode -> {
            List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath((String)itemCateCode);
            ArrayList<String> pathCode = new ArrayList<String>();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathCodeAndName(path, pathCode, pathName);
            resultMap.put(itemCateCode, ItmCateCodeAndNameRpcDTO.builder().cateNameList(pathName).cateCodeList(pathCode).build());
        });
        return ItmItemCateCodeRpcDTO.builder().cateMap(resultMap).build();
    }

    private void buildPathCodeAndName(List<ItmItemCateSimpleTree> tree, List<String> pathCode, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathCode.add(t.getItemCateCode());
            pathName.add(t.getItemCateName());
            this.buildPathCodeAndName(t.getTreeNodes(), pathCode, pathName);
        });
    }

    @Override
    public void exportTemplate(HttpServletResponse response) throws IOException {
        ArrayList<TmItmItemExcelVO> ystItmItemExcelVOList = new ArrayList<TmItmItemExcelVO>();
        TmItmItemExcelVO ystItmItemExcelVO = new TmItmItemExcelVO();
        ystItmItemExcelVO.setItemCode("1");
        ystItmItemExcelVO.setItemCode2("2");
        ystItmItemExcelVO.setItemName("\u6d4b\u8bd5\u7269\u6599");
        ystItmItemExcelVO.setItemCateCode("00-00-00");
        ystItmItemExcelVO.setSpec("\u89c4\u683c");
        ystItmItemExcelVO.setUom("EA");
        ystItmItemExcelVOList.add(ystItmItemExcelVO);
        ExcelWriteUtil.excelWrite(response, ystItmItemExcelVOList, TmItmItemExcelVO.class, "YstItmItem\u5bfc\u51fa", "YstItmItem\u5bfc\u51fa");
    }

    @Override
    public void textDataRelationshipSource(String type, List<Long> ids) {
        List dataRelationshipSourceList;
        List itemCodes;
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        QItmItemDO itmItem = QItmItemDO.itmItemDO;
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)itmItem.id.in(ids));
        if (ItmUdcEnum.ITM_DATASOURCE_A.getUdcVal().equals(type)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)itmItem.ismutex.eq(Boolean.TRUE).or((Predicate)itmItem.ismutex.eq(Boolean.TRUE)));
        }
        if (ItmUdcEnum.ITM_DATASOURCE_B.getUdcVal().equals(type)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)itmItem.isproportion.eq(Boolean.TRUE).or((Predicate)itmItem.tagItm.eq(Boolean.TRUE)));
        }
        if (ItmUdcEnum.ITM_DATASOURCE_C.getUdcVal().equals(type)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)itmItem.isproportion.eq(Boolean.TRUE).or((Predicate)itmItem.ismutex.eq(Boolean.TRUE)));
        }
        List srmItmItemPageRespVOList = ((JPAQuery)this.ystItmItemRepoProc.textDataRelationshipSource().where((Predicate)predicate)).fetch();
        if (ItmUdcEnum.ITM_DATASOURCE_A.getUdcVal().equals(type) && !CollectionUtils.isEmpty(itemCodes = (dataRelationshipSourceList = srmItmItemPageRespVOList.stream().filter(vo -> vo.getIsmutex() != false && vo.getTagItm() != false).filter(Objects::nonNull).collect(Collectors.toList())).stream().map(vo -> vo.getItemCode()).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25" + itemCodes + "\u4e92\u65a5\u4fdd\u5b58\u65f6\u5019\u63d0\u4e92\u65a5\u5173\u7cfb/\u5546\u54c1\u6bd4\u4f8b/\u5546\u54c1\u4e0a\u662f\u5426\u5206\u6563\u6253\u6563\u6807\u8bb0\u5df2\u7ecf\u5b58\u5728");
        }
        if (ItmUdcEnum.ITM_DATASOURCE_B.getUdcVal().equals(type) && !CollectionUtils.isEmpty(itemCodes = (dataRelationshipSourceList = srmItmItemPageRespVOList.stream().filter(vo -> vo.getIsproportion() != false && vo.getTagItm() != false).filter(Objects::nonNull).collect(Collectors.toList())).stream().map(vo -> vo.getItemCode()).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25" + itemCodes + "\u4e92\u65a5\u4fdd\u5b58\u65f6\u5019\u63d0\u4e92\u65a5\u5173\u7cfb/\u5546\u54c1\u6bd4\u4f8b/\u5546\u54c1\u4e0a\u662f\u5426\u5206\u6563\u6253\u6563\u6807\u8bb0\u5df2\u7ecf\u5b58\u5728");
        }
        if (ItmUdcEnum.ITM_DATASOURCE_C.getUdcVal().equals(type) && !CollectionUtils.isEmpty(itemCodes = (dataRelationshipSourceList = srmItmItemPageRespVOList.stream().filter(vo -> vo.getIsmutex() != false && vo.getIsproportion() != false).filter(Objects::nonNull).collect(Collectors.toList())).stream().map(vo -> vo.getItemCode()).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25" + itemCodes + "\u4e92\u65a5\u4fdd\u5b58\u65f6\u5019\u63d0\u4e92\u65a5\u5173\u7cfb/\u5546\u54c1\u6bd4\u4f8b/\u5546\u54c1\u4e0a\u662f\u5426\u5206\u6563\u6253\u6563\u6807\u8bb0\u5df2\u7ecf\u5b58\u5728");
        }
    }

    public TmSrmItmItemProvider(ItmItemRepo ystItmItemRepo, SrmService srmService, SrmItmItemRepoProc ystItmItemRepoProc, YstSuppC13Provider ystSuppC13Service, YstSuppC13RepoProc ystSuppC13RepoProc, YstSuppItemRepoProc ystSuppItemRepoProc, YstSuppItemProvider ystitemService, YstItemProportionRepoProc ystItemProportionRepoproc, SuppService suppService, ComOutService comOutService, ItmItemCateService itmItemCateService, ItmItemUomConvService itmItemUomConvService, YstItemProportionRepoProc ystItemProportionRepoProc, OrgBuService orgBuService) {
        this.ystItmItemRepo = ystItmItemRepo;
        this.srmService = srmService;
        this.ystItmItemRepoProc = ystItmItemRepoProc;
        this.ystSuppC13Service = ystSuppC13Service;
        this.ystSuppC13RepoProc = ystSuppC13RepoProc;
        this.ystSuppItemRepoProc = ystSuppItemRepoProc;
        this.ystitemService = ystitemService;
        this.ystItemProportionRepoproc = ystItemProportionRepoproc;
        this.suppService = suppService;
        this.comOutService = comOutService;
        this.itmItemCateService = itmItemCateService;
        this.itmItemUomConvService = itmItemUomConvService;
        this.ystItemProportionRepoProc = ystItemProportionRepoProc;
        this.orgBuService = orgBuService;
    }
}

