/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.industry.medicinal.tm.item.impl;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.industry.medicinal.tm.item.repo.TmItmItemBomRepo;
import com.elitesland.yst.srmdomain.industry.medicinal.tm.item.repo.TmItmItemBomRepoProc;
import com.elitesland.yst.srmdomain.industry.medicinal.tm.item.vo.TmItmItemBomDetailsVO;
import com.elitesland.yst.srmdomain.industry.medicinal.tm.item.vo.TmItmItemBomPagingVO;
import com.elitesland.yst.supportdomain.item.convert.ItmItemBomConvert;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBomDO;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemBomService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBomVO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemQueryDTO;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@UnicomTag(value="TONGMING")
public class TmItmItemBomServiceImpl
implements ItmItemBomService {
    private final TmItmItemBomRepo tmItmItemBomRepo;
    private final TmItmItemBomRepoProc tmItmItemBomRepoProc;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemRepoProc itmItemRepoProc;

    public PagingVO<TmItmItemBomPagingVO> itemBomPagingSearch(ItmItemBomPagingParam param) {
        return this.tmItmItemBomRepoProc.itemBomPagingSearch(param);
    }

    @SysCodeProc
    public TmItmItemBomDetailsVO findBomDetailsById(Long id) {
        TmItmItemBomDetailsVO result = this.tmItmItemBomRepoProc.findBomDetailsById(id);
        if (result == null) {
            return null;
        }
        result.setBomDetailsVos(this.tmItmItemBomRepoProc.findBomDetailsByPid(result.getId()));
        return result;
    }

    @Override
    public Long itemBomSaveOrUpdate(ItmItemBomSaveParam param) {
        List<ItmItemBomSaveParam> bomSubSaveParams;
        Long id = param.getId();
        ItmItemBomDO itemBomDO = this.tmItmItemBomRepo.findByPidAndItemId(0L, param.getItemId());
        if (!StringUtils.isEmpty((Object)((Object)itemBomDO))) {
            id = itemBomDO.getId();
        }
        if (CollectionUtils.isEmpty(bomSubSaveParams = param.getBomDetailsVos())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b50\u4ef6\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (id == null) {
            ItmItemBomDO bomDo = ItmItemBomConvert.INSTANCE.saveParamToDo(param);
            this.tmItmItemBomRepo.save((Object)bomDo);
            id = bomDo.getId();
            ArrayList<ItmItemBomDO> bomSubDos = new ArrayList<ItmItemBomDO>();
            for (ItmItemBomSaveParam saveParam : bomSubSaveParams) {
                ItmItemBomDO subDo = ItmItemBomConvert.INSTANCE.saveParamToDo(saveParam);
                subDo.setPid(id);
                bomSubDos.add(subDo);
            }
            this.tmItmItemBomRepo.saveAll(bomSubDos);
        } else {
            Optional optional = this.tmItmItemBomRepo.findById(id);
            if (optional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u7ed3\u6784\uff1a" + id + " \u4e0d\u5b58\u5728");
            }
            ItmItemBomDO bomDo = (ItmItemBomDO)((Object)optional.get());
            ItmItemBomConvert.INSTANCE.updateDoFromSaveParam(param, bomDo);
            this.tmItmItemBomRepo.save((Object)bomDo);
            List<ItmItemBomDO> bomSubDos = this.tmItmItemBomRepo.findByPid(bomDo.getId());
            List existsIds = bomSubDos.stream().map(BaseModel::getId).collect(Collectors.toList());
            List insertSubParams = bomSubSaveParams.stream().filter(t -> t.getId() == null || !existsIds.contains(t.getId())).collect(Collectors.toList());
            List updateSubParams = bomSubSaveParams.stream().filter(t -> existsIds.contains(t.getId())).collect(Collectors.toList());
            List updateIds = updateSubParams.stream().map(ItmItemBomSaveParam::getId).collect(Collectors.toList());
            List deleteSubDos = bomSubDos.stream().filter(t -> !updateIds.contains(t.getId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(insertSubParams)) {
                List insertSubDos = insertSubParams.stream().map(insertParam -> {
                    ItmItemBomDO subDo = ItmItemBomConvert.INSTANCE.saveParamToDo((ItmItemBomSaveParam)insertParam);
                    subDo.setPid(bomDo.getId());
                    return subDo;
                }).collect(Collectors.toList());
                this.tmItmItemBomRepo.saveAll(insertSubDos);
            }
            if (CollectionUtils.isNotEmpty(updateSubParams)) {
                Map<Long, ItmItemBomDO> existsDoMap = bomSubDos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t));
                List updateSubDos = updateSubParams.stream().map(updateParam -> {
                    ItmItemBomDO subDo = (ItmItemBomDO)((Object)((Object)existsDoMap.get(updateParam.getId())));
                    ItmItemBomConvert.INSTANCE.updateDoFromSaveParam((ItmItemBomSaveParam)updateParam, subDo);
                    return subDo;
                }).collect(Collectors.toList());
                this.tmItmItemBomRepo.saveAll(updateSubDos);
            }
            if (CollectionUtils.isNotEmpty(deleteSubDos)) {
                this.tmItmItemBomRepo.deleteInBatch(deleteSubDos);
            }
        }
        return id;
    }

    @Override
    public void itemBomSoftDelete(Long id) {
        ArrayList<Long> softDeleteIds = new ArrayList<Long>();
        softDeleteIds.add(id);
        List<Long> subIds = this.tmItmItemBomRepoProc.findIdsByPid(id);
        if (CollectionUtils.isNotEmpty(subIds)) {
            this.findAllSubIds(softDeleteIds, subIds);
        }
        this.tmItmItemBomRepo.softDeleteBomByIds(softDeleteIds);
    }

    private void findAllSubIds(List<Long> ids, List<Long> subIds) {
        subIds.forEach(id -> {
            List<Long> subIdList = this.tmItmItemBomRepoProc.findIdsByPid((Long)id);
            if (CollectionUtils.isNotEmpty((Collection)subIds)) {
                this.findAllSubIds(ids, subIdList);
            }
            ids.add((Long)id);
        });
    }

    @Override
    public void getData() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("grant_type", "client_credentials");
        paramMap.put("client_id", "SRM");
        paramMap.put("client_secret", "7cUDLPhK");
        String result = HttpUtil.get((String)"http://chubgpapi.tongming.biz/oauth/token", paramMap);
        JSONObject entries = JSONUtil.parseObj((String)result);
        if (entries.get((Object)"access_token") == null || entries.get((Object)"token_type") == null) {
            throw new BusinessException("\u8bf7\u6c42\u5f02\u5e38");
        }
        String authorization = entries.get((Object)"token_type") + " " + entries.get((Object)"access_token");
        HashMap<String, CallSite> header = new HashMap<String, CallSite>();
        header.put("Authorization", (CallSite)((Object)authorization));
        String result2 = ((HttpRequest)HttpUtil.createPost((String)"http://chubgpapi.tongming.biz/api/performance/srmbom").addHeaders(header)).body(String.valueOf(new JSONObject())).execute().body();
        JSONObject jsonObject = JSONUtil.parseObj((String)result2);
        Object rows = jsonObject.get((Object)"rows");
        JSONArray objects = JSONUtil.parseArray((Object)rows);
        List itmBomVOS = JSONUtil.toList((JSONArray)objects, ItmItemBomVO.class);
        Map<String, List<ItmItemBomVO>> itmItemBomVOList = itmBomVOS.stream().collect(Collectors.groupingBy(ItmItemBomVO::getIXKIT));
        List<String> itemCodes = itmBomVOS.stream().map(ItmItemBomVO::getIXKIT).collect(Collectors.toList());
        List itemCodes1 = itmBomVOS.stream().map(ItmItemBomVO::getIXITM).collect(Collectors.toList());
        itemCodes.addAll(itemCodes1);
        this.tmItmItemBomRepo.deleteAll();
        this.saveAllBom(itmItemBomVOList, itemCodes);
    }

    private void saveAllBom(Map<String, List<ItmItemBomVO>> itmItemBomVOList, List<String> itemCodes) {
        ArrayList itemList = new ArrayList();
        List partition = ListUtil.partition(itemCodes, (int)999);
        partition.forEach(list -> {
            List<ItmItemQueryDTO> itemByItemCodes = this.itmItemRepoProc.findItemByItemCodes((List<String>)list);
            itemList.addAll(itemByItemCodes);
        });
        itmItemBomVOList.forEach((key, value) -> {
            ItmItemBomSaveParam saveParam = new ItmItemBomSaveParam();
            itemList.stream().filter(i -> i.getItemCode().equals(key)).findFirst().ifPresent(item -> {
                saveParam.setItemId(item.getId());
                saveParam.setItemCode(item.getItemCode());
                saveParam.setItemCode2(item.getItemCode2());
                saveParam.setItemName(item.getItemName());
                saveParam.setItemName2(item.getItemName2());
            });
            ArrayList<ItmItemBomSaveParam> saveParamDetails = new ArrayList<ItmItemBomSaveParam>();
            value.forEach(sonBom -> {
                ItmItemBomSaveParam saveParamSon = new ItmItemBomSaveParam();
                itemList.stream().filter(i -> i.getItemCode().equals(sonBom.getIXITM())).findFirst().ifPresent(item -> {
                    saveParamSon.setItemId(item.getId());
                    saveParamSon.setItemCode(item.getItemCode());
                    saveParamSon.setItemCode2(item.getItemCode2());
                    saveParamSon.setItemName(item.getItemName());
                    saveParamSon.setItemName2(item.getItemName2());
                    saveParamSon.setGeneralAccessoriesSpec(item.getSpec());
                    saveParamSon.setUom(sonBom.getIXUM());
                    saveParamSon.setQty(sonBom.getQNTY());
                    saveParamDetails.add(saveParamSon);
                });
            });
            saveParam.setBomDetailsVos(saveParamDetails);
            this.itemBomSaveAll(saveParam);
        });
    }

    private void itemBomSaveAll(ItmItemBomSaveParam param) {
        Long id = param.getId();
        List<ItmItemBomSaveParam> bomSubSaveParams = param.getBomDetailsVos();
        if (CollectionUtils.isEmpty(bomSubSaveParams)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5b50\u4ef6\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItmItemBomDO bomDo = ItmItemBomConvert.INSTANCE.saveParamToDo(param);
        this.tmItmItemBomRepo.save((Object)bomDo);
        id = bomDo.getId();
        ArrayList<ItmItemBomDO> bomSubDos = new ArrayList<ItmItemBomDO>();
        for (ItmItemBomSaveParam saveParam : bomSubSaveParams) {
            ItmItemBomDO subDo = ItmItemBomConvert.INSTANCE.saveParamToDo(saveParam);
            subDo.setPid(id);
            bomSubDos.add(subDo);
        }
        this.tmItmItemBomRepo.saveAll(bomSubDos);
    }

    public TmItmItemBomServiceImpl(TmItmItemBomRepo tmItmItemBomRepo, TmItmItemBomRepoProc tmItmItemBomRepoProc, ItmItemRepo itmItemRepo, ItmItemRepoProc itmItemRepoProc) {
        this.tmItmItemBomRepo = tmItmItemBomRepo;
        this.tmItmItemBomRepoProc = tmItmItemBomRepoProc;
        this.itmItemRepo = itmItemRepo;
        this.itmItemRepoProc = itmItemRepoProc;
    }
}

