/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.industry.medicinal.tm.item.provider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.supp.dto.SrmPurSuppDTO;
import com.elitesland.supp.outprovider.PurPurcPriceOutProvider;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.srmdomain.itmitem.vo.param.SrmItmItemParamVO;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.SrmItmItemPageRespVO;
import com.elitesland.yst.srmdomain.out.service.SrmService;
import com.elitesland.yst.srmdomain.out.service.SuppService;
import com.elitesland.yst.srmdomain.proportion.entity.YstItemProportionDO;
import com.elitesland.yst.srmdomain.proportion.provider.YstItemProportionProvider;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepo;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepoProc;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstItemProportionParamVO;
import com.elitesland.yst.srmdomain.suppitem.entity.QYstSuppItemDO;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepo;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepoProc;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemParamVO;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemRespVO;
import com.elitesland.yst.srmdomain.util.listener.YstSuppC13Listener;
import com.elitesland.yst.srmdomain.ystsuppc13.convert.YstSuppC13Convert;
import com.elitesland.yst.srmdomain.ystsuppc13.entity.QYstSuppC13DO;
import com.elitesland.yst.srmdomain.ystsuppc13.entity.YstSuppC13DO;
import com.elitesland.yst.srmdomain.ystsuppc13.provider.YstSuppC13Provider;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13Repo;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13RepoProc;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.excel.YstSuppC13ExcelVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.param.YstSuppC13ParamVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.resp.YstSuppC13PageRespVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.resp.YstSuppC13RespVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.save.YstSuppC13PageSaveVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.save.YstSuppC13SaveVO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateCodeParam;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@UnicomTag(value="TONGMING")
public class TmYstSuppC13Provider
implements YstSuppC13Provider {
    private static final Logger log = LoggerFactory.getLogger(TmYstSuppC13Provider.class);
    @Resource(name="srmExecutor")
    private ThreadPoolExecutor srmExecutor;
    @Autowired
    private TaskExecutor taskExecutor;
    private final YstSuppC13Repo ystSuppC13Repo;
    private final SuppService suppService;
    private final YstSuppC13RepoProc ystSuppC13RepoProc;
    private final YstSuppItemRepoProc ystSuppItemRepoProc;
    private final YstSuppItemRepo ystSuppItemRepo;
    private final SrmService srmService;
    private final YstItemProportionProvider ystItemProportionProvider;
    private final SrmItmItemRepoProc ystItmItemRepoProc;
    private final YstItemProportionRepoProc ystItemProportionRepoProc;
    private final YstItemProportionRepo ystItemProportionRepo;
    @DubboReference
    private PurPurcPriceOutProvider purPurcPriceOutProvider;

    @Override
    public PagingVO<YstSuppC13PageRespVO> search(YstSuppC13ParamVO param) {
        if (StringUtils.isNotBlank((CharSequence)param.getSuppCodeName())) {
            List<SrmPurSuppDTO> SrmPurSuppDTOList = this.srmService.findBylikeSuppCodeOrName(param.getSuppCodeName());
            if (!CollectionUtils.isEmpty(SrmPurSuppDTOList)) {
                List<Long> suppIds = SrmPurSuppDTOList.stream().map(SrmPurSuppDTO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                param.setSuppIds(suppIds);
            } else {
                return new PagingVO();
            }
        }
        Long total = this.ystSuppC13RepoProc.countContractTmplTm(param);
        List<YstSuppC13RespVO> search = this.ystSuppC13RepoProc.searchTm(param);
        if (!CollectionUtils.isEmpty(search)) {
            this.fill(search);
        }
        List<YstSuppC13PageRespVO> pageList = YstSuppC13Convert.INSTANCE.respVOToPageResp(search);
        return total > 0L ? PagingVO.builder().total(total).records(pageList).build() : new PagingVO();
    }

    private void fill(List<YstSuppC13RespVO> list) {
        List<Long> suppIds = list.stream().map(YstSuppC13RespVO::getSuppId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemCateCodeS = list.stream().map(YstSuppC13RespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<SrmPurSuppDTO> purSuppBaseRespVOList = new ArrayList<SrmPurSuppDTO>();
        if (!CollectionUtils.isEmpty(suppIds)) {
            purSuppBaseRespVOList.addAll(this.srmService.findPurSuppbyId(suppIds));
        }
        ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
        codeParam.setItemCateCodes(itemCateCodeS);
        Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.suppService.findCateCodeReItemCateCode(codeParam);
        list.forEach(v -> {
            Optional<SrmPurSuppDTO> first;
            if (!Objects.isNull(v.getSuppId()) && (first = purSuppBaseRespVOList.stream().filter(t -> v.getSuppId().equals(t.getId())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                v.setSuppCode(first.get().getSuppCode());
                v.setSuppName(first.get().getSuppName());
                v.setSuppAbbr(first.get().getSuppAbbr());
            }
            if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                List cateNameList = codeAndNameRpcDTO.getCateNameList();
                if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                    v.setItemCateName(String.join((CharSequence)">", cateNameList));
                }
            }
        });
    }

    @Override
    public List<YstSuppC13PageRespVO> findAllbyid(String suppCode) {
        QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
        List fetch = ((JPAQuery)this.ystSuppC13RepoProc.select().where((Predicate)ystSuppC13Do.suppCode.eq((Object)suppCode))).fetch();
        this.fill(fetch);
        List<YstSuppC13PageRespVO> pageList = YstSuppC13Convert.INSTANCE.respVOToPageResp(fetch);
        return pageList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAll(List<YstSuppC13PageSaveVO> param) {
        List<String> itemCateCodeList = param.stream().map(YstSuppC13PageSaveVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(param)) {
            if (this.ystSuppC13Repo.existsBySuppCode(param.get(0).getSuppCode())) {
                QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
                ArrayList oldYstSuppC13 = new ArrayList();
                oldYstSuppC13.addAll(((JPAQuery)this.ystSuppC13RepoProc.select().where((Predicate)ystSuppC13Do.suppCode.eq((Object)param.get(0).getSuppCode()))).fetch());
                if (!CollectionUtils.isEmpty(oldYstSuppC13)) {
                    List<String> olditemCodes = oldYstSuppC13.stream().map(YstSuppC13RespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    List olditemCodes2 = oldYstSuppC13.stream().map(YstSuppC13RespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    olditemCodes.removeAll(itemCateCodeList);
                    if (!CollectionUtils.isEmpty(olditemCodes)) {
                        QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
                        List ystSuppItemRespVOList = ((JPAQuery)this.ystSuppItemRepoProc.selectProProtions().where((Predicate)ystSuppItemDo.itemCateCode.in(olditemCodes).and((Predicate)ystSuppItemDo.suppCode.eq((Object)param.get(0).getSuppCode())))).fetch();
                        List<String> itemCodes = ystSuppItemRespVOList.stream().map(YstSuppItemRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        if (!CollectionUtils.isEmpty(itemCodes)) {
                            YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
                            ystItemProportionParamVO.setItemCateCodeList(olditemCodes);
                            ystItemProportionParamVO.setNotitemCodeList(itemCodes);
                            ystItemProportionParamVO.setSuppCode(param.get(0).getSuppCode());
                            this.ystItemProportionRepoProc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
                        }
                    }
                    itemCateCodeList.removeAll(olditemCodes2);
                    if (!CollectionUtils.isEmpty(itemCateCodeList)) {
                        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
                        ystItemProportionParamVO.setItemCateCodeList(itemCateCodeList);
                        ystItemProportionParamVO.setSuppCode(param.get(0).getSuppCode());
                        this.ystItemProportionRepoProc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
                        this.createYstItemProportion(param.get(0).getSuppId(), param.get(0).getSuppCode(), itemCateCodeList);
                    }
                } else {
                    QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
                    List ystSuppItemRespVOList = ((JPAQuery)this.ystSuppItemRepoProc.selectProProtions().where((Predicate)ystSuppItemDo.itemCateCode.in(itemCateCodeList).and((Predicate)ystSuppItemDo.suppCode.eq((Object)param.get(0).getSuppCode())))).fetch();
                    List<String> itemCodes = ystSuppItemRespVOList.stream().map(YstSuppItemRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(itemCodes)) {
                        YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
                        ystItemProportionParamVO.setItemCateCodeList(itemCateCodeList);
                        ystItemProportionParamVO.setItemCodeList(itemCodes);
                        ystItemProportionParamVO.setSuppCode(param.get(0).getSuppCode());
                        this.ystItemProportionRepoProc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
                    }
                    this.createYstItemProportion(param.get(0).getSuppId(), param.get(0).getSuppCode(), itemCateCodeList);
                }
                this.ystSuppC13Repo.deleteBySuppCode(param.get(0).getSuppCode());
            } else {
                QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
                List ystSuppItemRespVOList = ((JPAQuery)this.ystSuppItemRepoProc.selectProProtions().where((Predicate)ystSuppItemDo.itemCateCode.in(itemCateCodeList).and((Predicate)ystSuppItemDo.suppCode.eq((Object)param.get(0).getSuppCode())))).fetch();
                List<String> itemCodes = ystSuppItemRespVOList.stream().map(YstSuppItemRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(itemCodes)) {
                    YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
                    ystItemProportionParamVO.setItemCateCodeList(itemCateCodeList);
                    ystItemProportionParamVO.setItemCodeList(itemCodes);
                    ystItemProportionParamVO.setSuppCode(param.get(0).getSuppCode());
                    this.ystItemProportionRepoProc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
                }
                this.createYstItemProportion(param.get(0).getSuppId(), param.get(0).getSuppCode(), itemCateCodeList);
            }
            List<YstSuppC13DO> ystSuppC13DoS = YstSuppC13Convert.INSTANCE.savePageListToDo(param);
            ystSuppC13DoS.forEach(v -> {
                if (!ObjectUtils.isEmpty((Object)v.getItemCateCode())) {
                    String[] splitItemCateCode = v.getItemCateCode().split("-");
                    if (splitItemCateCode.length > 0) {
                        v.setC1Code(splitItemCateCode[0]);
                    }
                    if (splitItemCateCode.length > 1) {
                        v.setC2Code(splitItemCateCode[1]);
                    }
                    if (splitItemCateCode.length > 2) {
                        v.setC3Code(splitItemCateCode[2]);
                    }
                }
            });
            this.ystSuppC13Repo.saveAll(ystSuppC13DoS);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void createYstItemProportion(Long suppId, String suppcode, List<String> itemCateCodeList) {
        SrmItmItemParamVO srmItmItemParamVO = new SrmItmItemParamVO();
        srmItmItemParamVO.setItemCateCodeList(itemCateCodeList);
        Long total = this.ystItmItemRepoProc.countContractTmpl(srmItmItemParamVO);
        srmItmItemParamVO.setSize(300);
        if (total > 0L) {
            long page = total / (long)srmItmItemParamVO.getSize().intValue();
            long l1 = total % (long)srmItmItemParamVO.getSize().intValue();
            if (l1 > 0L) {
                ++page;
            }
            if (page > 0L) {
                ExecutorCompletionService<Object> cs = new ExecutorCompletionService<Object>(this.srmExecutor);
                for (int i = 1; i <= (int)page; ++i) {
                    SrmItmItemParamVO srmItmItemParamVO1 = new SrmItmItemParamVO();
                    srmItmItemParamVO1.setCurrent(i);
                    srmItmItemParamVO1.setSize(300);
                    srmItmItemParamVO1.setItemCateCodeList(itemCateCodeList);
                    srmItmItemParamVO1.setSuppId(suppId);
                    srmItmItemParamVO1.setSuppCode(suppcode);
                    Future<Object> future = cs.submit(() -> this.createystItemProportionAll(srmItmItemParamVO1));
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    Object createystItemProportionAll(SrmItmItemParamVO srmItmItemParamVO) {
        List<SrmItmItemPageRespVO> search = this.ystItmItemRepoProc.searchSrmTM(srmItmItemParamVO);
        ArrayList ystItemProportionPageSaveVOlist = new ArrayList();
        search.forEach(v -> {
            YstItemProportionDO ystItemProportionDO = new YstItemProportionDO();
            ystItemProportionDO.setItemCateCode(v.getItemCateCode());
            ystItemProportionDO.setSuppCode(srmItmItemParamVO.getSuppCode());
            ystItemProportionDO.setSuppId(srmItmItemParamVO.getSuppId());
            ystItemProportionDO.setItemCode(v.getItemCode());
            ystItemProportionDO.setItemId(v.getId());
            ystItemProportionPageSaveVOlist.add(ystItemProportionDO);
        });
        this.ystItemProportionRepo.saveAll(ystItemProportionPageSaveVOlist);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    void big100(List<YstSuppC13PageSaveVO> param, List<YstSuppC13RespVO> ystSuppC13RespVOS, List<YstSuppItemRespVO> ystSuppItemRespVOS) {
        if (!(CollectionUtils.isEmpty(param) || CollectionUtils.isEmpty(ystSuppC13RespVOS) && CollectionUtils.isEmpty(ystSuppItemRespVOS))) {
            param.forEach(v -> {
                if (!ObjectUtils.isEmpty((Object)v.getItemCateCode()) && !ObjectUtils.isEmpty((Object)v.getItemProportion())) {
                    BigDecimal sum;
                    Optional<YstSuppC13RespVO> first = ystSuppC13RespVOS.stream().filter(t -> v.getItemCateCode().equals(t.getItemCateCode())).filter(Objects::nonNull).distinct().findFirst();
                    Optional<YstSuppItemRespVO> first1 = ystSuppItemRespVOS.stream().filter(t -> v.getItemCateCode().equals(t.getItemCateCode())).filter(Objects::nonNull).distinct().findFirst();
                    if (first.isPresent() && first1.isPresent()) {
                        BigDecimal sum2;
                        if (!ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum2 = first.get().getProportion().add(v.getItemProportion()).add(first1.get().getProportion())).compareTo(new BigDecimal("100")) == 1) {
                            throw new BusinessException(ApiCode.FAIL, v.getItemCateCode() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%" + sum2 + "%");
                        }
                    } else if (first.isPresent()) {
                        BigDecimal sum3;
                        if (!ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum3 = first.get().getProportion().add(v.getItemProportion())).compareTo(new BigDecimal("100")) == 1) {
                            throw new BusinessException(ApiCode.FAIL, v.getItemCateCode() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%,\u6bd4\u4f8b\u4e3a" + sum3 + "%");
                        }
                    } else if (first1.isPresent() && !ObjectUtils.isEmpty((Object)v.getItemProportion()) && (sum = first1.get().getProportion().add(v.getItemProportion())).compareTo(new BigDecimal("100")) == 1) {
                        throw new BusinessException(ApiCode.FAIL, v.getItemCateCode() + ":\u7269\u6599\u548c\u591a\u4e2a\u4f9b\u5e94\u5546\u6bd4\u4f8b\u5927\u4e8e100%,\u6bd4\u4f8b\u4e3a" + sum + "%");
                    }
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOne(Long id) {
        this.ystSuppC13Repo.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlagBatch(List<Long> ids) {
        this.ystSuppC13RepoProc.updateDeleteFlagBatch(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<Long> ids) {
        ids.forEach(this::deleteOne);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void imports(MultipartFile file) {
        YstSuppC13Listener listener = new YstSuppC13Listener();
        try {
            EasyExcel.read((InputStream)file.getInputStream(), YstSuppC13ExcelVO.class, (ReadListener)listener).sheet().doRead();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List<YstSuppC13ExcelVO> datas = listener.getDatas();
        if (CollUtil.isEmpty(datas)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        List<YstSuppC13PageSaveVO> ystSuppC13SaveVoS = YstSuppC13Convert.INSTANCE.excelVoListTosave(datas);
        ystSuppC13SaveVoS = ystSuppC13SaveVoS.stream().filter(Objects::nonNull).filter(o -> !StringUtils.isEmpty((CharSequence)o.getSuppCode()) && !StringUtils.isEmpty((CharSequence)o.getItemCateCode())).collect(Collectors.toList());
        List<String> suppCodes = ystSuppC13SaveVoS.stream().map(YstSuppC13PageSaveVO::getSuppCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList<SrmPurSuppDTO> purSuppBaseRespVOList = new ArrayList<SrmPurSuppDTO>();
        if (!CollectionUtils.isEmpty(suppCodes)) {
            try {
                purSuppBaseRespVOList.addAll(this.srmService.findBySuppCodes(suppCodes));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ystSuppC13SaveVoS.forEach(v -> {
            Optional<SrmPurSuppDTO> first;
            if (!ObjectUtils.isEmpty((Object)v.getSuppCode()) && (first = purSuppBaseRespVOList.stream().filter(t -> v.getSuppCode().equals(t.getSuppCode())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                v.setSuppId(first.get().getId());
                v.setSuppCode(first.get().getSuppCode());
            }
        });
        Map<String, List<YstSuppC13PageSaveVO>> collect = ystSuppC13SaveVoS.stream().collect(Collectors.groupingBy(i -> i.getSuppCode()));
        collect.keySet().stream().forEach(key -> this.updateAll((List)collect.get(key)));
    }

    @Override
    public List<YstSuppC13RespVO> findSuppCodeAndItemCateCode(String suppCode2, List<String> itemCateCodeS) {
        QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
        List fetch = ((JPAQuery)this.ystSuppC13RepoProc.select().where((Predicate)ystSuppC13Do.suppCode.eq((Object)suppCode2).and((Predicate)ystSuppC13Do.itemCateCode.in(itemCateCodeS)))).fetch();
        this.fill(fetch);
        return fetch;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDeleteFlag(Long id) {
        Optional byId = this.ystSuppC13Repo.findById(id);
        if (byId.isPresent()) {
            YstSuppC13ParamVO ystSuppC13ParamVO = new YstSuppC13ParamVO();
            ystSuppC13ParamVO.setId(id);
            this.ystSuppC13RepoProc.updateDeleteFlagBatch(ystSuppC13ParamVO);
            QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
            List search = ((JPAQuery)this.ystSuppItemRepoProc.select().where((Predicate)ystSuppItemDo.suppCode.eq((Object)((YstSuppC13DO)byId.get()).getSuppCode()).and((Predicate)ystSuppItemDo.itemCateCode.eq((Object)((YstSuppC13DO)byId.get()).getItemCateCode())))).fetch();
            YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
            ystItemProportionParamVO.setItemCateCode(((YstSuppC13DO)byId.get()).getItemCateCode());
            ystItemProportionParamVO.setSuppCode(((YstSuppC13DO)byId.get()).getSuppCode());
            if (!CollectionUtils.isEmpty((Collection)search)) {
                List<String> notItemCodeList = search.stream().map(YstSuppItemRespVO::getItemCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                ystItemProportionParamVO.setNotitemCodeList(notItemCodeList);
            }
            this.ystItemProportionRepoProc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItmProportion(List<YstSuppC13PageSaveVO> ystSuppC13SaveVoList) {
        YstSuppC13PageSaveVO suppC13PageSaveVO = ystSuppC13SaveVoList.get(0);
        ArrayList sumItemList = new ArrayList();
        List itemCateCodes = ystSuppC13SaveVoList.stream().map(YstSuppC13PageSaveVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.ystItemProportionRepo.deleteBySuppCode(ystSuppC13SaveVoList.get(0).getSuppCode());
        YstSuppItemParamVO ystSuppItemParamVO = new YstSuppItemParamVO();
        ystSuppItemParamVO.setSuppCode(suppC13PageSaveVO.getSuppCode());
        List<YstSuppItemRespVO> suppItems = this.ystSuppItemRepoProc.searchM(ystSuppItemParamVO);
        List splitItems = suppItems.stream().map(row -> {
            YstItemProportionDO result = new YstItemProportionDO();
            result.setItemId(row.getItemId());
            result.setItemCode(row.getItemCode());
            result.setItemCateCode(row.getItemCateCode());
            result.setItemCode2(row.getItemCode2());
            result.setSuppId(row.getSuppId());
            result.setSuppCode(row.getSuppCode());
            return result;
        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList cateItems = new ArrayList();
        List split = ListUtil.split(itemCateCodes, (int)10);
        for (List splitItemCates : split) {
            SrmItmItemParamVO SrmItmItemParamVO2 = new SrmItmItemParamVO();
            SrmItmItemParamVO2.setItemCateCodeList(splitItemCates);
            List<SrmItmItemPageRespVO> items = this.ystItmItemRepoProc.searchSrmM(SrmItmItemParamVO2);
            List inCateItems = items.stream().map(row -> {
                YstItemProportionDO result = new YstItemProportionDO();
                result.setItemId(row.getItemId());
                result.setItemCode(row.getItemCode());
                result.setItemCateCode(row.getItemCateCode());
                result.setItemCode2(row.getItemCode2());
                result.setSuppId(suppC13PageSaveVO.getSuppId());
                result.setSuppCode(suppC13PageSaveVO.getSuppCode());
                return result;
            }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            cateItems.addAll(inCateItems);
        }
        sumItemList.addAll(Stream.of(splitItems, cateItems).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        this.ystItemProportionRepo.saveAll(sumItemList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAl(List<YstSuppC13SaveVO> params) {
        if (!CollectionUtils.isEmpty(params)) {
            for (YstSuppC13SaveVO detailDTO : params) {
                QYstSuppC13DO ystSuppC13DO = QYstSuppC13DO.ystSuppC13DO;
                Iterable all = this.ystSuppC13Repo.findAll((Predicate)ystSuppC13DO.suppCode.eq((Object)detailDTO.getSuppCode()).and((Predicate)ystSuppC13DO.itemCateCode.eq((Object)detailDTO.getItemCateCode())));
                ArrayList ystSuppC13DoS = Lists.newArrayList((Iterable)all);
                if (!CollectionUtils.isEmpty((Collection)ystSuppC13DoS)) {
                    YstSuppC13DO ystSuppC13 = (YstSuppC13DO)ystSuppC13DoS.get(0);
                    YstSuppC13Convert.INSTANCE.copyRpSaveToDo(detailDTO, ystSuppC13);
                    this.ystSuppC13Repo.save(ystSuppC13);
                    continue;
                }
                Long id = ((YstSuppC13DO)this.ystSuppC13Repo.save(YstSuppC13Convert.INSTANCE.saveToDo(detailDTO))).getId();
                detailDTO.setId(id);
            }
        }
    }

    public List<YstSuppC13RespVO> selectProProtion(List<String> list) {
        QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
        return ((JPAQuery)this.ystSuppC13RepoProc.selectProProtion().where((Predicate)ystSuppC13Do.itemCateCode.in(list))).fetch();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void datatastart() {
        YstSuppC13ParamVO ystSuppC13ParamVO = new YstSuppC13ParamVO();
        ystSuppC13ParamVO.setSize(500);
        Long total = this.ystSuppC13RepoProc.countContractTmpl(ystSuppC13ParamVO);
        if (total > 0L) {
            long page = total / (long)ystSuppC13ParamVO.getSize().intValue();
            long l1 = total % (long)ystSuppC13ParamVO.getSize().intValue();
            if (l1 > 0L) {
                ++page;
            }
            if (page > 0L) {
                boolean p = true;
                for (int i = 1; i <= (int)page; ++i) {
                    List<YstSuppC13RespVO> ystSuppC13SaveVoS = this.ystSuppC13RepoProc.search(ystSuppC13ParamVO);
                    Map<String, List<YstSuppC13RespVO>> collect = ystSuppC13SaveVoS.stream().collect(Collectors.groupingBy(s -> s.getSuppCode()));
                    collect.keySet().stream().forEach(key -> this.updateAlls((List)collect.get(key)));
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void updateAlls(List<YstSuppC13RespVO> list) {
        List<String> itemCateCodeList = list.stream().map(YstSuppC13RespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(list)) {
            YstItemProportionParamVO ystItemProportionParamVO = new YstItemProportionParamVO();
            ystItemProportionParamVO.setItemCateCodeList(itemCateCodeList);
            ystItemProportionParamVO.setSuppCode(list.get(0).getSuppCode());
            this.ystItemProportionRepoProc.updateDeleteFlagBatchTm(ystItemProportionParamVO);
            this.createYstItemProportion(list.get(0).getSuppId(), list.get(0).getSuppCode(), itemCateCodeList);
        }
    }

    public TmYstSuppC13Provider(YstSuppC13Repo ystSuppC13Repo, SuppService suppService, YstSuppC13RepoProc ystSuppC13RepoProc, YstSuppItemRepoProc ystSuppItemRepoProc, YstSuppItemRepo ystSuppItemRepo, SrmService srmService, YstItemProportionProvider ystItemProportionProvider, SrmItmItemRepoProc ystItmItemRepoProc, YstItemProportionRepoProc ystItemProportionRepoProc, YstItemProportionRepo ystItemProportionRepo) {
        this.ystSuppC13Repo = ystSuppC13Repo;
        this.suppService = suppService;
        this.ystSuppC13RepoProc = ystSuppC13RepoProc;
        this.ystSuppItemRepoProc = ystSuppItemRepoProc;
        this.ystSuppItemRepo = ystSuppItemRepo;
        this.srmService = srmService;
        this.ystItemProportionProvider = ystItemProportionProvider;
        this.ystItmItemRepoProc = ystItmItemRepoProc;
        this.ystItemProportionRepoProc = ystItemProportionRepoProc;
        this.ystItemProportionRepo = ystItemProportionRepo;
    }
}

