/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.itmitem.Srmprovider;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.itmitem.provider.SrmItmItemProvider;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.srmdomain.itmitem.vo.param.SrmItmItemParamVO;
import com.elitesland.yst.srmdomain.proportion.entity.QYstServicesetDDO;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepoProc;
import com.elitesland.yst.srmdomain.proportion.repo.YstServicesetDRepoProc;
import com.elitesland.yst.srmdomain.suppitem.entity.QYstSuppItemDO;
import com.elitesland.yst.srmdomain.suppitem.repo.YstSuppItemRepoProc;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemRespVO;
import com.elitesland.yst.srmdomain.ystsuppc13.entity.QYstSuppC13DO;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13RepoProc;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemRpcRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.param.CommonItmItemParamVO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.yst.supportdomain.provider.item.param.SrmItmItemNParamVO;
import com.elitesland.yst.supportdomain.provider.item.param.SrmItmItemParamDTO;
import com.elitesland.yst.supportdomain.provider.item.param.TmItmItemParamDTO;
import com.elitesland.yst.supportdomain.provider.item.service.SrmItmItemRpcService;
import com.elitesland.yst.supportdomain.provider.item.vo.CommonItmItemDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItemMetaDataDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemUomDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.SrmItmItemNRespVO;
import com.elitesland.yst.supportdomain.provider.item.vo.TmItmItemNRespVO;
import com.elitesland.yst.supportdomain.provider.item.vo.YstItemProportionDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.YstServicesetDRespDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.YstSuppC13DTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@DubboService
@UnicomTag(value="GENERAL")
public class SrmItmItemRpcServiceImpl
implements SrmItmItemRpcService {
    private static final Logger log = LoggerFactory.getLogger(SrmItmItemRpcServiceImpl.class);
    private final SrmItmItemRepoProc srmItmItemRepoProc;
    private final YstSuppC13RepoProc ystSuppC13RepoProc;
    private final YstServicesetDRepoProc ystServicesetDRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final ItmItemRpcRepoProc itmItemRpcRepoProc;
    private final YstItemProportionRepoProc ystItemProportionRepoProc;
    private final YstSuppItemRepoProc ystSuppItemRepoProc;
    private final SrmItmItemProvider srmItmItemProvider;

    public List<SrmItmItemNRespVO> findItemRpcDtoByParam(SrmItmItemNParamVO param) {
        param.setSize(Integer.valueOf(500));
        if (ObjectUtils.isEmpty((Object)param.getId()) && ObjectUtils.isEmpty((Object)param.getItemCode()) && ObjectUtils.isEmpty((Object)param.getItemCode2()) && ObjectUtils.isEmpty((Object)param.getItemCateCode()) && CollectionUtils.isEmpty((Collection)param.getItemCodes2()) && CollectionUtils.isEmpty((Collection)param.getItemCodes()) && CollectionUtils.isEmpty((Collection)param.getItemIds())) {
            return Lists.newArrayList();
        }
        try {
            return this.srmItmItemProvider.findItemRpcDtoByParam(param);
        }
        catch (Exception e) {
            log.error("findItemUomConvDtoByParam error:", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    public List<SrmItmItemNRespVO> findParamByitemCode(String itemCode) {
        ArrayList<SrmItmItemNRespVO> list = new ArrayList<SrmItmItemNRespVO>();
        SrmItmItemNRespVO itemById = this.srmItmItemRepoProc.findParamByitemCode(itemCode);
        list.add(itemById);
        return list;
    }

    public YstItemProportionDTO getItemProportionByParam(Long suppId, Long itemId) {
        YstItemProportionDTO itemProportionByParam = this.ystItemProportionRepoProc.getItemProportionByParam(suppId, itemId);
        if (ObjectUtil.isNotNull((Object)itemProportionByParam)) {
            this.fills(Arrays.asList(itemProportionByParam));
        }
        return itemProportionByParam;
    }

    public List<SrmItmItemNRespVO> findItemIdAndItemCodeByParam(SrmItmItemParamDTO param) {
        return this.srmItmItemRepoProc.findItemIdAndItemCodeByParam(param).fetch();
    }

    public List<YstItemProportionDTO> findItemProportionbyParam(List<Long> itemIds) {
        List<YstItemProportionDTO> itemProportionByParam = this.ystItemProportionRepoProc.getItemProportionByParam(itemIds);
        if (ObjectUtil.isNotNull(itemProportionByParam)) {
            this.fills(itemProportionByParam);
        }
        return itemProportionByParam;
    }

    public List<TmItmItemNRespVO> findItemRpcParam(TmItmItemParamDTO param) {
        param.setSize(Integer.valueOf(500));
        if (ObjectUtils.isEmpty((Object)param.getStandard()) && ObjectUtils.isEmpty((Object)param.getDiameter()) && ObjectUtils.isEmpty((Object)param.getItemCateCode()) && ObjectUtils.isEmpty((Object)param.getMaterial())) {
            return new ArrayList<TmItmItemNRespVO>();
        }
        return this.itmItemRpcRepoProc.selectSrmTmss(param);
    }

    public List<YstSuppC13DTO> findYstSuppC13bySuppcode(List<String> suppCodeList) {
        QYstSuppC13DO ystSuppC13Do = QYstSuppC13DO.ystSuppC13DO;
        List<Object> ystSuppC13DTOList = new ArrayList<YstSuppC13DTO>();
        if (!CollectionUtils.isEmpty(suppCodeList)) {
            ystSuppC13DTOList = ((JPAQuery)this.ystSuppC13RepoProc.selectDto().where((Predicate)ystSuppC13Do.suppCode.in(suppCodeList))).fetch();
        }
        return ystSuppC13DTOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateIsmutex(boolean mutex, List<String> itemCodeList) {
        System.out.println("\u8c03\u7528\u5230\u63a5\u53e3\u4fee\u6539\u6570\u636emutex\uff1a" + mutex + "\u53c2\u6570\uff1a" + itemCodeList);
        SrmItmItemParamVO srmItmItemParamVO = new SrmItmItemParamVO();
        srmItmItemParamVO.setItemCodeList(itemCodeList);
        srmItmItemParamVO.setIsmutex(mutex);
        this.srmItmItemRepoProc.updateIsmutex(srmItmItemParamVO);
    }

    public List<YstServicesetDRespDTO> findYstServicesetDByfunction(String function) {
        QYstServicesetDDO ystServicesetDQDo = QYstServicesetDDO.ystServicesetDDO;
        if (!ObjectUtils.isEmpty((Object)function)) {
            return ((JPAQuery)this.ystServicesetDRepoProc.selectTm().where((Predicate)ystServicesetDQDo.function.eq((Object)function))).fetch();
        }
        return new ArrayList<YstServicesetDRespDTO>();
    }

    public List<ItemMetaDataDTO> queryItemMetaData(String itemCode, String itemCode2) {
        return this.srmItmItemRepoProc.queryItemMetaData(itemCode, itemCode2);
    }

    public Long isExpireItem(String itemCode, String itemCode2) {
        return this.srmItmItemRepoProc.isExpireItem(itemCode, itemCode2);
    }

    @SysCodeProc
    public ItmItemUomDTO findUomByItem(String itemCode, String itemCode2) {
        return this.srmItmItemRepoProc.findUomByItem(itemCode, itemCode2);
    }

    public ItemMetaDataDTO findByItemCodeOrItemCode2(String itemCode, String itemCode2) {
        return this.srmItmItemRepoProc.findByItemCodeOrItemCode2(itemCode, itemCode2);
    }

    public List<ItemMetaDataDTO> findByItemCode2s(List<String> itemCode2s) {
        return this.srmItmItemRepoProc.findByItemCode2s(itemCode2s);
    }

    public List<CommonItmItemDTO> findCommonItmItemByParam(CommonItmItemParamVO itemParamVO) {
        if (null == itemParamVO.getItemId() && CollUtil.isEmpty((Collection)itemParamVO.getItemIds()) && CollUtil.isEmpty((Collection)itemParamVO.getItemCodes()) && StrUtil.isBlank((CharSequence)itemParamVO.getItemCode()) && CollUtil.isEmpty((Collection)itemParamVO.getItemCode2s()) && StrUtil.isBlank((CharSequence)itemParamVO.getItemCode2())) {
            throw new BusinessException("\u67e5\u8be2\u7269\u6599\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.srmItmItemRepoProc.commonItemSelect(itemParamVO);
    }

    private void fills(List<YstItemProportionDTO> itemProportionByParam) {
        List longList = itemProportionByParam.stream().map(YstItemProportionDTO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        QYstSuppItemDO ystSuppItemDo = QYstSuppItemDO.ystSuppItemDO;
        List fetch = ((JPAQuery)this.ystSuppItemRepoProc.select().where((Predicate)ystSuppItemDo.itemId.in(longList))).fetch();
        if (!CollectionUtils.isEmpty((Collection)fetch)) {
            itemProportionByParam.forEach(v -> {
                Optional<YstSuppItemRespVO> first;
                if (!ObjectUtils.isEmpty((Object)v.getItemId()) && (first = fetch.stream().filter(vo -> vo.getItemId().equals(v.getItemId()) && vo.getSuppId().equals(v.getSuppId())).filter(Objects::nonNull).distinct().findFirst()).isPresent()) {
                    v.setItemProportion(first.get().getItemProportion());
                }
            });
        }
    }

    private void fill(List<SrmItmItemNRespVO> list) {
        List itemCateCodeS = list.stream().map(SrmItmItemNRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        try {
            ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
            codeParam.setItemCateCodes(itemCateCodeS);
            Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.findCateCodeReItemCateCode(codeParam);
            list.forEach(v -> {
                if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                    ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                    List cateNameList = codeAndNameRpcDTO.getCateNameList();
                    v.setItemCatePathName(cateNameList);
                    if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                        v.setItemCateName(String.join((CharSequence)">", cateNameList));
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
        }
    }

    public Map<String, ItmCateCodeAndNameRpcDTO> findCateCodeReItemCateCode(ItmItemCateCodeParam param) {
        log.info("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3findCateCodeReItemCateCode\u65b9\u6cd5\u5f00\u59cb,\u65f6\u95f4:{},\u53c2\u6570:{}", (Object)param);
        try {
            if (CollectionUtils.isEmpty((Collection)param.getItemCateCodes())) {
                return null;
            }
            ItmItemCateCodeRpcDTO itemCateCode = this.findCateCodeReItemCateCodes(param);
            Map itemCateCodeCateMap = itemCateCode.getCateMap();
            return itemCateCodeCateMap;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    public ItmItemCateCodeRpcDTO findCateCodeReItemCateCodes(ItmItemCateCodeParam param) {
        List itemCateCodes = param.getItemCateCodes();
        HashMap resultMap = new HashMap();
        itemCateCodes.forEach(itemCateCode -> {
            List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath((String)itemCateCode);
            ArrayList<String> pathCode = new ArrayList<String>();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathCodeAndName(path, pathCode, pathName);
            resultMap.put(itemCateCode, ItmCateCodeAndNameRpcDTO.builder().cateNameList(pathName).cateCodeList(pathCode).build());
        });
        return ItmItemCateCodeRpcDTO.builder().cateMap(resultMap).build();
    }

    private void buildPathCodeAndName(List<ItmItemCateSimpleTree> tree, List<String> pathCode, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathCode.add(t.getItemCateCode());
            pathName.add(t.getItemCateName());
            this.buildPathCodeAndName(t.getTreeNodes(), pathCode, pathName);
        });
    }

    public SrmItmItemRpcServiceImpl(SrmItmItemRepoProc srmItmItemRepoProc, YstSuppC13RepoProc ystSuppC13RepoProc, YstServicesetDRepoProc ystServicesetDRepoProc, ItmItemCateService itmItemCateService, ItmItemRpcRepoProc itmItemRpcRepoProc, YstItemProportionRepoProc ystItemProportionRepoProc, YstSuppItemRepoProc ystSuppItemRepoProc, SrmItmItemProvider srmItmItemProvider) {
        this.srmItmItemRepoProc = srmItmItemRepoProc;
        this.ystSuppC13RepoProc = ystSuppC13RepoProc;
        this.ystServicesetDRepoProc = ystServicesetDRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.itmItemRpcRepoProc = itmItemRpcRepoProc;
        this.ystItemProportionRepoProc = ystItemProportionRepoProc;
        this.ystSuppItemRepoProc = ystSuppItemRepoProc;
        this.srmItmItemProvider = srmItmItemProvider;
    }
}

