/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.itmitem.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.base.param.OrderItem;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.itmitem.provider.SrmItmItemProvider;
import com.elitesland.yst.srmdomain.itmitem.vo.param.SrmItmItemPageParamVO;
import com.elitesland.yst.srmdomain.itmitem.vo.resp.SrmItmItemPageRespVO;
import com.elitesland.yst.srmdomain.itmitem.vo.save.SrmItmItemPageSaveVO;
import com.elitesland.yst.srmdomain.util.enumproduct.SrmUdcEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"ystItmItem"})
@Api(value="ystItmItem", tags={"\u7269\u6599\u8868"})
@RestController
public class SrmItmItemController {
    private final SrmItmItemProvider ystItmItemService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<SrmItmItemPageRespVO>> search(@RequestBody SrmItmItemPageParamVO param) {
        if (CollectionUtils.isEmpty((Collection)param.getOrders())) {
            param.setOrders(this.initOrderColumn());
            param.setOrders(this.initOrderColumn());
        }
        if (!param.isSeatch()) {
            param.setItemStatus(SrmUdcEnum.CBPL_ITMITEMSTATUS_C.getValueCode());
        }
        PagingVO<SrmItmItemPageRespVO> ret = this.ystItmItemService.search(param);
        return ApiResult.ok(ret);
    }

    private List<OrderItem> initOrderColumn() {
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem itemTime = new OrderItem("createTime", false);
        OrderItem itemCode = new OrderItem("itemCode", false);
        orders.add(itemTime);
        orders.add(itemCode);
        return orders;
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void stkAcctExport(HttpServletResponse response, @RequestBody SrmItmItemPageParamVO param) throws IOException {
        this.ystItmItemService.stkAcctExport(response, param);
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165")
    public ApiResult<?> importVeFileDO(HttpServletResponse response, @RequestPart MultipartFile file) throws IOException {
        if (file.isEmpty()) {
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        this.ystItmItemService.importVeFile(file);
        return ApiResult.ok();
    }

    @GetMapping(value={"/findIdOne/{id}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    ApiResult<Object> findIdOne(@PathVariable Long id) {
        return ApiResult.ok((Object)this.ystItmItemService.findIdOne(id));
    }

    @PostMapping(value={"/findParam"})
    @ApiOperation(value="\u901a\u8fc7\u6761\u4ef6\u67e5\u8be2\u6570\u636e")
    ApiResult<Object> findParam(@RequestBody SrmItmItemPageParamVO param) {
        return ApiResult.ok((Object)this.ystItmItemService.findParam(param));
    }

    @PostMapping(value={"/createOne"})
    @ApiOperation(value="\u65b0\u589e\u4e00\u6761\u6570\u636e")
    public ApiResult<?> createOne(@RequestBody SrmItmItemPageSaveVO param) {
        Long id = this.ystItmItemService.createOne(param);
        return ApiResult.ok((Object)id.toString());
    }

    @PostMapping(value={"/createAll"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6279\u91cf")
    public ApiResult<?> createAll(@RequestBody List<SrmItmItemPageSaveVO> param) {
        this.ystItmItemService.createAll(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/updateOne"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    public ApiResult<?> updateOne(@RequestBody SrmItmItemPageSaveVO param) {
        Long id = this.ystItmItemService.updateOne(param);
        return ApiResult.ok((Object)id.toString());
    }

    @PostMapping(value={"/updateAll"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6570\u636e")
    public ApiResult<?> updateAll(@RequestBody List<SrmItmItemPageSaveVO> param) {
        List<SrmItmItemPageSaveVO> ystItmItemSaveVOS = this.ystItmItemService.updateAll(param);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteOne/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e")
    public ApiResult<Object> deleteOne(@PathVariable Long id) {
        this.ystItmItemService.deleteOne(id);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteBatchs"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        this.ystItmItemService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @PatchMapping(value={"/updateDeleteFlagBatchs"})
    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    public ApiResult<Object> updateDeleteFlagBatch(@RequestBody List<Long> ids) {
        this.ystItmItemService.updateDeleteFlagBatch(ids);
        return ApiResult.ok();
    }

    @PatchMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u5355\u903b\u8f91\u5220\u9664")
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        this.ystItmItemService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279")
    @PatchMapping(value={"/submit"})
    public ApiResult<String> submit(@RequestBody SrmItmItemPageSaveVO saveParam) {
        try {
            String procInstId = this.ystItmItemService.submitInquiry(saveParam);
            return ApiResult.ok((Object)procInstId);
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/exportTemplate"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u7248")
    public void exportTemplate(HttpServletResponse response) throws IOException {
        this.ystItmItemService.exportTemplate(response);
    }

    @PatchMapping(value={"/textDataRelationshipSource/{type}"})
    @ApiOperation(value="\u6821\u9a8c\u62a5\u9519")
    public ApiResult<Object> textDataRelationshipSource(@PathVariable String type, @RequestBody List<Long> ids) {
        this.ystItmItemService.textDataRelationshipSource(type, ids);
        return ApiResult.ok();
    }

    public SrmItmItemController(SrmItmItemProvider ystItmItemService) {
        this.ystItmItemService = ystItmItemService;
    }
}

