/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.out.service.impl;

import com.elitesland.yst.comm.consumer.service.ComCityCodeRpcService;
import com.elitesland.yst.comm.service.ComCurrProviderService;
import com.elitesland.yst.comm.service.ComCurrRateProviderService;
import com.elitesland.yst.comm.service.ComPaymentTermProviderService;
import com.elitesland.yst.comm.service.ComTaxRateProviderService;
import com.elitesland.yst.comm.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitesland.yst.comm.vo.resp.ComCommonTaxRateRespVO;
import com.elitesland.yst.comm.vo.resp.ComTaxRateVO;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.out.service.ComOutService;
import com.elitesland.yst.system.param.SysUserIdFlowRoleRpcParam;
import com.elitesland.yst.system.service.SysNumberRuleService;
import com.elitesland.yst.system.service.SysUdcService;
import com.elitesland.yst.system.service.SysUserFlowRoleRpcService;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ComOutService")
public class ComOutServiceImpl
implements ComOutService {
    private static final Logger log = LoggerFactory.getLogger(ComOutServiceImpl.class);
    @DubboReference(version="${provider.service.version}")
    private SysNumberRuleService sysNumberRuleService;
    @DubboReference
    private SysUserFlowRoleRpcService sysUserFlowRoleRpcService;
    @DubboReference
    private ComCityCodeRpcService comCityCodeRpcService;
    @DubboReference(version="${provider.service.version}")
    private ComCurrProviderService comCurrRpcService;
    @DubboReference(version="${provider.service.version}")
    private ComPaymentTermProviderService comPaymentTermService;
    @DubboReference(version="${provider.service.version}")
    private ComCurrRateProviderService comCurrRateService;
    @DubboReference(version="${provider.service.version}")
    private ComTaxRateProviderService comTaxRateService;
    @DubboReference
    private SysUdcService sysUdcService;

    @Override
    public Optional<ComCommonTaxRateRespVO> getCommonTaxRateRatio(ComCommonTaxRateQueryParamVO param) {
        try {
            ComCommonTaxRateRespVO comCommonTaxRateRespVO = this.comTaxRateService.getRatioOrNull(param);
            if (Objects.nonNull(comCommonTaxRateRespVO)) {
                return Optional.of(comCommonTaxRateRespVO);
            }
        }
        catch (Exception e) {
            log.error("getCommonTaxRateRatio error:", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public List<ComTaxRateVO> findTaxRateBytaxRateNoList(List<String> taxRateNos) {
        if (org.springframework.util.CollectionUtils.isEmpty(taxRateNos)) {
            return Lists.newArrayList();
        }
        try {
            List comTaxRateVos = this.comTaxRateService.findBytaxRateNoList(taxRateNos);
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)comTaxRateVos)) {
                return comTaxRateVos;
            }
        }
        catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public String generateCode(String ruleCode, List<String> runtimeValues) {
        try {
            String code = this.sysNumberRuleService.generateCode(ruleCode, runtimeValues);
            if (StringUtils.isEmpty((Object)code)) {
                log.error("\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
                throw new BusinessException(ApiCode.FAIL, "\u8c03\u7528\u53d1\u53f7\u5668\u5f02\u5e38,\u53d1\u53f7\u5668\u7f16\u7801\u672a\u751f\u6210,\u89c4\u5219:" + ruleCode);
            }
            return code;
        }
        catch (Exception e) {
            log.error("generateCode error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
    }

    @Override
    public List<Long> findUserIdsByFlowRoles(Long ouId, String customParams) {
        log.info("\u901a\u8fc7ouId,\u81ea\u5b9a\u4e49\u53c2\u6570\u83b7\u53d6\u7528\u6237\u5217\u8868\uff0c\u65f6\u95f4\uff1a{}\uff0c\u5165\u53c2\uff1a{}", (Object)LocalDateTime.now(), (Object)ouId);
        try {
            SysUserIdFlowRoleRpcParam param = new SysUserIdFlowRoleRpcParam();
            param.setOuIds(Collections.singletonList(ouId));
            String[] sp = customParams.split(";");
            ArrayList newStr = new ArrayList();
            Collections.addAll(newStr, sp);
            param.setFlowRoleCodes(newStr);
            List userIds = this.sysUserFlowRoleRpcService.findUserIdsByFlowRoles(param);
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                return userIds;
            }
        }
        catch (Exception e) {
            log.error("findUserIdsByFlowRoles error:", (Throwable)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        return null;
    }
}

