/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.out.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.srmdomain.out.service.ItmService;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.yst.supportdomain.provider.item.param.SrmItmItemNParamVO;
import com.elitesland.yst.supportdomain.provider.item.vo.SrmItmItemNRespVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ItmService")
public class ItmServiceImpl
implements ItmService {
    private static final Logger log = LoggerFactory.getLogger(ItmServiceImpl.class);
    private final SrmItmItemRepoProc srmItmItemRepoProc;
    private final ItmItemCateService itmItemCateService;

    @Override
    @SysCodeProc
    public List<SrmItmItemNRespVO> findItemRpcDtoByParam(SrmItmItemNParamVO param) {
        try {
            if (!CollectionUtils.isEmpty((Collection)param.getBrands())) {
                return Lists.newArrayList();
            }
            List fetch = this.srmItmItemRepoProc.selectN(param).fetch();
            if (!CollectionUtils.isEmpty((Collection)fetch)) {
                this.fill(fetch);
                return fetch;
            }
        }
        catch (Exception e) {
            log.error("findItemUomConvDtoByParam error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    private void fill(List<SrmItmItemNRespVO> list) {
        List itemCateCodeS = list.stream().map(SrmItmItemNRespVO::getItemCateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        try {
            ItmItemCateCodeParam codeParam = new ItmItemCateCodeParam();
            codeParam.setItemCateCodes(itemCateCodeS);
            Map<String, ItmCateCodeAndNameRpcDTO> codeReItemCateMap = this.findCateCodeReItemCateCode(codeParam);
            list.forEach(v -> {
                if (StringUtils.isNotBlank((CharSequence)v.getItemCateCode()) && null != codeReItemCateMap && !codeReItemCateMap.isEmpty() && codeReItemCateMap.containsKey(v.getItemCateCode())) {
                    ItmCateCodeAndNameRpcDTO codeAndNameRpcDTO = (ItmCateCodeAndNameRpcDTO)codeReItemCateMap.get(v.getItemCateCode());
                    List cateNameList = codeAndNameRpcDTO.getCateNameList();
                    v.setItemCatePathName(cateNameList);
                    if (!CollectionUtils.isEmpty((Collection)codeAndNameRpcDTO.getCateNameList())) {
                        v.setItemCateName(String.join((CharSequence)">", cateNameList));
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
        }
    }

    public Map<String, ItmCateCodeAndNameRpcDTO> findCateCodeReItemCateCode(ItmItemCateCodeParam param) {
        log.info("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3findCateCodeReItemCateCode\u65b9\u6cd5\u5f00\u59cb,\u65f6\u95f4:{},\u53c2\u6570:{}", (Object)param);
        try {
            if (CollectionUtils.isEmpty((Collection)param.getItemCateCodes())) {
                return null;
            }
            ItmItemCateCodeRpcDTO itemCateCode = this.findCateCodeReItemCateCodes(param);
            Map itemCateCodeCateMap = itemCateCode.getCateMap();
            return itemCateCodeCateMap;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    public ItmItemCateCodeRpcDTO findCateCodeReItemCateCodes(ItmItemCateCodeParam param) {
        List itemCateCodes = param.getItemCateCodes();
        HashMap resultMap = new HashMap();
        itemCateCodes.forEach(itemCateCode -> {
            List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath((String)itemCateCode);
            ArrayList<String> pathCode = new ArrayList<String>();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathCodeAndName(path, pathCode, pathName);
            resultMap.put(itemCateCode, ItmCateCodeAndNameRpcDTO.builder().cateNameList(pathName).cateCodeList(pathCode).build());
        });
        return ItmItemCateCodeRpcDTO.builder().cateMap(resultMap).build();
    }

    private void buildPathCodeAndName(List<ItmItemCateSimpleTree> tree, List<String> pathCode, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathCode.add(t.getItemCateCode());
            pathName.add(t.getItemCateName());
            this.buildPathCodeAndName(t.getTreeNodes(), pathCode, pathName);
        });
    }

    public ItmServiceImpl(SrmItmItemRepoProc srmItmItemRepoProc, ItmItemCateService itmItemCateService) {
        this.srmItmItemRepoProc = srmItmItemRepoProc;
        this.itmItemCateService = itmItemCateService;
    }
}

