/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.out.service.impl;

import com.elitesland.supp.dto.SrmPurSuppDTO;
import com.elitesland.supp.outprovider.SrmPurSuppOutProvider;
import com.elitesland.yst.srmdomain.out.service.SrmService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="SrmService")
public class SrmServiceImpl
implements SrmService {
    private static final Logger log = LoggerFactory.getLogger(SrmServiceImpl.class);
    @DubboReference
    private SrmPurSuppOutProvider purSuppService;

    @Override
    public List<SrmPurSuppDTO> findPurSuppbyId(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        try {
            List list = this.purSuppService.findById(ids);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
        }
        catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SrmPurSuppDTO> findBylikeSuppCodeOrName(String suppCodeName) {
        if (ObjectUtils.isEmpty((Object)suppCodeName)) {
            return Lists.newArrayList();
        }
        try {
            List list = this.purSuppService.findBylikeSuppCodeOrName(suppCodeName);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
        }
        catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<SrmPurSuppDTO> findBySuppCodes(List<String> suppCodess) {
        if (CollectionUtils.isEmpty(suppCodess)) {
            return Lists.newArrayList();
        }
        try {
            List list = this.purSuppService.findBySuppCodes(suppCodess);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
        }
        catch (Exception e) {
            log.error("findTaxRateBytaxRateNoList error:", (Throwable)e);
        }
        return Lists.newArrayList();
    }
}

