/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.out.service.impl;

import com.elitesland.yst.srmdomain.out.service.SuppService;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmBrandRpcRepoProc;
import com.elitesland.yst.supportdomain.item.provider.repo.ItmItemUomConvRpcRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.org.provider.repo.OrgOuRpcRepoProc;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmCateCodeAndNameRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemCateCodeRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemUomConvRpcDTO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemCateCodeParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemUomConvRpcDtoParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemUomConvRpcOtherParam;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.supportdomain.provider.org.param.OrgOuRpcDtoParam;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="SuppService")
public class SuppServiceImpl
implements SuppService {
    private static final Logger log = LoggerFactory.getLogger(SuppServiceImpl.class);
    private final OrgOuRpcRepoProc orgOuRpcRepoProc;
    private final ItmBrandRpcRepoProc itmBrandRpcRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final ItmItemUomConvRpcRepoProc itmItemUomConvRpcRepoProc;

    @Override
    public List<OrgOuRpcDTO> findOuByIds(List<Long> ouIds) {
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuIds(ouIds);
        try {
            List<OrgOuRpcDTO> ous = this.orgOuRpcRepoProc.findOuRpcDtoByParam(param);
            if (!org.springframework.util.CollectionUtils.isEmpty(ous)) {
                return ous;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Lists.newArrayList();
    }

    @Override
    public Map<String, ItmCateCodeAndNameRpcDTO> findCateCodeReItemCateCode(ItmItemCateCodeParam param) {
        log.info("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3findCateCodeReItemCateCode\u65b9\u6cd5\u5f00\u59cb,\u65f6\u95f4:{},\u53c2\u6570:{}", (Object)param);
        try {
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)param.getItemCateCodes())) {
                return null;
            }
            ItmItemCateCodeRpcDTO itemCateCode = this.findCateCodeReItemCateCodeS(param);
            Map itemCateCodeCateMap = itemCateCode.getCateMap();
            return itemCateCodeCateMap;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u652f\u6491\u57df\u5546\u54c1\u4e2d\u5fc3\u6839\u636e\u54c1\u7c7b\u7f16\u7801\u67e5\u8be2\u65b9\u6cd5\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    public List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParamS(ItmItemUomConvRpcDtoParam param) {
        List otherParam = param.getOtherParam();
        if (CollectionUtils.isNotEmpty((Collection)param.getOtherParam())) {
            List itemIds = otherParam.stream().map(ItmItemUomConvRpcOtherParam::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(itemIds)) {
                return Collections.emptyList();
            }
            List<ItmItemUomConvRpcDTO> rpcDtoByParam = this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(ItmItemUomConvRpcDtoParam.builder().itemIds(itemIds).build());
            if (CollectionUtils.isEmpty(rpcDtoByParam)) {
                return Collections.emptyList();
            }
            Map<Long, List<ItmItemUomConvRpcDTO>> rpcDtoByParamMap = rpcDtoByParam.stream().collect(Collectors.groupingBy(ItmItemUomConvRpcDTO::getItemId));
            ArrayList<ItmItemUomConvRpcDTO> result = new ArrayList<ItmItemUomConvRpcDTO>();
            for (ItmItemUomConvRpcOtherParam convParam : otherParam) {
                Long itemId = convParam.getItemId();
                String fromUom = convParam.getFromUom();
                String toUom = convParam.getToUom();
                List<ItmItemUomConvRpcDTO> itmItemUomConvRpcDTOS = rpcDtoByParamMap.get(itemId);
                if (!CollectionUtils.isNotEmpty(itmItemUomConvRpcDTOS)) continue;
                for (ItmItemUomConvRpcDTO itmItemUomConvRpcDTO : itmItemUomConvRpcDTOS) {
                    String fromUom1 = itmItemUomConvRpcDTO.getFromUom();
                    String toUom1 = itmItemUomConvRpcDTO.getToUom();
                    if (fromUom.equals(fromUom1) && toUom.equals(toUom1)) {
                        result.add(itmItemUomConvRpcDTO);
                        continue;
                    }
                    if (!fromUom.equals(toUom1) || !toUom.equals(fromUom1)) continue;
                    BigDecimal ratio = itmItemUomConvRpcDTO.getRatio();
                    itmItemUomConvRpcDTO.setRatio(itmItemUomConvRpcDTO.getRevertRatio());
                    itmItemUomConvRpcDTO.setRevertRatio(ratio);
                    result.add(itmItemUomConvRpcDTO);
                }
            }
            return result;
        }
        List<ItmItemUomConvRpcDTO> result = this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(param);
        if (CollectionUtils.isEmpty(result) && StringUtils.isNotBlank((CharSequence)param.getFromUom()) && StringUtils.isNotBlank((CharSequence)param.getToUom())) {
            String tempUom = param.getFromUom();
            param.setFromUom(param.getToUom());
            param.setToUom(tempUom);
            result = this.itmItemUomConvRpcRepoProc.findRpcDtoByParam(param);
            if (CollectionUtils.isNotEmpty(result)) {
                result.forEach(dto -> {
                    BigDecimal tempRatio = dto.getRatio();
                    dto.setRatio(dto.getRevertRatio());
                    dto.setRevertRatio(tempRatio);
                    String tmpUom = dto.getFromUom();
                    dto.setFromUom(dto.getToUom());
                    dto.setToUom(tmpUom);
                });
            }
        }
        return result;
    }

    public ItmItemCateCodeRpcDTO findCateCodeReItemCateCodeS(ItmItemCateCodeParam param) {
        List itemCateCodes = param.getItemCateCodes();
        HashMap resultMap = new HashMap();
        itemCateCodes.forEach(itemCateCode -> {
            List<ItmItemCateSimpleTree> path = this.itmItemCateService.findItemCatePath((String)itemCateCode);
            ArrayList<String> pathCode = new ArrayList<String>();
            ArrayList<String> pathName = new ArrayList<String>();
            this.buildPathCodeAndName(path, pathCode, pathName);
            resultMap.put(itemCateCode, ItmCateCodeAndNameRpcDTO.builder().cateNameList(pathName).cateCodeList(pathCode).build());
        });
        return ItmItemCateCodeRpcDTO.builder().cateMap(resultMap).build();
    }

    private void buildPathCodeAndName(List<ItmItemCateSimpleTree> tree, List<String> pathCode, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathCode.add(t.getItemCateCode());
            pathName.add(t.getItemCateName());
            this.buildPathCodeAndName(t.getTreeNodes(), pathCode, pathName);
        });
    }

    public SuppServiceImpl(OrgOuRpcRepoProc orgOuRpcRepoProc, ItmBrandRpcRepoProc itmBrandRpcRepoProc, ItmItemCateService itmItemCateService, ItmItemUomConvRpcRepoProc itmItemUomConvRpcRepoProc) {
        this.orgOuRpcRepoProc = orgOuRpcRepoProc;
        this.itmBrandRpcRepoProc = itmBrandRpcRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.itmItemUomConvRpcRepoProc = itmItemUomConvRpcRepoProc;
    }
}

