/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.proportion.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.base.param.OrderItem;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.proportion.provider.YstItemProportionProvider;
import com.elitesland.yst.srmdomain.proportion.vo.excel.YstItemProportionExcelVO;
import com.elitesland.yst.srmdomain.proportion.vo.param.YstItemProportionPageParamVO;
import com.elitesland.yst.srmdomain.proportion.vo.resp.YstItemProportionPageRespVO;
import com.elitesland.yst.srmdomain.proportion.vo.save.YstItemProportionPageSaveVO;
import com.elitesland.yst.srmdomain.suppitem.vo.excel.YstSuppItemExcelVO;
import com.elitesland.yst.srmdomain.util.excel.exportExcel.ExcelWriteUtil;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"ystItemProportion"})
@Api(value="ystItemProportion", tags={"\u6bd4\u4f8b\u8868"})
@RestController
public class YstItemProportionController {
    private final YstItemProportionProvider ystItemProportionService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<YstItemProportionPageRespVO>> search(@RequestBody YstItemProportionPageParamVO param) {
        PagingVO<YstItemProportionPageRespVO> ret = this.ystItemProportionService.search(param);
        return ApiResult.ok(ret);
    }

    @PostMapping(value={"/searchpo"})
    @ApiOperation(value="\u7528\u4e8e\u91c7\u8d2d\u7684\u5546\u54c1\u516c\u5171\u63a5\u53e3")
    public ApiResult<Object> searchpo(@RequestBody YstItemProportionPageParamVO param) {
        if (CollectionUtils.isEmpty((Collection)param.getOrders())) {
            param.setOrders(this.initOrderColumn());
        }
        Object ret = this.ystItemProportionService.searchpo(param);
        return ApiResult.ok((Object)ret);
    }

    private List<OrderItem> initOrderColumn() {
        ArrayList<OrderItem> orders = new ArrayList<OrderItem>();
        OrderItem itemTime = new OrderItem("createTime", false);
        OrderItem itemCode = new OrderItem("itemCode", false);
        orders.add(itemTime);
        orders.add(itemCode);
        return orders;
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void stkAcctExport(HttpServletResponse response, @RequestBody YstItemProportionPageParamVO param) throws IOException {
        param.setSize(20000);
        List ystItemProportionRespVOList = this.ystItemProportionService.searchGroup(param).getRecords();
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u5bfc\u5165")
    public ApiResult<?> importVeFileDO(HttpServletResponse response, @RequestPart MultipartFile file) throws IOException {
        if (file.isEmpty()) {
            throw new BusinessException("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        this.ystItemProportionService.importVeFile(file);
        return ApiResult.ok();
    }

    @GetMapping(value={"/findbySuppCode/{suppCode}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    ApiResult<List<YstItemProportionPageRespVO>> findbySuppCode(@PathVariable String suppCode) {
        return ApiResult.ok(this.ystItemProportionService.findbySuppCode(suppCode));
    }

    @PostMapping(value={"/updateAll"})
    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u6570\u636e")
    public ApiResult<?> updateAll(@RequestBody List<YstItemProportionPageSaveVO> param) {
        List<YstItemProportionPageSaveVO> ystItemProportionSaveVOS = this.ystItemProportionService.updateAll(param);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/deleteId/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e")
    public ApiResult<Object> deleteItemCode(@PathVariable Long id) {
        this.ystItemProportionService.deleteId(id);
        return ApiResult.ok();
    }

    @PatchMapping(value={"/updateDeleteFlagBatchs"})
    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    public ApiResult<Object> updateDeleteFlagBatch(@RequestBody List<Long> ids) {
        this.ystItemProportionService.updateDeleteFlagBatch(ids);
        return ApiResult.ok();
    }

    @PatchMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u5355\u903b\u8f91\u5220\u9664")
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        this.ystItemProportionService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/importsTemplate"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u7248")
    @ApiOperationSupport(order=11)
    public void uploadScore(HttpServletResponse response) throws IOException {
        ArrayList<YstItemProportionExcelVO> list = new ArrayList<YstItemProportionExcelVO>();
        YstItemProportionExcelVO param = new YstItemProportionExcelVO();
        param.setSuppCode("SU00005266");
        param.setItemCode("12L");
        param.setItemProportion(BigDecimal.ZERO);
        list.add(param);
        ExcelWriteUtil.excelWrite(response, list, YstSuppItemExcelVO.class, "\u4f9b\u5e94\u5546\u548c\u54c1\u7c7b\u5173\u7cfb\u6a21\u7248\u5bfc\u51fa", "\u4f9b\u5e94\u5546\u548c\u54c1\u7c7b\u5173\u7cfb\u67e5\u8be2");
    }

    public YstItemProportionController(YstItemProportionProvider ystItemProportionService) {
        this.ystItemProportionService = ystItemProportionService;
    }
}

