/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.suppitem.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.srmdomain.suppitem.convert.YstSuppItemConvert;
import com.elitesland.yst.srmdomain.suppitem.provider.YstSuppItemProvider;
import com.elitesland.yst.srmdomain.suppitem.vo.excel.YstSuppItemExcelVO;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemPageParamVO;
import com.elitesland.yst.srmdomain.suppitem.vo.param.YstSuppItemScorePayload;
import com.elitesland.yst.srmdomain.suppitem.vo.resp.YstSuppItemPageRespVO;
import com.elitesland.yst.srmdomain.suppitem.vo.save.SuppItemCompRespVO;
import com.elitesland.yst.srmdomain.suppitem.vo.save.YstSuppItemPageSaveVO;
import com.elitesland.yst.srmdomain.util.excel.exportExcel.ExcelWriteUtil;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/ystSuppItem"})
@Api(value="ystSuppItem", tags={"\u4f9b\u5e94\u5546\u548c\u54c1\u9879\u4e4b\u95f4\u5173\u7cfb\u8868"})
@RestController
public class YstSuppItemController {
    private final YstSuppItemProvider ystSuppItemService;

    @PostMapping(value={"/search"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<YstSuppItemPageRespVO>> search(@RequestBody YstSuppItemPageParamVO param) {
        PagingVO<YstSuppItemPageRespVO> ret = this.ystSuppItemService.search(param);
        return ApiResult.ok(ret);
    }

    @PatchMapping(value={"/updateDeleteFlagBatch"})
    @ApiOperation(value="\u4f9b\u8d27\u54c1\u9879 - \u903b\u8f91\u5220\u9664")
    public ApiResult<Object> updateDeleteFlagBatch(@RequestBody List<Long> ids) {
        this.ystSuppItemService.updateDeleteFlagBatch(ids);
        return ApiResult.ok();
    }

    @PostMapping(value={"/deleteBatch"})
    @ApiOperation(value="\u4f9b\u8d27\u54c1\u7c7b - \u7269\u7406\u5220\u9664")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids) {
        this.ystSuppItemService.deleteBatch(ids);
        return ApiResult.ok();
    }

    @GetMapping(value={"/item/{suppCode}"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    ApiResult<List<YstSuppItemPageRespVO>> findBySuppId(@PathVariable(value="suppCode") String suppCode) {
        return ApiResult.ok(this.ystSuppItemService.findBySuppId(suppCode));
    }

    @PostMapping(value={"/saveAll"})
    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    public ApiResult<?> updateAll(@RequestBody List<YstSuppItemPageSaveVO> param) {
        this.ystSuppItemService.updateAll(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/imports"})
    @ApiOperation(value="\u5bfc\u5165")
    @ApiOperationSupport(order=11)
    public ApiResult<Object> uploadScore(MultipartFile file) {
        this.ystSuppItemService.imports(file);
        return ApiResult.ok();
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u4f9b\u8d27\u54c1\u7c7b\u2014\u5bfc\u51fa\u6570\u636e")
    public void exporto(HttpServletResponse response, @RequestBody YstSuppItemPageParamVO param) throws IOException, ExecutionException, InterruptedException {
        param.setSize(20000);
        PagingVO<YstSuppItemPageRespVO> ret = this.ystSuppItemService.search(param);
        List records = ret.getRecords();
        List<YstSuppItemExcelVO> ystSuppItemExcelVoS = YstSuppItemConvert.INSTANCE.pageRespoListToExcelVo(records);
        ExcelWriteUtil.excelWrite(response, ystSuppItemExcelVoS, YstSuppItemExcelVO.class, "\u4f9b\u5e94\u5546\u548c\u54c1\u7c7b\u5173\u7cfb\u5bfc\u51fa", "\u4f9b\u5e94\u5546\u548c\u54c1\u7c7b\u5173\u7cfb\u67e5\u8be2");
    }

    @PostMapping(value={"/importsTemplate"})
    @ApiOperation(value="\u5bfc\u5165\u6a21\u7248")
    @ApiOperationSupport(order=11)
    public void uploadScore(HttpServletResponse response) throws IOException {
        ArrayList<YstSuppItemExcelVO> list = new ArrayList<YstSuppItemExcelVO>();
        YstSuppItemExcelVO ystSuppItemExcelVO = new YstSuppItemExcelVO();
        ystSuppItemExcelVO.setSuppCode("SU00005266");
        ystSuppItemExcelVO.setItemCode("12L");
        list.add(ystSuppItemExcelVO);
        ExcelWriteUtil.excelWrite(response, list, YstSuppItemExcelVO.class, "\u4f9b\u5e94\u5546\u548c\u54c1\u7c7b\u5173\u7cfb\u6a21\u7248\u5bfc\u51fa", "\u4f9b\u5e94\u5546\u548c\u54c1\u7c7b\u5173\u7cfb\u67e5\u8be2");
    }

    @PatchMapping(value={"/updateDeleteFlag/{id}"})
    @ApiOperation(value="\u5355\u903b\u8f91\u5220\u9664")
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id) {
        this.ystSuppItemService.updateDeleteFlag(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/changeSuppItemScore"})
    @ApiOperation(value="\u4f9b\u8d27\u54c1\u7c7b - \u6279\u91cf\u8bc4\u5206")
    public ApiResult<Object> changeSuppItemScore(@RequestBody YstSuppItemScorePayload payload) {
        this.ystSuppItemService.changeSuppItemScore(payload);
        return ApiResult.ok();
    }

    @PostMapping(value={"/searchItem"})
    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u67e5\u8be2\u5546\u54c1")
    public ApiResult<PagingVO<YstSuppItemPageRespVO>> searchItem(@RequestBody YstSuppItemPageParamVO param) {
        PagingVO<YstSuppItemPageRespVO> ret = this.ystSuppItemService.searchItem(param);
        return ApiResult.ok(ret);
    }

    @ApiOperation(value="\u4f9b\u8d27\u76ee\u5f55- \u7269\u6599\u653e\u5927\u955c\u7ec4\u4ef6(\u5206\u9875)")
    @PostMapping(value={"/picker"})
    public ApiResult<PagingVO<SuppItemCompRespVO>> picker(@RequestBody YstSuppItemPageParamVO payload) {
        return ApiResult.ok(this.ystSuppItemService.queryItemPicker(payload));
    }

    public YstSuppItemController(YstSuppItemProvider ystSuppItemService) {
        this.ystSuppItemService = ystSuppItemService;
    }
}

