/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.util.excel.exportExcel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.regex.Pattern;

public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    public Class<LocalDateTime> supportJavaTypeKey() {
        return LocalDateTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalDateTime convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        if (CellDataTypeEnum.NUMBER.equals((Object)cellData.getType())) {
            return LocalDateTime.of(1900, 1, 1, 0, 0, 0).plusDays(cellData.getNumberValue().intValue() - 2);
        }
        if (CellDataTypeEnum.STRING.equals((Object)cellData.getType())) {
            String stringValue = cellData.getStringValue();
            stringValue = stringValue.replaceAll("-", "/");
            String pattern = "^[0-9]{4}/(0?[1-9]|1[0-2])/((0?[1-9])|((1|2)[0-9])|30|31)$";
            String pattern1 = "^((0?[1-9])|((1|2)[0-9])|30|31)/(0?[1-9]|1[0-2])/[0-9]{4}$";
            if (Pattern.matches(pattern, stringValue)) {
                String[] split = stringValue.split("/");
                String m = String.join((CharSequence)"", Collections.nCopies(split[1].length(), "M"));
                String d = String.join((CharSequence)"", Collections.nCopies(split[2].length(), "d"));
                String formatStr = String.format("yyyy/%s/%s HH:mm:ss", m, d);
                return LocalDateTime.parse(stringValue + " 00:00:00", DateTimeFormatter.ofPattern(formatStr));
            }
            if (Pattern.matches(pattern1, stringValue)) {
                String[] split = stringValue.split("/");
                String d = String.join((CharSequence)"", Collections.nCopies(split[0].length(), "d"));
                String m = String.join((CharSequence)"", Collections.nCopies(split[1].length(), "M"));
                String formatStr = String.format("%s/%s/yyyy HH:mm:ss", d, m);
                return LocalDateTime.parse(stringValue + " 00:00:00", DateTimeFormatter.ofPattern(formatStr));
            }
            return null;
        }
        return null;
    }

    public WriteCellData<String> convertToExcelData(LocalDateTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        return new WriteCellData(value.format(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
    }
}

