/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.srmdomain.work.item.service.impl;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.srmdomain.itmitem.provider.SrmItmItemProvider;
import com.elitesland.yst.srmdomain.out.service.ComOutService;
import com.elitesland.yst.srmdomain.proportion.entity.YstItemProportionDO;
import com.elitesland.yst.srmdomain.proportion.repo.YstItemProportionRepo;
import com.elitesland.yst.srmdomain.util.SrmStringUtil;
import com.elitesland.yst.srmdomain.util.enumproduct.SrmUdcEnum;
import com.elitesland.yst.srmdomain.work.item.service.ItmIteWorkService;
import com.elitesland.yst.srmdomain.work.util.PeDocStatus;
import com.elitesland.yst.srmdomain.ystsuppc13.repo.YstSuppC13RepoProc;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.param.YstSuppC13ParamVO;
import com.elitesland.yst.srmdomain.ystsuppc13.vo.resp.YstSuppC13RespVO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItmItemWorkServiceImpl
implements ItmIteWorkService {
    private final SrmItmItemProvider ystItmItemService;
    private final ItmItemRepo ystItmItemRepo;
    private final YstSuppC13RepoProc ystSuppC13RepoProc;
    private final YstItemProportionRepo ystItemProportionRepo;
    private final ComOutService sysOutService;

    @Override
    public ArrayList<String> taskAssignee(long businessKey, String customParams) {
        Optional byId = this.ystItmItemRepo.findById(businessKey);
        Long ouId = null;
        if (byId.isPresent()) {
            ItmItemDO ystItmItemDO = (ItmItemDO)byId.get();
            ouId = ystItmItemDO.getOuId();
        }
        List<Long> userIds = this.sysOutService.findUserIdsByFlowRoles(ouId, customParams);
        return SrmStringUtil.toStringArray(userIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(long businessKey, ProcInstStatus procInstStatus) {
        String docStatus = PeDocStatus.WAITING.getStatus();
        ProcInstStatus pronstStatus = ProcInstStatus.APPROVING;
        switch (procInstStatus) {
            case NOTSUBMIT: {
                pronstStatus = ProcInstStatus.NOTSUBMIT;
                docStatus = SrmUdcEnum.CBPL_ITMITEMSTATUS_A.getValueCode();
                break;
            }
            case INTERRUPT: {
                pronstStatus = ProcInstStatus.INTERRUPT;
                docStatus = SrmUdcEnum.CBPL_ITMITEMSTATUS_A.getValueCode();
                break;
            }
            case REJECTED: {
                pronstStatus = ProcInstStatus.REJECTED;
                docStatus = SrmUdcEnum.CBPL_ITMITEMSTATUS_A.getValueCode();
                break;
            }
            case INVALID: {
                pronstStatus = ProcInstStatus.INVALID;
                docStatus = SrmUdcEnum.CBPL_ITMITEMSTATUS_D.getValueCode();
                break;
            }
            case APPROVING: {
                pronstStatus = ProcInstStatus.APPROVING;
                docStatus = SrmUdcEnum.CBPL_ITMITEMSTATUS_B.getValueCode();
                break;
            }
            case APPROVED: {
                pronstStatus = ProcInstStatus.APPROVED;
                docStatus = SrmUdcEnum.CBPL_ITMITEMSTATUS_C.getValueCode();
                Optional optional = this.ystItmItemRepo.findById(businessKey);
                if (!optional.isPresent()) break;
                ItmItemDO itmItemDO = (ItmItemDO)optional.get();
                YstSuppC13ParamVO ystSuppC13ParamVO = new YstSuppC13ParamVO();
                ystSuppC13ParamVO.setItemCateCode(itmItemDO.getItemCateCode());
                List<YstSuppC13RespVO> ystSuppC13RespVOS = this.ystSuppC13RepoProc.searchM(ystSuppC13ParamVO);
                List dos = ystSuppC13RespVOS.stream().map(i -> {
                    YstItemProportionDO ystItemProportionDO = new YstItemProportionDO();
                    ystItemProportionDO.setItemCateCode(i.getItemCateCode());
                    ystItemProportionDO.setSuppCode(i.getSuppCode());
                    ystItemProportionDO.setSuppId(i.getSuppId());
                    ystItemProportionDO.setItemProportion(i.getItemProportion());
                    ystItemProportionDO.setLessProportion(i.getLessProportion());
                    ystItemProportionDO.setLessNumber(i.getLessNumber());
                    ystItemProportionDO.setMoreProportion(i.getMoreProportion());
                    ystItemProportionDO.setItemCode(itmItemDO.getItemCode());
                    ystItemProportionDO.setItemCode2(itmItemDO.getItemCode2());
                    ystItemProportionDO.setItemId(itmItemDO.getId());
                    return ystItemProportionDO;
                }).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(dos)) break;
                this.ystItemProportionRepo.saveAll(dos);
            }
        }
        this.ystItmItemService.updateInquiryStatus(businessKey, docStatus, pronstStatus);
    }

    public ItmItemWorkServiceImpl(SrmItmItemProvider ystItmItemService, ItmItemRepo ystItmItemRepo, YstSuppC13RepoProc ystSuppC13RepoProc, YstItemProportionRepo ystItemProportionRepo, ComOutService sysOutService) {
        this.ystItmItemService = ystItmItemService;
        this.ystItmItemRepo = ystItmItemRepo;
        this.ystSuppC13RepoProc = ystSuppC13RepoProc;
        this.ystItemProportionRepo = ystItemProportionRepo;
        this.sysOutService = sysOutService;
    }
}

