/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.com.service.impl;

import com.elitesland.yst.supportdomain.com.repo.ComCityCodeRepo;
import com.elitesland.yst.supportdomain.com.repo.ComCityCodeRepoProc;
import com.elitesland.yst.supportdomain.com.service.ComCityCodeService;
import com.elitesland.yst.supportdomain.com.vo.ComCityCodeVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class ComCityCodeServiceImpl
implements ComCityCodeService {
    private final ComCityCodeRepo comCityCodeRepo;
    private final ComCityCodeRepoProc comCityCodeRepoProc;
    private static final String CACHE_NAME = "COM_CITY_CODE";

    @Override
    public List<ComCityCodeVO> findAllCityCodes() {
        List<ComCityCodeVO> allAreas = this.comCityCodeRepoProc.searchAll();
        if (CollectionUtils.isEmpty(allAreas)) {
            return null;
        }
        Map<Long, List<ComCityCodeVO>> pidAreasMap = allAreas.stream().collect(Collectors.groupingBy(ComCityCodeVO::getPid));
        List pAreas = pidAreasMap.getOrDefault(0L, null);
        if (CollectionUtils.isEmpty((Collection)pAreas)) {
            return null;
        }
        return ComCityCodeServiceImpl.build(pAreas, pidAreasMap);
    }

    @Override
    @Cacheable(cacheNames={"COM_CITY_CODE"}, key="'SUB_LIST_' + #pid", condition="#pid == null", unless="#result == null")
    public List<ComCityCodeVO> findByPid(Long pid) {
        if (pid == null) {
            return null;
        }
        List<ComCityCodeVO> result = this.comCityCodeRepoProc.searchByPid(pid);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        result.forEach(r -> r.setIsLeaf(!this.comCityCodeRepo.existsByPid(r.getPid())));
        return result;
    }

    private static List<ComCityCodeVO> build(List<ComCityCodeVO> areas, Map<Long, List<ComCityCodeVO>> pidAreasMap) {
        for (ComCityCodeVO area : areas) {
            if (pidAreasMap.containsKey(area.getId())) {
                List<ComCityCodeVO> subAreas = ComCityCodeServiceImpl.build(pidAreasMap.get(area.getId()), pidAreasMap);
                area.setIsLeaf(false);
                area.setAreas(subAreas);
                continue;
            }
            area.setIsLeaf(true);
        }
        return areas;
    }

    public ComCityCodeServiceImpl(ComCityCodeRepo comCityCodeRepo, ComCityCodeRepoProc comCityCodeRepoProc) {
        this.comCityCodeRepo = comCityCodeRepo;
        this.comCityCodeRepoProc = comCityCodeRepoProc;
    }
}

