/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.common.repo;

import com.elitesland.yst.supportdomain.common.entity.QTableColumnExtDO;
import com.elitesland.yst.supportdomain.item.dto.TableColumnExtDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class TableColumnExtRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QTableColumnExtDO tableColumnExt = QTableColumnExtDO.tableColumnExtDO;
    private final QBean<TableColumnExtDTO> tableColumnExtDto;

    public List<TableColumnExtDTO> findExtColumn(String tableName, String columnName, Long rowId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.tableColumnExtDto).from((EntityPath)this.tableColumnExt)).where((Predicate)this.tableColumnExt.tableName.eq((Object)tableName).and((Predicate)this.tableColumnExt.columnName.eq((Object)columnName)).and((Predicate)this.tableColumnExt.rowId.eq((Object)rowId)))).fetch();
    }

    public List<TableColumnExtDTO> findExtColumn(String tableName, String columnName, String rowCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.tableColumnExtDto).from((EntityPath)this.tableColumnExt)).where((Predicate)this.tableColumnExt.tableName.eq((Object)tableName).and((Predicate)this.tableColumnExt.columnName.eq((Object)columnName)).and((Predicate)this.tableColumnExt.rowCode.eq((Object)rowCode)))).fetch();
    }

    public List<TableColumnExtDTO> findExtColumn(String tableName, String columnName, Long rowId, String rowCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.tableColumnExtDto).from((EntityPath)this.tableColumnExt)).where((Predicate)this.tableColumnExt.tableName.eq((Object)tableName).and((Predicate)this.tableColumnExt.columnName.eq((Object)columnName)).and((Predicate)this.tableColumnExt.rowId.eq((Object)rowId)).and((Predicate)this.tableColumnExt.rowCode.eq((Object)rowCode)))).fetch();
    }

    public void softDeleteExtColumn(String tableName, String columnName, Long rowId, String rowCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (rowId != null) {
            predicates.add(this.tableColumnExt.rowId.eq((Object)rowId));
        }
        if (StringUtils.isNotBlank((CharSequence)rowCode)) {
            predicates.add(this.tableColumnExt.rowCode.eq((Object)rowCode));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return;
        }
        predicates.add(this.tableColumnExt.tableName.eq((Object)tableName));
        predicates.add(this.tableColumnExt.columnName.eq((Object)columnName));
        this.jpaQueryFactory.update((EntityPath)this.tableColumnExt).set(this.tableColumnExt.deleteFlag, (Object)1).where(new Predicate[]{ExpressionUtils.allOf(predicates)});
    }

    public boolean existExtColumn(String tableName, String columnName, Long rowId, String rowCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (rowId != null) {
            predicates.add(this.tableColumnExt.rowId.eq((Object)rowId));
        }
        if (StringUtils.isNotBlank((CharSequence)rowCode)) {
            predicates.add(this.tableColumnExt.rowCode.eq((Object)rowCode));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return false;
        }
        predicates.add(this.tableColumnExt.tableName.eq((Object)tableName));
        predicates.add(this.tableColumnExt.columnName.eq((Object)columnName));
        predicates.add(this.tableColumnExt.deleteFlag.isNull().or((Predicate)this.tableColumnExt.deleteFlag.eq((Object)0)));
        long count = ((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.tableColumnExt).where(ExpressionUtils.allOf(predicates))).fetchCount();
        return count > 0L;
    }

    public boolean existExtColumnByValue(String tableName, String columnName, String columnValue) {
        if (StringUtils.isBlank((CharSequence)columnValue)) {
            return false;
        }
        long count = ((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.tableColumnExt).where((Predicate)this.tableColumnExt.tableName.eq((Object)tableName).and((Predicate)this.tableColumnExt.columnName.eq((Object)columnName)).and((Predicate)this.tableColumnExt.columnValue.eq((Object)columnValue)).and((Predicate)this.tableColumnExt.deleteFlag.isNull().or((Predicate)this.tableColumnExt.deleteFlag.eq((Object)0))))).fetchCount();
        return count > 0L;
    }

    public List<TableColumnExtDTO> findExtColumn(String tableName, String columnName, Set<String> itemCateCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.tableColumnExtDto).from((EntityPath)this.tableColumnExt)).where((Predicate)this.tableColumnExt.tableName.eq((Object)tableName).and((Predicate)this.tableColumnExt.columnName.eq((Object)columnName)).and((Predicate)this.tableColumnExt.rowCode.in(itemCateCodes)))).fetch();
    }

    public TableColumnExtRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.tableColumnExtDto = Projections.bean(TableColumnExtDTO.class, (Expression[])new Expression[]{this.tableColumnExt.tableName, this.tableColumnExt.columnName, this.tableColumnExt.rowId, this.tableColumnExt.sortNo, this.tableColumnExt.rowCode, this.tableColumnExt.columnValue});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

