/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.common.service.impl;

import com.elitesland.yst.supportdomain.common.entity.TableColumnExtDO;
import com.elitesland.yst.supportdomain.common.repo.TableColumnExtRepo;
import com.elitesland.yst.supportdomain.common.repo.TableColumnExtRepoProc;
import com.elitesland.yst.supportdomain.common.service.TableColumnExtService;
import com.elitesland.yst.supportdomain.item.dto.TableColumnExtDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TableColumnExtServiceImpl
implements TableColumnExtService {
    private final TableColumnExtRepo tableColumnExtRepo;
    private final TableColumnExtRepoProc tableColumnExtRepoProc;

    @Override
    public List<TableColumnExtDTO> findExtColumnValues(String tableName, String columnName, Long rowId) {
        if (this.tableColumnExtRepo.existsByTableNameAndColumnNameAndRowId(tableName, columnName, rowId)) {
            return this.tableColumnExtRepoProc.findExtColumn(tableName, columnName, rowId);
        }
        return null;
    }

    @Override
    public List<TableColumnExtDTO> findExtColumnValues(String tableName, String columnName, String rowCode) {
        if (this.tableColumnExtRepo.existsByTableNameAndColumnNameAndRowCode(tableName, columnName, rowCode)) {
            return this.tableColumnExtRepoProc.findExtColumn(tableName, columnName, rowCode);
        }
        return null;
    }

    @Override
    public List<TableColumnExtDTO> findExtColumnValues(String tableName, String columnName, Long rowId, String rowCode) {
        if (this.tableColumnExtRepo.existsByTableNameAndColumnNameAndRowIdAndRowCode(tableName, columnName, rowId, rowCode)) {
            return this.tableColumnExtRepoProc.findExtColumn(tableName, columnName, rowId, rowCode);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void extColumnHardSave(String tableName, String columnName, Long rowId, List<String> columnValues) {
        if (StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)columnName) || rowId == null) {
            return;
        }
        this.tableColumnExtRepo.deleteByTableNameAndColumnNameAndRowId(tableName, columnName, rowId);
        if (columnValues == null) {
            return;
        }
        List<TableColumnExtDO> tableColumnExtDos = this.buildDos(tableName, columnName, rowId, null, columnValues);
        this.tableColumnExtRepo.saveAll(tableColumnExtDos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void extColumnHardSave(String tableName, String columnName, String rowCode, List<String> columnValues) {
        if (StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)columnName) || StringUtils.isBlank((CharSequence)rowCode)) {
            return;
        }
        this.tableColumnExtRepo.deleteByTableNameAndColumnNameAndRowCode(tableName, columnName, rowCode);
        if (columnValues == null) {
            return;
        }
        List<TableColumnExtDO> tableColumnExtDos = this.buildDos(tableName, columnName, null, rowCode, columnValues);
        this.tableColumnExtRepo.saveAll(tableColumnExtDos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void extColumnHardSave(String tableName, String columnName, Long rowId, String rowCode, List<String> columnValues) {
        if (StringUtils.isBlank((CharSequence)tableName) || StringUtils.isBlank((CharSequence)columnName) || rowId == null || StringUtils.isBlank((CharSequence)rowCode)) {
            return;
        }
        this.tableColumnExtRepo.deleteByTableNameAndColumnNameAndRowIdAndRowCode(tableName, columnName, rowId, rowCode);
        if (columnValues == null) {
            return;
        }
        List<TableColumnExtDO> tableColumnExtDos = this.buildDos(tableName, columnName, rowId, rowCode, columnValues);
        this.tableColumnExtRepo.saveAll(tableColumnExtDos);
    }

    @Override
    public void softDeleteExtColumn(String tableName, String columnName, Long rowId) {
        this.tableColumnExtRepoProc.softDeleteExtColumn(tableName, columnName, rowId, null);
    }

    @Override
    public void softDeleteExtColumn(String tableName, String columnName, String rowCode) {
        this.tableColumnExtRepoProc.softDeleteExtColumn(tableName, columnName, null, rowCode);
    }

    @Override
    public void softDeleteExtColumn(String tableName, String columnName, Long rowId, String rowCode) {
        this.tableColumnExtRepoProc.softDeleteExtColumn(tableName, columnName, rowId, rowCode);
    }

    @Override
    public boolean existExtColumn(String tableName, String columnName, Long rowId) {
        return this.tableColumnExtRepoProc.existExtColumn(tableName, columnName, rowId, null);
    }

    @Override
    public boolean existExtColumn(String tableName, String columnName, String rowCode) {
        return this.tableColumnExtRepoProc.existExtColumn(tableName, columnName, null, rowCode);
    }

    @Override
    public boolean existExtColumn(String tableName, String columnName, Long rowId, String rowCode) {
        return this.tableColumnExtRepoProc.existExtColumn(tableName, columnName, rowId, rowCode);
    }

    @Override
    public boolean existExtColumnByValue(String tableName, String columnName, String columnValue) {
        return this.tableColumnExtRepoProc.existExtColumnByValue(tableName, columnName, columnValue);
    }

    @Override
    public List<TableColumnExtDTO> findExtColumnValues(String tableName, String columnName, Set<String> itemCateCodes) {
        return this.tableColumnExtRepoProc.findExtColumn(tableName, columnName, itemCateCodes);
    }

    private List<TableColumnExtDO> buildDos(String tableName, String columnName, Long rowId, String rowCode, List<String> columnValues) {
        ArrayList<TableColumnExtDO> tableColumnExtDos = new ArrayList<TableColumnExtDO>();
        int sortNo = 1;
        for (String columnValue : columnValues) {
            TableColumnExtDO tableColumnExtDO = new TableColumnExtDO();
            tableColumnExtDO.setTableName(tableName);
            tableColumnExtDO.setColumnName(columnName);
            tableColumnExtDO.setRowId(rowId);
            tableColumnExtDO.setRowCode(rowCode);
            tableColumnExtDO.setColumnValue(columnValue);
            tableColumnExtDO.setSortNo(sortNo++);
            tableColumnExtDos.add(tableColumnExtDO);
        }
        return tableColumnExtDos;
    }

    public TableColumnExtServiceImpl(TableColumnExtRepo tableColumnExtRepo, TableColumnExtRepoProc tableColumnExtRepoProc) {
        this.tableColumnExtRepo = tableColumnExtRepo;
        this.tableColumnExtRepoProc = tableColumnExtRepoProc;
    }
}

