/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.controller;

import com.alibaba.excel.EasyExcel;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.srmdomain.util.excel.exportExcel.ExcelWriteUtil;
import com.elitesland.yst.srmdomain.util.excel.importExcel.listener.ExcelEntityDataListener;
import com.elitesland.yst.supportdomain.item.excel.service.TmItmItemExcelService;
import com.elitesland.yst.supportdomain.item.excel.vo.TmItmItemExportVO;
import com.elitesland.yst.supportdomain.provider.item.dto.ItmItemPicDTO;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemAttrParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemQueryParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSaveParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSpuQueryParam;
import com.elitesland.yst.supportdomain.provider.item.param.ItmItemSpuSaveParam;
import com.elitesland.yst.supportdomain.provider.item.service.ItmItemAttrRpcService;
import com.elitesland.yst.supportdomain.provider.item.service.ItmItemRpcService;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemQueryDTO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemSpuQueryDTO;
import com.elitesland.yst.supportdomain.sync.service.B2BItemSyncService;
import com.elitesland.yst.supportdomain.sync.vo.param.BaseItemMasSyncParam;
import com.elitesland.yst.supportdomain.sync.vo.param.BaseItemMasUploadVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/rpc/itm"})
@Api(value="\u4e1c\u660e\u5e7f\u573aDubbo\u63a5\u53e3\u6d4b\u8bd5", tags={"\u4e1c\u660e\u5e7f\u573aDubbo\u63a5\u53e3\u6d4b\u8bd5"})
public class ItmItemTestController {
    private final ItmItemRpcService itmItemRpcService;
    private final ItmItemAttrRpcService itmItemAttrRpcService;
    private final TmItmItemExcelService excelService;
    private final B2BItemSyncService b2BItemSyncService;

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1")
    @PostMapping(value={"/saveItem"})
    public ApiResult<Object> saveItem(@RequestBody List<ItmItemSaveParam> param) {
        this.itmItemRpcService.saveItmItemBatch(param);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1SPU")
    @PostMapping(value={"/saveItemSpu"})
    public ApiResult<Object> saveItemSpu(@RequestBody List<ItmItemSpuSaveParam> param) {
        this.itmItemRpcService.saveItmItemSpuBatch(param);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1SPU")
    @PostMapping(value={"/saveItemSpuSync"})
    public ApiResult<Object> saveItemSpuSync(@RequestBody List<ItmItemSaveParam> param) {
        ArrayList spuParam = new ArrayList();
        param.forEach(p -> {
            ItmItemSpuSaveParam saveParam = new ItmItemSpuSaveParam();
            saveParam.setSpuCode(p.getSpuCode());
            saveParam.setSpuName(p.getItemName());
            spuParam.add(saveParam);
        });
        this.itmItemRpcService.saveItmItemSync(spuParam, param);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1")
    @DeleteMapping(value={"/deleteItem"})
    public ApiResult<Object> deleteItmItemById(@RequestBody List<Long> param) {
        this.itmItemRpcService.deleteItmItemById(param);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1SPU")
    @DeleteMapping(value={"/deleteItemSpu/{id}"})
    public ApiResult<Object> saveSpuSku(@PathVariable Long id) {
        this.itmItemRpcService.deleteItmItemSpuById(id);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1")
    @PostMapping(value={"/updateItem"})
    public ApiResult<Object> updateItem(@RequestBody ItmItemSaveParam saveParam) {
        this.itmItemRpcService.updateItmItemById(saveParam);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1SPU")
    @PostMapping(value={"/updateItemSpu"})
    public ApiResult<Object> updateItemSpu(@RequestBody ItmItemSpuSaveParam saveParam) {
        this.itmItemRpcService.updateItmItemSpuById(saveParam);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1")
    @PostMapping(value={"/queryItem"})
    public ApiResult<PagingVO<ItmItemQueryDTO>> queryItem(@RequestBody ItmItemQueryParam saveParam) {
        PagingVO itmItemQueryDTOPagingVO = this.itmItemRpcService.queryItmItem(saveParam);
        return ApiResult.ok((Object)itmItemQueryDTOPagingVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1SPU")
    @PostMapping(value={"/queryItemSpu"})
    public ApiResult<PagingVO<ItmItemSpuQueryDTO>> queryItemSpu(@RequestBody ItmItemSpuQueryParam saveParam) {
        PagingVO itmItemSpuQueryDTOPagingVO = this.itmItemRpcService.queryItmItemSpu(saveParam);
        return ApiResult.ok((Object)itmItemSpuQueryDTOPagingVO);
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2SPU\u4fe1\u606f")
    @PostMapping(value={"/queryItemSpuById/{id}"})
    public ApiResult<ItmItemSpuQueryDTO> queryItemSpu(@PathVariable Long id) {
        ItmItemSpuQueryDTO itmItemSpuQueryDTOPagingVO = this.itmItemRpcService.queryItmItemSpuById(id);
        return ApiResult.ok((Object)itmItemSpuQueryDTOPagingVO);
    }

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1\u56fe\u7247")
    @PostMapping(value={"/saveItemPic"})
    public ApiResult<Object> saveItemPic(@RequestBody List<ItmItemPicDTO> param) {
        this.itmItemRpcService.saveItmItemPic(param);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5c5e\u6027")
    @PostMapping(value={"/queryItemAttr"})
    public ApiResult<Map<String, Object>> queryItemAttr(@RequestBody ItmItemAttrParam param) {
        List spuList = this.itmItemAttrRpcService.queryItemSpu(param);
        List standardList = this.itmItemAttrRpcService.queryItemStandard(param);
        List materialList = this.itmItemAttrRpcService.queryItemMaterial(param);
        List diameterList = this.itmItemAttrRpcService.queryItemDiameter(param);
        List lengthsList = this.itmItemAttrRpcService.queryItemLengths(param);
        List toothList = this.itmItemAttrRpcService.queryItemTooth(param);
        List surfaceList = this.itmItemAttrRpcService.queryItemSurface(param);
        List strengthList = this.itmItemAttrRpcService.queryItemStrength(param);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("spuList", spuList);
        result.put("standardList", standardList);
        result.put("materialList", materialList);
        result.put("diameterList", diameterList);
        result.put("lengthsList", lengthsList);
        result.put("toothList", toothList);
        result.put("surfaceList", surfaceList);
        result.put("strengthList", strengthList);
        return ApiResult.ok(result);
    }

    @PostMapping(value={"/export"})
    @ApiModelProperty(value="\u5bfc\u51fa\u4ea7\u54c1\u660e\u7ec6")
    public void exportCategory(HttpServletResponse response, @RequestBody ItmItemQueryParam param) throws IOException {
        param.setSize(Integer.valueOf(100000));
        List<TmItmItemExportVO> categoryList = this.excelService.exportItmItem(param);
        ExcelWriteUtil.excelWrite(response, categoryList, TmItmItemExportVO.class, "\u5546\u54c1\u660e\u7ec6\u5bfc\u51fa\u4fe1\u606f", "\u5546\u54c1\u660e\u7ec6\u5bfc\u51fa\u4fe1\u606f");
    }

    @ApiOperation(value="b2b\u5546\u54c1\u540c\u6b65")
    @GetMapping(value={"/items"})
    public ApiResult<Object> syncBaseItem(BaseItemMasSyncParam param) {
        try {
            this.b2BItemSyncService.syncBaseItem(param);
            return ApiResult.ok();
        }
        catch (BusinessException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    @ApiOperation(value="b2b\u5546\u54c1\u540c\u6b652")
    @PostMapping(value={"/itemsByItemCode"}, headers={"content-type=multipart/form-data"})
    public ApiResult<Object> syncBaseItemByItemCode(@RequestBody MultipartFile file) {
        ExcelEntityDataListener uploadListener = new ExcelEntityDataListener();
        try {
            EasyExcel.read((InputStream)file.getInputStream(), BaseItemMasUploadVO.class, uploadListener).doReadAll();
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u5bfc\u5165\u5931\u8d25");
        }
        List datas = uploadListener.getDatas();
        if (CollectionUtils.isEmpty(datas)) {
            throw new BusinessException("\u8868\u683c\u4e3a\u7a7a");
        }
        List<String> itemCodeList = datas.stream().filter(t -> StringUtils.isNotEmpty((String)t.getItemCode())).map(BaseItemMasUploadVO::getItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return ApiResult.ok();
        }
        BaseItemMasSyncParam syncParam = new BaseItemMasSyncParam();
        syncParam.setAllFlag("0");
        syncParam.setItemCodeList(itemCodeList);
        this.b2BItemSyncService.syncBaseItem(syncParam);
        return ApiResult.ok();
    }

    public ItmItemTestController(ItmItemRpcService itmItemRpcService, ItmItemAttrRpcService itmItemAttrRpcService, TmItmItemExcelService excelService, B2BItemSyncService b2BItemSyncService) {
        this.itmItemRpcService = itmItemRpcService;
        this.itmItemAttrRpcService = itmItemAttrRpcService;
        this.excelService = excelService;
        this.b2BItemSyncService = b2BItemSyncService;
    }
}

