/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.supportdomain.controller.CacheTest;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.param.ItmItemBusinessSaveParam;
import com.elitesland.yst.supportdomain.item.service.ItmItemBusinessService;
import com.elitesland.yst.supportdomain.item.service.impl.ItmItemCateCacheManager;
import com.elitesland.yst.system.service.SysNumberRuleService;
import com.elitesland.yst.system.service.SysUdcService;
import com.elitesland.yst.system.service.SysUserRoleService;
import com.elitesland.yst.system.service.SysUserService;
import com.elitesland.yst.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/demo"})
@Api(value="API \u6d4b\u8bd5", tags={"API \u6d4b\u8bd5"})
public class TestController {
    @DubboReference
    private SysUserRoleService sysUserRoleService;
    private final CacheTest cacheTest;
    @DubboReference(version="${provider.service.version}")
    private SysNumberRuleService sysNumberRuleService;
    private final ItmItemBusinessService itmItemBusinessService;
    private final Environment environment;
    private final ItmItemCateCacheManager itmItemCateCacheManager;
    @DubboReference(version="${provider.service.version}")
    private SysUserService sysUserService;
    private final SysUdcService sysUdcService;

    @ApiOperation(value="API user\u63a5\u53e3\u6d4b\u8bd5")
    @GetMapping(value={"/user"})
    public ApiResult<Object> user() {
        return ApiResult.ok((Object)SecurityUtil.getUser());
    }

    @ApiOperation(value="API \u63a5\u53e3\u6d4b\u8bd5")
    @GetMapping(value={"/test"})
    public ApiResult<Object> demo() {
        return ApiResult.ok();
    }

    @ApiOperation(value="System Dubbo \u63a5\u53e3\u6d4b\u8bd5")
    @GetMapping(value={"/dubbo/system"})
    public ApiResult<Object> systemDubbo(@RequestParam Long userId) {
        Set result = this.sysUserRoleService.listRolesByUserId(userId);
        return ApiResult.ok((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58")
    @GetMapping(value={"/cache/cacheable/{key}"})
    public ApiResult<String> cacheableTest(@PathVariable String key) {
        String result = this.cacheTest.getCache(key);
        return ApiResult.ok((Object)result);
    }

    @ApiOperation(value="\u6e05\u7a7a\u7f13\u5b58")
    @GetMapping(value={"/cache/evict/{key}"})
    public ApiResult<Object> evictCacheTest(@PathVariable String key) {
        this.cacheTest.evictCache(key);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u53d1\u53f7\u5668\u6d4b\u8bd5")
    @GetMapping(value={"/code/{rule}"})
    public ApiResult<String> getNextNumber(@PathVariable String rule, @RequestParam(required=false) String runtimeValue) {
        List<String> runtimeValues = null;
        if (StringUtils.isNotBlank((CharSequence)runtimeValue)) {
            runtimeValues = Collections.singletonList(runtimeValue);
        }
        String code = this.sysNumberRuleService.generateCode(rule, runtimeValues);
        return ApiResult.ok((Object)code);
    }

    @ApiOperation(value="\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u6dfb\u52a0(\u5546\u54c1\u65b0\u589e\u65f6\uff0c\u540c\u6b65\u5728\u7ecf\u8425\u76ee\u5f55\u8868\u6dfb\u52a0\u6570\u636e)")
    @PostMapping(value={"/itm/itmItemBusinessSave"})
    public ApiResult<Object> itmItemBusinessSave(@RequestBody List<ItmItemBusinessSaveParam> itmItemBusinessSaveParams) {
        this.itmItemBusinessService.itmItemBusinessSave(itmItemBusinessSaveParams, false);
        return ApiResult.ok();
    }

    @ApiOperation(value="EL\u7ecf\u8425\u76ee\u5f55\u56fa\u5b9a\u7ec4\u7ec7\u6811\u7f16\u7801\u914d\u7f6e")
    @GetMapping(value={"/buTreeCodeTest"})
    public ApiResult<String> buTreeCodeTest() {
        String result = this.environment.getProperty("buTree.code");
        return ApiResult.ok((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u54c1\u7c7b\u8def\u5f84")
    @GetMapping(value={"/refresh/catePath/{itemCateCode}"})
    public ApiResult<Object> refreshCateTreeByCode(@PathVariable String itemCateCode) {
        this.itmItemCateCacheManager.refreshItemCatePathCache(itemCateCode);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u54c1\u7c7b\u8def\u5f84")
    @PostMapping(value={"/catePaths"})
    public ApiResult<List<List<ItmItemCateSimpleTree>>> findCatePathsByCodes(@RequestBody List<String> itemCateCodes) {
        ArrayList<List<ItmItemCateSimpleTree>> result = new ArrayList<List<ItmItemCateSimpleTree>>();
        for (String itemCateCode : itemCateCodes) {
            List<ItmItemCateSimpleTree> tree = this.itmItemCateCacheManager.findItemCatePath(itemCateCode);
            result.add(tree);
        }
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/user/findByIds"})
    public ApiResult<Object> findUserByIds(@RequestParam List<Long> ids) {
        List result = this.sysUserService.getByIds(ids);
        return ApiResult.ok((Object)result);
    }

    @GetMapping(value={"/udc/findOne"})
    public ApiResult<Object> findUserDtoByIds(@RequestParam List<Long> ids) {
        SysUdcVO result = this.sysUdcService.findOneSysUdc("ITM", "ITEM_STATUS", "DRAFT");
        return ApiResult.ok((Object)result);
    }

    public TestController(CacheTest cacheTest, ItmItemBusinessService itmItemBusinessService, Environment environment, ItmItemCateCacheManager itmItemCateCacheManager, SysUdcService sysUdcService) {
        this.cacheTest = cacheTest;
        this.itmItemBusinessService = itmItemBusinessService;
        this.environment = environment;
        this.itmItemCateCacheManager = itmItemCateCacheManager;
        this.sysUdcService = sysUdcService;
    }
}

