/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.cpcnt.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.cpcnt.repo.CPCNTAttachRepoProc;
import com.elitesland.yst.supportdomain.cpcnt.repo.CPCNTIncomingPartsRepoProc;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTIncomingPartsService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTxCodeService;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCN2734ParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTAttachInfoParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTAttachInfoRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTIncomingPartsAndAttachRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTQueryParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.ResponseBodyRespVO;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="CPCNTIncomingPartsService")
public class CPCNTIncomingPartsServiceImpl
implements CPCNTIncomingPartsService {
    private static final Logger log = LoggerFactory.getLogger(CPCNTIncomingPartsServiceImpl.class);
    private final CPCNTIncomingPartsRepoProc cpcntIncomingPartsRepoProc;
    private final CPCNTAttachRepoProc cpcntAttachRepoProc;
    private final CPCNTxCodeService cpcnTxCodeService;

    @Override
    public List<CPCNTIncomingPartsAndAttachRespVO> bindingBankCard(CPCN2734ParamVO param) {
        if (StringUtils.isEmpty((Object)param.getUserId())) {
            throw new BusinessException(ApiCode.FAIL, "\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JPAQuery<CPCNTIncomingPartsAndAttachRespVO> cpcntIncomingPartsAndAttachRespVOJPAQuery = this.cpcntIncomingPartsRepoProc.selectAttachAndIncomingParts(param);
        List fetch = cpcntIncomingPartsAndAttachRespVOJPAQuery.fetch();
        List<String> collect = fetch.stream().map(CPCNTIncomingPartsAndAttachRespVO::getBindingTxSn2734).collect(Collectors.toList());
        CPCNTAttachInfoParamVO cpcntAttachInfoParamVO = new CPCNTAttachInfoParamVO();
        cpcntAttachInfoParamVO.setBindingTxSn2734List(collect);
        JPAQuery<CPCNTAttachInfoRespVO> cpcntAttachInfoRespVOJPAQuery = this.cpcntAttachRepoProc.selectH(cpcntAttachInfoParamVO);
        fetch.stream().forEach(v -> {
            CPCNTQueryParamVO cpcntQueryParamVO = new CPCNTQueryParamVO();
            cpcntQueryParamVO.setApplyNo(v.getBindingTxSn2734());
            cpcntQueryParamVO.setInstitutionID(param.getInstitutionID());
            ResponseBodyRespVO data = (ResponseBodyRespVO)this.cpcnTxCodeService.merchantsPiecesResult(cpcntQueryParamVO).getData();
            v.setResponsePlainText(data.getResponsePlainText());
            v.setStatus(data.getStatus());
            v.setMerchantID(data.getMerchantID());
            v.setMsg(data.getMsg());
            List<CPCNTAttachInfoRespVO> attacfList = cpcntAttachInfoRespVOJPAQuery.fetch().stream().filter(m -> v.getBindingTxSn2734().equals(m.getBindingTxSn2734())).collect(Collectors.toList());
            v.setCPCNTAttachInfoRespVOList(attacfList);
            if (!StringUtils.isEmpty((Object)v.getPayWay()) && "10".equals(v.getPayWay())) {
                v.setCategoryWechat(v.getCategory());
            } else if (!StringUtils.isEmpty((Object)v.getPayWay()) && "20".equals(v.getPayWay())) {
                v.setCategoryAlipay(v.getCategory());
            } else if (!StringUtils.isEmpty((Object)v.getPayWay()) && "40".equals(v.getPayWay())) {
                v.setCategoryUnionpay(v.getCategory());
            } else {
                throw new BusinessException(ApiCode.FAIL, "\u652f\u4ed8\u65b9\u5f0f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            }
        });
        return fetch;
    }

    public CPCNTIncomingPartsServiceImpl(CPCNTIncomingPartsRepoProc cpcntIncomingPartsRepoProc, CPCNTAttachRepoProc cpcntAttachRepoProc, CPCNTxCodeService cpcnTxCodeService) {
        this.cpcntIncomingPartsRepoProc = cpcntIncomingPartsRepoProc;
        this.cpcntAttachRepoProc = cpcntAttachRepoProc;
        this.cpcnTxCodeService = cpcnTxCodeService;
    }
}

