/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.cpcnt.service.impl;

import com.elitesland.external.cpcn.core.param.ImageInfoParam;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.cpcnt.entity.QCPCNTRequestDO;
import com.elitesland.yst.supportdomain.cpcnt.repo.CPCNTRequestRepoProc;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTAttchService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTBankService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTCategoryService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTDistrictService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTImageService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTIndustryService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTIndustryTypeService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTMerchanService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTProvinceService;
import com.elitesland.yst.supportdomain.cpcnt.service.CPCNTRequestService;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTAttachInfoParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTAttachInfoRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTBankParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTBankRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTCategoryParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTCategoryRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTDistrictParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTDistrictRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTImageParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTImageRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTIndustryParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTIndustryRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTIndustryTypeParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTIndustryTypeRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTMerchantParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTProvinceParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTProvinceRespVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTRequestParamVO;
import com.elitesland.yst.supportdomain.cpcnt.vo.CPCNTRequestRespVO;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="CPCNTRequestService")
public class CPCNTRequestServiceImpl
implements CPCNTRequestService {
    private static final Logger log = LoggerFactory.getLogger(CPCNTRequestServiceImpl.class);
    private final CPCNTRequestRepoProc cpcntRequestRepoProc;
    private final CPCNTAttchService cpcntAttchService;
    private final CPCNTBankService cpcntBankService;
    private final CPCNTCategoryService cpcntCategoryService;
    private final CPCNTDistrictService cpcntDistrictService;
    private final CPCNTIndustryService cpcntIndustryService;
    private final CPCNTIndustryTypeService cpcntIndustryTypeService;
    private final CPCNTMerchanService cpcntMerchanService;
    private final CPCNTProvinceService cpcntProvinceService;
    private final CPCNTImageService cpcntImageService;

    @Override
    public PagingVO<CPCNTRequestRespVO> bindingBankCard(CPCNTRequestParamVO cpcntRequestParamVO) {
        JPAQuery<CPCNTRequestRespVO> cpcntRequestRespVOJPAQuery = this.cpcntRequestRepoProc.selectH(cpcntRequestParamVO);
        long dataCount = cpcntRequestRespVOJPAQuery.fetchCount();
        List fetch = cpcntRequestRespVOJPAQuery.fetch();
        cpcntRequestParamVO.fillOrders(cpcntRequestRespVOJPAQuery, QCPCNTRequestDO.cPCNTRequestDO);
        cpcntRequestParamVO.setPaging(cpcntRequestRespVOJPAQuery);
        List<CPCNTRequestRespVO> query = this.query(fetch);
        return PagingVO.builder().total(Long.valueOf(dataCount)).records(query).build();
    }

    @Override
    public ApiResult<String> updateRequest(CPCNTRequestParamVO param) {
        if (StringUtils.isEmpty((Object)param.getId())) {
            throw new BusinessException(ApiCode.FAIL, "id\u4e3a\u7a7a");
        }
        this.cpcntRequestRepoProc.updateStatusById(param.getId(), 1);
        return ApiResult.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    public List<CPCNTRequestRespVO> query(List<CPCNTRequestRespVO> fetch) {
        if (CollectionUtils.isEmpty(fetch)) {
            return new ArrayList<CPCNTRequestRespVO>();
        }
        CPCNTAttachInfoParamVO cpcntAttachInfoParamVO = new CPCNTAttachInfoParamVO();
        CPCNTBankParamVO cpcntBankParamVO = new CPCNTBankParamVO();
        CPCNTCategoryParamVO cpcntCategoryParamVO = new CPCNTCategoryParamVO();
        CPCNTDistrictParamVO cpcntDistrictParamVO = new CPCNTDistrictParamVO();
        CPCNTIndustryParamVO cpcntIndustryParamVO = new CPCNTIndustryParamVO();
        CPCNTIndustryTypeParamVO cpcntIndustryTypeParamVO = new CPCNTIndustryTypeParamVO();
        CPCNTProvinceParamVO cpcntProvinceParamVO = new CPCNTProvinceParamVO();
        CPCNTImageParamVO CPCNTImageParamVO2 = new CPCNTImageParamVO();
        CPCNTMerchantParamVO cpcntMerchantParamVO = new CPCNTMerchantParamVO();
        List<String> userIdList = fetch.stream().map(CPCNTRequestRespVO::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
        cpcntAttachInfoParamVO.setRelateUserIdList(userIdList);
        List<CPCNTAttachInfoRespVO> cpcntAttachInfoRespVOS = this.cpcntAttchService.bindingBankCard(cpcntAttachInfoParamVO);
        List<String> bandIdList = fetch.stream().map(CPCNTRequestRespVO::getBankId).filter(Objects::nonNull).collect(Collectors.toList());
        cpcntBankParamVO.setBankIdList(bandIdList);
        List<CPCNTBankRespVO> cpcntBankRespVOS = this.cpcntBankService.bindingBankCard(cpcntBankParamVO);
        List<String> cateforyList = fetch.stream().map(CPCNTRequestRespVO::getCategory).filter(Objects::nonNull).collect(Collectors.toList());
        cpcntCategoryParamVO.setCategoryIdList(cateforyList);
        List<CPCNTCategoryRespVO> cpcntCategoryRespVOS = this.cpcntCategoryService.bindingBankCard(cpcntCategoryParamVO);
        List<String> districtList = fetch.stream().map(CPCNTRequestRespVO::getDistrict).filter(Objects::nonNull).collect(Collectors.toList());
        List cityList = fetch.stream().map(CPCNTRequestRespVO::getCity).filter(Objects::nonNull).collect(Collectors.toList());
        districtList.addAll(cityList);
        cpcntDistrictParamVO.setDistrictIdList(districtList);
        List<CPCNTDistrictRespVO> cpcntDistrictRespVOS = this.cpcntDistrictService.bindingBankCard(cpcntDistrictParamVO);
        List<String> industryList = fetch.stream().map(CPCNTRequestRespVO::getIndustry).filter(Objects::nonNull).collect(Collectors.toList());
        cpcntIndustryParamVO.setIndustryIdList(industryList);
        List<CPCNTIndustryRespVO> cpcntIndustryRespVOS = this.cpcntIndustryService.bindingBankCard(cpcntIndustryParamVO);
        List<String> industryTypeList = fetch.stream().map(CPCNTRequestRespVO::getIndustryBelongType).filter(Objects::nonNull).collect(Collectors.toList());
        cpcntIndustryTypeParamVO.setIndustryTypeIdList(industryTypeList);
        List<CPCNTIndustryTypeRespVO> cpcntIndustryTypeRespVOS = this.cpcntIndustryTypeService.bindingBankCard(cpcntIndustryTypeParamVO);
        List<String> provinceList = fetch.stream().map(CPCNTRequestRespVO::getProvince).filter(Objects::nonNull).collect(Collectors.toList());
        cpcntProvinceParamVO.setProvinceIdList(provinceList);
        List<CPCNTProvinceRespVO> cpcntProvinceRespVOS = this.cpcntProvinceService.bindingBankCard(cpcntProvinceParamVO);
        CPCNTImageParamVO2.setRelateUserIdList(userIdList);
        List<CPCNTImageRespVO> cpcntImageRespVOS = this.cpcntImageService.bindingBankCard(CPCNTImageParamVO2);
        fetch.stream().forEach(t -> {
            ArrayList<ImageInfoParam> imageInfoList = new ArrayList<ImageInfoParam>();
            ArrayList<CPCNTAttachInfoParamVO> CPCNTAttachList = new ArrayList<CPCNTAttachInfoParamVO>();
            cpcntAttachInfoRespVOS.stream().filter(request -> request.getRelateUserId().equals(t.getUserId())).forEach(result -> {
                CPCNTAttachInfoParamVO cpcntAttachInfoParamVO1 = new CPCNTAttachInfoParamVO();
                cpcntAttachInfoParamVO1.setPayType(result.getPayType());
                cpcntAttachInfoParamVO1.setAppId(result.getAppId());
                cpcntAttachInfoParamVO1.setAuthPath(result.getAuthPath());
                CPCNTAttachList.add(cpcntAttachInfoParamVO1);
            });
            t.setCPCNTAttachInfoList(CPCNTAttachList);
            cpcntBankRespVOS.stream().filter(request -> request.getBankId().equals(t.getBankId())).findAny().ifPresent(result -> t.setBankName(result.getBankName()));
            cpcntDistrictRespVOS.stream().filter(request -> request.getDistrictId().equals(t.getDistrict())).findAny().ifPresent(result -> t.setDistrictName(result.getDistrictName()));
            cpcntDistrictRespVOS.stream().filter(request -> request.getDistrictId().equals(t.getCity())).findAny().ifPresent(result -> t.setCityName(result.getDistrictName()));
            cpcntCategoryRespVOS.stream().filter(request -> request.getCategoryId().equals(t.getCategory())).findAny().ifPresent(result -> t.setCategoryName(result.getCategoryName()));
            cpcntCategoryRespVOS.stream().filter(request -> request.getCategoryId().equals(t.getCategory())).findAny().ifPresent(result -> t.setCategoryName(result.getCategoryName()));
            cpcntIndustryRespVOS.stream().filter(request -> request.getIndustryId().equals(t.getInstitutionId())).findAny().ifPresent(result -> t.setIndustryName(result.getIndustryName()));
            cpcntIndustryTypeRespVOS.stream().filter(request -> request.getIndustryTypeId().equals(t.getIndustryBelongType())).findAny().ifPresent(result -> t.setIndustryBelongTypeName(result.getIndustryTypeName()));
            cpcntProvinceRespVOS.stream().filter(request -> request.getProvinceId().equals(t.getProvince())).findAny().ifPresent(result -> t.setProvinceName(result.getProvinceName()));
            cpcntImageRespVOS.stream().filter(request -> request.getRelateUserId().equals(t.getUserId())).forEach(result -> {
                ImageInfoParam imageInfoParam = new ImageInfoParam();
                imageInfoParam.setImageType(result.getImageType());
                imageInfoParam.setImageInfo(result.getImageInfo());
                imageInfoParam.setImageContent(result.getImageContent());
                imageInfoList.add(imageInfoParam);
            });
            t.setImageInfoParamsList(imageInfoList);
        });
        return fetch;
    }

    public CPCNTRequestServiceImpl(CPCNTRequestRepoProc cpcntRequestRepoProc, CPCNTAttchService cpcntAttchService, CPCNTBankService cpcntBankService, CPCNTCategoryService cpcntCategoryService, CPCNTDistrictService cpcntDistrictService, CPCNTIndustryService cpcntIndustryService, CPCNTIndustryTypeService cpcntIndustryTypeService, CPCNTMerchanService cpcntMerchanService, CPCNTProvinceService cpcntProvinceService, CPCNTImageService cpcntImageService) {
        this.cpcntRequestRepoProc = cpcntRequestRepoProc;
        this.cpcntAttchService = cpcntAttchService;
        this.cpcntBankService = cpcntBankService;
        this.cpcntCategoryService = cpcntCategoryService;
        this.cpcntDistrictService = cpcntDistrictService;
        this.cpcntIndustryService = cpcntIndustryService;
        this.cpcntIndustryTypeService = cpcntIndustryTypeService;
        this.cpcntMerchanService = cpcntMerchanService;
        this.cpcntProvinceService = cpcntProvinceService;
        this.cpcntImageService = cpcntImageService;
    }
}

