/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyPagingParam;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyByDocNoVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyPagingVO;
import com.elitesland.yst.supportdomain.org.entity.QOrgOuDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemApplyAlterRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemApplyAlterDO itmApply = QItmItemApplyAlterDO.itmItemApplyAlterDO;
    private final QOrgOuDO orgBu = QOrgOuDO.orgOuDO;

    public PagingVO<ItmItemApplyPagingVO> searchPagingList(ItmItemApplyPagingParam param) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getDocNo())) {
            predicates.add(this.itmApply.docNo.eq((Object)param.getDocNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getDocType())) {
            predicates.add(this.itmApply.docType.eq((Object)param.getDocType()));
        }
        if (null != param.getApplyDateFrom()) {
            predicates.add(this.itmApply.applyDate.gt((Comparable)param.getApplyDateFrom()));
        }
        if (null != param.getApplyDateTo()) {
            predicates.add(this.itmApply.applyDate.lt((Comparable)param.getApplyDateTo()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getDocStatus())) {
            predicates.add(this.itmApply.docStatus.eq((Object)param.getDocStatus()));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyPagingVO.class, (Expression[])new Expression[]{this.itmApply.docNo, this.itmApply.docType, this.itmApply.docStatus, this.itmApply.creator, this.itmApply.applyDesc, this.orgBu.ouName.as("creatorOuName"), this.itmApply.createTime})).from((EntityPath)this.itmApply)).leftJoin((EntityPath)this.orgBu)).on((Predicate)this.itmApply.ouId.eq(this.orgBu.id));
        predicates.add(this.itmApply.deleteFlag.isNull().or((Predicate)this.itmApply.deleteFlag.eq((Object)0)));
        predicates.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.itmApply.getMetadata()));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmApply);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmItemApplyByDocNoVO findItemApplyDetailByDocNo(String docNo) {
        return (ItmItemApplyByDocNoVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyByDocNoVO.class, (Expression[])new Expression[]{this.itmApply.docNo, this.itmApply.docType, this.itmApply.docStatus, this.itmApply.applyDesc, this.itmApply.procInstId, this.itmApply.procInstStatus, this.itmApply.submitTime, this.itmApply.approvedTime, this.itmApply.applyUserId, this.itmApply.creator, this.itmApply.createUserId, this.itmApply.applyEmpId})).from((EntityPath)this.itmApply)).where((Predicate)this.itmApply.docNo.eq((Object)docNo))).fetchOne();
    }

    public ItmItemApplyAlterDO findItemApplyAlterByDocNo(String docNo) {
        return (ItmItemApplyAlterDO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.itmApply).from((EntityPath)this.itmApply)).where((Predicate)this.itmApply.docNo.eq((Object)docNo))).fetchOne();
    }

    public void itmItemApplyChange(String docNo, String docStatus) {
        this.jpaQueryFactory.update((EntityPath)this.itmApply).set((Path)this.itmApply.docStatus, (Object)docStatus).where(new Predicate[]{this.itmApply.docNo.eq((Object)docNo)}).execute();
    }

    public void itmItemApplyChangeDesc(String docNo, String applyDesc) {
        this.jpaQueryFactory.update((EntityPath)this.itmApply).set((Path)this.itmApply.applyDesc, (Object)applyDesc).where(new Predicate[]{this.itmApply.docNo.eq((Object)docNo)}).execute();
    }

    public ItmItemApplyAlterRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

