/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.repo;

import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyPropDO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyPropVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemApplyPropRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemApplyPropDO itemProp = QItmItemApplyPropDO.itmItemApplyPropDO;

    public List<ItmItemApplyPropVO> findVosByItemId(Long itemId, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != itemId) {
            predicates.add(this.itemProp.itemId.eq((Object)itemId));
        }
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemProp.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemProp.deleteFlag.isNull().or((Predicate)this.itemProp.deleteFlag.eq((Object)0)));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyPropVO.class, (Expression[])new Expression[]{this.itemProp.id, this.itemProp.itemId, this.itemProp.catePropCode, this.itemProp.catePropName, this.itemProp.catePropType, this.itemProp.propValue})).from((EntityPath)this.itemProp)).where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<ItmItemApplyPropVO> findVosByItemId(List<Long> itemId, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.itemProp.itemId.in(itemId));
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemProp.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemProp.deleteFlag.isNull().or((Predicate)this.itemProp.deleteFlag.eq((Object)0)));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyPropVO.class, (Expression[])new Expression[]{this.itemProp.itemId, this.itemProp.catePropCode, this.itemProp.catePropName, this.itemProp.catePropType, this.itemProp.propValue, this.itemProp.createTime, this.itemProp.createUserId, this.itemProp.creator, this.itemProp.modifyTime, this.itemProp.modifyUserId, this.itemProp.updater})).from((EntityPath)this.itemProp)).where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public boolean existsByCatePropCodeAndItemNotDelete(String catePropCode) {
        QItmItemApplyDO itmItem = QItmItemApplyDO.itmItemApplyDO;
        long count = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.itemProp).innerJoin((EntityPath)itmItem)).on((Predicate)itmItem.id.eq(this.itemProp.itemId).and((Predicate)itmItem.deleteFlag.isNull().or((Predicate)itmItem.deleteFlag.eq((Object)0))))).where((Predicate)this.itemProp.catePropCode.eq((Object)catePropCode))).fetchCount();
        return count > 0L;
    }

    public void addDocNoBySpuId(List<Long> spuIds, String docNo) {
        this.jpaQueryFactory.update((EntityPath)this.itemProp).set((Path)this.itemProp.docNo, (Object)docNo).where(new Predicate[]{this.itemProp.itemId.in(spuIds)}).execute();
    }

    public void deleteDocNoBySpuId(List<Long> spuIds) {
        this.jpaQueryFactory.update((EntityPath)this.itemProp).setNull((Path)this.itemProp.docNo).where(new Predicate[]{this.itemProp.itemId.in(spuIds)}).execute();
    }

    public ItmItemApplyPropRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

