/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.repo;

import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyTagDO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyTagVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemApplyTagRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemApplyTagDO itemTag = QItmItemApplyTagDO.itmItemApplyTagDO;

    public List<ItmItemApplyTagVO> searchVoByItemIds(List<Long> itemIds, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            predicates.add(this.itemTag.itemId.in(itemIds));
        }
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemTag.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemTag.deleteFlag.isNull().or((Predicate)this.itemTag.deleteFlag.eq((Object)0)));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyTagVO.class, (Expression[])new Expression[]{this.itemTag.id, this.itemTag.itemId, this.itemTag.tagCode, this.itemTag.tagName})).from((EntityPath)this.itemTag)).where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<ItmItemApplyTagVO> searchVoByItemIdsComplete(List<Long> itemIds, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            predicates.add(this.itemTag.itemId.in(itemIds));
        }
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemTag.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemTag.deleteFlag.isNull().or((Predicate)this.itemTag.deleteFlag.eq((Object)0)));
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyTagVO.class, (Expression[])new Expression[]{this.itemTag.itemId, this.itemTag.tagCode, this.itemTag.tagName, this.itemTag.createTime, this.itemTag.createUserId, this.itemTag.creator, this.itemTag.modifyTime, this.itemTag.modifyUserId, this.itemTag.updater})).from((EntityPath)this.itemTag)).where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public boolean existsByTagCodeAndItemNotDelete(String tagCode) {
        QItmItemApplyDO item = QItmItemApplyDO.itmItemApplyDO;
        long count = ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.from((EntityPath)this.itemTag).innerJoin((EntityPath)item)).on((Predicate)item.id.eq(this.itemTag.itemId).and((Predicate)item.deleteFlag.isNull().or((Predicate)item.deleteFlag.eq((Object)0))))).where((Predicate)this.itemTag.tagCode.eq((Object)tagCode))).fetchCount();
        return count > 0L;
    }

    public void addDocNoByItemId(List<Long> itemIds, String docNo) {
        this.jpaQueryFactory.update((EntityPath)this.itemTag).set((Path)this.itemTag.docNo, (Object)docNo).where(new Predicate[]{this.itemTag.itemId.in(itemIds)}).execute();
    }

    public void deleteDocNoByItemId(List<Long> itemIds) {
        this.jpaQueryFactory.update((EntityPath)this.itemTag).setNull((Path)this.itemTag.docNo).where(new Predicate[]{this.itemTag.itemId.in(itemIds)}).execute();
    }

    public ItmItemApplyTagRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

