/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.repo;

import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyAttachmentDO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyAttachmentVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmSkuApplyImageVO;
import com.elitesland.yst.supportdomain.util.ItmItemAttachmenTypeEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemAttachApplymentRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemApplyAttachmentDO itemAttachment = QItmItemApplyAttachmentDO.itmItemApplyAttachmentDO;
    private final QBean<ItmItemApplyAttachmentVO> itemAttachmentVO;

    public List<ItmSkuApplyImageVO> findSkuImgByItemIds(List<Long> itemIds, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(itemIds)) {
            predicates.add(this.itemAttachment.itemId.in(itemIds));
        }
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemAttachment.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemAttachment.fileType.eq((Object)ItmItemAttachmenTypeEnum.IMG.name()).and((Predicate)this.itemAttachment.deleteFlag.isNull().or((Predicate)this.itemAttachment.deleteFlag.eq((Object)0))));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmSkuApplyImageVO.class, (Expression[])new Expression[]{this.itemAttachment.itemId, this.itemAttachment.fileCode, this.itemAttachment.fileName})).from((EntityPath)this.itemAttachment)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<ItmItemApplyAttachmentVO> findItemImagesByItemIdAndFileType(Long itemId, String fileType, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (null != itemId) {
            predicates.add(this.itemAttachment.itemId.eq((Object)itemId));
        }
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemAttachment.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemAttachment.fileType.eq((Object)fileType));
        predicates.add(this.itemAttachment.deleteFlag.isNull().or((Predicate)this.itemAttachment.deleteFlag.eq((Object)0)));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itemAttachmentVO).from((EntityPath)this.itemAttachment)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<ItmItemApplyAttachmentVO> findItemImagesByItemIdAndFileType(List<Long> itemId, String docNo) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(this.itemAttachment.itemId.in(itemId));
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            predicates.add(this.itemAttachment.docNo.eq((Object)docNo));
        }
        predicates.add(this.itemAttachment.deleteFlag.isNull().or((Predicate)this.itemAttachment.deleteFlag.eq((Object)0)));
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemApplyAttachmentVO.class, (Expression[])new Expression[]{this.itemAttachment.itemId, this.itemAttachment.fileName, this.itemAttachment.fileCode, this.itemAttachment.imgSize, this.itemAttachment.fileSize, this.itemAttachment.fileType, this.itemAttachment.major, this.itemAttachment.url, this.itemAttachment.createTime, this.itemAttachment.createUserId, this.itemAttachment.creator, this.itemAttachment.modifyTime, this.itemAttachment.modifyUserId, this.itemAttachment.updater})).from((EntityPath)this.itemAttachment)).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public void addDocNoById(List<Long> ids, String docNo) {
        this.jpaQueryFactory.update((EntityPath)this.itemAttachment).set((Path)this.itemAttachment.docNo, (Object)docNo).where(new Predicate[]{this.itemAttachment.itemId.in(ids)}).execute();
    }

    public void deleteDocNoById(List<Long> ids) {
        this.jpaQueryFactory.update((EntityPath)this.itemAttachment).setNull((Path)this.itemAttachment.docNo).where(new Predicate[]{this.itemAttachment.itemId.in(ids)}).execute();
    }

    public ItmItemAttachApplymentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.itemAttachmentVO = Projections.bean(ItmItemApplyAttachmentVO.class, (Expression[])new Expression[]{this.itemAttachment.id, this.itemAttachment.fileName, this.itemAttachment.fileCode, this.itemAttachment.imgSize, this.itemAttachment.fileSize, this.itemAttachment.fileType, this.itemAttachment.major, this.itemAttachment.url});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

