/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyAttachmentConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyDConvert;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyAttachmentSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyChangeParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyDetailsAddParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySaveRowParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySkuSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySpuSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyTagSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyUomConvSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmSkuApplyImageSaveParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItemItemChangeService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyAttachmentService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyCustPropService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyPropService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyQualifyService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyTagService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyUomConvService;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepoProc;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.util.GuaranteeConvUtil;
import com.elitesland.yst.supportdomain.util.ItmItemAttachmenTypeEnum;
import com.elitesland.yst.supportdomain.workflow.ProcDefKey;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ItemItemChangeServiceImpl
implements ItemItemChangeService {
    private static final Logger log = LoggerFactory.getLogger(ItemItemChangeServiceImpl.class);
    private static final String SKU_BAR_CODE = "SKU_BAR_CODE";
    private static final Integer ONE_INTEGER = 1;
    private static final Integer ZERO_INTEGER = 0;
    private final ItmItemApplyService itmItemApplyService;
    private final ItmItemApplyAttachmentService itmItemApplyAttachmentService;
    private final ItmItemApplyPropService itmItemApplyPropService;
    private final ItmItemApplyTagService itmItemApplyTagService;
    private final ItmItemApplyUomConvService itmItemApplyUomConvService;
    private final ItmItemApplyQualifyService itmItemApplyQualifyService;
    private final ItmItemApplyCustPropService itmItemApplyCustPropService;
    private final OrgBuRepo orgBuRepo;
    private final ItmItemApplyAlterRepo itmItemApplyAlterRepo;
    private final ItmItemApplyRepo itmItemApplyRepo;
    private final ItmItemApplyRepoProc itmItemApplyRepoProc;
    private final ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc;
    private final ItmItemRepoProc itmItemRepoProc;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private static final String SKU_NO = "SKU_NO";
    @DubboReference
    private WorkflowService workflowService;
    private final JPAQueryFactory jpaQueryFactory;
    private final PlatformTransactionManager platformTransactionManager;
    private final RedissonClient redissonClient;
    private final TransactionTemplate transactionTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itemChangeApplication(ItmItemApplyChangeParam param) {
        this.transactionTemplate.setPropagationBehavior(3);
        ItmItemApplyAlterDO execute = (ItmItemApplyAlterDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                return this.changApplication(param);
            }
            catch (Exception e) {
                log.error(" \u5546\u54c1\u53d8\u66f4\u7533\u8bf7error:", (Throwable)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
        if (ONE_INTEGER.equals(param.getExecuteType())) {
            assert (execute != null);
            this.workFlow(execute);
        }
    }

    private ItmItemApplyAlterDO changApplication(ItmItemApplyChangeParam param) {
        if (StringUtils.isBlank((CharSequence)param.getDocNo())) {
            throw new BusinessException("\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)param.getDocType())) {
            throw new BusinessException("\u7533\u8bf7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String docNoKey = param.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNoKey);
        ItmItemApplyAlterDO itemApplyAlterDO = null;
        try {
            if (!rLock.tryLock(0L, 20L, TimeUnit.SECONDS)) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25");
                throw new BusinessException("\u5355\u636e\u91cd\u590d\u63d0\u4ea4\uff1a:" + docNoKey);
            }
            Long checkSpuId = param.getChangeItemInfo().getSpuId();
            List<Long> longs = this.itmItemRepoProc.checkIsThreeItem(Collections.singletonList(checkSpuId));
            if (CollectionUtils.isNotEmpty(longs)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7b2c\u4e09\u65b9\u5165\u9a7b\u5546\u54c1\u4e0d\u80fd\u53d8\u66f4");
            }
            Long spuId = param.getChangeItemInfo().getSpuId();
            String docNo = param.getDocNo();
            ItmItemApplySaveRowParam applySaveRowParam = new ItmItemApplySaveRowParam();
            if (this.itmItemApplyAlterRepo.existsByDocNo(docNo)) {
                try {
                    Optional<ItmItemApplyAlterDO> byDocNo = this.itmItemApplyAlterRepo.findByDocNo(docNo);
                    if (!byDocNo.isPresent()) {
                        throw new BusinessException("\u5355\u636e\u4fe1\u606f\u4e0d\u5b58\u5728");
                    }
                    itemApplyAlterDO = byDocNo.get();
                    if (ONE_INTEGER.equals(param.getExecuteType())) {
                        this.itmItemApplyAlterRepoProc.itmItemApplyChange(docNo, ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                        this.itmItemApplyAlterRepoProc.itmItemApplyChangeDesc(docNo, param.getApplyDesc());
                        String itemApplyStatus = ItmUdcEnum.ITM_ITEM_APPLY_STATUS_APPROVING.getUdcVal();
                        applySaveRowParam.setDocStatus(ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                        this.saveOrUpdateItemChange(param.getChangeItemInfo(), param.getDocNo(), param.getDocType(), itemApplyStatus);
                        this.workFlow(itemApplyAlterDO);
                    }
                    if (ZERO_INTEGER.equals(param.getExecuteType())) {
                        this.itmItemApplyAlterRepoProc.itmItemApplyChange(param.getDocNo(), ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
                        this.itmItemApplyAlterRepoProc.itmItemApplyChangeDesc(param.getDocNo(), param.getApplyDesc());
                        String itemApplyStatus = ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal();
                        applySaveRowParam.setDocStatus(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
                        this.saveOrUpdateItemChange(param.getChangeItemInfo(), param.getDocNo(), param.getDocType(), itemApplyStatus);
                    }
                    throw new BusinessException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b:" + param.getExecuteType());
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58/\u63d0\u4ea4\u5355\u636e\u5931\u8d25\uff1a" + e);
                    throw new BusinessException("\u4fdd\u5b58/\u63d0\u4ea4\u5355\u636e\u5931\u8d25\uff1a" + e);
                }
            } else {
                List<String> docStatusBySpuId = this.itmItemApplyRepoProc.findDocStatusBySpuId(spuId);
                if (docStatusBySpuId.contains(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal()) || docStatusBySpuId.contains(ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal()) || docStatusBySpuId.contains(ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal())) {
                    throw new BusinessException("\u8be5\u5546\u54c1\u5df2\u5728\u5546\u54c1\u53d8\u66f4\u5ba1\u6838\u6d41\u7a0b\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
                }
                ItmItemApplyDetailsAddParam itmItemApplyDetailsAddParam = new ItmItemApplyDetailsAddParam();
                applySaveRowParam.setDocNo(param.getDocNo());
                applySaveRowParam.setDocType(param.getDocType());
                applySaveRowParam.setApplyDesc(param.getApplyDesc());
                applySaveRowParam.setDocStatus(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
                if (ONE_INTEGER.equals(param.getExecuteType())) {
                    try {
                        itemApplyAlterDO = this.itmItemApplyService.saveAndUpdateRow(applySaveRowParam);
                    }
                    catch (Exception e) {
                        log.error("\u65b0\u589e\u5355\u636e\u5931\u8d25\uff1a" + e);
                        throw new BusinessException("\u65b0\u589e\u5355\u636e\u5931\u8d25\uff1a" + e);
                    }
                    try {
                        this.itmItemApplyAlterRepoProc.itmItemApplyChange(itemApplyAlterDO.getDocNo(), ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                        itmItemApplyDetailsAddParam.setItemApplyStatus(ItmUdcEnum.ITM_ITEM_APPLY_STATUS_APPROVING.getUdcVal());
                        this.saveOrUpdateItemChange(param.getChangeItemInfo(), param.getDocNo(), param.getDocType(), itmItemApplyDetailsAddParam.getItemApplyStatus());
                    }
                    catch (Exception e) {
                        log.error("\u65b0\u589e\u5355\u636e\u5931\u8d25\uff1a" + e);
                        throw new BusinessException("\u65b0\u589e\u5355\u636e\u5931\u8d25\uff1a" + e);
                    }
                }
                if (ZERO_INTEGER.equals(param.getExecuteType())) {
                    try {
                        applySaveRowParam.setDocStatus(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
                        itmItemApplyDetailsAddParam.setItemApplyStatus(ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal());
                        this.itmItemApplyService.saveAndUpdateRow(applySaveRowParam);
                        this.saveOrUpdateItemChange(param.getChangeItemInfo(), param.getDocNo(), param.getDocType(), itmItemApplyDetailsAddParam.getItemApplyStatus());
                    }
                    catch (Exception e) {
                        log.error("\u4fdd\u5b58\u5355\u636e\u5931\u8d25\uff1a" + e);
                        throw new BusinessException("\u4fdd\u5b58\u5355\u636e\u5931\u8d25\uff1a" + e);
                    }
                } else {
                    throw new BusinessException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b:" + param.getExecuteType());
                }
            }
            if (!rLock.isHeldByCurrentThread()) {
                log.error("\u6301\u6709\u9501\u5df2\u8fc7\u671f");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6301\u6709\u9501\u5df2\u8fc7\u671f\uff01");
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("\u5355\u636e\u63d0\u4ea4/\u4fdd\u5b58\u5931\u8d25\uff1a" + (Exception)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return itemApplyAlterDO;
    }

    private void workFlow(ItmItemApplyAlterDO itemApplyAlterDO) {
        SysUserDTO user = null;
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        user = generalUserDetails.getUser();
        if (itemApplyAlterDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(itemApplyAlterDO.getProcInstStatus())) {
            String procInstName = "\u5546\u54c1\u4fe1\u606f\u53d8\u66f4\u5ba1\u6838-" + itemApplyAlterDO.getDocNo();
            ProcessInfo processInfo = this.workflowService.startProcess(ProcDefKey.ITEM_INFO_CHANGE.name(), procInstName, itemApplyAlterDO.getDocNo(), null);
            QItmItemApplyAlterDO qItmItemApplyAlterDO = QItmItemApplyAlterDO.itmItemApplyAlterDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qItmItemApplyAlterDO).set((Path)qItmItemApplyAlterDO.procInstId, (Object)processInfo.getProcInstId()).set(qItmItemApplyAlterDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qItmItemApplyAlterDO.id.eq((Object)itemApplyAlterDO.getId())});
            if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qItmItemApplyAlterDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
            }
            jpaUpdateClause.execute();
        }
    }

    private List<ItmItemApplyAttachmentSaveParam> mergeAttachSaveParams(List<ItmItemApplyAttachmentSaveParam> spuImages, List<ItmItemApplyAttachmentSaveParam> spuVideos) {
        if (CollectionUtils.isNotEmpty(spuImages) && CollectionUtils.isNotEmpty(spuVideos)) {
            spuImages.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.IMG.name()));
            spuVideos.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.VIDEO.name()));
            spuImages.addAll(spuVideos);
            return spuImages;
        }
        if (CollectionUtils.isNotEmpty(spuImages)) {
            spuImages.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.IMG.name()));
            return spuImages;
        }
        if (CollectionUtils.isNotEmpty(spuVideos)) {
            spuVideos.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.VIDEO.name()));
            return spuVideos;
        }
        return Collections.emptyList();
    }

    private void saveOrUpdateItemChange(ItmItemApplySpuSaveParam param, String docNo, String docType, String itemApplyStatus) {
        if (CollectionUtils.isEmpty(param.getItemSkuSaveParams())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SKU\u4fe1\u606f\u81f3\u5c11\u8981\u6709\u4e00\u6761");
        }
        List<ItmItemApplySkuSaveParam> skuSaveParams = param.getItemSkuSaveParams();
        boolean existsBySpuIdAndDocNo = this.itmItemApplyRepo.existsBySpuIdAndDocNo(param.getSpuId(), docNo);
        if (existsBySpuIdAndDocNo) {
            this.itmSpuUpdateApply(param, docNo, itemApplyStatus);
        } else {
            this.itmSpuInsert(param, skuSaveParams, docNo, docType, itemApplyStatus);
        }
        List<ItmItemApplyAttachmentSaveParam> itmAttachmentSaveParams = this.mergeAttachSaveParams(param.getSpuImages(), param.getSpuVideos());
        this.itmItemApplyAttachmentService.itemAttachmentsApplyHardSave(param.getSpuId(), itmAttachmentSaveParams, docNo);
        this.itmItemApplyPropService.itemPropsApplyHardSave(param.getSpuId(), param.getItemPropSaveParams(), docNo);
        this.itmItemApplyQualifyService.itemQualifyApplyHardSave(param.getSpuId(), param.getItemQualifySaveParams(), docNo);
        this.itmItemApplyCustPropService.itemCustPropApplyHardSave(param.getSpuId(), param.getItemCustPropSaveParams(), docNo);
    }

    private Long itmSpuInsert(ItmItemApplySpuSaveParam param, List<ItmItemApplySkuSaveParam> skuSaveParams, String docNo, String docType, String itemApplyStatus) {
        if (this.itmItemApplyRepo.existsBySpuNameAndSuppCodeAndItemCateCodeAndDocNo(param.getSpuName(), param.getSuppCode(), param.getItemCateCode(), docNo)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546','\u7533\u8bf7\u5355\u53f7'\u7684\u5546\u54c1");
        }
        List<ItmItemApplyDO> itmItemDos = ItmItemApplyDConvert.INSTANCE.skuSaveParamToDo(skuSaveParams);
        Long spuId = param.getSpuId();
        for (ItmItemApplyDO item : itmItemDos) {
            ItmItemApplyDConvert.INSTANCE.updateDoFromSpuSaveParam(param, item);
            item.setId(null);
            item.setItemStatus(itemApplyStatus);
            item.setDocNo(docNo);
            item.setDocType(ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal());
            Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
            if (!byBuCode.isPresent()) continue;
            Long ouId = byBuCode.get().getOuId();
            item.setSecOuId(ouId);
            item.setOuId(ouId);
        }
        this.itmItemApplyRepo.saveAll(itmItemDos);
        ArrayList<ItmSkuApplyImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuApplyImageSaveParam>();
        ArrayList<ItmItemApplyTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemApplyTagSaveParam>();
        ArrayList<ItmItemApplyUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemApplyUomConvSaveParam>();
        for (int i = 0; i < itmItemDos.size(); ++i) {
            List<ItmItemApplyUomConvSaveParam> convSaveParams;
            ItmItemApplySkuSaveParam skuSaveParam = skuSaveParams.get(i);
            ItmItemApplyDO item = itmItemDos.get(i);
            ItmSkuApplyImageSaveParam skuImage = ItmItemApplyAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(skuSaveParam);
            skuImage.setItemId(item.getId());
            skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
            skuImageSaveParams.add(skuImage);
            List<ItmItemApplyTagSaveParam> tagSaveParams = skuSaveParam.getItemSaveTags();
            if (!CollectionUtils.isEmpty(tagSaveParams)) {
                tagSaveParams.forEach(t -> t.setItemId(item.getId()));
                itemTagSaveParams.addAll(tagSaveParams);
            }
            if (CollectionUtils.isEmpty(convSaveParams = skuSaveParam.getItemUomConvSaveParams())) continue;
            convSaveParams.forEach(t -> t.setItemId(item.getId()));
            uomConvSaveParams.addAll(convSaveParams);
        }
        this.itmItemApplyAttachmentService.skuImgApplyHardSave(null, skuImageSaveParams, docNo);
        this.itmItemApplyTagService.itemTagApplyHardSave(null, itemTagSaveParams, docNo);
        this.itmItemApplyUomConvService.itemUomConvApplyHardSave(null, uomConvSaveParams, docNo);
        return spuId;
    }

    public void itmSpuUpdateApply(ItmItemApplySpuSaveParam param, String docNo, String itemApplyStatus) {
        List<ItmItemApplyUomConvSaveParam> convSaveParams;
        List<ItmItemApplyTagSaveParam> tagSaveParams;
        ItmSkuApplyImageSaveParam skuImage;
        List<ItmItemApplySkuSaveParam> skuSaveParams = param.getItemSkuSaveParams();
        if (CollectionUtils.isEmpty(param.getItemSkuSaveParams())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SKU\u4fe1\u606f\u81f3\u5c11\u8981\u6709\u4e00\u6761");
        }
        Long spuId = param.getSpuId();
        List<ItmItemApplyDO> itmItemDos = this.itmItemApplyRepo.findBySpuId(param.getSpuId());
        if (CollectionUtils.isEmpty(itmItemDos)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SPU\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        boolean isChange = ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal().equals(itmItemDos.get(0).getItemStatus());
        List existsIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        List updateSkuParams = skuSaveParams.stream().filter(skuSaveParam -> existsIds.contains(skuSaveParam.getId())).collect(Collectors.toList());
        List updateIds = updateSkuParams.stream().map(ItmItemApplySkuSaveParam::getId).collect(Collectors.toList());
        List insertSkuParams = skuSaveParams.stream().filter(skuSaveParam -> !updateIds.contains(skuSaveParam.getId())).peek(skuSaveParam -> skuSaveParam.setId(null)).collect(Collectors.toList());
        List deleteDos = itmItemDos.stream().filter(item -> !updateIds.contains(item.getId())).collect(Collectors.toList());
        ArrayList<ItmSkuApplyImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuApplyImageSaveParam>();
        ArrayList<ItmItemApplyTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemApplyTagSaveParam>();
        ArrayList<ItmItemApplyUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemApplyUomConvSaveParam>();
        if (!CollectionUtils.isEmpty(updateSkuParams)) {
            Map<Long, ItmItemApplyDO> updateDoMap = itmItemDos.stream().filter(item -> updateIds.contains(item.getId())).collect(Collectors.toMap(BaseModel::getId, t -> t));
            List updateDos = updateSkuParams.stream().map(skuSaveParam -> {
                ItmItemApplyDO updateDo = (ItmItemApplyDO)updateDoMap.get(skuSaveParam.getId());
                ItmItemApplyDConvert.INSTANCE.updateDoFromSpuSaveParam(param, updateDo);
                updateDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(updateDo.getGuaranteePeriod(), updateDo.getGuaranteePeriodUnit()));
                ItmItemApplyDConvert.INSTANCE.updateDoFromSkuSaveParam((ItmItemApplySkuSaveParam)skuSaveParam, updateDo);
                updateDo.setItemStatus(itemApplyStatus);
                Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
                if (byBuCode.isPresent()) {
                    Long ouId = byBuCode.get().getOuId();
                    updateDo.setSecOuId(ouId);
                    updateDo.setOuId(ouId);
                }
                updateDo.setDocNo(docNo);
                return updateDo;
            }).collect(Collectors.toList());
            this.itmItemApplyRepo.saveAll(updateDos);
            for (ItmItemApplySkuSaveParam updateSkuParam : updateSkuParams) {
                skuImage = ItmItemApplyAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(updateSkuParam);
                skuImage.setItemId(updateSkuParam.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                tagSaveParams = updateSkuParam.getItemSaveTags();
                if (!CollectionUtils.isEmpty(tagSaveParams)) {
                    tagSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = updateSkuParam.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(insertSkuParams)) {
            List insertDos = insertSkuParams.stream().map(insertSkuParam -> {
                ItmItemApplyDO insertDo = ItmItemApplyDConvert.INSTANCE.skuSaveParamToDo((ItmItemApplySkuSaveParam)insertSkuParam);
                ItmItemApplyDConvert.INSTANCE.updateDoFromSpuSaveParam(param, insertDo);
                insertDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(param.getGuaranteePeriod(), param.getGuaranteePeriodUnit()));
                String skuCode = this.sysNumberGeneratorWrapper.generate(SKU_NO, param.getSpuCode());
                if (this.itmItemApplyRepo.existsByItemCode(skuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SKU \u7f16\u53f7\uff1a" + skuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                }
                insertDo.setItemCode(skuCode);
                insertDo.setDocNo(docNo);
                insertDo.setItemStatus(itemApplyStatus);
                insertDo.setDocType(ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal());
                if (StringUtils.isBlank((CharSequence)insertSkuParam.getBarCode())) {
                    insertDo.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
                }
                if (isChange) {
                    insertDo.setItemStatus(ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal());
                } else {
                    insertDo.setItemStatus(ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal());
                }
                Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
                if (byBuCode.isPresent()) {
                    Long ouId = byBuCode.get().getOuId();
                    insertDo.setSecOuId(ouId);
                    insertDo.setOuId(ouId);
                }
                return insertDo;
            }).collect(Collectors.toList());
            this.itmItemApplyRepo.saveAll(insertDos);
            for (int i = 0; i < insertDos.size(); ++i) {
                ItmItemApplySkuSaveParam insertSkuParam2 = (ItmItemApplySkuSaveParam)insertSkuParams.get(i);
                ItmItemApplyDO item2 = (ItmItemApplyDO)insertDos.get(i);
                skuImage = ItmItemApplyAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(insertSkuParam2);
                skuImage.setItemId(item2.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                tagSaveParams = insertSkuParam2.getItemSaveTags();
                if (!CollectionUtils.isEmpty(tagSaveParams)) {
                    tagSaveParams.forEach(t -> t.setItemId(item2.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = insertSkuParam2.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(item2.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(deleteDos) && !isChange) {
            this.itmItemApplyRepo.deleteInBatch(deleteDos);
        }
        List<Long> itemIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.itmItemApplyAttachmentService.skuImgApplyHardSave(itemIds, skuImageSaveParams, docNo);
        this.itmItemApplyTagService.itemTagApplyHardSave(itemIds, itemTagSaveParams, docNo);
        this.itmItemApplyUomConvService.itemUomConvApplyHardSave(itemIds, uomConvSaveParams, docNo);
    }

    public ItemItemChangeServiceImpl(ItmItemApplyService itmItemApplyService, ItmItemApplyAttachmentService itmItemApplyAttachmentService, ItmItemApplyPropService itmItemApplyPropService, ItmItemApplyTagService itmItemApplyTagService, ItmItemApplyUomConvService itmItemApplyUomConvService, ItmItemApplyQualifyService itmItemApplyQualifyService, ItmItemApplyCustPropService itmItemApplyCustPropService, OrgBuRepo orgBuRepo, ItmItemApplyAlterRepo itmItemApplyAlterRepo, ItmItemApplyRepo itmItemApplyRepo, ItmItemApplyRepoProc itmItemApplyRepoProc, ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc, ItmItemRepoProc itmItemRepoProc, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, JPAQueryFactory jpaQueryFactory, PlatformTransactionManager platformTransactionManager, RedissonClient redissonClient, TransactionTemplate transactionTemplate) {
        this.itmItemApplyService = itmItemApplyService;
        this.itmItemApplyAttachmentService = itmItemApplyAttachmentService;
        this.itmItemApplyPropService = itmItemApplyPropService;
        this.itmItemApplyTagService = itmItemApplyTagService;
        this.itmItemApplyUomConvService = itmItemApplyUomConvService;
        this.itmItemApplyQualifyService = itmItemApplyQualifyService;
        this.itmItemApplyCustPropService = itmItemApplyCustPropService;
        this.orgBuRepo = orgBuRepo;
        this.itmItemApplyAlterRepo = itmItemApplyAlterRepo;
        this.itmItemApplyRepo = itmItemApplyRepo;
        this.itmItemApplyRepoProc = itmItemApplyRepoProc;
        this.itmItemApplyAlterRepoProc = itmItemApplyAlterRepoProc;
        this.itmItemRepoProc = itmItemRepoProc;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.jpaQueryFactory = jpaQueryFactory;
        this.platformTransactionManager = platformTransactionManager;
        this.redissonClient = redissonClient;
        this.transactionTemplate = transactionTemplate;
    }
}

