/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyDetailsAddParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySaveRowParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySubmitParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyCustPropRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyPropRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyQualifyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyTagRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyUomConvRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemAttachApplymentRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyApproveService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemUniqueVO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.workflow.ProcDefKey;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ItmItemApplyApproveServiceImpl
implements ItmItemApplyApproveService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemApplyApproveServiceImpl.class);
    private static final Integer SAVE = 0;
    private static final Integer COMMIT = 1;
    private final ItmItemApplyService itmItemApplyService;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemApplyRepoProc itmItemApplyRepoProc;
    private final ItmItemApplyCustPropRepoProc itmItemApplyCustPropRepoProc;
    private final ItmItemApplyPropRepoProc itmItemApplyPropRepoProc;
    private final ItmItemApplyQualifyRepoProc itmItemApplyQualifyRepoProc;
    private final ItmItemApplyTagRepoProc itmItemApplyTagRepoProc;
    private final ItmItemApplyUomConvRepoProc itmItemApplyUomConvRepoProc;
    private final ItmItemAttachApplymentRepoProc itmItemAttachApplymentRepoProc;
    private final ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc;
    @DubboReference
    private WorkflowService workflowService;
    private final JPAQueryFactory jpaQueryFactory;
    private final PlatformTransactionManager platformTransactionManager;
    private final RedissonClient redissonClient;
    private final TransactionTemplate transactionTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSubmitItem(ItmItemApplySubmitParam param) {
        this.transactionTemplate.setPropagationBehavior(3);
        ItmItemApplyAlterDO execute = (ItmItemApplyAlterDO)this.transactionTemplate.execute(transactionStatus -> {
            try {
                return this.updateItem(param);
            }
            catch (Exception e) {
                log.error(" \u5546\u54c1\u53d8\u66f4\u7533\u8bf7error:", (Throwable)e);
                transactionStatus.setRollbackOnly();
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
        if (COMMIT.equals(param.getExecuteType())) {
            assert (execute != null);
            this.workFlow(execute);
        }
    }

    private ItmItemApplyAlterDO updateItem(ItmItemApplySubmitParam param) {
        List<String> repeatDocNoItemBySpuIds = this.itmItemApplyRepoProc.findRepeatDocNoItemBySpuIds(param.getSpuIds());
        List isDocNo = repeatDocNoItemBySpuIds.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isDocNo)) {
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5df2\u7533\u8bf7\u8be5\u5546\u54c1\u5ba1\u6838");
        }
        this.isReapateItem(param.getSpuIds());
        ItmItemApplySaveRowParam itmItemApplySaveRowParam = new ItmItemApplySaveRowParam();
        itmItemApplySaveRowParam.setDocType(ItmUdcEnum.ITM_APPLY_TYPE_ITEM_NEWAPPLY.getUdcVal());
        itmItemApplySaveRowParam.setApplyDesc(param.getApplyDesc());
        itmItemApplySaveRowParam.setDocStatus(ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
        Integer executeType = param.getExecuteType();
        ItmItemApplyDetailsAddParam itmItemApplyDetailsAddParam = new ItmItemApplyDetailsAddParam();
        ItmItemApplyAlterDO itemApplyAlterDO = this.itmItemApplyService.saveAndUpdateRow(itmItemApplySaveRowParam);
        String docNo = itemApplyAlterDO.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNo);
        try {
            if (!rLock.tryLock(0L, 20L, TimeUnit.SECONDS)) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25");
                throw new BusinessException("\u5355\u636e\u91cd\u590d\u63d0\u4ea4\uff1a:" + docNo);
            }
            if (SAVE.equals(executeType)) {
                itmItemApplyDetailsAddParam.setItemApplyStatus(ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal());
                this.updateItemStatus(param, itmItemApplyDetailsAddParam, docNo);
            } else if (COMMIT.equals(executeType)) {
                this.itmItemApplyAlterRepoProc.itmItemApplyChange(itemApplyAlterDO.getDocNo(), ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                itmItemApplyDetailsAddParam.setItemApplyStatus(ItmUdcEnum.ITM_ITEM_APPLY_STATUS_APPROVING.getUdcVal());
                this.updateItemStatus(param, itmItemApplyDetailsAddParam, docNo);
            } else {
                throw new BusinessException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b");
            }
            if (!rLock.isHeldByCurrentThread()) {
                log.error("\u6301\u6709\u9501\u5df2\u8fc7\u671f");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6301\u6709\u9501\u5df2\u8fc7\u671f\uff01");
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("\u5355\u636e\u63d0\u4ea4/\u4fdd\u5b58\u5931\u8d25\uff1a" + (Exception)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return itemApplyAlterDO;
    }

    private void workFlow(ItmItemApplyAlterDO itemApplyAlterDO) {
        String docNo = itemApplyAlterDO.getDocNo();
        SysUserDTO user = null;
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails == null || generalUserDetails.getUser() == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
        }
        user = generalUserDetails.getUser();
        if (itemApplyAlterDO.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(itemApplyAlterDO.getProcInstStatus())) {
            String procInstName = "\u5546\u54c1\u65b0\u5efa\u5ba1\u6838-" + docNo;
            ProcessInfo processInfo = this.workflowService.startProcess(ProcDefKey.ITEM_ADD.name(), procInstName, docNo, null);
            QItmItemApplyAlterDO qItmItemApplyAlterDO = QItmItemApplyAlterDO.itmItemApplyAlterDO;
            JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qItmItemApplyAlterDO).set((Path)qItmItemApplyAlterDO.procInstId, (Object)processInfo.getProcInstId()).set(qItmItemApplyAlterDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qItmItemApplyAlterDO.docNo.eq((Object)docNo)});
            if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set(qItmItemApplyAlterDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
            }
            jpaUpdateClause.execute();
        }
    }

    private void updateItemStatus(ItmItemApplySubmitParam param, ItmItemApplyDetailsAddParam itmItemApplyDetailsAddParam, String docNo) {
        itmItemApplyDetailsAddParam.setDocNo(docNo);
        itmItemApplyDetailsAddParam.setDocType(ItmUdcEnum.ITM_APPLY_TYPE_ITEM_NEWAPPLY.getUdcVal());
        itmItemApplyDetailsAddParam.setSpuIds(param.getSpuIds());
        this.itmItemApplyService.updateItemApplyByAdd(itmItemApplyDetailsAddParam);
        List<Long> spuIds = param.getSpuIds();
        List<Long> itemIds = this.itmItemApplyRepoProc.findItemIdBySpuId(spuIds);
        this.itmItemApplyCustPropRepoProc.addDocNoBySpuId(spuIds, docNo);
        this.itmItemApplyPropRepoProc.addDocNoBySpuId(spuIds, docNo);
        this.itmItemApplyQualifyRepoProc.addDocNoBySpuId(spuIds, docNo);
        this.itmItemApplyTagRepoProc.addDocNoByItemId(itemIds, docNo);
        this.itmItemApplyUomConvRepoProc.addDocNoByItemId(itemIds, docNo);
        this.itmItemAttachApplymentRepoProc.addDocNoById(itemIds, docNo);
        this.itmItemAttachApplymentRepoProc.addDocNoById(spuIds, docNo);
    }

    @Override
    public void isReapateItem(List<Long> spuIds) {
        List<ItmItemUniqueVO> uniqueItemInfo = this.itmItemApplyRepoProc.findUniqueItemInfo(spuIds);
        StringBuilder errorInfo = new StringBuilder();
        uniqueItemInfo.forEach(item -> {
            if (this.itmItemRepo.existsBySpuNameAndSuppCodeAndItemCateCode(item.getSpuName(), item.getSuppCode(), item.getItemCateCode())) {
                errorInfo.append(item.getSpuName()).append("\u5728\u6b63\u5f0f\u8868\u4e2d\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546'\u7684\u5546\u54c1").append(";");
            }
        });
        String errorResult = errorInfo.toString();
        if (StringUtils.isNotBlank((CharSequence)errorResult)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, errorResult);
        }
    }

    public ItmItemApplyApproveServiceImpl(ItmItemApplyService itmItemApplyService, ItmItemRepo itmItemRepo, ItmItemApplyRepoProc itmItemApplyRepoProc, ItmItemApplyCustPropRepoProc itmItemApplyCustPropRepoProc, ItmItemApplyPropRepoProc itmItemApplyPropRepoProc, ItmItemApplyQualifyRepoProc itmItemApplyQualifyRepoProc, ItmItemApplyTagRepoProc itmItemApplyTagRepoProc, ItmItemApplyUomConvRepoProc itmItemApplyUomConvRepoProc, ItmItemAttachApplymentRepoProc itmItemAttachApplymentRepoProc, ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc, JPAQueryFactory jpaQueryFactory, PlatformTransactionManager platformTransactionManager, RedissonClient redissonClient, TransactionTemplate transactionTemplate) {
        this.itmItemApplyService = itmItemApplyService;
        this.itmItemRepo = itmItemRepo;
        this.itmItemApplyRepoProc = itmItemApplyRepoProc;
        this.itmItemApplyCustPropRepoProc = itmItemApplyCustPropRepoProc;
        this.itmItemApplyPropRepoProc = itmItemApplyPropRepoProc;
        this.itmItemApplyQualifyRepoProc = itmItemApplyQualifyRepoProc;
        this.itmItemApplyTagRepoProc = itmItemApplyTagRepoProc;
        this.itmItemApplyUomConvRepoProc = itmItemApplyUomConvRepoProc;
        this.itmItemAttachApplymentRepoProc = itmItemAttachApplymentRepoProc;
        this.itmItemApplyAlterRepoProc = itmItemApplyAlterRepoProc;
        this.jpaQueryFactory = jpaQueryFactory;
        this.platformTransactionManager = platformTransactionManager;
        this.redissonClient = redissonClient;
        this.transactionTemplate = transactionTemplate;
    }
}

