/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyAttachmentConvert;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAttachmentDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyAttachmentSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmSkuApplyImageSaveParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAttachmentRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemAttachApplymentRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyAttachmentService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyAttachmentVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmSkuApplyImageVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemApplyAttachmentServiceImpl
implements ItmItemApplyAttachmentService {
    private final ItmItemAttachApplymentRepoProc itmItemAttachApplymentRepoProc;
    private final ItmItemApplyAttachmentRepo itmItemApplyAttachmentRepo;

    @Override
    public List<ItmSkuApplyImageVO> findSkuImgByItemIds(List<Long> itemIds, String docNo) {
        return this.itmItemAttachApplymentRepoProc.findSkuImgByItemIds(itemIds, docNo);
    }

    @Override
    public List<ItmItemApplyAttachmentVO> findAttachmentByItemIdAndFileType(Long itemId, String fileType, String docNo) {
        return this.itmItemAttachApplymentRepoProc.findItemImagesByItemIdAndFileType(itemId, fileType, docNo);
    }

    @Override
    public void itemAttachmentsHardSave(Long itemId, List<ItmItemApplyAttachmentSaveParam> params) {
        if (itemId == null) {
            return;
        }
        this.itmItemApplyAttachmentRepo.deleteByItemId(itemId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyAttachmentDO> attachments = ItmItemApplyAttachmentConvert.INSTANCE.saveParamToDo(params);
        attachments.forEach(attachment -> attachment.setItemId(itemId));
        this.itmItemApplyAttachmentRepo.saveAll(attachments);
    }

    @Override
    public void itemAttachmentsApplyHardSave(Long itemId, List<ItmItemApplyAttachmentSaveParam> params, String docNo) {
        if (itemId == null) {
            return;
        }
        this.itmItemApplyAttachmentRepo.deleteByItemIdAndDocNo(itemId, docNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyAttachmentDO> attachments = ItmItemApplyAttachmentConvert.INSTANCE.saveParamToDo(params);
        attachments.forEach(attachment -> {
            attachment.setItemId(itemId);
            attachment.setDocNo(docNo);
        });
        this.itmItemApplyAttachmentRepo.saveAll(attachments);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void skuImgHardSave(List<Long> itemIds, List<ItmSkuApplyImageSaveParam> params) {
        if (CollectionUtils.isNotEmpty(itemIds)) {
            this.itmItemApplyAttachmentRepo.deleteByItemIdIn(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        this.itmItemApplyAttachmentRepo.saveAll(ItmItemApplyAttachmentConvert.INSTANCE.skuImageSaveParamToDo(params));
    }

    @Override
    public void skuImgApplyHardSave(List<Long> itemIds, List<ItmSkuApplyImageSaveParam> params, String docNo) {
        if (CollectionUtils.isNotEmpty(itemIds)) {
            this.itmItemApplyAttachmentRepo.deleteByItemIdIn(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyAttachmentDO> itmItemApplyAttachmentDOS = ItmItemApplyAttachmentConvert.INSTANCE.skuImageSaveParamToDo(params);
        itmItemApplyAttachmentDOS.forEach(dos -> dos.setDocNo(docNo));
        this.itmItemApplyAttachmentRepo.saveAll(itmItemApplyAttachmentDOS);
    }

    public ItmItemApplyAttachmentServiceImpl(ItmItemAttachApplymentRepoProc itmItemAttachApplymentRepoProc, ItmItemApplyAttachmentRepo itmItemApplyAttachmentRepo) {
        this.itmItemAttachApplymentRepoProc = itmItemAttachApplymentRepoProc;
        this.itmItemApplyAttachmentRepo = itmItemApplyAttachmentRepo;
    }
}

