/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.el.coordinator.core.common.jpa.vo.PagingVO;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.apply.convert.excel.ItmItemApplyExportConvert;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyExportParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyDExportRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyDExportService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmApplyDCateExportVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyDExportVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyVO;
import com.elitesland.yst.supportdomain.item.excel.convert.mapstruct.ItmItemExportConvert;
import com.elitesland.yst.supportdomain.item.excel.vo.ItemCateSalePropVO;
import com.elitesland.yst.supportdomain.item.repo.ItmBrandRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandVO;
import com.elitesland.yst.supportdomain.item.vo.ItmExportDescPropVO;
import com.elitesland.yst.supportdomain.item.vo.ItmExportSalePropVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.util.ItmExportUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ItmItemApplyDExportServiceImpl
implements ItmItemApplyDExportService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemApplyDExportServiceImpl.class);
    private final ItmItemApplyDExportRepoProc itmItemApplyDExportRepoProc;
    private final ItmBrandRepoProc itmBrandRepoProc;
    private final ItmItemCateService itmItemCateService;
    private final OrgBuService orgBuService;
    private final UdcService sysUdcService;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    private final ItmExportUtil itmExportUtil;
    private final TaskExecutor taskExecutor;

    @Override
    public PagingVO<ItmItemApplyDExportVO> getExportData(ItmItemApplyExportParam param) {
        List<String> docNos = param.getDocNos();
        if (CollectionUtils.isEmpty(docNos)) {
            return null;
        }
        Map itemType2CodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE2");
        Map itemTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE");
        Map allocTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "ALLOC_TYPE");
        Map returnExchangePolicyCodeMap = this.sysUdcService.getCodeMap("ITM", "RETURN_EXCHANGE_POLICY");
        Map uomCodeMap = this.sysUdcService.getCodeMap("COM", "UOM");
        Map weightUnitCodeMap = this.sysUdcService.getCodeMap("COM", "WEIGHT_UNIT");
        Map volumeUnitCodeMap = this.sysUdcService.getCodeMap("COM", "VOLUME_UNIT");
        Map timeUnitCodeMap = this.sysUdcService.getCodeMap("COM", "TIME_UNIT");
        Map docTypeCodeMap = this.sysUdcService.getCodeMap("ITM", "APPLY_TYPE");
        PagingVO<ItmItemApplyDExportVO> exportItemData = this.itmItemApplyDExportRepoProc.getExportItemData(param);
        List itemList = exportItemData.getRecords();
        CompletableFuture<Map> docNoThread = CompletableFuture.supplyAsync(() -> this.itmItemApplyDExportRepoProc.getApplicationDataByDocNos(docNos).stream().collect(Collectors.toMap(ItmItemApplyVO::getDocNo, t -> t)), (Executor)this.taskExecutor);
        CompletableFuture<Map> itemBrandMapThread = CompletableFuture.supplyAsync(() -> this.itmBrandRepoProc.getBrandNameByCode(itemList.stream().map(ItmItemApplyDExportVO::getBrand).collect(Collectors.toList())).stream().collect(Collectors.toMap(ItmBrandVO::getBrandCode, ItmBrandVO::getBrandName)), (Executor)this.taskExecutor);
        CompletableFuture<Map> itemUomConvMapThread = CompletableFuture.supplyAsync(() -> this.itmItemApplyDExportRepoProc.findItmItemUomByItemId(itemList.stream().map(ItmItemApplyDExportVO::getId).collect(Collectors.toList()), docNos).stream().collect(Collectors.groupingBy(vo -> vo.getItemId() + "-" + vo.getDocNo())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(HashMap::new, (m, v) -> m.put(v.getFromUom() + "-" + v.getToUom(), v.getRatio()), Map::putAll))), (Executor)this.taskExecutor);
        CompletableFuture<Map> cateNameThread = CompletableFuture.supplyAsync(() -> {
            List<String> itemCateCodeList = itemList.stream().map(ItmItemApplyDExportVO::getItemCateCode).collect(Collectors.toList());
            return this.itmExportUtil.allItemCateNameFill(itemCateCodeList);
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> buMapThread = CompletableFuture.supplyAsync(() -> {
            List<String> itemSources = itemList.stream().map(ItmItemApplyDExportVO::getItemSource).collect(Collectors.toList());
            List purcCode = itemList.stream().map(ItmItemApplyDExportVO::getBuCode).collect(Collectors.toList());
            itemSources.addAll(purcCode);
            OrgBuDtoParam buParam = OrgBuDtoParam.builder().buCodes(itemSources).build();
            return this.orgBuService.findBuDtoByParam(buParam).stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t, (t1, t2) -> t1));
        }, (Executor)this.taskExecutor);
        CompletableFuture<Map> descPropThread = CompletableFuture.supplyAsync(() -> this.itmItemApplyDExportRepoProc.getItemDescProp(itemList.stream().map(ItmItemApplyDExportVO::getSpuId).distinct().collect(Collectors.toList()), docNos).stream().collect(Collectors.groupingBy(vo -> vo.getItemId() + "-" + vo.getDocNo())), (Executor)this.taskExecutor);
        Set taxRateNoSet = itemList.stream().map(ItmItemApplyDExportVO::getTaxRateNo).collect(Collectors.toSet());
        Set taxRateNo2Set = itemList.stream().map(ItmItemApplyDExportVO::getTaxRateNo2).collect(Collectors.toSet());
        taxRateNoSet.addAll(taxRateNo2Set);
        ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
        taxParam.setTaxRateNos(new ArrayList(taxRateNoSet));
        Map<String, Double> taxRateMap = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam).stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, ComTaxRateRpcDTO::getTaxRateValue));
        Map docNoMap = docNoThread.join();
        Map itemBrandMap = itemBrandMapThread.join();
        Map itemUomConvMap = itemUomConvMapThread.join();
        Map buMap = buMapThread.join();
        Map descPropMap = descPropThread.join();
        Map cateNameMap = cateNameThread.join();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        for (ItmItemApplyDExportVO item : itemList) {
            BigDecimal price5;
            BigDecimal bigDecimal;
            ItmItemApplyExportConvert.INSTANCE.updateDocData((ItmItemApplyVO)docNoMap.get(item.getDocNo()), item);
            item.setDocType((String)docTypeCodeMap.get(item.getDocType()));
            item.setCreateTimeStr(df.format(item.getCreateTime()));
            ItmApplyDCateExportVO itmApplyDCateExportVO = (ItmApplyDCateExportVO)cateNameMap.get(item.getItemCateCode());
            item.setBigCateName(itmApplyDCateExportVO.getBigCateName());
            item.setMidCateName(itmApplyDCateExportVO.getMidCateName());
            item.setSmallCateName(itmApplyDCateExportVO.getSmallCateName());
            if (StringUtils.isNotBlank((CharSequence)item.getItemSource()) && null != buMap.get(item.getItemSource())) {
                item.setItemSource(((OrgBuDTO)buMap.get(item.getItemSource())).getBuName());
            }
            if (StringUtils.isNotBlank((CharSequence)item.getBuCode()) && null != buMap.get(item.getBuCode())) {
                item.setBuCode(((OrgBuDTO)buMap.get(item.getBuCode())).getBuName());
            }
            item.setBrand((String)itemBrandMap.get(item.getBrand()));
            HashMap uomConvHashMap = (HashMap)itemUomConvMap.get(item.getId() + "-" + item.getDocNo());
            if (MapUtils.isNotEmpty((Map)uomConvHashMap) && null != (bigDecimal = (BigDecimal)uomConvHashMap.get(item.getPurcUom() + "-" + item.getSaleUom()))) {
                item.setRatio(bigDecimal);
            }
            item.setItemType2((String)itemType2CodeMap.get(item.getItemType2()));
            item.setItemType((String)itemTypeCodeMap.get(item.getItemType()));
            item.setAllocType((String)allocTypeCodeMap.get(item.getAllocType()));
            item.setReturnExchangePolicy((String)returnExchangePolicyCodeMap.get(item.getReturnExchangePolicy()));
            item.setSaleUom((String)uomCodeMap.get(item.getSaleUom()));
            item.setPurcUom((String)uomCodeMap.get(item.getPurcUom()));
            if (null != taxRateMap.get(item.getTaxRateNo())) {
                item.setTaxRateNo(String.valueOf(taxRateMap.get(item.getTaxRateNo()) * 100.0));
            }
            if (null != taxRateMap.get(item.getTaxRateNo2())) {
                item.setTaxRateNo2(String.valueOf(taxRateMap.get(item.getTaxRateNo2()) * 100.0));
            }
            String weightUnit = (String)weightUnitCodeMap.get(item.getWeightUnit());
            BigDecimal grossWeight = item.getGrossWeight();
            if (null != grossWeight) {
                item.setWeightUnit(grossWeight.setScale(2, RoundingMode.HALF_UP) + weightUnit);
            }
            String volumeUnit = (String)volumeUnitCodeMap.get(item.getVolumeUnit());
            BigDecimal volume = item.getVolume();
            if (null != volume) {
                item.setVolumeUnit(volume.setScale(2, RoundingMode.HALF_UP) + volumeUnit);
            }
            String guaranteePeriodUnit = (String)timeUnitCodeMap.get(item.getGuaranteePeriodUnit());
            if (null != item.getGuaranteePeriod() && StringUtils.isNotBlank((CharSequence)guaranteePeriodUnit)) {
                item.setGuaranteePeriodUnit(item.getGuaranteePeriod() + guaranteePeriodUnit);
            }
            String warrantyPeriodUnit = (String)timeUnitCodeMap.get(item.getWarrantyPeriodUnit());
            if (null != item.getWarrantyPeriod() && StringUtils.isNotBlank((CharSequence)warrantyPeriodUnit)) {
                item.setWarrantyPeriodUnit(item.getWarrantyPeriod() + warrantyPeriodUnit);
            }
            item.setSalepurcFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getSalepurcFlag()));
            item.setSnFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getSnFlag()));
            item.setAftersalesServiceFlagxStr(this.itmExportUtil.trueOrFalseTransfrom(item.getAftersalesServiceFlagx()));
            item.setInstallFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getInstallFlag()));
            item.setReturnExchangeFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getReturnExchangeFlag()));
            item.setWarrantyFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getWarrantyFlag()));
            item.setMemberdiscFlagXStr(this.itmExportUtil.trueOrFalseTransfrom(item.getMemberdiscFlagX()));
            item.setDistributionFlagXStr(this.itmExportUtil.trueOrFalseTransfrom(item.getDistributionFlagX()));
            item.setLotFlagStr(this.itmExportUtil.trueOrFalseTransfrom(item.getLotFlag()));
            List itemCateDescPropVOS = (List)descPropMap.get(item.getSpuId() + "-" + item.getDocNo());
            ItmExportDescPropVO itmExportDescPropVO = new ItmExportDescPropVO();
            this.itmExportUtil.reflectionItemDescValue(itemCateDescPropVOS, itmExportDescPropVO);
            ItmItemExportConvert.INSTANCE.descVoToItem(item, itmExportDescPropVO);
            String itemAttr = item.getItemAttr();
            List<ItemCateSalePropVO> itemCateSalePropVOS = this.itmExportUtil.jsonToItemAttrJsonEntity(itemAttr);
            ItmExportSalePropVO itmExportSalePropVO = new ItmExportSalePropVO();
            this.itmExportUtil.reflectionItemSaleValue(itemCateSalePropVOS, itmExportSalePropVO);
            ItmItemExportConvert.INSTANCE.saleVoToItem(item, itmExportSalePropVO);
            BigDecimal price4 = item.getPrice4();
            if (null != price4) {
                item.setPrice4(price4.multiply(BigDecimal.valueOf(100L)));
            }
            if (null == (price5 = item.getPrice5())) continue;
            item.setPrice5(price5.multiply(BigDecimal.valueOf(100L)));
        }
        exportItemData.setRecords(itemList);
        return exportItemData;
    }

    public ItmItemApplyDExportServiceImpl(ItmItemApplyDExportRepoProc itmItemApplyDExportRepoProc, ItmBrandRepoProc itmBrandRepoProc, ItmItemCateService itmItemCateService, OrgBuService orgBuService, UdcService sysUdcService, ItmExportUtil itmExportUtil, TaskExecutor taskExecutor) {
        this.itmItemApplyDExportRepoProc = itmItemApplyDExportRepoProc;
        this.itmBrandRepoProc = itmBrandRepoProc;
        this.itmItemCateService = itmItemCateService;
        this.orgBuService = orgBuService;
        this.sysUdcService = sysUdcService;
        this.itmExportUtil = itmExportUtil;
        this.taskExecutor = taskExecutor;
    }
}

