/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.provider.IdGeneratorProvider;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.core.udc.SysUdcProxyService;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.common.SysNumberGeneratorWrapper;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyAttachmentConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyDConvert;
import com.elitesland.yst.supportdomain.item.apply.dto.ItmItemApplyDTO;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyAttachmentSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySkuSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySpuPagingParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySpuSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyTagSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyUomConvSaveParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemSearchSpuDetailsParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmSkuApplyImageSaveParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyAttachmentService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyCustPropService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyDService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyPropService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyQualifyService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyTagService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyUomConvService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplySkuVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplySpuDetailsVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplySpuPagingVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyTagVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyUomConvVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmSkuApplyImageVO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemDTO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.param.ItmItemBatchDeleteParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuPublishParam;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgBuDO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.util.GuaranteeConvUtil;
import com.elitesland.yst.supportdomain.util.ItmItemAttachmenTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemApplyDServiceImpl
implements ItmItemApplyDService {
    private static final String SPU_NO = "SPU_NO";
    private static final String SKU_NO = "SKU_NO";
    private static final String SKU_BAR_CODE = "SKU_BAR_CODE";
    private static final String CNY = "CNY";
    private final ItmItemApplyRepoProc itmItemApplyRepoProc;
    private final OrgBuService orgBuService;
    private final ItmItemCateService itmItemCateService;
    private final SysUdcProxyService sysUdcProxyService;
    private final ItmItemApplyAttachmentService itmItemApplyAttachmentService;
    private final ItmItemApplyPropService itmItemApplyPropService;
    private final ItmItemApplyTagService itmItemApplyTagService;
    private final ItmItemApplyUomConvService itmItemApplyUomConvService;
    private final ItmItemApplyQualifyService itmItemApplyQualifyService;
    private final ItmItemApplyCustPropService itmItemApplyCustPropService;
    private final SysNumberGeneratorWrapper sysNumberGeneratorWrapper;
    private final ItmItemApplyRepo itmItemApplyRepo;
    private final OrgBuRepo orgBuRepo;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    private final IdGeneratorProvider idGeneratorProvider;

    @Override
    @SysCodeProc
    public PagingVO<ItmItemApplySpuPagingVO> itemApplySpuPagingSearch(ItmItemApplySpuPagingParam param) {
        PagingVO<ItmItemApplySpuPagingVO> result = this.itmItemApplyRepoProc.selectSpuApplyPagingResult(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            OrgBuDtoParam buParam;
            List<OrgBuDTO> orgBuDtos;
            ArrayList<String> buCodes = new ArrayList<String>();
            ArrayList taxRateNos = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (StringUtils.isNotBlank((CharSequence)vo.getDocNo())) {
                    vo.setUniqueCode(vo.getSpuId() + vo.getDocNo());
                } else {
                    vo.setUniqueCode(vo.getSpuId().toString());
                }
                List<OrgBuDTO> buDtoByParam = this.orgBuService.findBuDtoByParam(OrgBuDtoParam.builder().buCodes(Arrays.asList(vo.getBuCode())).build());
                if (CollectionUtils.isNotEmpty(buDtoByParam)) {
                    vo.setBuCodeName(buDtoByParam.get(0).getBuName());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getItemSource()) && !buCodes.contains(vo.getItemSource())) {
                    buCodes.add(vo.getItemSource());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo()) && !taxRateNos.contains(vo.getTaxRateNo())) {
                    taxRateNos.add(vo.getTaxRateNo());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo2()) && !taxRateNos.contains(vo.getTaxRateNo2())) {
                    taxRateNos.add(vo.getTaxRateNo2());
                }
            });
            Map<Object, Object> buMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(buCodes) && CollectionUtils.isNotEmpty(orgBuDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(buCodes).build()))) {
                buMap = orgBuDtos.stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t));
            }
            Map<Object, Object> taxMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                }
            }
            for (ItmItemApplySpuPagingVO record : result.getRecords()) {
                ComTaxRateRpcDTO tax;
                OrgBuDTO bu;
                if (StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) {
                    record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)record.getItemSource()) && (bu = (OrgBuDTO)buMap.get(record.getItemSource())) != null) {
                    record.setItemSourceName(bu.getBuName());
                }
                if (StringUtils.isNotBlank((CharSequence)record.getTaxRateNo()) && (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo())) != null) {
                    record.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
                if (!StringUtils.isNotBlank((CharSequence)record.getTaxRateNo2()) || (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo2())) == null) continue;
                record.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
            }
        }
        return result;
    }

    @Override
    public ItmItemApplySpuDetailsVO findSpuApplyDetailsBySpuId(ItmItemSearchSpuDetailsParam param) {
        OrgBuDtoParam buParam;
        List<OrgBuDTO> buDtos;
        List<OrgBuDTO> buDtoByParam;
        ItmItemApplySpuDetailsVO result = this.itmItemApplyRepoProc.searchSpuApplyDetailVoById(param);
        String docNo = result.getDocNo();
        if (result == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6570\u636e\u5f02\u5e38\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e");
        }
        if (StringUtils.isNotBlank((CharSequence)result.getBuCode()) && CollectionUtils.isNotEmpty(buDtoByParam = this.orgBuService.findBuDtoByParam(OrgBuDtoParam.builder().buCodes(Arrays.asList(result.getBuCode())).build()))) {
            result.setBuCodeName(buDtoByParam.get(0).getBuName());
        }
        if (!StringUtils.isBlank((CharSequence)result.getItemCateCode())) {
            result.setItemCatePath(this.itmItemCateService.findItemCatePath(result.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)result.getItemSource()) && CollectionUtils.isNotEmpty(buDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(Collections.singletonList(result.getItemSource())).build()))) {
            result.setItemSourceName(buDtos.get(0).getBuName());
        }
        ArrayList<String> taxRateNos = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo())) {
            taxRateNos.add(result.getTaxRateNo());
        }
        if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo2())) {
            taxRateNos.add(result.getTaxRateNo2());
        }
        if (CollectionUtils.isNotEmpty(taxRateNos)) {
            ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
            taxParam.setTaxRateNos(taxRateNos);
            List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
            if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                ComTaxRateRpcDTO tax;
                Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo()) && (tax = taxMap.get(result.getTaxRateNo())) != null) {
                    result.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                    result.setTaxRateDesc(tax.getTaxRateDesc());
                }
                if (StringUtils.isNotBlank((CharSequence)result.getTaxRateNo2()) && (tax = taxMap.get(result.getTaxRateNo2())) != null) {
                    result.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                    result.setTaxRate2Desc(tax.getTaxRateDesc());
                }
            }
        }
        List<ItmItemApplySkuVO> skuVos = this.itmItemApplyRepoProc.findSkuVosBySpuId(result.getSpuId(), docNo);
        this.sysUdcProxyService.translate(skuVos);
        if (!CollectionUtils.isEmpty(skuVos)) {
            List<Long> itemIds = skuVos.stream().map(ItmItemApplySkuVO::getId).collect(Collectors.toList());
            List itemCodes = skuVos.stream().map(ItmItemApplySkuVO::getItemCode).collect(Collectors.toList());
            Map<Long, ItmSkuApplyImageVO> skuImageMap = this.itmItemApplyAttachmentService.findSkuImgByItemIds(itemIds, docNo).stream().collect(Collectors.toMap(ItmSkuApplyImageVO::getItemId, t -> t));
            Map<Long, List<ItmItemApplyTagVO>> skuTagMap = this.itmItemApplyTagService.findVoByItemIds(itemIds, docNo).stream().collect(Collectors.groupingBy(ItmItemApplyTagVO::getItemId));
            Map<Long, List<ItmItemApplyUomConvVO>> uomConvMap = this.itmItemApplyUomConvService.getItmItemUomConvByItemIds(itemIds, docNo).stream().collect(Collectors.groupingBy(ItmItemApplyUomConvVO::getItemId));
            skuVos.forEach(sku -> {
                Long itemId = sku.getId();
                String itemCode = sku.getItemCode();
                if (skuImageMap.containsKey(itemId)) {
                    sku.setImgCode(((ItmSkuApplyImageVO)skuImageMap.get(itemId)).getFileCode());
                    sku.setImgName(((ItmSkuApplyImageVO)skuImageMap.get(itemId)).getFileName());
                }
                if (skuTagMap.containsKey(itemId)) {
                    sku.setItemTags((List)skuTagMap.get(itemId));
                }
                if (uomConvMap.containsKey(itemId)) {
                    sku.setItemUomConvVos((List)uomConvMap.get(itemId));
                }
            });
            result.setItemSkuVos(skuVos);
        }
        result.setSpuImages(this.itmItemApplyAttachmentService.findAttachmentByItemIdAndFileType(param.getId(), ItmItemAttachmenTypeEnum.IMG.name(), docNo));
        result.setSpuVideos(this.itmItemApplyAttachmentService.findAttachmentByItemIdAndFileType(param.getId(), ItmItemAttachmenTypeEnum.VIDEO.name(), docNo));
        result.setItemPropVos(this.itmItemApplyPropService.findVosByItemId(param.getId(), docNo));
        result.setItemQualifyVos(this.itmItemApplyQualifyService.findVosBySpuId(param.getId(), docNo));
        result.setItemCustPropVos(this.itmItemApplyCustPropService.findVosByItemId(param.getId(), docNo));
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdateSpuApply(ItmItemApplySpuSaveParam param) {
        if (CollectionUtils.isEmpty(param.getItemSkuSaveParams())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SKU\u4fe1\u606f\u81f3\u5c11\u8981\u6709\u4e00\u6761");
        }
        List<ItmItemApplySkuSaveParam> skuSaveParams = param.getItemSkuSaveParams();
        Long spuId = param.getSpuId();
        if (spuId == null) {
            spuId = this.itmSpuInsert(param, skuSaveParams);
        } else {
            this.itmSpuUpdate(param, skuSaveParams);
        }
        String docNo = param.getDocNo();
        List<ItmItemApplyAttachmentSaveParam> itmAttachmentSaveParams = this.mergeAttachSaveParams(param.getSpuImages(), param.getSpuVideos());
        if (StringUtils.isNotBlank((CharSequence)docNo)) {
            this.itmItemApplyAttachmentService.itemAttachmentsApplyHardSave(spuId, itmAttachmentSaveParams, docNo);
            this.itmItemApplyPropService.itemPropsApplyHardSave(spuId, param.getItemPropSaveParams(), docNo);
            this.itmItemApplyQualifyService.itemQualifyApplyHardSave(spuId, param.getItemQualifySaveParams(), docNo);
            this.itmItemApplyCustPropService.itemCustPropApplyHardSave(spuId, param.getItemCustPropSaveParams(), docNo);
        } else {
            this.itmItemApplyAttachmentService.itemAttachmentsHardSave(spuId, itmAttachmentSaveParams);
            this.itmItemApplyPropService.itemPropsHardSave(spuId, param.getItemPropSaveParams());
            this.itmItemApplyQualifyService.itemQualifyHardSave(spuId, param.getItemQualifySaveParams());
            this.itmItemApplyCustPropService.itemCustPropHardSave(spuId, param.getItemCustPropSaveParams());
        }
        return spuId;
    }

    private Long itmSpuInsert(ItmItemApplySpuSaveParam param, List<ItmItemApplySkuSaveParam> skuSaveParams) {
        if (this.itmItemApplyRepo.existsBySpuNameAndSuppCodeAndItemCateCode(param.getSpuName(), param.getSuppCode(), param.getItemCateCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546'\u7684\u5546\u54c1");
        }
        List<ItmItemApplyDO> itmItemDos = ItmItemApplyDConvert.INSTANCE.skuSaveParamToDo(skuSaveParams);
        Long spuId = this.idGeneratorProvider.nextId();
        String spuCode = this.sysNumberGeneratorWrapper.generate(SPU_NO);
        if (this.itmItemApplyRepo.existsBySpuCode(spuCode)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SPU \u7f16\u53f7\uff1a" + spuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
        }
        boolean singleSku = itmItemDos.size() == 1;
        Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
        for (ItmItemApplyDO item : itmItemDos) {
            ItmItemApplyDConvert.INSTANCE.updateDoFromSpuSaveParam(param, item);
            item.setSpuId(spuId);
            item.setSpuCode(spuCode);
            item.setItemStatus(ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal());
            item.setGuaranteeDays(GuaranteeConvUtil.convertToDays(item.getGuaranteePeriod(), item.getGuaranteePeriodUnit()));
            if (singleSku) {
                item.setItemCode(spuCode);
            } else {
                String skuCode = this.sysNumberGeneratorWrapper.generate(SKU_NO, spuCode);
                if (this.itmItemApplyRepo.existsByItemCode(skuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SKU \u7f16\u53f7\uff1a" + skuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                }
                item.setItemCode(skuCode);
            }
            this.judgeCostBuCodeAndPrice(item.getPrice11(), item.getPrice12());
            if (StringUtils.isBlank((CharSequence)item.getBarCode())) {
                item.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
            }
            if (null != item.getPrice12()) {
                item.setPrice8(item.getPrice12());
            } else if (null != item.getPrice11()) {
                item.setPrice8(item.getPrice11());
            }
            if (!byBuCode.isPresent()) continue;
            Long ouId = byBuCode.get().getOuId();
            item.setSecOuId(ouId);
            item.setOuId(ouId);
        }
        this.itmItemApplyRepo.saveAll(itmItemDos);
        ArrayList<ItmSkuApplyImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuApplyImageSaveParam>();
        ArrayList skuPriceSaveParams = new ArrayList();
        ArrayList<ItmItemApplyTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemApplyTagSaveParam>();
        ArrayList<ItmItemApplyUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemApplyUomConvSaveParam>();
        for (int i = 0; i < itmItemDos.size(); ++i) {
            List<ItmItemApplyUomConvSaveParam> convSaveParams;
            ItmItemApplySkuSaveParam skuSaveParam = skuSaveParams.get(i);
            ItmItemApplyDO item = itmItemDos.get(i);
            ItmSkuApplyImageSaveParam skuImage = ItmItemApplyAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(skuSaveParam);
            skuImage.setItemId(item.getId());
            skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
            skuImageSaveParams.add(skuImage);
            List<ItmItemApplyTagSaveParam> tagSaveParams = skuSaveParam.getItemSaveTags();
            if (!CollectionUtils.isEmpty(tagSaveParams)) {
                tagSaveParams.forEach(t -> t.setItemId(item.getId()));
                itemTagSaveParams.addAll(tagSaveParams);
            }
            if (CollectionUtils.isEmpty(convSaveParams = skuSaveParam.getItemUomConvSaveParams())) continue;
            convSaveParams.forEach(t -> t.setItemId(item.getId()));
            uomConvSaveParams.addAll(convSaveParams);
        }
        this.itmItemApplyAttachmentService.skuImgHardSave(null, skuImageSaveParams);
        this.itmItemApplyTagService.itemTagHardSave(null, itemTagSaveParams);
        this.itmItemApplyUomConvService.itemUomConvHardSave(null, uomConvSaveParams);
        return spuId;
    }

    private void itmSpuUpdate(ItmItemApplySpuSaveParam param, List<ItmItemApplySkuSaveParam> skuSaveParams) {
        List<ItmItemApplyUomConvSaveParam> convSaveParams;
        List<ItmItemApplyTagSaveParam> tagSaveParams;
        ItmSkuApplyImageSaveParam skuImage;
        if (this.itmItemApplyRepo.existsBySpuNameAndSuppCodeAndItemCateCodeAndSpuIdNot(param.getSpuName(), param.getSuppCode(), param.getItemCateCode(), param.getSpuId())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c'\u5546\u54c1\u540d\u79f0'\uff0c'\u54c1\u7c7b'\uff0c'\u4f9b\u5e94\u5546'\u7684\u5546\u54c1");
        }
        List<ItmItemApplyDO> itmItemDos = this.itmItemApplyRepo.findBySpuId(param.getSpuId());
        if (CollectionUtils.isEmpty(itmItemDos)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "SPU\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        boolean isChange = ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal().equals(itmItemDos.get(0).getItemStatus());
        List existsIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        List updateSkuParams = skuSaveParams.stream().filter(skuSaveParam -> existsIds.contains(skuSaveParam.getId())).collect(Collectors.toList());
        List updateIds = updateSkuParams.stream().map(ItmItemApplySkuSaveParam::getId).collect(Collectors.toList());
        List insertSkuParams = skuSaveParams.stream().filter(skuSaveParam -> !updateIds.contains(skuSaveParam.getId())).peek(skuSaveParam -> skuSaveParam.setId(null)).collect(Collectors.toList());
        List deleteDos = itmItemDos.stream().filter(item -> !updateIds.contains(item.getId())).collect(Collectors.toList());
        ArrayList<ItmSkuApplyImageSaveParam> skuImageSaveParams = new ArrayList<ItmSkuApplyImageSaveParam>();
        ArrayList<ItmItemApplyTagSaveParam> itemTagSaveParams = new ArrayList<ItmItemApplyTagSaveParam>();
        ArrayList<ItmItemApplyUomConvSaveParam> uomConvSaveParams = new ArrayList<ItmItemApplyUomConvSaveParam>();
        if (!CollectionUtils.isEmpty(updateSkuParams)) {
            Map<Long, ItmItemApplyDO> updateDoMap = itmItemDos.stream().filter(item -> updateIds.contains(item.getId())).collect(Collectors.toMap(BaseModel::getId, t -> t));
            List updateDos = updateSkuParams.stream().map(skuSaveParam -> {
                ItmItemApplyDO updateDo = (ItmItemApplyDO)updateDoMap.get(skuSaveParam.getId());
                this.judgeCostBuCodeAndPrice(updateDo.getPrice11(), updateDo.getPrice12());
                ItmItemApplyDConvert.INSTANCE.updateDoFromSpuSaveParam(param, updateDo);
                updateDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(updateDo.getGuaranteePeriod(), updateDo.getGuaranteePeriodUnit()));
                ItmItemApplyDConvert.INSTANCE.updateDoFromSkuSaveParam((ItmItemApplySkuSaveParam)skuSaveParam, updateDo);
                if (null != updateDo.getPrice12()) {
                    updateDo.setPrice8(updateDo.getPrice12());
                } else if (null != updateDo.getPrice11()) {
                    updateDo.setPrice8(updateDo.getPrice11());
                }
                Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
                if (byBuCode.isPresent()) {
                    Long ouId = byBuCode.get().getOuId();
                    updateDo.setSecOuId(ouId);
                    updateDo.setOuId(ouId);
                }
                return updateDo;
            }).collect(Collectors.toList());
            this.itmItemApplyRepo.saveAll(updateDos);
            for (ItmItemApplySkuSaveParam updateSkuParam : updateSkuParams) {
                skuImage = ItmItemApplyAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(updateSkuParam);
                skuImage.setItemId(updateSkuParam.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                tagSaveParams = updateSkuParam.getItemSaveTags();
                if (!CollectionUtils.isEmpty(tagSaveParams)) {
                    tagSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = updateSkuParam.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(updateSkuParam.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(insertSkuParams)) {
            List insertDos = insertSkuParams.stream().map(insertSkuParam -> {
                ItmItemApplyDO insertDo = ItmItemApplyDConvert.INSTANCE.skuSaveParamToDo((ItmItemApplySkuSaveParam)insertSkuParam);
                this.judgeCostBuCodeAndPrice(insertDo.getPrice11(), insertDo.getPrice12());
                ItmItemApplyDConvert.INSTANCE.updateDoFromSpuSaveParam(param, insertDo);
                insertDo.setGuaranteeDays(GuaranteeConvUtil.convertToDays(param.getGuaranteePeriod(), param.getGuaranteePeriodUnit()));
                String skuCode = this.sysNumberGeneratorWrapper.generate(SKU_NO, param.getSpuCode());
                if (this.itmItemApplyRepo.existsByItemCode(skuCode)) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53d1\u53f7\u5668\u751f\u6210\u7684 SKU \u7f16\u53f7\uff1a" + skuCode + " \u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53d1\u53f7\u5668\u914d\u7f6e\u662f\u5426\u6b63\u786e");
                }
                insertDo.setItemCode(skuCode);
                if (StringUtils.isBlank((CharSequence)insertSkuParam.getBarCode())) {
                    insertDo.setBarCode(this.sysNumberGeneratorWrapper.generate(SKU_BAR_CODE));
                }
                if (isChange) {
                    insertDo.setItemStatus(ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal());
                } else {
                    insertDo.setItemStatus(ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal());
                }
                if (null != insertDo.getPrice12()) {
                    insertDo.setPrice8(insertDo.getPrice12());
                } else if (null != insertDo.getPrice11()) {
                    insertDo.setPrice8(insertDo.getPrice11());
                }
                Optional<OrgBuDO> byBuCode = this.orgBuRepo.findByBuCode(param.getItemSource());
                if (byBuCode.isPresent()) {
                    Long ouId = byBuCode.get().getOuId();
                    insertDo.setSecOuId(ouId);
                    insertDo.setOuId(ouId);
                    GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
                }
                return insertDo;
            }).collect(Collectors.toList());
            this.itmItemApplyRepo.saveAll(insertDos);
            for (int i = 0; i < insertDos.size(); ++i) {
                ItmItemApplySkuSaveParam insertSkuParam2 = (ItmItemApplySkuSaveParam)insertSkuParams.get(i);
                ItmItemApplyDO item2 = (ItmItemApplyDO)insertDos.get(i);
                skuImage = ItmItemApplyAttachmentConvert.INSTANCE.skuSaveParamToSkuImageSaveParam(insertSkuParam2);
                skuImage.setItemId(item2.getId());
                skuImage.setFileType(ItmItemAttachmenTypeEnum.IMG.name());
                skuImageSaveParams.add(skuImage);
                tagSaveParams = insertSkuParam2.getItemSaveTags();
                if (!CollectionUtils.isEmpty(tagSaveParams)) {
                    tagSaveParams.forEach(t -> t.setItemId(item2.getId()));
                    itemTagSaveParams.addAll(tagSaveParams);
                }
                if (CollectionUtils.isEmpty(convSaveParams = insertSkuParam2.getItemUomConvSaveParams())) continue;
                convSaveParams.forEach(t -> t.setItemId(item2.getId()));
                uomConvSaveParams.addAll(convSaveParams);
            }
        }
        if (!CollectionUtils.isEmpty(deleteDos) && !isChange) {
            this.itmItemApplyRepo.deleteInBatch(deleteDos);
        }
        List<Long> itemIds = itmItemDos.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.itmItemApplyAttachmentService.skuImgHardSave(itemIds, skuImageSaveParams);
        this.itmItemApplyTagService.itemTagHardSave(itemIds, itemTagSaveParams);
        this.itmItemApplyUomConvService.itemUomConvHardSave(itemIds, uomConvSaveParams);
    }

    private List<ItmItemApplyAttachmentSaveParam> mergeAttachSaveParams(List<ItmItemApplyAttachmentSaveParam> spuImages, List<ItmItemApplyAttachmentSaveParam> spuVideos) {
        if (CollectionUtils.isNotEmpty(spuImages) && CollectionUtils.isNotEmpty(spuVideos)) {
            spuImages.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.IMG.name()));
            spuVideos.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.VIDEO.name()));
            spuImages.addAll(spuVideos);
            return spuImages;
        }
        if (CollectionUtils.isNotEmpty(spuImages)) {
            spuImages.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.IMG.name()));
            return spuImages;
        }
        if (CollectionUtils.isNotEmpty(spuVideos)) {
            spuVideos.forEach(t -> t.setFileType(ItmItemAttachmenTypeEnum.VIDEO.name()));
            return spuVideos;
        }
        return Collections.emptyList();
    }

    @Override
    public void batchSpuPublish(ItmItemSpuPublishParam param) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void softDeleteByParam(ItmItemBatchDeleteParam param) {
        if (CollectionUtils.isEmpty(param.getSpuIds())) {
            return;
        }
        List<Long> spuIds = param.getSpuIds();
        List<ItmItemApplyDTO> dtos = this.itmItemApplyRepoProc.findItemDtoBySpuIds(spuIds);
        dtos.forEach(dto -> {
            if (!ItmUdcEnum.ITEM_STATUS_DRAFT.getUdcVal().equals(dto.getItemStatus())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u53ea\u80fd\u5220\u9664\u8349\u7a3f\u72b6\u6001\u7684\u5546\u54c1");
            }
        });
        this.itmItemApplyRepoProc.softDeleteBySpuId(spuIds);
    }

    @Override
    public List<ItmItemDTO> findAllItemDto(String itemType) {
        return this.itmItemApplyRepoProc.findAllItemDto(itemType);
    }

    private void judgeCostBuCodeAndPrice(BigDecimal price11, BigDecimal price12) {
        if (null == price11 && null == price12) {
            throw new BusinessException("\u5df2\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\uff1a\u542b\u7a0e\u4ef7\u683c\u4e0e\u542b\u8fd0\u8d39\u542b\u7a0e\u4ef7\u683c\u81f3\u5c11\u586b\u5199\u4e00\u4e2a");
        }
        if (null != price11 && null != price12 && price12.compareTo(price11) < 0) {
            throw new BusinessException("\u542b\u8fd0\u8d39\u542b\u7a0e\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u542b\u7a0e\u4ef7\u683c");
        }
    }

    public ItmItemApplyDServiceImpl(ItmItemApplyRepoProc itmItemApplyRepoProc, OrgBuService orgBuService, ItmItemCateService itmItemCateService, SysUdcProxyService sysUdcProxyService, ItmItemApplyAttachmentService itmItemApplyAttachmentService, ItmItemApplyPropService itmItemApplyPropService, ItmItemApplyTagService itmItemApplyTagService, ItmItemApplyUomConvService itmItemApplyUomConvService, ItmItemApplyQualifyService itmItemApplyQualifyService, ItmItemApplyCustPropService itmItemApplyCustPropService, SysNumberGeneratorWrapper sysNumberGeneratorWrapper, ItmItemApplyRepo itmItemApplyRepo, OrgBuRepo orgBuRepo, IdGeneratorProvider idGeneratorProvider) {
        this.itmItemApplyRepoProc = itmItemApplyRepoProc;
        this.orgBuService = orgBuService;
        this.itmItemCateService = itmItemCateService;
        this.sysUdcProxyService = sysUdcProxyService;
        this.itmItemApplyAttachmentService = itmItemApplyAttachmentService;
        this.itmItemApplyPropService = itmItemApplyPropService;
        this.itmItemApplyTagService = itmItemApplyTagService;
        this.itmItemApplyUomConvService = itmItemApplyUomConvService;
        this.itmItemApplyQualifyService = itmItemApplyQualifyService;
        this.itmItemApplyCustPropService = itmItemApplyCustPropService;
        this.sysNumberGeneratorWrapper = sysNumberGeneratorWrapper;
        this.itmItemApplyRepo = itmItemApplyRepo;
        this.orgBuRepo = orgBuRepo;
        this.idGeneratorProvider = idGeneratorProvider;
    }
}

