/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyQualifyConvert;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyQualifyDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyQualifySaveParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyQualifyRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyQualifyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyQualifyService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyQualifyVO;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ItmItemApplyQualifyServiceImpl
implements ItmItemApplyQualifyService {
    private final ItmItemApplyQualifyRepoProc itmItemApplyQualifyRepoProc;
    private final ItmItemApplyQualifyRepo itmItemApplyQualifyRepo;

    @Override
    @SysCodeProc
    public List<ItmItemApplyQualifyVO> findVosBySpuId(Long spuId, String docNo) {
        return this.itmItemApplyQualifyRepoProc.findVosBySpuId(spuId, docNo);
    }

    @Override
    public void itemQualifyHardSave(Long spuId, List<ItmItemApplyQualifySaveParam> params) {
        if (spuId == null) {
            return;
        }
        this.itmItemApplyQualifyRepo.deleteBySpuId(spuId);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyQualifyDO> qualifyDos = ItmItemApplyQualifyConvert.INSTANCE.saveParamToDo(params);
        qualifyDos.forEach(qualify -> qualify.setSpuId(spuId));
        this.itmItemApplyQualifyRepo.saveAll(qualifyDos);
    }

    @Override
    public void itemQualifyApplyHardSave(Long spuId, List<ItmItemApplyQualifySaveParam> params, String docNo) {
        if (spuId == null) {
            return;
        }
        this.itmItemApplyQualifyRepo.deleteBySpuIdAndDocNo(spuId, docNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyQualifyDO> qualifyDos = ItmItemApplyQualifyConvert.INSTANCE.saveParamToDo(params);
        qualifyDos.forEach(qualify -> {
            qualify.setSpuId(spuId);
            qualify.setDocNo(docNo);
        });
        this.itmItemApplyQualifyRepo.saveAll(qualifyDos);
    }

    public ItmItemApplyQualifyServiceImpl(ItmItemApplyQualifyRepoProc itmItemApplyQualifyRepoProc, ItmItemApplyQualifyRepo itmItemApplyQualifyRepo) {
        this.itmItemApplyQualifyRepoProc = itmItemApplyQualifyRepoProc;
        this.itmItemApplyQualifyRepo = itmItemApplyQualifyRepo;
    }
}

