/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.base.BaseModel;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.security.util.SecurityUtil;
import com.elitesland.yst.dto.save.PurPriceSaveDTO;
import com.elitesland.yst.provider.PurPriceProvider;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyAlertConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyAttachmentConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyConvUomConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyCustPropConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyDConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyPropConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyQualifyConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyTagConvert;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyUomConvConvert;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.entity.QItmItemApplyAlterDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmApplySaveAndCommitParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyAddPagingParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyDetailsAddParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyPagingParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplySaveRowParam;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemSearchSpuDetailsParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyAlterRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyCustPropRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyPropRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyQualifyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyTagRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyUomConvRepoProc;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemAttachApplymentRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyDExportService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyDService;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmApplyChangeByDocNoVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmApplySpuIdByDocNosVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemAllApplyItemVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyAddPagingVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyAttachmentVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyByDocNoVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyCustPropVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyDDetialsVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyPagingVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyPropVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyQualifyVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplySkuVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplySpuDetailsVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyTagVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyUomConvVO;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemBaseInfoVO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemAttachmentDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemCustPropDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemPropDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemQualifyDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemTagDO;
import com.elitesland.yst.supportdomain.item.entity.ItmItemUomConvDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.param.ItmItemSkuSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuSaveParam;
import com.elitesland.yst.supportdomain.item.repo.ItmItemAttachmentRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCustPropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemPropRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemQualifyRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemTagRepo;
import com.elitesland.yst.supportdomain.item.repo.ItmItemUomConvRepo;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemChangUpdateVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.dto.OrgOuDTO;
import com.elitesland.yst.supportdomain.org.entity.OrgEmpDO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuRepo;
import com.elitesland.yst.supportdomain.org.repo.OrgEmpRepo;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.org.service.OrgEmpBuService;
import com.elitesland.yst.supportdomain.org.service.OrgEmpService;
import com.elitesland.yst.supportdomain.org.service.OrgOuService;
import com.elitesland.yst.supportdomain.org.vo.OrgEmpBuVO;
import com.elitesland.yst.supportdomain.org.vo.OrgUserEmpInfoVO;
import com.elitesland.yst.supportdomain.pri.entity.PriMainPriceRowDO;
import com.elitesland.yst.supportdomain.pri.enums.PriMainPriceUdcEnum;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepo;
import com.elitesland.yst.supportdomain.util.ComUdcEnum;
import com.elitesland.yst.supportdomain.workflow.ProcDefKey;
import com.elitesland.yst.system.service.SysUdcService;
import com.elitesland.yst.system.vo.SysUserDTO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItmItemApplyServiceImpl
implements ItmItemApplyService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemApplyServiceImpl.class);
    private static final Integer ONE_INTEGER = 1;
    private final OrgBuRepo orgBuRepo;
    private final OrgEmpRepo orgEmpRepo;
    private final OrgEmpBuService orgEmpBuService;
    private final OrgBuService orgBuService;
    private final ItmItemCateService itmItemCateService;
    private final SysUdcService sysUdcService;
    private final ItmItemApplyAlterRepo itmItemApplyAlterRepo;
    private final ItmItemApplyRepoProc itmItemApplyRepoProc;
    private final ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc;
    private final ItmItemApplyCustPropRepoProc itmItemApplyCustPropRepoProc;
    private final ItmItemApplyPropRepoProc itmItemApplyPropRepoProc;
    private final ItmItemApplyQualifyRepoProc itmItemApplyQualifyRepoProc;
    private final ItmItemApplyTagRepoProc itmItemApplyTagRepoProc;
    private final ItmItemApplyUomConvRepoProc itmItemApplyUomConvRepoProc;
    private final ItmItemAttachApplymentRepoProc itmItemAttachApplymentRepoProc;
    private final ItmItemRepo itmItemRepo;
    private final ItmItemCustPropRepo itmItemCustPropRepo;
    private final ItmItemQualifyRepo itmItemQualifyRepo;
    private final ItmItemPropRepo itmItemPropRepo;
    private final ItmItemUomConvRepo itmItemUomConvRepo;
    private final ItmItemTagRepo itmItemTagRepo;
    private final ItmItemAttachmentRepo itmItemAttachmentRepo;
    private final PriMainPriceRowRepo priMainPriceRowRepo;
    private final ItmItemApplyDService itmItemApplyDService;
    private final ItmItemService itmItemService;
    private final OrgEmpService orgEmpService;
    private final OrgOuService orgOuService;
    private final ItmItemApplyDExportService itmItemApplyDExportService;
    private final ItmItemBusinessRepo itmItemBusinessRepo;
    private final JPAQueryFactory jpaQueryFactory;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    @DubboReference
    private WorkflowService workflowService;
    @DubboReference
    private PurPriceProvider purPriceProvider;
    private final RedissonClient redissonClient;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ItmItemApplyAlterDO saveAndUpdateRow(ItmItemApplySaveRowParam param) {
        List ouIds;
        List buIds;
        if (StringUtils.isBlank((CharSequence)param.getDocNo())) {
            param.setDocNo(new SimpleDateFormat("yyyyMMddHHmmssSSSSS").format(new Date()));
        }
        List<OrgEmpBuVO> orgEmpBuVos = this.getEmpBuDetail();
        ItmItemApplyAlterDO itmItemApplyDO = ItmItemApplyAlertConvert.INSTANCE.saveParamToParam(param);
        if (CollectionUtils.isNotEmpty(orgEmpBuVos) && CollectionUtils.isNotEmpty(buIds = orgEmpBuVos.stream().map(s -> s.getEmpBuId()).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(ouIds = this.orgBuRepo.findAllById(buIds).stream().map(s -> s.getOuId()).collect(Collectors.toList()))) {
            itmItemApplyDO.setOuId((Long)ouIds.get(0));
            itmItemApplyDO.setSecOuId((Long)ouIds.get(0));
        }
        itmItemApplyDO.setApplyDate(LocalDateTime.now());
        SysUserDTO userInfo = this.getUserInfo();
        if (userInfo.getId() != null) {
            itmItemApplyDO.setCreateUserId(userInfo.getId());
            itmItemApplyDO.setCreator(userInfo.getUsername());
            OrgUserEmpInfoVO orgUserEmpInfoVO = this.orgEmpService.userEmpInfo(userInfo.getId());
            if (null != orgUserEmpInfoVO) {
                itmItemApplyDO.setApplyEmpId(orgUserEmpInfoVO.getEmpId());
            }
        }
        ItmItemApplyAlterDO applyAlterDO = (ItmItemApplyAlterDO)this.itmItemApplyAlterRepo.save(itmItemApplyDO);
        return applyAlterDO;
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemApplyPagingVO> searchPagingList(ItmItemApplyPagingParam param) {
        PagingVO<ItmItemApplyPagingVO> itmItemApplyPagingVOPagingVO = this.itmItemApplyAlterRepoProc.searchPagingList(param);
        List records = itmItemApplyPagingVOPagingVO.getRecords();
        List<String> docNos = records.stream().filter(itemApply -> ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal().equals(itemApply.getDocType())).map(ItmItemApplyPagingVO::getDocNo).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(docNos)) {
            Map<String, Long> docNoAndSpuIdMap = this.itmItemApplyRepoProc.getApplyChangeSpuIdByDocNo(docNos, ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal()).stream().collect(Collectors.toMap(ItmApplySpuIdByDocNosVO::getDocNo, ItmApplySpuIdByDocNosVO::getSpuId, (t1, t2) -> t1));
            itmItemApplyPagingVOPagingVO.getRecords().forEach(itemApply -> {
                if (docNoAndSpuIdMap.containsKey(itemApply.getDocNo())) {
                    itemApply.setSpuId((Long)docNoAndSpuIdMap.get(itemApply.getDocNo()));
                }
            });
        }
        return itmItemApplyPagingVOPagingVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemApplyAddPagingVO> itemApplyAddPagingSearch(ItmItemApplyAddPagingParam param) {
        PagingVO<ItmItemApplyAddPagingVO> result = this.itmItemApplyRepoProc.itemApplyAddPagingSearch(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            OrgBuDtoParam buParam;
            List<OrgBuDTO> orgBuDtos;
            ArrayList<String> buCodes = new ArrayList<String>();
            ArrayList taxRateNos = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (StringUtils.isNotBlank((CharSequence)vo.getItemSource()) && !buCodes.contains(vo.getItemSource())) {
                    buCodes.add(vo.getItemSource());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo()) && !taxRateNos.contains(vo.getTaxRateNo())) {
                    taxRateNos.add(vo.getTaxRateNo());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo2()) && !taxRateNos.contains(vo.getTaxRateNo2())) {
                    taxRateNos.add(vo.getTaxRateNo2());
                }
            });
            Map<Object, Object> buMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(buCodes) && CollectionUtils.isNotEmpty(orgBuDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(buCodes).build()))) {
                buMap = orgBuDtos.stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t));
            }
            Map<Object, Object> taxMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                }
            }
            for (ItmItemApplyAddPagingVO record : result.getRecords()) {
                ComTaxRateRpcDTO tax;
                OrgBuDTO bu;
                if (StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) {
                    record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)record.getItemSource()) && (bu = (OrgBuDTO)buMap.get(record.getItemSource())) != null) {
                    record.setItemSourceName(bu.getBuName());
                }
                if (StringUtils.isNotBlank((CharSequence)record.getTaxRateNo()) && (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo())) != null) {
                    record.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
                if (!StringUtils.isNotBlank((CharSequence)record.getTaxRateNo2()) || (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo2())) == null) continue;
                record.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
            }
        }
        return result;
    }

    @Override
    public ItmItemApplyByDocNoVO findItmApplyDetailsByDocNo(String docNo) {
        ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
        List<ItmItemApplyDDetialsVO> applySpuList = this.itmItemApplyRepoProc.findApplySpuList(docNo);
        Map itemTypeMap = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE");
        Map itemType2Map = this.sysUdcService.getCodeMap("ITM", "ITEM_TYPE2");
        Map allocTypeMap = this.sysUdcService.getCodeMap("ITM", "ALLOC_TYPE");
        Map timeUnitMap = this.sysUdcService.getCodeMap("ITM", "TIME_UNIT");
        Map itemStatusMap = this.sysUdcService.getCodeMap("ITM", "ITEM_APPLY_STATUS");
        if (!CollectionUtils.isEmpty(applySpuList)) {
            OrgBuDtoParam buParam;
            List<OrgBuDTO> orgBuDtos;
            ArrayList<String> buCodes = new ArrayList<String>();
            ArrayList taxRateNos = new ArrayList();
            applySpuList.forEach(vo -> {
                vo.setItemTypeName((String)itemTypeMap.get(vo.getItemType()));
                vo.setItemType2Name((String)itemType2Map.get(vo.getItemType2()));
                vo.setAllocTypeName((String)allocTypeMap.get(vo.getAllocType()));
                vo.setGuaranteePeriodUnitName((String)timeUnitMap.get(vo.getGuaranteePeriodUnit()));
                vo.setItemStatusName((String)itemStatusMap.get(vo.getItemStatus()));
                if (StringUtils.isNotBlank((CharSequence)vo.getItemSource()) && !buCodes.contains(vo.getItemSource())) {
                    buCodes.add(vo.getItemSource());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo()) && !taxRateNos.contains(vo.getTaxRateNo())) {
                    taxRateNos.add(vo.getTaxRateNo());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo2()) && !taxRateNos.contains(vo.getTaxRateNo2())) {
                    taxRateNos.add(vo.getTaxRateNo2());
                }
            });
            Map<Object, Object> buMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(buCodes) && CollectionUtils.isNotEmpty(orgBuDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(buCodes).build()))) {
                buMap = orgBuDtos.stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t));
            }
            Map<Object, Object> taxMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                }
            }
            for (ItmItemApplyDDetialsVO record : applySpuList) {
                ComTaxRateRpcDTO tax;
                OrgBuDTO bu;
                if (StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) {
                    record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)record.getItemSource()) && (bu = (OrgBuDTO)buMap.get(record.getItemSource())) != null) {
                    record.setItemSourceName(bu.getBuName());
                }
                if (StringUtils.isNotBlank((CharSequence)record.getTaxRateNo()) && (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo())) != null) {
                    record.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
                if (!StringUtils.isNotBlank((CharSequence)record.getTaxRateNo2()) || (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo2())) == null) continue;
                record.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
            }
        }
        itemApplyDetailByDocNo.setSpuList(applySpuList);
        return itemApplyDetailByDocNo;
    }

    @Override
    public ItmApplyChangeByDocNoVO findItmApplyDetailsChangeByDocNo(String docNo) {
        ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
        ItmApplyChangeByDocNoVO itmApplyChangeByDocNoVO = ItmItemApplyAlertConvert.INSTANCE.voToVo(itemApplyDetailByDocNo);
        List<ItmApplySpuIdByDocNosVO> applyChangeSpuIdByDocNo = this.itmItemApplyRepoProc.getApplyChangeSpuIdByDocNo(List.of(docNo), ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal());
        if (CollectionUtils.isNotEmpty(applyChangeSpuIdByDocNo)) {
            ItmApplySpuIdByDocNosVO itmApplySpuIdByDocNosVO = applyChangeSpuIdByDocNo.get(0);
            ItmItemApplySpuDetailsVO spuApplyDetailsBySpuId = this.itmItemApplyDService.findSpuApplyDetailsBySpuId(ItmItemSearchSpuDetailsParam.builder().id(itmApplySpuIdByDocNosVO.getSpuId()).docNo(docNo).build());
            itmApplyChangeByDocNoVO.setSpuDetailsVO(spuApplyDetailsBySpuId);
        }
        return itmApplyChangeByDocNoVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemApplyCommit(ItmApplySaveAndCommitParam param) {
        String docNo = param.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNo);
        try {
            if (!rLock.tryLock(0L, 20L, TimeUnit.SECONDS)) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25");
                throw new BusinessException("\u5355\u636e\u91cd\u590d\u63d0\u4ea4\uff1a:" + docNo);
            }
            ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
            List<Long> newSpuIds = param.getSpuIds();
            List<Long> deleteSpuList = this.findDeleteSpuList(param);
            this.itmItemApplyAlterRepoProc.itmItemApplyChange(docNo, ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
            this.itmItemApplyAlterRepoProc.itmItemApplyChangeDesc(docNo, param.getApplyDesc());
            this.addSpuIdsChange(newSpuIds, ItmUdcEnum.ITM_ITEM_APPLY_STATUS_APPROVING.getUdcVal(), itemApplyDetailByDocNo.getDocType(), docNo);
            this.deleteSpuIdsChange(deleteSpuList);
            SysUserDTO user = null;
            GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
            if (generalUserDetails == null || generalUserDetails.getUser() == null) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
            }
            user = generalUserDetails.getUser();
            if (itemApplyDetailByDocNo.getProcInstId() == null || WorkflowConstant.CAN_START_PROC_STATUSES.contains(itemApplyDetailByDocNo.getProcInstStatus())) {
                String procInstName = "\u5546\u54c1\u65b0\u5efa\u5ba1\u6838-" + itemApplyDetailByDocNo.getDocNo();
                ProcessInfo processInfo = this.workflowService.startProcess(ProcDefKey.ITEM_ADD.name(), procInstName, itemApplyDetailByDocNo.getDocNo(), null);
                QItmItemApplyAlterDO qItmItemApplyAlterDO = QItmItemApplyAlterDO.itmItemApplyAlterDO;
                JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)qItmItemApplyAlterDO).set((Path)qItmItemApplyAlterDO.procInstId, (Object)processInfo.getProcInstId()).set(qItmItemApplyAlterDO.submitTime, (Object)LocalDateTime.now()).where(new Predicate[]{qItmItemApplyAlterDO.docNo.eq((Object)docNo)});
                if (!Objects.equals(processInfo.getProcInstStatus(), ProcInstStatus.APPROVED)) {
                    jpaUpdateClause.set(qItmItemApplyAlterDO.procInstStatus, (Object)ProcInstStatus.APPROVING);
                    jpaUpdateClause.set((Path)qItmItemApplyAlterDO.docStatus, (Object)ComUdcEnum.COM_APPLY_STATUS_DOING.getUdcVal());
                }
                jpaUpdateClause.execute();
            }
            if (!rLock.isHeldByCurrentThread()) {
                log.error("\u6301\u6709\u9501\u5df2\u8fc7\u671f");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6301\u6709\u9501\u5df2\u8fc7\u671f\uff01");
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("\u5355\u636e\u63d0\u4ea4/\u4fdd\u5b58\u5931\u8d25\uff1a" + (Exception)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void itmItemApplySave(ItmApplySaveAndCommitParam param) {
        if (CollectionUtils.isEmpty(param.getSpuIds())) {
            throw new BusinessException("\u5355\u636e\u4e2d\u6ca1\u6709\u5546\u54c1\uff0c\u4e0d\u80fd\u4fdd\u5b58\u6b64\u5355\u636e\uff0c\u8bf7\u6dfb\u52a0\u5546\u54c1");
        }
        String docNo = param.getDocNo();
        RLock rLock = this.redissonClient.getLock(docNo);
        try {
            if (!rLock.tryLock(0L, 20L, TimeUnit.SECONDS)) {
                log.error("\u83b7\u53d6\u9501\u5931\u8d25");
                throw new BusinessException("\u5355\u636e\u91cd\u590d\u63d0\u4ea4\uff1a:" + docNo);
            }
            ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
            List<Long> newSpuIds = param.getSpuIds();
            List<Long> deleteSpuList = this.findDeleteSpuList(param);
            this.itmItemApplyAlterRepoProc.itmItemApplyChange(docNo, ComUdcEnum.COM_APPLY_STATUS_DRAFT.getUdcVal());
            this.itmItemApplyAlterRepoProc.itmItemApplyChangeDesc(docNo, param.getApplyDesc());
            this.addSpuIdsChange(newSpuIds, ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal(), itemApplyDetailByDocNo.getDocType(), docNo);
            this.deleteSpuIdsChange(deleteSpuList);
            if (!rLock.isHeldByCurrentThread()) {
                log.error("\u6301\u6709\u9501\u5df2\u8fc7\u671f");
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u6301\u6709\u9501\u5df2\u8fc7\u671f\uff01");
            }
        }
        catch (BusinessException | InterruptedException e) {
            log.error("\u5355\u636e\u63d0\u4ea4/\u4fdd\u5b58\u5931\u8d25\uff1a" + (Exception)e);
            throw new BusinessException(ApiCode.FAIL, e.getMessage());
        }
        finally {
            if (rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateItemApplyByAdd(ItmItemApplyDetailsAddParam param) {
        this.itmItemApplyRepoProc.updateItemApplyDocNoByAdd(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateItemApplyByUpdate(ItmItemApplyDetailsAddParam param) {
        this.itmItemApplyRepoProc.updateItemApplyDocNoByUpdate(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void voidApplication(String docNo) {
        ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
        if (null != itemApplyDetailByDocNo) {
            String docType = itemApplyDetailByDocNo.getDocType();
            if (ItmUdcEnum.ITM_APPLY_TYPE_ITEM_NEWAPPLY.getUdcVal().equals(docType)) {
                this.itmItemApplyRepoProc.voidApplication(docNo);
                List<Long> spuIds = this.itmItemApplyRepoProc.getSpuIdByDocNo(docNo);
                List<Long> itemIds = this.itmItemApplyRepoProc.findItemIdBySpuId(spuIds);
                this.itmItemApplyCustPropRepoProc.deleteDocNoBySpuId(spuIds);
                this.itmItemApplyPropRepoProc.deleteDocNoBySpuId(spuIds);
                this.itmItemApplyQualifyRepoProc.deleteDocNoBySpuId(spuIds);
                this.itmItemApplyTagRepoProc.deleteDocNoByItemId(itemIds);
                this.itmItemApplyUomConvRepoProc.deleteDocNoByItemId(itemIds);
                this.itmItemAttachApplymentRepoProc.deleteDocNoById(itemIds);
                this.itmItemAttachApplymentRepoProc.deleteDocNoById(spuIds);
            } else if (ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal().equals(docType)) {
                this.itmItemApplyRepoProc.changeItemApplyStatusByDocNo(docNo, ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DISABLE.getUdcVal());
            }
            this.itmItemApplyAlterRepoProc.itmItemApplyChange(docNo, ComUdcEnum.COM_APPLY_STATUS_VOID.getUdcVal());
            if (!StringUtils.isEmpty((CharSequence)itemApplyDetailByDocNo.getProcInstId()) && WorkflowConstant.CAN_DELETE_PROC.contains(itemApplyDetailByDocNo.getProcInstStatus())) {
                SysUserDTO user = null;
                GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
                if (generalUserDetails == null || generalUserDetails.getUser() == null) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u5230\u83b7\u53d6\u5f53\u524d\u7528\u6237");
                }
                user = generalUserDetails.getUser();
                this.workflowService.deleteProcess(itemApplyDetailByDocNo.getProcInstId(), user.getId().longValue(), "\u4e1a\u52a1\u5355\u636e\u4f5c\u5e9f");
            }
        } else {
            throw new BusinessException("\u5355\u636e\u53f7\u4e3a" + docNo + "\u7684\u5355\u636e\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public void rejectApplication(String docNo) {
        this.itmItemApplyAlterRepoProc.itmItemApplyChange(docNo, ComUdcEnum.COM_APPLY_STATUS_REJECTED.getUdcVal());
        this.itmItemApplyRepoProc.changeItemApplyStatusByDocNo(docNo, ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DISABLE.getUdcVal());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertItemApplyComplete(String docNo) {
        ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
        if (null == itemApplyDetailByDocNo) {
            throw new BusinessException("\u5355\u636e\u53f7\uff1a" + docNo + "\u5173\u8054\u7684\u5355\u636e\u4e0d\u5b58\u5728");
        }
        this.itmItemApplyAlterRepoProc.itmItemApplyChange(docNo, ComUdcEnum.COM_APPLY_STATUS_COMPLETE.getUdcVal());
        this.itmItemApplyRepoProc.changeItemApplyStatusByDocNo(docNo, ItmUdcEnum.ITM_ITEM_APPLY_STATUS_ENABLE.getUdcVal());
        String docType = itemApplyDetailByDocNo.getDocType();
        if (ItmUdcEnum.ITM_APPLY_TYPE_ITEM_NEWAPPLY.getUdcVal().equals(docType)) {
            this.fillItemInfoToFormalItem(docNo);
        } else if (ItmUdcEnum.ITM_APPLY_TYPE_ITEM_CHANGEAPPLY.getUdcVal().equals(docType)) {
            this.updateItemInfoToFormalItem(docNo);
        } else {
            throw new BusinessException("\u5355\u636e\u7c7b\u578b\uff1a" + docType + "\u4e0d\u5b58\u5728");
        }
    }

    private void fillItemInfoToFormalItem(String docNo) {
        ItmItemApplyByDocNoVO itemApplyDetailByDocNo = this.itmItemApplyAlterRepoProc.findItemApplyDetailByDocNo(docNo);
        List<ItmItemAllApplyItemVO> itmItemAllApplyItemVOS = this.itmItemApplyRepoProc.findAllApplyItem(docNo);
        if (CollectionUtils.isEmpty(itmItemAllApplyItemVOS)) {
            return;
        }
        List taxCodes = itmItemAllApplyItemVOS.stream().map(ItmItemAllApplyItemVO::getTaxRateNo).collect(Collectors.toList());
        ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
        taxParam.setTaxRateNos(taxCodes);
        Map<String, Double> taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam).stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, ComTaxRateRpcDTO::getTaxRateValue));
        Map<Long, ItmItemDO> itmItemDOS = ItmItemApplyDConvert.INSTANCE.vosToDos(itmItemAllApplyItemVOS).stream().map(item -> {
            item.setItemStatus(ItmUdcEnum.ITM_ITEM_APPLY_STATUS_ENABLE.getUdcVal());
            item.setReleaseFlag(false);
            item.setCreateTime(LocalDateTime.now());
            item.setItemStatus2(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_ENABLE.getUdcVal());
            return item;
        }).collect(Collectors.groupingBy(BaseModel::getId)).entrySet().stream().peek(entry -> ((List)entry.getValue()).forEach(itmItem -> itmItem.setId(null))).collect(Collectors.toMap(Map.Entry::getKey, value -> (ItmItemDO)((List)value.getValue()).get(0)));
        List<Long> spuIds = itmItemAllApplyItemVOS.stream().map(ItmItemAllApplyItemVO::getSpuId).collect(Collectors.toList());
        List<Long> ids = itmItemAllApplyItemVOS.stream().map(ItmItemAllApplyItemVO::getId).collect(Collectors.toList());
        LocalDate nowDate = LocalDate.now();
        Map<String, OrgOuDTO> ouDTOMap = this.orgOuService.findAllOuDto().stream().collect(Collectors.toMap(OrgOuDTO::getBuCode, t -> t, (t1, t2) -> t1));
        ArrayList priceDos = new ArrayList();
        ArrayList purPriceSaveDTOS = new ArrayList();
        itmItemAllApplyItemVOS.forEach(item -> {
            PriMainPriceRowDO priceRowDO = new PriMainPriceRowDO();
            priceRowDO.setItemId(item.getId());
            priceRowDO.setItemCode(item.getItemCode());
            priceRowDO.setBuCode(item.getItemSource());
            priceRowDO.setPrice1(item.getPrice1());
            priceRowDO.setPrice2(item.getPrice2());
            priceRowDO.setPrice3(item.getPrice3());
            priceRowDO.setPrice4(item.getPrice4());
            priceRowDO.setPrice5(item.getPrice5());
            priceRowDO.setPrice8(item.getPrice8());
            priceRowDO.setPrice9(item.getPrice9());
            priceRowDO.setPrice10(item.getPrice10());
            priceRowDO.setSecOuId(item.getSecOuId());
            OrgOuDTO orgOuDTO = (OrgOuDTO)ouDTOMap.get(item.getItemSource());
            if (null != orgOuDTO) {
                priceRowDO.setCurrCode(orgOuDTO.getCurrCode());
            } else {
                priceRowDO.setCurrCode("CNY");
            }
            priceRowDO.setUom(item.getUom());
            priceRowDO.setValidFrom(LocalDateTime.of(nowDate, LocalTime.MIN));
            String s = nowDate.plusYears(30L) + " 23:59:59";
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            priceRowDO.setValidTo(LocalDateTime.parse(s, df));
            priceRowDO.setPriceType(PriMainPriceUdcEnum.PRI_PRICE_TYPE_ITEM_PRICE.getUdcVal());
            priceRowDO.setInstallFlag(false);
            priceRowDO.setPriceStatus(ComUdcEnum.COM_ACTIVE.getUdcVal());
            priceRowDO.setDeleteFlag(0);
            priceRowDO.setCreateTime(item.getCreateTime());
            priceRowDO.setCreateUserId(item.getCreateUserId());
            priceRowDO.setCreator(item.getCreator());
            priceRowDO.setUpdater(item.getUpdater());
            priceRowDO.setModifyTime(item.getModifyTime());
            priceRowDO.setModifyUserId(item.getModifyUserId());
            priceDos.add(priceRowDO);
            if (null != item.getBuId()) {
                PurPriceSaveDTO purPriceSaveDTO = new PurPriceSaveDTO();
                purPriceSaveDTO.setOuId(item.getOuId());
                purPriceSaveDTO.setOuName(item.getOuName());
                purPriceSaveDTO.setBuId(item.getBuId());
                purPriceSaveDTO.setItemId(item.getId());
                purPriceSaveDTO.setPrice(item.getPrice11());
                purPriceSaveDTO.setFreightTaxPrice(item.getPrice12());
                purPriceSaveDTO.setSuppId(item.getSuppId());
                purPriceSaveDTO.setTaxRateNo(item.getTaxRateNo());
                purPriceSaveDTO.setTaxRateValue((Double)taxDtos.get(item.getTaxRateNo()));
                purPriceSaveDTO.setItemBrand(item.getBrand());
                purPriceSaveDTO.setUom(item.getPurcUom());
                purPriceSaveDTO.setCreateUserId(itemApplyDetailByDocNo.getCreateUserId());
                purPriceSaveDTO.setCreator(itemApplyDetailByDocNo.getCreator());
                purPriceSaveDTO.setEmpId(itemApplyDetailByDocNo.getApplyEmpId());
                purPriceSaveDTO.setValidFrom(LocalDateTime.now());
                purPriceSaveDTOS.add(purPriceSaveDTO);
            }
        });
        List<ItmItemApplyCustPropVO> custProps = this.itmItemApplyCustPropRepoProc.findVosByItemId(spuIds, docNo);
        List<ItmItemCustPropDO> custPropDOS = ItmItemApplyCustPropConvert.INSTANCE.vosToDos(custProps);
        List<ItmItemApplyQualifyVO> qualifys = this.itmItemApplyQualifyRepoProc.findVosBySpuId(spuIds, docNo);
        List<ItmItemQualifyDO> qualifyDos = ItmItemApplyQualifyConvert.INSTANCE.vosToDos(qualifys);
        List<ItmItemApplyPropVO> props = this.itmItemApplyPropRepoProc.findVosByItemId(spuIds, docNo);
        List<ItmItemPropDO> propDOS = ItmItemApplyPropConvert.INSTANCE.vosToDos(props);
        List<ItmItemApplyAttachmentVO> spuAttachments = this.itmItemAttachApplymentRepoProc.findItemImagesByItemIdAndFileType(spuIds, docNo);
        List<ItmItemAttachmentDO> spuAttachmentDos = ItmItemApplyAttachmentConvert.INSTANCE.vosToDos(spuAttachments);
        List<ItmItemApplyUomConvVO> uom = this.itmItemApplyUomConvRepoProc.getItmItemUomConvByItemIds(ids, docNo);
        Map<Long, List<ItmItemUomConvDO>> uomDoMap = ItmItemApplyUomConvConvert.INSTANCE.vosToDos(uom).stream().collect(Collectors.groupingBy(ItmItemUomConvDO::getItemId));
        List<ItmItemApplyTagVO> tag = this.itmItemApplyTagRepoProc.searchVoByItemIdsComplete(ids, docNo);
        Map<Long, List<ItmItemTagDO>> tagDoMap = ItmItemApplyTagConvert.INSTANCE.vosToDos(tag).stream().collect(Collectors.groupingBy(ItmItemTagDO::getItemId));
        List<ItmItemApplyAttachmentVO> skuAttachments = this.itmItemAttachApplymentRepoProc.findItemImagesByItemIdAndFileType(ids, docNo);
        Map<Long, List<ItmItemAttachmentDO>> skuAttachmentMap = ItmItemApplyAttachmentConvert.INSTANCE.vosToDos(skuAttachments).stream().collect(Collectors.groupingBy(ItmItemAttachmentDO::getItemId));
        this.itmItemRepo.saveAll(itmItemDOS.values());
        this.itmItemCustPropRepo.saveAll(custPropDOS);
        this.itmItemQualifyRepo.saveAll(qualifyDos);
        this.itmItemPropRepo.saveAll(propDOS);
        this.itmItemAttachmentRepo.saveAll(spuAttachmentDos);
        uomDoMap.forEach((key, values) -> {
            Long id = ((ItmItemDO)itmItemDOS.get(key)).getId();
            values.forEach(value -> value.setItemId(id));
        });
        this.itmItemUomConvRepo.saveAll(uomDoMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        tagDoMap.forEach((key, values) -> {
            Long id = ((ItmItemDO)itmItemDOS.get(key)).getId();
            values.forEach(value -> value.setItemId(id));
        });
        this.itmItemTagRepo.saveAll(tagDoMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        skuAttachmentMap.forEach((key, values) -> {
            Long id = ((ItmItemDO)itmItemDOS.get(key)).getId();
            values.forEach(value -> value.setItemId(id));
        });
        this.itmItemAttachmentRepo.saveAll(skuAttachmentMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        priceDos.forEach(price -> {
            Long itemId = price.getItemId();
            Long newItemId = ((ItmItemDO)itmItemDOS.get(itemId)).getId();
            price.setItemId(newItemId);
        });
        purPriceSaveDTOS.forEach(purPrice -> {
            Long itemId = purPrice.getItemId();
            Long newItemId = ((ItmItemDO)itmItemDOS.get(itemId)).getId();
            purPrice.setItemId(newItemId);
        });
        this.priMainPriceRowRepo.saveAll(priceDos);
        this.purPriceProvider.savePriceBatch(purPriceSaveDTOS);
    }

    private void updateItemInfoToFormalItem(String docNo) {
        List<Long> spuIdByDocNo = this.itmItemApplyRepoProc.getSpuIdByDocNo(docNo);
        if (ONE_INTEGER.intValue() != spuIdByDocNo.size()) {
            throw new BusinessException("\u5546\u54c1\u53d8\u66f4\u5355\u636e\u4e2d\u53ea\u5141\u8bb8\u4e00\u4e2a\u5546\u54c1");
        }
        Long spuId = spuIdByDocNo.get(0);
        ItmItemApplySpuDetailsVO spuApplyDetailsBySpuId = this.itmItemApplyDService.findSpuApplyDetailsBySpuId(ItmItemSearchSpuDetailsParam.builder().docNo(docNo).id(spuId).build());
        ItmItemBaseInfoVO itmItemBaseInfo = this.itmItemApplyRepoProc.findItmItemBaseInfo(spuId);
        List<ItmItemApplySkuVO> itemSkuVos = spuApplyDetailsBySpuId.getItemSkuVos();
        List<ItmItemSkuSaveParam> itmItemSkuSaveParams = itemSkuVos.stream().map(sku -> {
            ItmItemSkuSaveParam itmItemSkuSaveParam = ItmItemApplyDConvert.INSTANCE.applyVoToParam((ItmItemApplySkuVO)sku);
            itmItemSkuSaveParam.setItemUomConvSaveParams(ItmItemApplyConvUomConvert.INSTANCE.applyVosToParams(sku.getItemUomConvVos()));
            itmItemSkuSaveParam.setItemSaveTags(ItmItemApplyTagConvert.INSTANCE.applyVosToParams(sku.getItemTags()));
            return itmItemSkuSaveParam;
        }).collect(Collectors.toList());
        ItmItemSpuSaveParam itmItemSpuSaveParam = ItmItemApplyDConvert.INSTANCE.voToSave(spuApplyDetailsBySpuId);
        itmItemSpuSaveParam.setSpuImages(ItmItemApplyAttachmentConvert.INSTANCE.applyVosToParams(spuApplyDetailsBySpuId.getSpuImages()));
        itmItemSpuSaveParam.setSpuVideos(ItmItemApplyAttachmentConvert.INSTANCE.applyVosToParams(spuApplyDetailsBySpuId.getSpuVideos()));
        itmItemSpuSaveParam.setItemCustPropSaveParams(ItmItemApplyCustPropConvert.INSTANCE.applyVosToParams(spuApplyDetailsBySpuId.getItemCustPropVos()));
        itmItemSpuSaveParam.setItemPropSaveParams(ItmItemApplyPropConvert.INSTANCE.applyVosToParams(spuApplyDetailsBySpuId.getItemPropVos()));
        itmItemSpuSaveParam.setItemQualifySaveParams(ItmItemApplyQualifyConvert.INSTANCE.applyVosToParams(spuApplyDetailsBySpuId.getItemQualifyVos()));
        itmItemSpuSaveParam.setItemSkuSaveParams(itmItemSkuSaveParams);
        List<String> itemCodes = itmItemSpuSaveParam.getItemSkuSaveParams().stream().map(ItmItemSkuSaveParam::getItemCode).collect(Collectors.toList());
        Map<String, Long> idMap = this.itmItemService.findItmItemChangInfo(itemCodes).stream().collect(Collectors.toMap(ItmItemChangUpdateVO::getItemCode, ItmItemChangUpdateVO::getId));
        itmItemSpuSaveParam.getItemSkuSaveParams().forEach(sku -> sku.setId(idMap.getOrDefault(sku.getItemCode(), null)));
        this.itmItemService.itmSpuUpdateApply(itmItemSpuSaveParam, itmItemSpuSaveParam.getItemSkuSaveParams(), itmItemBaseInfo);
        String spuCode = itmItemSpuSaveParam.getSpuCode();
        String itemSource = itmItemSpuSaveParam.getItemSource();
        List<ItmItemBusinessDO> allBySpuCodeAndBuCode = this.itmItemBusinessRepo.findAllBySpuCodeAndBuCode(spuCode, itemSource);
        if (CollectionUtils.isNotEmpty(allBySpuCodeAndBuCode)) {
            for (ItmItemBusinessDO itmItemBusinessDO : allBySpuCodeAndBuCode) {
                itmItemBusinessDO.setAllocType(itmItemSpuSaveParam.getAllocType());
                itmItemBusinessDO.setTaxRateNo(itmItemSpuSaveParam.getTaxRateNo());
                itmItemBusinessDO.setTaxRateNo2(itmItemSpuSaveParam.getTaxRateNo2());
                itmItemBusinessDO.setInstallFlag(itmItemSpuSaveParam.getInstallFlag());
                itmItemBusinessDO.setReturnExchangeFlag(itmItemSpuSaveParam.getReturnExchangeFlag());
                itmItemBusinessDO.setReturnExchangePolicy(itmItemSpuSaveParam.getReturnExchangePolicy());
                itmItemBusinessDO.setWarrantyFlag(itmItemSpuSaveParam.getWarrantyFlag());
                itmItemBusinessDO.setWarrantyPeriod(itmItemSpuSaveParam.getWarrantyPeriod());
                itmItemBusinessDO.setWarrantyPeriodUnit(itmItemSpuSaveParam.getWarrantyPeriodUnit());
            }
            this.itmItemBusinessRepo.saveAll(allBySpuCodeAndBuCode);
        }
    }

    private List<OrgEmpBuVO> getEmpBuDetail() {
        List<OrgEmpBuVO> orgEmpBuVos;
        Long userId;
        Optional<OrgEmpDO> orgEmpOptional;
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null && (orgEmpOptional = this.orgEmpRepo.findByUserId(userId = generalUserDetails.getUser().getId())).isPresent() && CollectionUtils.isNotEmpty(orgEmpBuVos = this.orgEmpBuService.findEmpBuVoByEmpIds(Collections.singletonList(orgEmpOptional.get().getId())))) {
            return orgEmpBuVos;
        }
        return Collections.emptyList();
    }

    private SysUserDTO getUserInfo() {
        SysUserDTO sysUserDTO = new SysUserDTO();
        GeneralUserDetails generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            sysUserDTO = generalUserDetails.getUser();
        }
        return sysUserDTO;
    }

    private void deleteSpuIdsChange(List<Long> deleteSpuList) {
        ItmItemApplyDetailsAddParam deleteParam = new ItmItemApplyDetailsAddParam();
        deleteParam.setSpuIds(deleteSpuList);
        deleteParam.setItemApplyStatus(ItmUdcEnum.ITM_ITEM_APPLY_STATUS_DRAFT.getUdcVal());
        this.itmItemApplyRepoProc.updateItemApplyDocNoByAdd(deleteParam);
    }

    private void addSpuIdsChange(List<Long> newSpuIds, String itemApplyStatus, String docType, String docNo) {
        ItmItemApplyDetailsAddParam newAddParam = new ItmItemApplyDetailsAddParam();
        newAddParam.setItemApplyStatus(itemApplyStatus);
        newAddParam.setSpuIds(newSpuIds);
        newAddParam.setDocType(docType);
        newAddParam.setDocNo(docNo);
        this.itmItemApplyRepoProc.updateItemApplyDocNoByAdd(newAddParam);
    }

    private List<Long> findDeleteSpuList(ItmApplySaveAndCommitParam param) {
        List<Long> oldSpuIds = this.itmItemApplyRepoProc.getSpuIdByDocNo(param.getDocNo());
        ArrayList<Long> deleteSpuList = new ArrayList<Long>();
        List<Long> newSpuIds = param.getSpuIds();
        oldSpuIds.forEach(oldSpuId -> {
            if (!newSpuIds.contains(oldSpuId)) {
                deleteSpuList.add((Long)oldSpuId);
            }
        });
        return deleteSpuList;
    }

    public ItmItemApplyServiceImpl(OrgBuRepo orgBuRepo, OrgEmpRepo orgEmpRepo, OrgEmpBuService orgEmpBuService, OrgBuService orgBuService, ItmItemCateService itmItemCateService, SysUdcService sysUdcService, ItmItemApplyAlterRepo itmItemApplyAlterRepo, ItmItemApplyRepoProc itmItemApplyRepoProc, ItmItemApplyAlterRepoProc itmItemApplyAlterRepoProc, ItmItemApplyCustPropRepoProc itmItemApplyCustPropRepoProc, ItmItemApplyPropRepoProc itmItemApplyPropRepoProc, ItmItemApplyQualifyRepoProc itmItemApplyQualifyRepoProc, ItmItemApplyTagRepoProc itmItemApplyTagRepoProc, ItmItemApplyUomConvRepoProc itmItemApplyUomConvRepoProc, ItmItemAttachApplymentRepoProc itmItemAttachApplymentRepoProc, ItmItemRepo itmItemRepo, ItmItemCustPropRepo itmItemCustPropRepo, ItmItemQualifyRepo itmItemQualifyRepo, ItmItemPropRepo itmItemPropRepo, ItmItemUomConvRepo itmItemUomConvRepo, ItmItemTagRepo itmItemTagRepo, ItmItemAttachmentRepo itmItemAttachmentRepo, PriMainPriceRowRepo priMainPriceRowRepo, ItmItemApplyDService itmItemApplyDService, ItmItemService itmItemService, OrgEmpService orgEmpService, OrgOuService orgOuService, ItmItemApplyDExportService itmItemApplyDExportService, ItmItemBusinessRepo itmItemBusinessRepo, JPAQueryFactory jpaQueryFactory, RedissonClient redissonClient) {
        this.orgBuRepo = orgBuRepo;
        this.orgEmpRepo = orgEmpRepo;
        this.orgEmpBuService = orgEmpBuService;
        this.orgBuService = orgBuService;
        this.itmItemCateService = itmItemCateService;
        this.sysUdcService = sysUdcService;
        this.itmItemApplyAlterRepo = itmItemApplyAlterRepo;
        this.itmItemApplyRepoProc = itmItemApplyRepoProc;
        this.itmItemApplyAlterRepoProc = itmItemApplyAlterRepoProc;
        this.itmItemApplyCustPropRepoProc = itmItemApplyCustPropRepoProc;
        this.itmItemApplyPropRepoProc = itmItemApplyPropRepoProc;
        this.itmItemApplyQualifyRepoProc = itmItemApplyQualifyRepoProc;
        this.itmItemApplyTagRepoProc = itmItemApplyTagRepoProc;
        this.itmItemApplyUomConvRepoProc = itmItemApplyUomConvRepoProc;
        this.itmItemAttachApplymentRepoProc = itmItemAttachApplymentRepoProc;
        this.itmItemRepo = itmItemRepo;
        this.itmItemCustPropRepo = itmItemCustPropRepo;
        this.itmItemQualifyRepo = itmItemQualifyRepo;
        this.itmItemPropRepo = itmItemPropRepo;
        this.itmItemUomConvRepo = itmItemUomConvRepo;
        this.itmItemTagRepo = itmItemTagRepo;
        this.itmItemAttachmentRepo = itmItemAttachmentRepo;
        this.priMainPriceRowRepo = priMainPriceRowRepo;
        this.itmItemApplyDService = itmItemApplyDService;
        this.itmItemService = itmItemService;
        this.orgEmpService = orgEmpService;
        this.orgOuService = orgOuService;
        this.itmItemApplyDExportService = itmItemApplyDExportService;
        this.itmItemBusinessRepo = itmItemBusinessRepo;
        this.jpaQueryFactory = jpaQueryFactory;
        this.redissonClient = redissonClient;
    }
}

