/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.apply.service.impl;

import com.elitesland.yst.common.base.ApiCode;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.apply.convert.ItmItemApplyUomConvConvert;
import com.elitesland.yst.supportdomain.item.apply.entity.ItmItemApplyUomConvDO;
import com.elitesland.yst.supportdomain.item.apply.param.ItmItemApplyUomConvSaveParam;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyUomConvRepo;
import com.elitesland.yst.supportdomain.item.apply.repo.ItmItemApplyUomConvRepoProc;
import com.elitesland.yst.supportdomain.item.apply.service.ItmItemApplyUomConvService;
import com.elitesland.yst.supportdomain.item.apply.vo.ItmItemApplyUomConvVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ItmItemApplyUomConvServiceImpl
implements ItmItemApplyUomConvService {
    private final ItmItemApplyUomConvRepoProc itmItemApplyUomConvRepoProc;
    private final ItmItemApplyUomConvRepo itmItemApplyUomConvRepo;

    @Override
    public List<ItmItemApplyUomConvVO> getItmItemUomConvByItemIds(List<Long> itemId, String docNo) {
        return this.itmItemApplyUomConvRepoProc.getItmItemUomConvByItemId(itemId, docNo);
    }

    @Override
    public void itemUomConvHardSave(List<Long> itemIds, List<ItmItemApplyUomConvSaveParam> params) {
        if (!CollectionUtils.isEmpty(itemIds)) {
            this.itmItemApplyUomConvRepoProc.deleteByItemIds(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyUomConvDO> itmItemUomConvDOS = ItmItemApplyUomConvConvert.INSTANCE.saveParamToDo(params);
        for (ItmItemApplyUomConvDO itmItemUomConvDO : itmItemUomConvDOS) {
            String toUom;
            BigDecimal conversionCoefficient = itmItemUomConvDO.getRatio();
            String fromUom = itmItemUomConvDO.getFromUom();
            if (fromUom.equals(toUom = itmItemUomConvDO.getToUom())) {
                if (conversionCoefficient != null) {
                    itmItemUomConvDO.setRevertRatio(this.judgmentConversionCoefficient(conversionCoefficient));
                }
            } else {
                if (conversionCoefficient == null) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8f6c\u6362\u7cfb\u6570\u5fc5\u586b");
                }
                itmItemUomConvDO.setRevertRatio(this.judgmentConversionCoefficient(conversionCoefficient));
            }
            this.itmItemApplyUomConvRepo.saveAll(itmItemUomConvDOS);
        }
    }

    @Override
    public void itemUomConvApplyHardSave(List<Long> itemIds, List<ItmItemApplyUomConvSaveParam> params, String docNo) {
        if (!CollectionUtils.isEmpty(itemIds)) {
            this.itmItemApplyUomConvRepoProc.deleteByItemIds(itemIds);
        }
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        List<ItmItemApplyUomConvDO> itmItemUomConvDOS = ItmItemApplyUomConvConvert.INSTANCE.saveParamToDo(params);
        for (ItmItemApplyUomConvDO itmItemUomConvDO : itmItemUomConvDOS) {
            itmItemUomConvDO.setDocNo(docNo);
            BigDecimal conversionCoefficient = itmItemUomConvDO.getRatio();
            String fromUom = itmItemUomConvDO.getFromUom();
            String toUom = itmItemUomConvDO.getToUom();
            if (fromUom.equals(toUom)) {
                if (conversionCoefficient != null) {
                    itmItemUomConvDO.setRevertRatio(this.judgmentConversionCoefficient(conversionCoefficient));
                }
            } else {
                if (conversionCoefficient == null) {
                    throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8f6c\u6362\u7cfb\u6570\u5fc5\u586b");
                }
                itmItemUomConvDO.setRevertRatio(this.judgmentConversionCoefficient(conversionCoefficient));
            }
            this.itmItemApplyUomConvRepo.saveAll(itmItemUomConvDOS);
        }
    }

    private BigDecimal judgmentConversionCoefficient(BigDecimal conversionCoefficient) {
        if (conversionCoefficient.compareTo(BigDecimal.ZERO) < 0 || BigDecimal.ZERO.compareTo(conversionCoefficient) == 0) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u8f6c\u6362\u7cfb\u6570\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        return BigDecimal.ONE.divide(conversionCoefficient, 4, RoundingMode.HALF_UP);
    }

    public ItmItemApplyUomConvServiceImpl(ItmItemApplyUomConvRepoProc itmItemApplyUomConvRepoProc, ItmItemApplyUomConvRepo itmItemApplyUomConvRepo) {
        this.itmItemApplyUomConvRepoProc = itmItemApplyUomConvRepoProc;
        this.itmItemApplyUomConvRepo = itmItemApplyUomConvRepo;
    }
}

