/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemGiftSkuToBusinessParam;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemGiftSkuToBusinessVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSkuToBusinessVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSpuToBusinessVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemToBParam;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemToBPropVO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemPropDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemSalePropVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItemToBComponentRepoProc {
    private static final String DESC_PROP = "DESC_PROP";
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;
    private final QItmItemBusinessDO itmBusiness = QItmItemBusinessDO.itmItemBusinessDO;
    private final QItmItemPropDO itemProp = QItmItemPropDO.itmItemPropDO;
    private final QItmItemBusinessStatusDO itemBusinessStatus = QItmItemBusinessStatusDO.itmItemBusinessStatusDO;

    public List<ItmItemSpuToBusinessVO> findItmItemBusinessSpuInfo(ItmItemToBParam param) {
        List spuIds;
        List spuCodes;
        List buCodes;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(param.getBuCodes()) && CollectionUtils.isNotEmpty(buCodes = param.getBuCodes().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.itmBusiness.buCode.in(buCodes));
        }
        if (CollectionUtils.isNotEmpty(param.getSpuCodes()) && CollectionUtils.isNotEmpty(spuCodes = param.getSpuCodes().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.itmItem.spuCode.in(spuCodes));
        }
        if (CollectionUtils.isNotEmpty(param.getSpuIds()) && CollectionUtils.isNotEmpty(spuIds = param.getSpuIds().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.itmItem.spuId.in(spuIds));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        QItmBrandDO brand = QItmBrandDO.itmBrandDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSpuToBusinessVO.class, (Expression[])new Expression[]{this.itmItem.spuId, this.itmItem.suppId, this.itmItem.suppName, this.itmBusiness.buCode, this.itmBusiness.itemSource, this.itmItem.itemType2, this.itmItem.itemType, this.itmItem.spuCode, this.itmItem.spuName, this.itmItem.suppCode, this.itmItem.itemCateCode, brand.brandName.as("brand"), this.itmItem.spec, this.itmBusiness.allocType, this.itmBusiness.installFlag, this.itmBusiness.returnExchangeFlag, this.itmBusiness.returnExchangePolicy, this.itmBusiness.warrantyFlag, this.itmBusiness.warrantyPeriod, this.itmBusiness.warrantyPeriodUnit})).from((EntityPath)this.itmBusiness)).leftJoin((EntityPath)this.itmItem)).on((Predicate)this.itmBusiness.spuId.eq(this.itmItem.spuId).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).leftJoin((EntityPath)brand)).on((Predicate)brand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)brand.deleteFlag.isNull().or((Predicate)brand.deleteFlag.eq((Object)0))))).where(ExpressionUtils.allOf(predicates))).groupBy(this.itmItem.spuId);
        return query.fetch();
    }

    public List<Long> findSpuIdByItemId(List<Long> itemIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.itmItem.spuId).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.id.in(itemIds))).fetch();
    }

    public List<ItmItemSkuToBusinessVO> findSkuInfosBySpuId(Long spuId, List<Long> itemIds, String buCode) {
        List itemIdList;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(itemIds) && CollectionUtils.isNotEmpty(itemIdList = itemIds.stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.itmItem.id.in(itemIdList));
        }
        predicates.add(this.itmItem.spuId.eq((Object)spuId));
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSkuToBusinessVO.class, (Expression[])new Expression[]{this.itmItem.id.as("itemId"), this.itmItem.itemCode, this.itmItem.itemName, this.itmItem.barCode, this.itmItem.grossWeight, this.itmItem.weightUnit, this.itmItem.suppCode, this.itmItem.packageSpec, this.itmItem.volume, this.itmItem.volumeUnit, this.itmItem.saleUom, this.itmItem.uom, this.itemBusinessStatus.itemLifeStatus})).from((EntityPath)this.itmItem)).leftJoin((EntityPath)this.itemBusinessStatus)).on((Predicate)this.itmItem.itemCode.eq((Expression)this.itemBusinessStatus.itemCode).and((Predicate)this.itemBusinessStatus.buCode.eq((Object)buCode)))).where(ExpressionUtils.allOf(predicates))).fetch();
    }

    public List<ItmItemToBPropVO> findItemDescPropByItemId(Long itemId) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemToBPropVO.class, (Expression[])new Expression[]{this.itemProp.catePropCode.as("propCode"), this.itemProp.catePropName.as("propName"), this.itemProp.propValue.as("propValue")})).from((EntityPath)this.itemProp)).where((Predicate)this.itemProp.itemId.eq((Object)itemId).and((Predicate)this.itemProp.catePropType.eq((Object)DESC_PROP)).and((Predicate)this.itemProp.deleteFlag.isNull().or((Predicate)this.itemProp.deleteFlag.eq((Object)0))));
        return query.fetch();
    }

    public List<ItmItemSalePropVO> findSalePropByItemCode(List<String> itemCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSalePropVO.class, (Expression[])new Expression[]{this.itmItem.itemCode, this.itmItem.itemAttr})).from((EntityPath)this.itmItem)).where((Predicate)this.itmItem.itemCode.in(itemCodes))).fetch();
    }

    public PagingVO<ItmItemGiftSkuToBusinessVO> findItemGiftSkuToBByParam(ItmItemGiftSkuToBusinessParam param) {
        String strLike;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            strLike = "%" + param.getItemCode() + "%";
            predicates.add(this.itmItem.itemCode.like(strLike));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemName())) {
            strLike = "%" + param.getItemName() + "%";
            predicates.add(this.itmItem.itemName.like(strLike));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBuCode())) {
            predicates.add(this.itmBusiness.buCode.eq((Object)param.getBuCode()));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemGiftSkuToBusinessVO.class, (Expression[])new Expression[]{this.itmItem.itemCode, this.itmItem.itemName, this.itmBusiness.buCode})).from((EntityPath)this.itmItem)).innerJoin((EntityPath)this.itmBusiness)).on((Predicate)this.itmItem.spuId.eq(this.itmBusiness.spuId))).where((Predicate)this.itmItem.itemType2.eq((Object)ItmUdcEnum.ITM_ITM_TYPE2_30.getUdcVal()));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmItem);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItemToBComponentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

