/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.item.component.param.ItmBrandComPagingParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemBusinessComPagingParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemSkuComPagingParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemSkuPriComPagingParam;
import com.elitesland.yst.supportdomain.item.component.vo.ItmBrandComPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemBusinessComPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSkuComPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSkuPriComPagingVO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmComponentRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO itmItem = QItmItemDO.itmItemDO;
    private final QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
    private final QItmItemBusinessDO itmItemBusinessDO = QItmItemBusinessDO.itmItemBusinessDO;

    public PagingVO<ItmItemSkuComPagingVO> itemSkuComPagingSearch(ItmItemSkuComPagingParam param) {
        String likeStr;
        List itemType2s;
        List ids;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSkuComPagingVO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.itemName, this.itmItem.itemAbbr, this.itmItem.outerCode, this.itmItem.barCode, this.itmItem.itemCateCode, this.itmItem.itemType, this.itmItem.itemType2, this.itmItem.itemStatus, this.itmItem.spec, this.itmItem.brand, this.itmBrand.brandName, this.itmItem.packageSpec, this.itmItem.uom, this.itmItem.pricingUom, this.itmItem.shipUom, this.itmItem.purcUom, this.itmItem.grossWeight, this.itmItem.netWeight, this.itmItem.weightUnit, this.itmItem.volume, this.itmItem.volumeUnit, this.itmItem.allocType, this.itmItem.suppId, this.itmItem.suppCode, this.itmItem.suppName, this.itmItem.taxRateNo.as("taxCode"), this.itmItem.taxRateNo2.as("taxCode2"), this.itmItem.taxRateTariff, this.itmItem.installFlag, this.itmItem.lotFlag, this.itmItem.guaranteeFlag, this.itmItem.guaranteePeriod, this.itmItem.guaranteePeriodUnit, this.itmItem.guaranteeDays, this.itmItem.itemStatus2})).from((EntityPath)this.itmItem)).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmItem.brand.eq((Expression)this.itmBrand.brandCode).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(param.getIds()) && CollectionUtils.isNotEmpty(ids = param.getIds().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.itmItem.id.in(ids));
        }
        if (CollectionUtils.isNotEmpty(param.getItemType2s()) && CollectionUtils.isNotEmpty(itemType2s = param.getItemType2s().stream().filter(Objects::nonNull).collect(Collectors.toList()))) {
            predicates.add(this.itmItem.itemType2.in(itemType2s));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCodeName())) {
            likeStr = "%" + param.getItemCodeName() + "%";
            predicates.add(this.itmItem.itemCode.like(likeStr).or((Predicate)this.itmItem.itemName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemName())) {
            likeStr = "%" + param.getItemName() + "%";
            predicates.add(this.itmItem.itemName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCode())) {
            likeStr = "%" + param.getItemCode() + "%";
            predicates.add(this.itmItem.itemCode.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSpec())) {
            likeStr = "%" + param.getSpec() + "%";
            predicates.add(this.itmItem.spec.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBrandCodeName())) {
            likeStr = "%" + param.getBrandCodeName() + "%";
            predicates.add(this.itmBrand.brandCode.like(likeStr).or((Predicate)this.itmBrand.brandName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType2())) {
            Object[] splitItemType2 = param.getItemType2().split(",");
            predicates.add(this.itmItem.itemType2.in(splitItemType2));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSuppCodeName())) {
            likeStr = "%" + param.getSuppCodeName() + "%";
            predicates.add(this.itmItem.suppCode.like(likeStr).or((Predicate)this.itmItem.suppName.like(likeStr)));
        }
        if (null != param.getLotFlag()) {
            predicates.add(this.itmItem.lotFlag.eq(param.getLotFlag()));
        }
        predicates.add(this.itmItem.itemStatus.eq((Object)ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal()));
        predicates.add(this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0)));
        predicates.add(this.itmItem.cat.eq((Object)"0"));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmItem);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public PagingVO<ItmItemSkuPriComPagingVO> itemSkuPriComPagingSearch(ItmItemSkuPriComPagingParam param) {
        String likeStr;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSkuPriComPagingVO.class, (Expression[])new Expression[]{this.itmItem.id, this.itmItem.itemCode, this.itmItem.itemName, this.itmItem.itemAbbr, this.itmItem.outerCode, this.itmItem.barCode, this.itmItem.itemCateCode, this.itmItem.itemType, this.itmItem.itemType2, this.itmItem.spec, this.itmItem.brand, this.itmBrand.brandName, this.itmItem.itemSource, this.itmItem.uom, this.itmItem.pricingUom, this.itmItem.shipUom, this.itmItem.purcUom})).from((EntityPath)this.itmItem)).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmItem.brand.eq((Expression)this.itmBrand.brandCode).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))));
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemCodeName())) {
            likeStr = "%" + param.getItemCodeName() + "%";
            predicates.add(this.itmItem.itemCode.like(likeStr).or((Predicate)this.itmItem.itemName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSpec())) {
            likeStr = "%" + param.getSpec() + "%";
            predicates.add(this.itmItem.spec.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.itmItem.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getBrandCodeName())) {
            likeStr = "%" + param.getBrandCodeName() + "%";
            predicates.add(this.itmBrand.brandCode.like(likeStr).or((Predicate)this.itmBrand.brandName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItem.itemType2.eq((Object)param.getItemType2()));
        }
        predicates.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.itmItem.getMetadata()));
        predicates.add(this.itmItem.itemStatus.eq((Object)ItmUdcEnum.ITEM_STATUS_ENABLE.getUdcVal()));
        predicates.add(this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0)));
        predicates.add(this.itmItem.cat.eq((Object)"0"));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmItem);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public PagingVO<ItmBrandComPagingVO> findBrandComPaging(ItmBrandComPagingParam param) {
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmBrandComPagingVO.class, (Expression[])new Expression[]{this.itmBrand.id, this.itmBrand.brandCode, this.itmBrand.brandName, this.itmBrand.brandEnName, this.itmBrand.brandInitial, this.itmBrand.fileCode, this.itmBrand.originalName, this.itmBrand.status})).from((EntityPath)this.itmBrand);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (!StringUtils.isEmpty((CharSequence)param.getBrandCodeName())) {
            String likeStr = "%" + param.getBrandCodeName() + "%";
            predicates.add(this.itmBrand.brandCode.like(likeStr).or((Predicate)this.itmBrand.brandName.like(likeStr).or((Predicate)this.itmBrand.brandEnName.like(likeStr))));
        }
        predicates.add(this.itmBrand.status.eq((Object)ItmUdcEnum.BRAND_STATUS_ENABLE.getUdcVal()));
        predicates.add(this.itmBrand.deleteFlag.eq((Object)0).or((Predicate)this.itmBrand.deleteFlag.isNull()));
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.itmBrand);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public PagingVO<ItmItemBusinessComPagingVO> selectPagingResult(ItmItemBusinessComPagingParam param, List<String> buCodes) {
        String likeStr;
        QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessComPagingVO.class, (Expression[])new Expression[]{this.itmItemBusinessDO.id, this.itmItem.spuCode, this.itmItem.spuName, this.itmItem.itemType, this.itmItem.itemType2, this.itmItem.itemCateCode, itmBrand.brandName, this.itmItem.suppName, this.itmItemBusinessDO.allocType, this.itmItemBusinessDO.taxRateNo, this.itmItemBusinessDO.taxRateNo2, this.itmItemBusinessDO.taxRateTariff, this.itmItemBusinessDO.installFlag, this.itmItemBusinessDO.returnExchangeFlag, this.itmItemBusinessDO.warrantyFlag, this.itmItemBusinessDO.createTime})).from((EntityPath)this.itmItemBusinessDO)).leftJoin((EntityPath)this.itmItem)).on((Predicate)this.itmItem.spuId.eq(this.itmItemBusinessDO.spuId).and((Predicate)this.itmItem.deleteFlag.isNull().or((Predicate)this.itmItem.deleteFlag.eq((Object)0))))).leftJoin((EntityPath)itmBrand)).on((Predicate)itmBrand.brandCode.eq((Expression)this.itmItem.brand).and((Predicate)itmBrand.deleteFlag.isNull().or((Predicate)itmBrand.deleteFlag.eq((Object)0))));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty(buCodes)) {
            predicates.add(this.itmItemBusinessDO.buCode.in(buCodes));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSpuCodeName())) {
            likeStr = "%" + param.getSpuCodeName() + "%";
            predicates.add(this.itmItem.spuCode.like(likeStr).or((Predicate)this.itmItem.spuName.like(likeStr)));
        }
        if (!StringUtils.isBlank((CharSequence)param.getBrand())) {
            likeStr = "%" + param.getBrand() + "%";
            predicates.add(itmBrand.brandCode.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getBrandName())) {
            likeStr = "%" + param.getBrandName() + "%";
            predicates.add(itmBrand.brandName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemCateCode())) {
            likeStr = "%" + param.getItemCateCode() + "%";
            predicates.add(this.itmItem.itemCateCode.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppName())) {
            likeStr = "%" + param.getSuppName() + "%";
            predicates.add(this.itmItem.suppName.like(likeStr));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType())) {
            predicates.add(this.itmItem.itemType.eq((Object)param.getItemType()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.itmItem.itemType2.eq((Object)param.getItemType2()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getSuppCode())) {
            predicates.add(this.itmItem.suppCode.eq((Object)param.getSuppCode()));
        }
        if (!StringUtils.isBlank((CharSequence)param.getItemStatus())) {
            predicates.add(this.itmItem.itemStatus.eq((Object)param.getItemStatus()));
        }
        if (CollectionUtils.isNotEmpty(param.getBuTreeDIds())) {
            predicates.add(this.itmItemBusinessDO.buTreeDId.in(param.getBuTreeDIds()));
        }
        predicates.add(this.itmItemBusinessDO.deleteFlag.isNull().or((Predicate)this.itmItemBusinessDO.deleteFlag.eq((Object)0)));
        query.where(ExpressionUtils.allOf(predicates));
        query.groupBy(this.itmItem.spuId);
        param.fillOrders(query, this.itmItemBusinessDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public ItmComponentRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

