/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.repo;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemCheckBFreezeParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemLifeBParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemLifeListParam;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemLifeListPagingVO;
import com.elitesland.yst.supportdomain.item.entity.QItmBrandDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemBusinessStatusDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemDO;
import com.elitesland.yst.supportdomain.item.entity.QItmItemLifeStatusDO;
import com.elitesland.yst.supportdomain.item.vo.ItmCheckBusinessStatusVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemBusinessStatusVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemLifeStatusVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSkuVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ItmItemLifeRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QItmItemDO qItmItemDO = QItmItemDO.itmItemDO;
    private final QItmItemBusinessDO qItmItemBusinessDO = QItmItemBusinessDO.itmItemBusinessDO;
    private final QItmBrandDO itmBrand = QItmBrandDO.itmBrandDO;
    private final QItmItemBusinessStatusDO itemBusinessStatus = QItmItemBusinessStatusDO.itmItemBusinessStatusDO;
    private final QItmItemLifeStatusDO itmItemLifeStatus = QItmItemLifeStatusDO.itmItemLifeStatusDO;

    public PagingVO<ItmItemLifeListPagingVO> findItemLifeListPagingByParam(ItmItemLifeListParam param) {
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemNameCode())) {
            String likeStr = "%" + param.getItemNameCode() + "%";
            predicates.add(this.qItmItemDO.itemCode.like(likeStr).or((Predicate)this.qItmItemDO.itemName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemSource())) {
            predicates.add(this.qItmItemDO.itemSource.eq((Object)param.getItemSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.qItmItemDO.itemType2.eq((Object)param.getItemType2()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.qItmItemDO.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSuppName())) {
            predicates.add(this.qItmItemDO.suppName.eq((Object)param.getSuppName()));
        }
        predicates.add(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qItmItemDO.getMetadata()));
        predicates.add(this.qItmItemDO.cat.eq((Object)"0"));
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeListPagingVO.class, (Expression[])new Expression[]{this.qItmItemDO.id.as("itemId"), this.qItmItemDO.itemSource, this.qItmItemDO.itemCateCode, this.qItmItemDO.itemCode, this.qItmItemDO.itemName, this.itmBrand.brandName.as("brand"), this.qItmItemDO.itemType2, this.qItmItemDO.itemType, this.qItmItemDO.salepurcFlag, this.qItmItemDO.suppName})).from((EntityPath)this.qItmItemDO)).where(ExpressionUtils.allOf(predicates))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.qItmItemDO.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))));
        param.fillOrders(query, this.qItmItemDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public PagingVO<ItmItemLifeListPagingVO> findItemLifeBPagingByParam(ItmItemLifeBParam param) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StringUtils.isNotBlank((CharSequence)param.getItemNameCode())) {
            String likeStr = "%" + param.getItemNameCode() + "%";
            predicates.add(this.qItmItemDO.itemCode.like(likeStr).or((Predicate)this.qItmItemDO.itemName.like(likeStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemType2())) {
            predicates.add(this.qItmItemDO.itemType2.eq((Object)param.getItemType2()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getItemCateCode())) {
            predicates.add(this.qItmItemDO.itemCateCode.eq((Object)param.getItemCateCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSuppName())) {
            predicates.add(this.qItmItemDO.suppName.eq((Object)param.getSuppName()));
        }
        predicates.add(this.qItmItemBusinessDO.buCode.eq((Object)param.getOuBuCode()));
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeListPagingVO.class, (Expression[])new Expression[]{this.qItmItemBusinessDO.id.as("itemId"), this.qItmItemBusinessDO.itemSource, this.qItmItemBusinessDO.buCode, this.qItmItemDO.itemCode, this.qItmItemDO.itemCateCode, this.qItmItemDO.itemName, this.itmBrand.brandName.as("brand"), this.qItmItemDO.itemType2, this.qItmItemDO.itemType, this.qItmItemDO.salepurcFlag, this.qItmItemDO.suppCode, this.qItmItemDO.suppName})).from((EntityPath)this.qItmItemDO)).innerJoin((EntityPath)this.qItmItemBusinessDO)).on((Predicate)this.qItmItemDO.spuId.eq(this.qItmItemBusinessDO.spuId))).leftJoin((EntityPath)this.itmBrand)).on((Predicate)this.itmBrand.brandCode.eq((Expression)this.qItmItemDO.brand).and((Predicate)this.itmBrand.deleteFlag.isNull().or((Predicate)this.itmBrand.deleteFlag.eq((Object)0))))).where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, this.qItmItemDO);
        param.setPaging(query);
        return PagingVO.builder().total(Long.valueOf(query.fetchCount())).records(query.fetch()).build();
    }

    public List<ItmItemSkuVO> findItemLifeStatusList(List<Long> itemIds, String checkItemLifeStatus) {
        String likeStr = "%" + checkItemLifeStatus + "%";
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemSkuVO.class, (Expression[])new Expression[]{this.qItmItemDO.id, this.qItmItemDO.itemName, this.qItmItemDO.itemStatus2})).from((EntityPath)this.qItmItemDO)).where((Predicate)this.qItmItemDO.id.in(itemIds).and((Predicate)this.qItmItemDO.itemStatus2.like(likeStr)))).fetch();
    }

    public List<ItmItemBusinessStatusVO> findBusinessLifeStatusList(List<ItmItemCheckBFreezeParam> bFreezeList, String checkItemLifeStatus) {
        ArrayList predicates = new ArrayList();
        String likeStr = "%" + checkItemLifeStatus + "%";
        bFreezeList.forEach(freeze -> predicates.add(this.itemBusinessStatus.itemId.eq((Object)freeze.getItemId()).and((Predicate)this.itemBusinessStatus.buCode.eq((Object)freeze.getBuCode()))));
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemBusinessStatusVO.class, (Expression[])new Expression[]{this.itemBusinessStatus.itemId, this.qItmItemDO.itemName, this.itemBusinessStatus.buCode, this.itemBusinessStatus.itemLifeStatus})).from((EntityPath)this.itemBusinessStatus)).leftJoin((EntityPath)this.qItmItemDO)).on((Predicate)this.itemBusinessStatus.itemId.eq(this.qItmItemDO.id))).where((Predicate)this.itemBusinessStatus.itemLifeStatus.like(likeStr))).where(ExpressionUtils.anyOf(predicates))).fetch();
    }

    public List<ItmItemLifeStatusVO> findItemLifeStatusOnTime(List<String> itemCodes, LocalDateTime time) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatus.itemCode, this.itmItemLifeStatus.buCode, this.itmItemLifeStatus.itemSource, this.itmItemLifeStatus.branchPlant, this.itmItemLifeStatus.itemLifeStatus, this.itmItemLifeStatus.globalOrNot})).from((EntityPath)this.itmItemLifeStatus)).where((Predicate)this.itmItemLifeStatus.itemCode.in(itemCodes))).where((Predicate)this.itmItemLifeStatus.validFrom.loe((Comparable)time).and((Predicate)this.itmItemLifeStatus.validTo.goe((Comparable)time)))).fetch();
    }

    public List<ItmItemLifeStatusVO> findBusinessLifeStatusOnTime(List<ItmCheckBusinessStatusVO> businesses, LocalDateTime time) {
        ArrayList predicates = new ArrayList();
        businesses.forEach(business -> predicates.add(this.itmItemLifeStatus.itemCode.eq((Object)business.getItemCode()).and((Predicate)this.itmItemLifeStatus.branchPlant.eq((Object)business.getBuCode()))));
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatus.itemCode, this.itmItemLifeStatus.buCode, this.itmItemLifeStatus.itemSource, this.itmItemLifeStatus.branchPlant, this.itmItemLifeStatus.itemLifeStatus, this.itmItemLifeStatus.globalOrNot})).from((EntityPath)this.itmItemLifeStatus)).where(ExpressionUtils.anyOf(predicates))).where((Predicate)this.itmItemLifeStatus.validFrom.loe((Comparable)time).and((Predicate)this.itmItemLifeStatus.validTo.goe((Comparable)time)))).fetch();
    }

    public List<ItmItemLifeStatusVO> findGlobalLifeStatusOnTime(List<String> itemCodes, LocalDateTime time) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ItmItemLifeStatusVO.class, (Expression[])new Expression[]{this.itmItemLifeStatus.itemCode, this.itmItemLifeStatus.buCode, this.itmItemLifeStatus.itemSource, this.itmItemLifeStatus.branchPlant, this.itmItemLifeStatus.itemLifeStatus, this.itmItemLifeStatus.globalOrNot})).from((EntityPath)this.itmItemLifeStatus)).where((Predicate)this.itmItemLifeStatus.itemCode.in(itemCodes).and((Predicate)this.itmItemLifeStatus.globalOrNot.eq(Boolean.valueOf(true))))).where((Predicate)this.itmItemLifeStatus.validFrom.loe((Comparable)time).and((Predicate)this.itmItemLifeStatus.validTo.goe((Comparable)time)))).fetch();
    }

    public ItmItemLifeRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

