/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.service.impl;

import cn.hutool.json.JSONUtil;
import com.elitesland.sale.dto.PriBasePriceDTO;
import com.elitesland.sale.dto.query.PriBasePriceReqDTO;
import com.elitesland.sale.dto.query.PriSaleItemReqDTO;
import com.elitesland.sale.service.PriSalePriceRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemGiftSkuToBusinessParam;
import com.elitesland.yst.supportdomain.item.component.repo.ItemToBComponentRepoProc;
import com.elitesland.yst.supportdomain.item.component.service.ItemBusinessToBService;
import com.elitesland.yst.supportdomain.item.component.vo.ItemAttrJsonEntity;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemGiftSkuToBusinessVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSkuToBusinessVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSpuToBusinessVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemToBParam;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemToBPropVO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.provider.vo.ItmItemLifeStatusFilterVO;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepoProc;
import com.elitesland.yst.supportdomain.item.vo.ItmItemStatusConfigVO;
import com.elitesland.yst.supportdomain.pri.repo.PriMainPriceRowRepoProc;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.provider.item.vo.ItmItemSalePropVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

@Service
public class ItemBusinessToBServiceImpl
implements ItemBusinessToBService {
    private final ItemToBComponentRepoProc itemToBComponentRepoProc;
    private final PriMainPriceRowRepoProc priMainPriceRowRepoProc;
    private final ItmItemStatusConfigRepoProc itmItemStatusConfigRepoProc;
    @DubboReference(version="${provider.service.version}")
    private PriSalePriceRpcService priSalePriceRpcService;

    @Override
    @SysCodeProc
    public List<ItmItemSpuToBusinessVO> findItemToBRpcDtoByParam(ItmItemToBParam param) {
        if (null == param.getOuId()) {
            throw new BusinessException("\u8bf7\u586b\u5199\u516c\u53f8\u7684id");
        }
        if (CollectionUtils.isNotEmpty(param.getItemIds())) {
            List<Long> spuIdByItemId = this.itemToBComponentRepoProc.findSpuIdByItemId(param.getItemIds());
            if (CollectionUtils.isNotEmpty(param.getSpuIds())) {
                spuIdByItemId.addAll(param.getSpuIds());
            }
            param.setSpuIds(spuIdByItemId.stream().distinct().collect(Collectors.toList()));
        }
        List<ItmItemSpuToBusinessVO> itmItemBusinessSpuInfo = this.itemToBComponentRepoProc.findItmItemBusinessSpuInfo(param);
        return this.fillItemInfo(itmItemBusinessSpuInfo, param.getItemIds(), param.getOuId());
    }

    @Override
    public PagingVO<ItmItemGiftSkuToBusinessVO> findItemGiftSkuToBByParam(ItmItemGiftSkuToBusinessParam param) {
        return this.itemToBComponentRepoProc.findItemGiftSkuToBByParam(param);
    }

    private List<ItmItemSpuToBusinessVO> fillItemInfo(List<ItmItemSpuToBusinessVO> result, List<Long> itemIds, Long ouId) {
        return result.stream().map(spu -> {
            Long spuId = spu.getSpuId();
            List<ItmItemSkuToBusinessVO> skuVos = this.itemToBComponentRepoProc.findSkuInfosBySpuId(spuId, itemIds, spu.getBuCode());
            PriBasePriceReqDTO priBasePriceReqDTO = new PriBasePriceReqDTO();
            priBasePriceReqDTO.setOuId(ouId);
            priBasePriceReqDTO.setItems(skuVos.stream().map(sku -> {
                PriSaleItemReqDTO priSaleItemReqDTO = new PriSaleItemReqDTO();
                priSaleItemReqDTO.setItemId(sku.getItemId());
                priSaleItemReqDTO.setUom(sku.getUom());
                return priSaleItemReqDTO;
            }).collect(Collectors.toList()));
            PriBasePriceDTO data = (PriBasePriceDTO)this.priSalePriceRpcService.findBasePriceDto(priBasePriceReqDTO).getData();
            List priceList = data.getPriceList();
            Map basePriceMap = priceList.stream().collect(HashMap::new, (m, v) -> m.put(v.getItemCode(), v.getBasePrice()), HashMap::putAll);
            if (CollectionUtils.isNotEmpty(skuVos)) {
                List<String> itemCodeList = skuVos.stream().map(ItmItemSkuToBusinessVO::getItemCode).collect(Collectors.toList());
                Map<String, ItmItemSalePropVO> salePropByItemCodeMap = this.itemToBComponentRepoProc.findSalePropByItemCode(itemCodeList).stream().collect(Collectors.toMap(ItmItemSalePropVO::getItemCode, t -> t));
                Map<String, PriItemPricePagingVO> skuPriceMap = this.priMainPriceRowRepoProc.searchMainPrice(itemCodeList, true).stream().collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, t -> t));
                ArrayList<ItmItemToBPropVO> allSalePropList = new ArrayList<ItmItemToBPropVO>();
                String allocType = spu.getAllocType();
                skuVos.forEach(sku -> {
                    if (null != basePriceMap.get(sku.getItemCode())) {
                        sku.setBasePrice((BigDecimal)basePriceMap.get(sku.getItemCode()));
                    }
                    sku.setAllocType(allocType);
                    String itemCode = sku.getItemCode();
                    if (skuPriceMap.containsKey(itemCode)) {
                        PriItemPricePagingVO priItemPricePagingSyncDTO = (PriItemPricePagingVO)skuPriceMap.get(itemCode);
                        sku.setPrice1(priItemPricePagingSyncDTO.getPrice1());
                        sku.setPrice2(priItemPricePagingSyncDTO.getPrice2());
                        List<ItmItemToBPropVO> itmItemPropDTOS = this.jsonToItemAttrJsonEntity(((ItmItemSalePropVO)salePropByItemCodeMap.get(itemCode)).getItemAttr());
                        if (CollectionUtils.isNotEmpty(itmItemPropDTOS)) {
                            sku.setSalePropList(itmItemPropDTOS);
                            allSalePropList.addAll(itmItemPropDTOS);
                        }
                    }
                });
                spu.setAllSalePropList(allSalePropList);
                spu.setSkuList(skuVos);
            }
            spu.setDescPropList(this.itemToBComponentRepoProc.findItemDescPropByItemId(spuId));
            return spu;
        }).collect(Collectors.toList());
    }

    private List<ItmItemToBPropVO> jsonToItemAttrJsonEntity(String itemAttr) {
        if (StringUtils.isBlank((CharSequence)itemAttr)) {
            return Collections.emptyList();
        }
        ArrayList<ItmItemToBPropVO> props = new ArrayList<ItmItemToBPropVO>();
        Pattern pat = Pattern.compile("(\\{).*?(})");
        Matcher mat = pat.matcher(itemAttr);
        while (mat.find()) {
            ItmItemToBPropVO prop = new ItmItemToBPropVO();
            ItemAttrJsonEntity responseInfo = (ItemAttrJsonEntity)JSONUtil.toBean((String)mat.group(), ItemAttrJsonEntity.class);
            prop.setPropCode(responseInfo.getCode());
            prop.setPropName(responseInfo.getName());
            prop.setPropValue(responseInfo.getValue());
            props.add(prop);
        }
        return props;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ItmItemLifeStatusFilterVO getFilterCondition(String businessCode, String businExcuSignStatus) {
        ItmItemLifeStatusFilterVO result = new ItmItemLifeStatusFilterVO();
        if (StringUtils.isNotBlank((CharSequence)businessCode) && StringUtils.isNotBlank((CharSequence)businExcuSignStatus)) {
            List<ItmItemStatusConfigVO> statusVos = this.itmItemStatusConfigRepoProc.findStatusVOByBusinessCode(businessCode);
            if (CollectionUtils.isEmpty(statusVos)) {
                throw new BusinessException("\u4e1a\u52a1\u7f16\u7801\u65e0\u5bf9\u5e94\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e1a\u52a1\u7f16\u7801\uff1a" + businessCode);
            }
            ItmItemStatusConfigVO itmItemStatusConfigVO = statusVos.get(0);
            if (!itmItemStatusConfigVO.getConfigStatus().booleanValue()) return result;
            if (businExcuSignStatus.contains(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal())) {
                Boolean purcFlag = itmItemStatusConfigVO.getBusinExcuSignStatus3();
                if (null == purcFlag) {
                    throw new BusinessException("\u8be5\u4e1a\u52a1\u7f16\u7801\u5e76\u6ca1\u6709\u914d\u7f6e\u91c7\u8d2d\u51bb\u7ed3" + businessCode);
                }
                if (purcFlag.booleanValue()) return result;
                result.setPurcFreeze(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal());
                return result;
            } else {
                if (!businExcuSignStatus.contains(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal())) throw new BusinessException("\u9519\u8bef\u7684\u5546\u54c1\u51bb\u7ed3\u7c7b\u578b\uff1a" + businExcuSignStatus);
                Boolean saleFlag = itmItemStatusConfigVO.getBusinExcuSignStatus2();
                if (null == saleFlag) {
                    throw new BusinessException("\u8be5\u4e1a\u52a1\u7f16\u7801\u5e76\u6ca1\u6709\u914d\u7f6e\u9500\u552e\u51bb\u7ed3" + businessCode);
                }
                if (saleFlag.booleanValue()) return result;
                result.setSaleFreeze(ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal());
            }
            return result;
        } else {
            if (!StringUtils.isBlank((CharSequence)businessCode) || !StringUtils.isBlank((CharSequence)businExcuSignStatus)) throw new BusinessException("\u4e1a\u52a1\u7f16\u7801\u4e0e\u4e1a\u52a1\u6267\u884c\u6807\u8bc6\u72b6\u6001\u5fc5\u987b\u90fd\u4e3a\u7a7a\u6216\u90fd\u4e0d\u4e3a\u7a7a");
            return result;
        }
    }

    public ItemBusinessToBServiceImpl(ItemToBComponentRepoProc itemToBComponentRepoProc, PriMainPriceRowRepoProc priMainPriceRowRepoProc, ItmItemStatusConfigRepoProc itmItemStatusConfigRepoProc) {
        this.itemToBComponentRepoProc = itemToBComponentRepoProc;
        this.priMainPriceRowRepoProc = priMainPriceRowRepoProc;
        this.itmItemStatusConfigRepoProc = itmItemStatusConfigRepoProc;
    }
}

