/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.service.impl;

import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemToSCParam;
import com.elitesland.yst.supportdomain.item.component.repo.ItmItemToSCComponentRepoProc;
import com.elitesland.yst.supportdomain.item.component.service.ItemBusinessToSCService;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSpuToSCBusinessPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemToBPropVO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemBusinessToSCServiceImpl
implements ItemBusinessToSCService {
    private static final String DESC_PROP_NAME = "\u5e8f\u5217\u53f7\u4ea7\u54c1\u7f16\u53f7";
    private final ItmItemToSCComponentRepoProc itmItemToSCComponentRepoProc;
    private final UdcService sysUdcService;

    @Override
    public PagingVO<ItmItemSpuToSCBusinessPagingVO> findItemToSCByParam(ItmItemToSCParam param) {
        List<String> propNames = param.getPropNames();
        Map codeMap = this.sysUdcService.getCodeMap("COM", "UOM");
        List<Long> spuIds = this.itmItemToSCComponentRepoProc.findSpuIdByPropName(propNames).stream().distinct().collect(Collectors.toList());
        PagingVO<ItmItemSpuToSCBusinessPagingVO> itmItemBusinessSpuInfo = this.itmItemToSCComponentRepoProc.findItmItemBusinessSpuInfo(param, spuIds);
        if (null == itmItemBusinessSpuInfo) {
            return itmItemBusinessSpuInfo;
        }
        List records = itmItemBusinessSpuInfo.getRecords();
        List resultRecords = records.stream().peek(record -> {
            record.setUomName((String)codeMap.get(record.getUom()));
            List<ItmItemToBPropVO> itemDescPropByItemId = this.itmItemToSCComponentRepoProc.findItemDescPropByItemId(record.getSpuId());
            List<ItmItemToBPropVO> descPropResult = itemDescPropByItemId.stream().filter(descProp -> propNames.contains(descProp.getPropName())).collect(Collectors.toList());
            record.setDescPropList(descPropResult);
        }).filter(t -> CollectionUtils.isNotEmpty(t.getDescPropList())).collect(Collectors.toList());
        itmItemBusinessSpuInfo.setRecords(resultRecords);
        return itmItemBusinessSpuInfo;
    }

    public ItemBusinessToSCServiceImpl(ItmItemToSCComponentRepoProc itmItemToSCComponentRepoProc, UdcService sysUdcService) {
        this.itmItemToSCComponentRepoProc = itmItemToSCComponentRepoProc;
        this.sysUdcService = sysUdcService;
    }
}

