/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.service.impl;

import com.elitesland.yst.comm.consumer.dto.ComCurrRpcDTO;
import com.elitesland.yst.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitesland.yst.comm.consumer.param.ComCurrRpcDtoParam;
import com.elitesland.yst.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitesland.yst.comm.consumer.service.ComCurrRpcService;
import com.elitesland.yst.comm.consumer.service.ComTaxRateRpcService;
import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.component.param.ItmBrandComPagingParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemBusinessComPagingParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemSkuComPagingParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemSkuPriComPagingParam;
import com.elitesland.yst.supportdomain.item.component.repo.ItmComponentRepoProc;
import com.elitesland.yst.supportdomain.item.component.service.ItmComponentService;
import com.elitesland.yst.supportdomain.item.component.vo.ItmBrandComPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemBusinessComPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSkuComPagingVO;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemSkuPriComPagingVO;
import com.elitesland.yst.supportdomain.item.convert.ItmItemConvert;
import com.elitesland.yst.supportdomain.item.repo.ItmItemBusinessRepoProc;
import com.elitesland.yst.supportdomain.item.repo.ItmItemCateRepoProc;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateVO;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.repo.OrgBuTreeDRepoProc;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import com.elitesland.yst.supportdomain.pri.service.PriMainPriceService;
import com.elitesland.yst.supportdomain.pri.vo.PriCatePricePagingVO;
import com.elitesland.yst.supportdomain.pri.vo.PriItemPricePagingVO;
import com.elitesland.yst.supportdomain.util.TreeUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class ItmComponentServiceImpl
implements ItmComponentService {
    private static final Logger log = LoggerFactory.getLogger(ItmComponentServiceImpl.class);
    private final ItmItemCateService itmItemCateService;
    private final ItmComponentRepoProc itmComponentRepoProc;
    private final ItmItemCateRepoProc itmItemCateRepoProc;
    private final PriMainPriceService priMainPriceService;
    private final OrgBuService orgBuService;
    private final OrgBuTreeDRepoProc orgBuTreeDRepoProc;
    private final ItmItemBusinessRepoProc itmItemBusinessRepoProc;
    @DubboReference
    private ComTaxRateRpcService comTaxRateRpcService;
    @DubboReference
    private ComCurrRpcService comCurrRpcService;

    @Override
    @Cacheable(cacheNames={"ITEM_CATE"}, key="'TREE'")
    public List<ItmItemCateVO> itmItemCateSearchTree() {
        log.debug("\u901a\u8fc7\u83b7\u53d6\u54c1\u7c7b\u6811\u5f62\u7ed3\u6784\u5f00\u59cb\u6267\u884c");
        List<ItmItemCateVO> treeVos = this.itmItemCateRepoProc.findAllTreeVos();
        return TreeUtils.buildTree(null, true, treeVos);
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemSkuComPagingVO> itemSkuComPagingSearch(ItmItemSkuComPagingParam param) {
        log.debug("\u5546\u54c1SKU\u5206\u9875\u67e5\u8be2-\u653e\u5927\u955c\u7ec4\u4ef6\uff0c\u5f00\u59cb\u6267\u884c\uff1b\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a" + param);
        PagingVO<ItmItemSkuComPagingVO> result = this.itmComponentRepoProc.itemSkuComPagingSearch(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ArrayList taxCodes = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (!StringUtils.isBlank((CharSequence)vo.getItemCateCode())) {
                    vo.setItemCatePath(this.itmItemCateService.findItemCatePath(vo.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && !taxCodes.contains(vo.getTaxCode())) {
                    taxCodes.add(vo.getTaxCode());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && !taxCodes.contains(vo.getTaxCode2())) {
                    taxCodes.add(vo.getTaxCode2());
                }
            });
            if (CollectionUtils.isNotEmpty(taxCodes)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxCodes);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    Map<String, ComTaxRateRpcDTO> taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                    result.getRecords().forEach(vo -> {
                        ComTaxRateRpcDTO tax;
                        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode())) != null) {
                            vo.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                            vo.setTaxRateDesc(tax.getTaxRateDesc());
                        }
                        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode2()) && (tax = (ComTaxRateRpcDTO)taxMap.get(vo.getTaxCode2())) != null) {
                            vo.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
                            vo.setTaxRate2Desc(tax.getTaxRateDesc());
                        }
                    });
                }
            }
        }
        return result;
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemSkuPriComPagingVO> itemSkuPriComPagingSearch(ItmItemSkuPriComPagingParam param) {
        log.debug("\u5546\u54c1SKU\u5206\u9875\u67e5\u8be2(\u4ef7\u683c\u4e2d\u5fc3\u4e13\u7528)-\u653e\u5927\u955c\u7ec4\u4ef6\uff0c\u5f00\u59cb\u6267\u884c\uff1b\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a" + param);
        PagingVO<ItmItemSkuPriComPagingVO> result = this.itmComponentRepoProc.itemSkuPriComPagingSearch(param);
        if (!CollectionUtils.isEmpty((Collection)result.getRecords())) {
            ComCurrRpcDtoParam currParam;
            List currDtos;
            List currCodes;
            OrgBuDtoParam buParam;
            List<OrgBuDTO> orgBuDtos;
            result.getRecords().forEach(t -> {
                if (!StringUtils.isBlank((CharSequence)t.getItemCateCode())) {
                    t.setItemCatePath(this.itmItemCateService.findItemCatePath(t.getItemCateCode()));
                }
            });
            List<String> buCodes = result.getRecords().stream().map(ItmItemSkuPriComPagingVO::getItemSource).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            Map<Object, Object> buMap = new HashMap();
            if (CollectionUtils.isNotEmpty(buCodes) && CollectionUtils.isNotEmpty(orgBuDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(buCodes).build()))) {
                buMap = orgBuDtos.stream().collect(Collectors.toMap(OrgBuDTO::getBuCode, t -> t));
            }
            List<String> itemCateCodes = result.getRecords().stream().map(ItmItemSkuPriComPagingVO::getItemCateCode).distinct().collect(Collectors.toList());
            List<String> itemCodes = result.getRecords().stream().map(ItmItemSkuPriComPagingVO::getItemCode).collect(Collectors.toList());
            List<PriItemPricePagingVO> priceVos = this.priMainPriceService.priMainPriceQuery(itemCodes, true);
            Map<Object, Object> currMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(priceVos) && CollectionUtils.isNotEmpty(currCodes = priceVos.stream().map(PriItemPricePagingVO::getCurrCode).filter(Objects::nonNull).distinct().collect(Collectors.toList())) && CollectionUtils.isNotEmpty((Collection)(currDtos = this.comCurrRpcService.findRpcDtoByParam(currParam = ComCurrRpcDtoParam.builder().currCodes(currCodes).build())))) {
                currMap = currDtos.stream().collect(Collectors.toMap(ComCurrRpcDTO::getCurrCode, ComCurrRpcDTO::getCurrName));
            }
            Map<String, PriItemPricePagingVO> skuPriceMap = priceVos.stream().collect(Collectors.toMap(PriItemPricePagingVO::getItemCode, t -> t));
            Map<String, PriCatePricePagingVO> catePriceMap = this.priMainPriceService.priCatePriceQuery(itemCateCodes).stream().collect(Collectors.toMap(PriCatePricePagingVO::getItemCateCode, t -> t, (t1, t2) -> t1));
            for (ItmItemSkuPriComPagingVO vo : result.getRecords()) {
                OrgBuDTO bu;
                if (StringUtils.isNotBlank((CharSequence)vo.getItemSource()) && (bu = (OrgBuDTO)buMap.getOrDefault(vo.getItemSource(), null)) != null) {
                    vo.setItemSourceName(bu.getBuName());
                }
                if (skuPriceMap.containsKey(vo.getItemCode())) {
                    ItmItemConvert.INSTANCE.updateSkuPriComVoFromPricePagingVo(skuPriceMap.get(vo.getItemCode()), vo);
                    vo.setCurrName(currMap.getOrDefault(vo.getCurrCode(), null));
                }
                if (!catePriceMap.containsKey(vo.getItemCateCode())) continue;
                PriCatePricePagingVO catePrice = catePriceMap.get(vo.getItemCateCode());
                vo.setCatePrice4(catePrice.getPrice4());
                vo.setCatePrice5(catePrice.getPrice5());
            }
        }
        return result;
    }

    @Override
    public PagingVO<ItmBrandComPagingVO> brandComPagingSearch(ItmBrandComPagingParam param) {
        log.debug("\u5546\u54c1\u54c1\u724c\u5206\u9875\u67e5\u8be2-\u653e\u5927\u955c\u7ec4\u4ef6\uff0c\u5f00\u59cb\u6267\u884c\uff1b\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a" + param);
        return this.itmComponentRepoProc.findBrandComPaging(param);
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemBusinessComPagingVO> findBusinessPagingByParam(ItmItemBusinessComPagingParam param) {
        PagingVO<ItmItemBusinessComPagingVO> result;
        List<Long> buTreeDIds = null;
        ArrayList<String> buCodes = new ArrayList<String>();
        if (param.getBuTreeDId() != null) {
            buTreeDIds = Collections.singletonList(param.getBuTreeDId());
            buCodes.addAll(this.orgBuTreeDRepoProc.searchBuCodeByBuTreeDIds(buTreeDIds));
        }
        if (!CollectionUtils.isEmpty((Collection)(result = this.itmComponentRepoProc.selectPagingResult(param, buCodes)).getRecords())) {
            ArrayList taxRateNos = new ArrayList();
            result.getRecords().forEach(vo -> {
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo()) && !taxRateNos.contains(vo.getTaxRateNo())) {
                    taxRateNos.add(vo.getTaxRateNo());
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getTaxRateNo2()) && !taxRateNos.contains(vo.getTaxRateNo2())) {
                    taxRateNos.add(vo.getTaxRateNo2());
                }
            });
            Map<Object, Object> taxMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(taxRateNos)) {
                ComTaxRateRpcDtoParam taxParam = new ComTaxRateRpcDtoParam();
                taxParam.setTaxRateNos(taxRateNos);
                List taxDtos = this.comTaxRateRpcService.findTaxRateRpcDtoByParam(taxParam);
                if (CollectionUtils.isNotEmpty((Collection)taxDtos)) {
                    taxMap = taxDtos.stream().collect(Collectors.toMap(ComTaxRateRpcDTO::getTaxRateNo, t -> t));
                }
            }
            for (ItmItemBusinessComPagingVO record : result.getRecords()) {
                ComTaxRateRpcDTO tax;
                if (StringUtils.isNotBlank((CharSequence)record.getItemCateCode())) {
                    record.setItemCatePath(this.itmItemCateService.findItemCatePath(record.getItemCateCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)record.getTaxRateNo()) && (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo())) != null) {
                    record.setTaxRate(BigDecimal.valueOf(tax.getTaxRateValue()));
                }
                if (!StringUtils.isNotBlank((CharSequence)record.getTaxRateNo2()) || (tax = (ComTaxRateRpcDTO)taxMap.get(record.getTaxRateNo2())) == null) continue;
                record.setTaxRate2(BigDecimal.valueOf(tax.getTaxRateValue()));
            }
        }
        return result;
    }

    public ItmComponentServiceImpl(ItmItemCateService itmItemCateService, ItmComponentRepoProc itmComponentRepoProc, ItmItemCateRepoProc itmItemCateRepoProc, PriMainPriceService priMainPriceService, OrgBuService orgBuService, OrgBuTreeDRepoProc orgBuTreeDRepoProc, ItmItemBusinessRepoProc itmItemBusinessRepoProc) {
        this.itmItemCateService = itmItemCateService;
        this.itmComponentRepoProc = itmComponentRepoProc;
        this.itmItemCateRepoProc = itmItemCateRepoProc;
        this.priMainPriceService = priMainPriceService;
        this.orgBuService = orgBuService;
        this.orgBuTreeDRepoProc = orgBuTreeDRepoProc;
        this.itmItemBusinessRepoProc = itmItemBusinessRepoProc;
    }
}

