/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.service.impl;

import com.elitesland.yst.common.annotation.SysCodeProc;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.core.udc.UdcService;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemLifeBParam;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemLifeListParam;
import com.elitesland.yst.supportdomain.item.component.repo.ItmItemLifeRepoProc;
import com.elitesland.yst.supportdomain.item.component.service.ItmItemLifeService;
import com.elitesland.yst.supportdomain.item.component.vo.ItmItemLifeListPagingVO;
import com.elitesland.yst.supportdomain.item.dto.ItmItemCateSimpleTree;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepo;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.org.dto.OrgBuDTO;
import com.elitesland.yst.supportdomain.org.param.OrgBuDtoParam;
import com.elitesland.yst.supportdomain.org.service.OrgBuService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItmItemLifeServiceImpl
implements ItmItemLifeService {
    private static final Logger log = LoggerFactory.getLogger(ItmItemLifeServiceImpl.class);
    private final ItmItemLifeRepoProc itmItemLifeRepoProc;
    private final OrgBuService orgBuService;
    private final ItmItemCateService itmItemCateService;
    private final ItmItemStatusConfigRepo itmItemStatusConfigRepo;
    private final UdcService sysUdcService;

    @Override
    @SysCodeProc
    public PagingVO<ItmItemLifeListPagingVO> findItemLifeListPagingByParam(ItmItemLifeListParam param) {
        PagingVO<ItmItemLifeListPagingVO> itemLifeListPagingByParam = this.itmItemLifeRepoProc.findItemLifeListPagingByParam(param);
        itemLifeListPagingByParam.getRecords().forEach(itemList -> {
            String itemCateCode;
            OrgBuDtoParam buParam;
            List<OrgBuDTO> buDtos;
            if (StringUtils.isNotBlank((CharSequence)itemList.getItemSource()) && CollectionUtils.isNotEmpty(buDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(Collections.singletonList(itemList.getItemSource())).build()))) {
                itemList.setItemSourceName(buDtos.get(0).getBuName());
            }
            if (StringUtils.isNotBlank((CharSequence)(itemCateCode = itemList.getItemCateCode()))) {
                ArrayList<String> pathName = new ArrayList<String>();
                this.buildPathName(this.itmItemCateService.findItemCatePath(itemCateCode), pathName);
                String collect = String.join((CharSequence)">", pathName);
                itemList.setItemCateNames(collect);
            }
        });
        return itemLifeListPagingByParam;
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmItemLifeListPagingVO> findItemLifeBPagingByParam(ItmItemLifeBParam param) {
        if (StringUtils.isBlank((CharSequence)param.getOuBuCode())) {
            throw new BusinessException("\u5f53\u524d\u7528\u6237\u65e0\u6240\u5c5e\u516c\u53f8");
        }
        PagingVO<ItmItemLifeListPagingVO> itemLifeBPagingByParam = this.itmItemLifeRepoProc.findItemLifeBPagingByParam(param);
        itemLifeBPagingByParam.getRecords().forEach(itemList -> {
            String itemCateCode;
            OrgBuDtoParam buParam;
            List<OrgBuDTO> buDtos;
            if (StringUtils.isNotBlank((CharSequence)itemList.getItemSource()) && CollectionUtils.isNotEmpty(buDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(Collections.singletonList(itemList.getItemSource())).build()))) {
                itemList.setItemSourceName(buDtos.get(0).getBuName());
            }
            if (StringUtils.isNotBlank((CharSequence)itemList.getBuCode()) && CollectionUtils.isNotEmpty(buDtos = this.orgBuService.findBuDtoByParam(buParam = OrgBuDtoParam.builder().buCodes(Collections.singletonList(itemList.getBuCode())).build()))) {
                itemList.setBuName(buDtos.get(0).getBuName());
            }
            if (StringUtils.isNotBlank((CharSequence)(itemCateCode = itemList.getItemCateCode()))) {
                ArrayList<String> pathName = new ArrayList<String>();
                this.buildPathName(this.itmItemCateService.findItemCatePath(itemCateCode), pathName);
                String collect = String.join((CharSequence)">", pathName);
                itemList.setItemCateNames(collect);
            }
        });
        return itemLifeBPagingByParam;
    }

    private void buildPathName(List<ItmItemCateSimpleTree> tree, List<String> pathName) {
        if (CollectionUtils.isEmpty(tree)) {
            return;
        }
        tree.forEach(t -> {
            pathName.add(t.getItemCateName());
            this.buildPathName(t.getTreeNodes(), pathName);
        });
    }

    public ItmItemLifeServiceImpl(ItmItemLifeRepoProc itmItemLifeRepoProc, OrgBuService orgBuService, ItmItemCateService itmItemCateService, ItmItemStatusConfigRepo itmItemStatusConfigRepo, UdcService sysUdcService) {
        this.itmItemLifeRepoProc = itmItemLifeRepoProc;
        this.orgBuService = orgBuService;
        this.itmItemCateService = itmItemCateService;
        this.itmItemStatusConfigRepo = itmItemStatusConfigRepo;
        this.sysUdcService = sysUdcService;
    }
}

