/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.component.service.impl;

import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.supportdomain.item.component.param.ItmItemStatusConfigConParam;
import com.elitesland.yst.supportdomain.item.component.service.ItmStatusConfigConService;
import com.elitesland.yst.supportdomain.item.entity.ItmItemStatusConfigDO;
import com.elitesland.yst.supportdomain.item.enums.ItmUdcEnum;
import com.elitesland.yst.supportdomain.item.repo.ItmItemStatusConfigRepo;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ItmStatusConfigConServiceImpl
implements ItmStatusConfigConService {
    private final ItmItemStatusConfigRepo itmItemStatusConfigRepo;

    @Override
    public Boolean getItemStatusConfig(ItmItemStatusConfigConParam param) {
        ItmItemStatusConfigDO statusConfig;
        String businessCode = param.getBusinessCode();
        String itemLifeStatus = param.getItemLifeStatus();
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            throw new BusinessException("\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)itemLifeStatus)) {
            throw new BusinessException("\u51bb\u7ed3\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional<ItmItemStatusConfigDO> byBusinessCode = this.itmItemStatusConfigRepo.findByBusinessCode(businessCode);
        if (byBusinessCode.isPresent() && (statusConfig = byBusinessCode.get()).getConfigStatus().booleanValue()) {
            if (ItmUdcEnum.ITM_ITEM_LIFE_STATUS_SALE_FREEZE.getUdcVal().equals(itemLifeStatus)) {
                return statusConfig.getBusinExcuSignStatus2();
            }
            if (ItmUdcEnum.ITM_ITEM_LIFE_STATUS_PURC_FREEZE.getUdcVal().equals(itemLifeStatus)) {
                return statusConfig.getBusinExcuSignStatus3();
            }
            throw new BusinessException("\u51bb\u7ed3\u72b6\u6001\u4e0d\u5b58\u5728\uff1a" + itemLifeStatus);
        }
        return true;
    }

    public ItmStatusConfigConServiceImpl(ItmItemStatusConfigRepo itmItemStatusConfigRepo) {
        this.itmItemStatusConfigRepo = itmItemStatusConfigRepo;
    }
}

