/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.excel.service.ItmBrandExcelService;
import com.elitesland.yst.supportdomain.item.param.ItmBrandPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmBrandSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmBrandSwitchParam;
import com.elitesland.yst.supportdomain.item.service.ItmBrandService;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmBrandVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/itm/brand"})
@Api(value="\u54c1\u724c", tags={"\u54c1\u724c"})
public class ItmBrandController {
    private final ItmBrandService itmBrandService;
    private final ItmBrandExcelService itmBrandExcelService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u54c1\u724c\u5206\u9875\u6570\u636e")
    public ApiResult<PagingVO<ItmBrandPagingVO>> searchPagingList(@RequestBody ItmBrandPagingParam param) {
        return ApiResult.ok(this.itmBrandService.itmBrandPagingSearch(param));
    }

    @GetMapping(value={"/details/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u54c1\u724c\u8be6\u60c5")
    public ApiResult<ItmBrandVO> searchBrandDetailsById(@PathVariable Long id) {
        return ApiResult.ok((Object)this.itmBrandService.findItmBrandDetailsById(id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539 \u54c1\u724c\u6570\u636e")
    public ApiResult<String> searchBrandDetailsById(@RequestBody ItmBrandSaveParam param) {
        return ApiResult.ok((Object)this.itmBrandService.saveOrUpdateItmBrand(param).toString());
    }

    @PostMapping(value={"/switch"})
    @ApiOperation(value="\u542f\u7528/\u7981\u7528 \u54c1\u724c")
    public ApiResult<Object> switchStatusByIds(@RequestBody ItmBrandSwitchParam param) {
        this.itmBrandService.switchStatusByIds(param.getIds(), param.getStatus());
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u54c1\u724c")
    public ApiResult<Object> deleteById(@PathVariable Long id) {
        this.itmBrandService.softDeleteById(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/upload"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u54c1\u724c\u5bfc\u5165")
    public ApiResult<Object> uploadData(@RequestBody MultipartFile file) {
        this.itmBrandExcelService.uploadExcel(file);
        return ApiResult.ok();
    }

    @PostMapping(value={"/itemBrandExport"})
    @ApiOperation(value="\u54c1\u724c\u5bfc\u51fa")
    public ApiResult<Object> itemBrandExport(@RequestBody ItmBrandPagingParam param, HttpServletResponse response) {
        this.itmBrandExcelService.itemBrandExport(param, response);
        return ApiResult.ok();
    }

    public ItmBrandController(ItmBrandService itmBrandService, ItmBrandExcelService itmBrandExcelService) {
        this.itmBrandService = itmBrandService;
        this.itmBrandExcelService = itmBrandExcelService;
    }
}

