/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemCatePropExportService;
import com.elitesland.yst.supportdomain.item.param.ItmCatePropSaveParam;
import com.elitesland.yst.supportdomain.item.param.ItmCatePropSearchParam;
import com.elitesland.yst.supportdomain.item.service.ItmCatePropService;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropDetailVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropPagingVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCatePropVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/itm/itmCateProp"})
@Api(value="\u5546\u54c1\u54c1\u7c7b-\u5c5e\u6027", tags={"\u5546\u54c1\u54c1\u7c7b-\u5c5e\u6027"})
public class ItmCatePropController {
    private final ItmCatePropService itmCatePropService;
    private final ItmItemCatePropExportService itmItemCatePropExportService;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2-\u54c1\u7c7b\u5c5e\u6027\u6761\u4ef6\u67e5\u8be2")
    public ApiResult<PagingVO<ItmCatePropPagingVO>> itmCatePagingByParam(@RequestBody ItmCatePropSearchParam itmCatePropSearchParam) {
        PagingVO<ItmCatePropPagingVO> result = this.itmCatePropService.searchPagingByParam(itmCatePropSearchParam);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/list/cate/{itemCateCode}"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u54c1\u7c7b\u4e0b\u7684\u6240\u6709\u5c5e\u6027\u5217\u8868")
    public ApiResult<List<ItmCatePropVO>> getPropsByItemCateCode(@PathVariable String itemCateCode) {
        List<ItmCatePropVO> result = this.itmCatePropService.getPropsByItemCateCode(itemCateCode);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/details/{id}"})
    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u5546\u54c1\u54c1\u7c7b\u5c5e\u6027")
    public ApiResult<ItmCatePropDetailVO> getDetailById(@PathVariable Long id) {
        ItmCatePropDetailVO result = this.itmCatePropService.getDetailById(id);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u5546\u54c1\u54c1\u7c7b\u5c5e\u6027\u65b0\u589e\u66f4\u65b0")
    public ApiResult<String> create(@RequestBody ItmCatePropSaveParam itmCatePropSaveParam) {
        Long result = this.itmCatePropService.itmCatePropSaveOrUpdate(itmCatePropSaveParam);
        return ApiResult.ok((Object)result.toString());
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5546\u54c1\u54c1\u7c7b\u5c5e\u6027\u5220\u9664")
    public ApiResult<Object> deleteById(@PathVariable Long id) {
        this.itmCatePropService.softDeleteById(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/upload"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u54c1\u7c7b\u5c5e\u6027\u5bfc\u5165")
    public ApiResult<Object> uploadData(MultipartFile file) {
        this.itmItemCatePropExportService.uploadExcel(file);
        return ApiResult.ok();
    }

    public ItmCatePropController(ItmCatePropService itmCatePropService, ItmItemCatePropExportService itmItemCatePropExportService) {
        this.itmCatePropService = itmCatePropService;
        this.itmItemCatePropExportService = itmItemCatePropExportService;
    }
}

