/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.excel.service.ItemBomExportService;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemBomExcelService;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemBomSaveParam;
import com.elitesland.yst.supportdomain.item.service.ItmItemBomService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/itm/bom"})
@Api(value="\u5546\u54c1BOM\u7ed3\u6784", tags={"\u5546\u54c1BOM\u7ed3\u6784"})
public class ItmItemBomController {
    private final ItmItemBomService itmItemBomService;
    private final ItmItemBomExcelService itmItemBomExcelService;
    private final ItemBomExportService itemBomExportService;

    @PostMapping(value={"/paging"})
    @ApiOperation(value="\u5546\u54c1BOM\u5206\u9875\u67e5\u8be2")
    public ApiResult<PagingVO<?>> searchPaging(@RequestBody ItmItemBomPagingParam param) {
        return ApiResult.ok(this.itmItemBomService.itemBomPagingSearch(param));
    }

    @GetMapping(value={"/details/{id}"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u5546\u54c1BOM\u8be6\u60c5")
    public ApiResult<?> findDetailsById(@PathVariable Long id) {
        return ApiResult.ok(this.itmItemBomService.findBomDetailsById(id));
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u5546\u54c1BOM\u65b0\u589e/\u4fee\u6539")
    public ApiResult<Long> itemBomSaveOrUpdate(@RequestBody ItmItemBomSaveParam param) {
        return ApiResult.ok((Object)this.itmItemBomService.itemBomSaveOrUpdate(param));
    }

    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5546\u54c1BOM\u8f6f\u5220\u9664")
    public ApiResult<Object> itemBomSoftDelete(@PathVariable Long id) {
        this.itmItemBomService.itemBomSoftDelete(id);
        return ApiResult.ok();
    }

    @PostMapping(value={"/upload"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="\u5546\u54c1Bom\u5bfc\u5165")
    public ApiResult<Object> uploadData(MultipartFile file) {
        this.itmItemBomExcelService.uploadExcel(file);
        return ApiResult.ok();
    }

    @GetMapping(value={"/data"})
    @ApiOperation(value="\u5546\u54c1Bom\u62c9\u53d6\u6570\u636e")
    public ApiResult<Object> getData() {
        this.itmItemBomService.getData();
        return ApiResult.ok();
    }

    public ItmItemBomController(ItmItemBomService itmItemBomService, ItmItemBomExcelService itmItemBomExcelService, ItemBomExportService itemBomExportService) {
        this.itmItemBomService = itmItemBomService;
        this.itmItemBomExcelService = itmItemBomExcelService;
        this.itemBomExportService = itemBomExportService;
    }
}

