/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.excel.entity.ErrorInfo;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemCateExcelService;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateAddParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemCatePageParamVO;
import com.elitesland.yst.supportdomain.item.param.ItmItemCateSwitchParam;
import com.elitesland.yst.supportdomain.item.service.ItmItemCateService;
import com.elitesland.yst.supportdomain.item.vo.ItmCateQualifyVO;
import com.elitesland.yst.supportdomain.item.vo.ItmCateTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemCateVO;
import com.elitesland.yst.supportdomain.item.vo.YstItemClassView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/itm/itmItemCate"})
@Api(value="\u5546\u54c1\u54c1\u7c7b", tags={"\u5546\u54c1\u54c1\u7c7b"})
public class ItmItemCateController {
    private final ItmItemCateService itmItemCateService;
    private final ItmItemCateExcelService itmItemCateExcelService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u5546\u54c1\u54c1\u7c7b\u65b0\u589e")
    public ApiResult<String> create(@RequestBody ItmItemCateAddParam itmItemCateParam) {
        Long result = this.itmItemCateService.itmItemCateCreate(itmItemCateParam);
        return ApiResult.ok((Object)result.toString());
    }

    @PutMapping(value={"/update"})
    @ApiOperation(value="\u5546\u54c1\u54c1\u7c7b\u66f4\u65b0")
    public ApiResult<String> update(@RequestBody ItmItemCateAddParam itmItemCateParam) {
        Long result = this.itmItemCateService.itmItemCateUpdate(itmItemCateParam);
        return ApiResult.ok((Object)result.toString());
    }

    @DeleteMapping(value={"/del/{id}"})
    @ApiOperation(value="\u5546\u54c1\u54c1\u7c7b\u5220\u9664")
    public ApiResult<Object> deleteById(@PathVariable Long id) {
        this.itmItemCateService.itmItemCateSoftDelete(id);
        return ApiResult.ok();
    }

    @GetMapping(value={"/getById/{id}"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u5546\u54c1\u54c1\u7c7b\u8be6\u7ec6\u4fe1\u606f")
    public ApiResult<ItmItemCateDetailsVO> searchById(@PathVariable Long id) {
        ItmItemCateDetailsVO result = this.itmItemCateService.itmItemCateSearchById(id);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/searchGetById"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u5546\u54c1\u54c1\u7c7b\u5217\u8868")
    public ApiResult<PagingVO<YstItemClassView>> searchGetById(@RequestBody ItmItemCatePageParamVO param) {
        return ApiResult.ok(this.itmItemCateService.searchGetById(param));
    }

    @PostMapping(value={"/updateItmItemCate"})
    @ApiOperation(value="\u6839\u636eid\u4fee\u6539\u5b89\u5168\u5e93\u5b58\u5929\u6570\u6216\u8005\u9ed8\u8ba4\u4ea4\u671f")
    public ApiResult<Long> updateItmItemCate(@RequestBody ItmItemCateAddParam param) {
        return ApiResult.ok((Object)this.itmItemCateService.updateItmItemCate(param));
    }

    @GetMapping(value={"/search/{pid}"})
    @ApiOperation(value="\u6839\u636e\u4e0a\u7ea7ID\u83b7\u53d6\u5b50\u5217\u8868(\u975e\u6811\u5f62\u7ed3\u6784)")
    public ApiResult<List<ItmItemCateVO>> search(@PathVariable Long pid) {
        List<ItmItemCateVO> result = this.itmItemCateService.itmItemCateSearchByPid(pid);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/searchTree"})
    @ApiOperation(value="\u83b7\u53d6\u5546\u54c1\u54c1\u7c7b\u5b8c\u6574\u6811\u5f62\u7ed3\u6784")
    public ApiResult<List<ItmItemCateVO>> searchTree() {
        List<ItmItemCateVO> result = this.itmItemCateService.itmItemCateSearchTree();
        return ApiResult.ok(result);
    }

    @PostMapping(value={"/switch"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u54c1\u7c7b\u72b6\u6001")
    public ApiResult<Object> switchStatusByIds(@RequestBody ItmItemCateSwitchParam param) {
        this.itmItemCateService.updateStatusByIds(param.getIds(), param.getStatus());
        return ApiResult.ok();
    }

    @GetMapping(value={"/tag/{itemCateCode}"})
    @ApiOperation(value="\u6839\u636e\u54c1\u7c7b\u7f16\u53f7\u83b7\u53d6\u54c1\u7c7b\u6807\u7b7e")
    public ApiResult<List<ItmCateTagVO>> searchCateTag(@PathVariable String itemCateCode) {
        List<ItmCateTagVO> result = this.itmItemCateService.findCateTagByItemCateCode(itemCateCode);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/qualifyType/{itemCateCode}"})
    @ApiOperation(value="\u6839\u636e\u54c1\u7c7b\u7f16\u53f7\u83b7\u53d6\u54c1\u7c7b\u8bc1\u7167\u7c7b\u578b")
    public ApiResult<List<ItmCateQualifyVO>> searchCateQualifyTypes(@PathVariable String itemCateCode) {
        List<ItmCateQualifyVO> result = this.itmItemCateService.findCateQualifyTypesByItemCateCode(itemCateCode);
        return ApiResult.ok(result);
    }

    @PostMapping(value={"/upload"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="excel\u5bfc\u5165\u54c1\u7c7b\u6570\u636e")
    public ApiResult<ErrorInfo> uploadData(@RequestBody MultipartFile file) throws Exception {
        this.itmItemCateExcelService.uploadExcel(file);
        return ApiResult.ok();
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u54c1\u7c7b\u5bfc\u51fa")
    public ApiResult<Object> exportData(HttpServletResponse response) {
        this.itmItemCateExcelService.exportData(response);
        return ApiResult.ok();
    }

    @GetMapping(value={"/exportxin"})
    @ApiOperation(value="\u54c1\u7c7b\u5bfc\u51fa")
    public ApiResult<Object> exportDataxin(HttpServletResponse response) {
        this.itmItemCateExcelService.exportDataxin(response);
        return ApiResult.ok();
    }

    @PostMapping(value={"/uploadxin"}, headers={"content-type=multipart/form-data"})
    @ApiOperation(value="excel\u5bfc\u5165\u54c1\u7c7b\u6570\u636e\u65b0")
    public ApiResult<ErrorInfo> uploadDataxin(@RequestBody MultipartFile file) throws Exception {
        this.itmItemCateExcelService.uploadExcelxin(file);
        return ApiResult.ok();
    }

    public ItmItemCateController(ItmItemCateService itmItemCateService, ItmItemCateExcelService itmItemCateExcelService) {
        this.itmItemCateService = itmItemCateService;
        this.itmItemCateExcelService = itmItemCateExcelService;
    }
}

