/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.supportdomain.item.param.ItmItemComboPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemComboSaveParam;
import com.elitesland.yst.supportdomain.item.service.ItmComboDService;
import com.elitesland.yst.supportdomain.item.service.ItmComboTagService;
import com.elitesland.yst.supportdomain.item.service.ItmItemComboService;
import com.elitesland.yst.supportdomain.item.vo.ItmComboDVO;
import com.elitesland.yst.supportdomain.item.vo.ItmComboTagVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemComboDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemComboVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/itm/itmItemCombo"})
@Api(value="\u7ec4\u5408\u5546\u54c1", tags={"\u7ec4\u5408\u5546\u54c1"})
public class ItmItemComboController {
    private final ItmItemComboService itmItemComboService;
    private final ItmComboTagService itmComboTagService;
    private final ItmComboDService itmComboDService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u7ec4\u5408\u5546\u54c1\u65b0\u589e")
    public ApiResult<Object> create(@RequestBody ItmItemComboSaveParam param) {
        Long result = this.itmItemComboService.itmItemComboSaveOrUpdate(param);
        return ApiResult.ok((Object)result);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u7ec4\u5408\u5546\u54c1\u66f4\u65b0")
    public ApiResult<Object> update(@RequestBody ItmItemComboSaveParam param) {
        this.itmItemComboService.itmItemComboUpdate(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u7ec4\u5408\u5546\u54c1\u5206\u9875\u6761\u4ef6\u67e5\u8be2")
    public ApiResult<PagingVO<ItmItemComboVO>> searchByParam(@RequestBody ItmItemComboPagingParam param) {
        PagingVO<ItmItemComboVO> result = this.itmItemComboService.itmItemComboSearchByParams(param);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/getItemCateCode"})
    @ApiOperation(value="\u7f16\u7801\u540e\u53f0\u751f\u6210")
    public ApiResult<Object> getCode() {
        String result = this.itmItemComboService.createCode();
        return ApiResult.ok((Object)result);
    }

    @GetMapping(value={"/getComboTagByCode/{itemComboCode}"})
    @ApiOperation(value="\u901a\u8fc7\u7ec4\u5408\u5546\u54c1\u7f16\u7801\u83b7\u53d6\u6807\u7b7e")
    public ApiResult<Object> getComboTagByCode(@PathVariable String itemComboCode) {
        List<ItmComboTagVO> result = this.itmComboTagService.itmComboTagQueryByCode(itemComboCode);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/getComboDByCode/{itemComboCode}"})
    @ApiOperation(value="\u901a\u8fc7\u7ec4\u5408\u5546\u54c1\u7f16\u7801\u83b7\u53d6\u5546\u54c1\u660e\u7ec6")
    public ApiResult<Object> getComboDByCode(@PathVariable String itemComboCode) {
        List<ItmComboDVO> result = this.itmComboDService.itmComboDQueryByCode(itemComboCode);
        return ApiResult.ok(result);
    }

    @GetMapping(value={"/details/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u8be6\u60c5\uff08\u5305\u542b\u6807\u7b7e\u3001\u5546\u54c1\u660e\u7ec6\uff09")
    public ApiResult<ItmItemComboDetailsVO> searchItmItemComboDetailsById(@PathVariable Long id) {
        ItmItemComboDetailsVO result = this.itmItemComboService.searchItmItemComboDetailsById(id);
        return ApiResult.ok((Object)result);
    }

    public ItmItemComboController(ItmItemComboService itmItemComboService, ItmComboTagService itmComboTagService, ItmComboDService itmComboDService) {
        this.itmItemComboService = itmItemComboService;
        this.itmComboTagService = itmComboTagService;
        this.itmComboDService = itmComboDService;
    }
}

