/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.supportdomain.item.controller;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.base.PagingVO;
import com.elitesland.yst.srmdomain.itmitem.repo.SrmItmItemRepoProc;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemCateExcelService;
import com.elitesland.yst.supportdomain.item.excel.service.ItmItemExcelService;
import com.elitesland.yst.supportdomain.item.param.ItmItemBatchDeleteParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemPubBusiParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuPagingParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuPublishParam;
import com.elitesland.yst.supportdomain.item.param.ItmItemSpuSaveParam;
import com.elitesland.yst.supportdomain.item.service.ItmItemService;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuDetailsVO;
import com.elitesland.yst.supportdomain.item.vo.ItmItemSpuPagingVO;
import com.elitesland.yst.supportdomain.provider.item.param.CommonItmItemParamVO;
import com.elitesland.yst.supportdomain.provider.item.vo.CommonItmItemDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/itm/item"})
@Api(value="\u5546\u54c1", tags={"\u5546\u54c1"})
public class ItmItemController {
    private final ItmItemService itmItemService;
    private final ItmItemExcelService itmItemExcelService;
    private final ItmItemCateExcelService itmItemCateExcelService;
    private final SrmItmItemRepoProc srmItmItemRepoProc;

    @PostMapping(value={"/spu/list"})
    @ApiOperation(value="\u83b7\u53d6SPU\u5546\u54c1\u5206\u9875\u6570\u636e")
    public ApiResult<PagingVO<ItmItemSpuPagingVO>> searchSpuPaging(@RequestBody ItmItemSpuPagingParam param) {
        return ApiResult.ok(this.itmItemService.itemSpuPagingSearch(param));
    }

    @GetMapping(value={"/spu/details/{id}"})
    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6SPU\u5546\u54c1\u8be6\u60c5")
    public ApiResult<ItmItemSpuDetailsVO> searchSpuDetails(@PathVariable Long id) {
        return ApiResult.ok((Object)this.itmItemService.findSpuDetailsBySpuId(id));
    }

    @PostMapping(value={"/spu/save"})
    @ApiOperation(value="\u65b0\u589e\u6216\u66f4\u65b0SPU\u5546\u54c1")
    public ApiResult<String> saveOrUpdateSpu(@RequestBody ItmItemSpuSaveParam param) {
        Long result = this.itmItemService.saveOrUpdateSpu(param);
        return ApiResult.ok((Object)result.toString());
    }

    @PostMapping(value={"/spu/publish"})
    @ApiOperation(value="\u6279\u91cf\u53d1\u5e03SPU\u5546\u54c1")
    public ApiResult<Object> batchPublishSpu(@RequestBody ItmItemSpuPublishParam param) {
        this.itmItemService.batchSpuPublish(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/delete/batch"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664SPU\u4fe1\u606f\uff0c\u53ea\u80fd\u5220\u9664\u8349\u7a3f\u72b6\u6001\u7684\u5546\u54c1")
    public ApiResult<Object> softDeleteBatch(@RequestBody ItmItemBatchDeleteParam param) {
        this.itmItemService.softDeleteByParam(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/businessParam/pub"})
    @ApiOperation(value="\u6279\u91cf\u53d1\u5e03\u7ecf\u8425\u53c2\u6570")
    public ApiResult<Object> batchPublishBusinessParam(@RequestBody ItmItemPubBusiParam param) {
        this.itmItemService.batchPublishBusinessParam(param);
        return ApiResult.ok();
    }

    @PostMapping(value={"/info"})
    @ApiOperation(value="\u6d4b\u8bd5")
    public ApiResult<List<CommonItmItemDTO>> info(@RequestBody CommonItmItemParamVO paramVO) {
        return ApiResult.ok(this.srmItmItemRepoProc.commonItemSelect(paramVO));
    }

    public ItmItemController(ItmItemService itmItemService, ItmItemExcelService itmItemExcelService, ItmItemCateExcelService itmItemCateExcelService, SrmItmItemRepoProc srmItmItemRepoProc) {
        this.itmItemService = itmItemService;
        this.itmItemExcelService = itmItemExcelService;
        this.itmItemCateExcelService = itmItemCateExcelService;
        this.srmItmItemRepoProc = srmItmItemRepoProc;
    }
}

